/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.admin.application.api.Client;
import io.axoniq.axonserver.admin.replicationgroup.api.JoinReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.LeaveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.RemoveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupOverview;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.axoniq.axonserver.rest.ContextJSON;
import io.axoniq.axonserver.rest.NodeAndRole;
import io.axoniq.axonserver.rest.ReplicationGroupJSON;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.transport.rest.G;
import io.axoniq.axonserver.transport.rest.H;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.e;
import io.axoniq.axonserver.transport.rest.i;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@CrossOrigin
@RequestMapping(value={"/v1"})
public class ReplicationGroupRestController {
    private final ReplicationGroupAdminService E;
    private static final Logger C = AuditLog.getLogger();
    private final Logger c;
    private final ReplicationLeaderProvider e;

    public ReplicationGroupRestController(ReplicationLeaderProvider a2, ReplicationGroupAdminService a3) {
        ReplicationGroupRestController a4;
        ReplicationGroupRestController replicationGroupRestController = a4;
        a4.c = LoggerFactory.getLogger(ReplicationGroupRestController.class);
        replicationGroupRestController.e = a2;
        replicationGroupRestController.E = a3;
    }

    @GetMapping(path={"public/replicationgroups"})
    public Flux<ReplicationGroupJSON> M(@Parameter(hidden=true) Principal a3) {
        return this.E.getReplicationGroups((Authentication)new PrincipalAuthentication(a3)).map(a2 -> {
            ReplicationGroupRestController a3;
            ReplicationGroupJSON replicationGroupJSON = new ReplicationGroupJSON(a2.name());
            ReplicationGroupOverview replicationGroupOverview = a2;
            replicationGroupJSON.setChangePending(replicationGroupOverview.changePending());
            if (replicationGroupOverview.pendingSince() != null) {
                replicationGroupJSON.setPendingSince(a2.pendingSince().getTime());
            }
            ReplicationGroupJSON replicationGroupJSON2 = replicationGroupJSON;
            ReplicationGroupOverview replicationGroupOverview2 = a2;
            replicationGroupJSON2.setLeader(a3.e.getLeader(replicationGroupOverview2.name()));
            replicationGroupJSON2.setRoles(replicationGroupOverview2.members().stream().map(NodeAndRole::new).sorted().collect(Collectors.toList()));
            if (a2.members().stream().anyMatch(AdminReplicationGroupMember::isPendingDelete)) {
                replicationGroupJSON.setChangePending(true);
            }
            replicationGroupJSON.setContexts(a2.contexts().stream().map(ContextJSON::new).collect(Collectors.toList()));
            return replicationGroupJSON;
        }).sort(Comparator.comparing(ReplicationGroupJSON::getName));
    }

    @DeleteMapping(path={"replicationgroups/{replicationgroup}/{node}"})
    public Mono<ResponseEntity<RestResponse>> h(@PathVariable(value="replicationgroup") String name, @PathVariable(value="node") String node, @RequestParam(name="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a2) {
        return Mono.defer(() -> {
            ReplicationGroupRestController a7;
            Object[] objectArray = new Object[3];
            objectArray[0] = node;
            objectArray[1] = name;
            objectArray[2] = preserveEventStore ? Client.M((Object)"\nXl\u001dB\bN\u0016@XB\u000eB\u0016SXT\fH\nB") : "";
            a7.c.info(ClientVersionsCache.M((Object)"EImIuI!BnHd\fsIpYd_u\fsIbIhZdH!Jn^!BnHd\u0016!W|\f,\f`Be\fsIq@hO`XhCo\ff^nYq\u0016!W|\fzQ"), objectArray);
            return a7.M(name, node, preserveEventStore, (Authentication)new PrincipalAuthentication(a2)).thenReturn((Object)a7.M(ClientVersionsCache.M((Object)"mbOd\\uIe\feImIuI!^d]tIrX"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
        });
    }

    @PostMapping(path={"replicationgroups"})
    public Mono<ResponseEntity<RestResponse>> M(@RequestBody @Valid ReplicationGroupJSON replicationGroupJSON, @Parameter(hidden=true) Principal a2) {
        return Mono.defer(() -> {
            ReplicationGroupRestController a5;
            ReplicationGroupJSON replicationGroupJSON = replicationGroupJSON;
            a5.c.info(Client.M((Object)"9C\u001c\u0007\nB\bK\u0011D\u0019S\u0011H\u0016\u0007\u001fU\u0017R\b\u0007\nB\tR\u001dT\f\u0007\nB\u001bB\u0011Q\u001dCXA\u0017UXU\u001dW\u0014N\u001bF\fN\u0017IX@\nH\rWB\u0007\u0003Z"), (Object)replicationGroupJSON.getName());
            if (!replicationGroupJSON.hasRoles()) {
                throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, ClientVersionsCache.M((Object)"meH!Mu\fmI`_u\fnBd\foCeI!Jn^!XiI!Mq\\mEbMuEnB!KsCt\\"));
            }
            return a5.M(replicationGroupJSON, (Authentication)new PrincipalAuthentication(a2)).thenReturn((Object)a5.M(Client.M((Object)"f\u001bD\u001dW\fB\u001c\u0007\u001bU\u001dF\fBXU\u001dV\rB\u000bS"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
        });
    }

    @GetMapping(path={"replicationgroups/roles"})
    public Set<String> M(@Parameter(hidden=true) Principal a3) {
        C.info(ClientVersionsCache.M((Object)"wzQ\\\fSIpYd_u\fuC!@h_u\fsIq@hO`XhCo\ff^nYq\fsCmIr\u0002"), (Object)AuditLog.username((Principal)a3));
        return Arrays.stream(Role.values()).filter(a2 -> {
            if (!Role.UNRECOGNIZED.equals(a2)) {
                return true;
            }
            return false;
        }).map(Enum::name).collect(Collectors.toSet());
    }

    @PostMapping(path={"replicationgroups/{replicationgroup}/{node}"})
    public Mono<ResponseEntity<RestResponse>> M(@PathVariable(value="replicationgroup") String name, @PathVariable(value="node") String node, @RequestParam(value="role", required=false, defaultValue="PRIMARY") String role, @Parameter(hidden=true) Principal a2) {
        return Mono.defer(() -> {
            ReplicationGroupRestController a7;
            ReplicationGroupRestController replicationGroupRestController = a7;
            replicationGroupRestController.c.info(ClientVersionsCache.M((Object)"@He\foCeI!^d]tIrX!^dOdEwIe\fgCs\foCeI;\fzQ!\u0001!MoH!OnBuIyX;\fzQ"), (Object)node, (Object)name);
            return replicationGroupRestController.M(name, node, role, (Authentication)new PrincipalAuthentication(a2)).thenReturn((Object)a7.M(Client.M((Object)"f\u001bD\u001dW\fB\u001c\u0007\u0019C\u001c\u0007\u0016H\u001cBXU\u001dV\rB\u000bS"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
        });
    }

    private /* synthetic */ Mono<Void> M(String a2, String a3, String a4, Authentication a5) {
        ReplicationGroupRestController a6;
        return a6.E.addNodeToReplicationGroup((JoinReplicationGroup)new e(a6, a3, a2, a4), a5);
    }

    @DeleteMapping(path={"replicationgroups/{name}"})
    public Mono<ResponseEntity<RestResponse>> M(@PathVariable(value="name") String name, @RequestParam(value="preserveEventStore", required=false, defaultValue="false") boolean preserveEventStore, @Parameter(hidden=true) Principal a3) {
        return this.M(name, preserveEventStore, (Authentication)new PrincipalAuthentication(a3)).thenReturn((Object)this.M(Client.M((Object)"f\u001bD\u001dW\fB\u001c\u0007\u001cB\u0014B\fBXU\u001dV\rB\u000bS"))).onErrorResume(a2 -> Mono.just((Object)new RestResponse(false, a2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)a2))));
    }

    @NotNull
    private /* synthetic */ Mono<Void> M(String a2, String a3, boolean a4, Authentication a5) {
        ReplicationGroupRestController a6;
        return a6.E.removeNodeFromReplicationGroup((LeaveReplicationGroup)new i(a6, a3, a2, a4), a5);
    }

    private /* synthetic */ ResponseEntity<RestResponse> M(String a2) {
        return ResponseEntity.accepted().body((Object)new RestResponse(true, a2));
    }

    @NotNull
    private /* synthetic */ Mono<Void> M(String a2, boolean a3, Authentication a4) {
        ReplicationGroupRestController a5;
        return a5.E.deleteReplicationGroup((RemoveReplicationGroup)new G(a5, a2, a3), a4);
    }

    @NotNull
    private /* synthetic */ Mono<Void> M(ReplicationGroupJSON a2, Authentication a3) {
        ReplicationGroupRestController a4;
        return a4.E.createReplicationGroup((ReplicationGroup)new H(a4, a2), a3);
    }
}

