/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.enterprise.replication.SnapshotDataProviders;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.L;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.UserRestController;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="UserRestController")
@CrossOrigin
@RequestMapping(value={"/v1"})
public class UserRestController {
    private static final Logger E;
    private static final Logger C;
    private final RoleController c;
    private final UserAdminService e;

    @DeleteMapping(path={"users/{name}"})
    public void M(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        try {
            this.e.deleteUser(name, (Authentication)new PrincipalAuthentication(a2));
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = name;
            objectArray[2] = exception.getMessage();
            E.error(SnapshotDataProviders.M((Object)")y\u000f_RF\u0017n\u0017v\u0017\"\u0007q\u0017pRy\u000f\"\u0014c\u001bn\u0017fR/Ry\u000f"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    static {
        C = LoggerFactory.getLogger(UserRestController.class);
        E = AuditLog.getLogger();
    }

    @GetMapping(value={"public/users"})
    public List<UserJson> M(@Parameter(hidden=true) Principal a2) {
        try {
            return this.e.users((Authentication)new PrincipalAuthentication(a2)).stream().map(UserJson::new).sorted(Comparator.comparing(UserJson::getUserName)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            C.info(HeartbeatMonitor.M((Object)"]\u0016{0&!o\u001erMs\u001ec\u001fuM`\fo\u0001c\t&@&\u0016{"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    public UserRestController(UserAdminService a2, RoleController a3) {
        UserRestController a4;
        UserRestController userRestController = a4;
        userRestController.e = a2;
        userRestController.c = a3;
    }

    @PostMapping(value={"users"})
    public void M(@RequestBody @Valid UserJson userJson, @Parameter(hidden=true) Principal a3) {
        if (a3 != null && userJson.userName.equals(a3.getName())) {
            throw new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, SnapshotDataProviders.M((Object)"L\u001dvRc\u001en\u001du\u0017fRv\u001d\"\u0011j\u0013l\u0015gR{\u001dw\u0000\"\u001du\u001c\"\u0011p\u0017f\u0017l\u0006k\u0013n\u0001"));
        }
        Set<Object> set = new HashSet();
        if (userJson.roles != null) {
            set = Arrays.stream(userJson.roles).map(AdminUserRole::parse).collect(Collectors.toSet());
        }
        UserJson userJson2 = userJson;
        this.e.createOrUpdateUser(userJson2.userName, userJson2.password, set.stream().map(a2 -> {
            UserRestController a3;
            return new L(a3, a2);
        }).collect(Collectors.toSet()), (Authentication)new PrincipalAuthentication(a3));
    }
}

