/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest.v2;

import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessorAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.ComponentItems;
import io.axoniq.axonserver.component.instance.Client;
import io.axoniq.axonserver.component.instance.Clients;
import io.axoniq.axonserver.message.command.CommandHandler;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.serializer.Printable;
import io.axoniq.axonserver.transport.rest.PrincipalAuthentication;
import io.axoniq.axonserver.transport.rest.json.GenericProcessor;
import io.axoniq.axonserver.transport.rest.json.StreamingProcessor;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"v2/components"})
@CrossOrigin
public class ComponentRestControllerV2 {
    private final CommandRegistrationCache E;
    private final QueryRegistrationCache C;
    private final EventProcessorAdminService c;
    private final Clients e;

    @GetMapping(value={"{name}/commands"}, produces={"application/json"})
    public Set<String> h(@PathVariable(value="name") String a4) {
        return this.E.getAll().entrySet().stream().filter(a3 -> ((CommandHandler)a3.getKey()).B().equals(a4)).flatMap(a2 -> ((Set)a2.getValue()).stream()).map(CommandRegistrationCache.RegistrationEntry::M).collect(Collectors.toSet());
    }

    @GetMapping(value={"{name}/queries"}, produces={"application/json"})
    public Set<String> M(@PathVariable(value="name") String a4) {
        return this.C.getAll().entrySet().stream().filter(a3 -> ((Map)a3.getValue()).containsKey(a4)).map(a2 -> ((QueryDefinition)a2.getKey()).getQueryName()).collect(Collectors.toSet());
    }

    @GetMapping(value={"{name}/clients"}, produces={"application/json"})
    public Flux<Client> M(@PathVariable(value="name") String a2) {
        return Flux.fromIterable((Iterable)new ComponentItems(a2, null, (Iterable)this.e));
    }

    @GetMapping(value={"{name}/processors"})
    public Flux<Printable> M(@PathVariable(value="name") String component, @Parameter(hidden=true) Principal a3) {
        return this.c.eventProcessorsByComponent(component, (Authentication)new PrincipalAuthentication(a3)).map(a2 -> {
            if (a2.isStreaming()) {
                return new StreamingProcessor(a2);
            }
            return new GenericProcessor(a2);
        });
    }

    public ComponentRestControllerV2(Clients a2, CommandRegistrationCache a3, QueryRegistrationCache a4, EventProcessorAdminService a5) {
        ComponentRestControllerV2 a6;
        ComponentRestControllerV2 componentRestControllerV2 = a6;
        ComponentRestControllerV2 componentRestControllerV22 = a6;
        componentRestControllerV22.e = a2;
        componentRestControllerV22.E = a3;
        componentRestControllerV2.C = a4;
        componentRestControllerV2.c = a5;
    }
}

