/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.ui;

import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.v2.LoggingRestControllerV2;
import io.axoniq.axonserver.ui.ClusterUpdatesService;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@Service
public class ClusterUpdatesService {
    private final Sinks.Many<SimpleUpdate> C;
    private final Logger c = LoggerFactory.getLogger(ClusterUpdatesService.class);
    private static final Logger e = AuditLog.getLogger();

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.B, a2.context(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceDisconnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.A, a2.getNodeName(), SimpleUpdateState.e);
    }

    public Flux<SimpleUpdate> subscribeToUpdates(@Nonnull Authentication a2) {
        return this.C.asFlux().publish().autoConnect().doFirst(() -> e.info(LoggingRestControllerV2.M((Object)"X1~\u0017#\u0019v(p)q#a/gjw%#)l$w/{>#?s.b>f9-"), (Object)AuditLog.username((String)a2.username())));
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.G, a2.replicationGroup(), SimpleUpdateState.C);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.C, a2.h(), SimpleUpdateState.e);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceConnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.A, a2.getNodeName(), SimpleUpdateState.c);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.B, a2.context(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupCreated a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.e, a2.replicationGroup(), SimpleUpdateState.B);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.G, a2.replicationGroup(), SimpleUpdateState.C);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeConnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.c, a2.getNodeInfo().getHostName(), SimpleUpdateState.c);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeDeleted a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.c, a2.node(), SimpleUpdateState.c);
    }

    @EventListener
    public void on(ClusterEvents.BecomeLeader a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.G, a2.replicationGroup(), SimpleUpdateState.C);
    }

    public ClusterUpdatesService() {
        ClusterUpdatesService a2;
        a2.C = Sinks.many().multicast().onBackpressureBuffer();
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.e, a2.replicationGroup(), SimpleUpdateState.C);
    }

    private /* synthetic */ void M(UpdateType a4, String a5, SimpleUpdateState a6) {
        ClusterUpdatesService a7;
        a7.C.emitNext((Object)new SimpleUpdate(a4, a5 + ":" + a6.name()), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.C, a2.B(), SimpleUpdateState.c);
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.B, a2.M(), SimpleUpdateState.C);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        ClusterUpdatesService a3;
        a3.M(UpdateType.e, a2.replicationGroup(), SimpleUpdateState.A);
    }
}

