/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.source.jpa;

import io.axoniq.axonserver.migration.source.DomainEvent;
import io.axoniq.axonserver.migration.source.EventProducer;
import io.axoniq.axonserver.migration.source.SnapshotEvent;
import io.axoniq.axonserver.migration.source.jpa.DomainEventEntry;
import io.axoniq.axonserver.migration.source.jpa.SnapshotEventEntry;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@ConditionalOnProperty(value={"axoniq.migration.source"}, havingValue="RDBMS")
@Transactional(readOnly=true, transactionManager="eventStoreTransactionManager")
public class JpaEventProducer
implements EventProducer {
    @PersistenceContext(name="eventstore")
    private EntityManager entityManager;

    public List<? extends DomainEvent> findEvents(long lastProcessedToken, int batchSize) {
        return this.entityManager.createNamedQuery("DomainEventEntry.findByGlobalIndex", DomainEventEntry.class).setParameter("lastToken", (Object)lastProcessedToken).setMaxResults(batchSize).getResultList();
    }

    public List<? extends SnapshotEvent> findSnapshots(String lastProcessedTimestamp, int batchSize) {
        return this.entityManager.createNamedQuery("SnapshotEventEntry.findByTimestamp", SnapshotEventEntry.class).setParameter("lastTimeStamp", (Object)lastProcessedTimestamp).setMaxResults(batchSize).getResultList();
    }

    public long getMinIndex() {
        return (Long)this.entityManager.createNamedQuery("DomainEventEntry.minGlobalIndex", Long.class).getSingleResult();
    }

    public long getMaxIndex() {
        return (Long)this.entityManager.createNamedQuery("DomainEventEntry.maxGlobalIndex", Long.class).getSingleResult();
    }
}

