/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.cli.CommandExecutionException;
import io.axoniq.cli.CommandOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class AxonIQCliCommand {
    protected static CommandLine processCommandLine(String name, String[] args, Option ... options) {
        Options cliOptions = new Options().addOption(CommandOptions.ADDRESS).addOption(CommandOptions.USE_HTTPS).addOption(CommandOptions.CONNECT_INSECURE).addOption(CommandOptions.OUTPUT);
        for (Option option : options) {
            cliOptions.addOption(option);
        }
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(cliOptions, args);
        }
        catch (ParseException ex) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(name, cliOptions);
            throw new RuntimeException("Invalid command", ex);
        }
    }

    protected static String createUrl(CommandLine commandLine, String uri, Option ... args) {
        String address = commandLine.getOptionValue(CommandOptions.ADDRESS.getOpt());
        if (address == null) {
            address = commandLine.hasOption(CommandOptions.USE_HTTPS.getOpt()) ? "https://localhost:8024" : "http://localhost:8024";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(address).append(uri);
        for (Option c : args) {
            builder.append("/").append(commandLine.getOptionValue(c.getOpt()));
        }
        return builder.toString();
    }

    protected static CloseableHttpClient createClient(CommandLine commandLine) {
        try {
            String address = commandLine.getOptionValue(CommandOptions.ADDRESS.getOpt());
            if (address == null) {
                String string = address = commandLine.hasOption(CommandOptions.USE_HTTPS.getOpt()) ? "https://localhost:8024" : "http://localhost:8024";
            }
            if (address.startsWith("https")) {
                HttpClientBuilder clientBuilder = HttpClients.custom().useSystemProperties().disableRedirectHandling();
                if (commandLine.hasOption(CommandOptions.CONNECT_INSECURE.getOpt())) {
                    clientBuilder.setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build()).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
                }
                return clientBuilder.build();
            }
            return HttpClientBuilder.create().disableRedirectHandling().useSystemProperties().build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T> T getJSON(CloseableHttpClient httpclient, String url, Class<T> resultClass, int expectedStatusCode, String token) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Accept", "application/json");
        if (token != null) {
            httpGet.addHeader("AxonIQ-Access-Token", token);
        }
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        if (response.getStatusLine().getStatusCode() != expectedStatusCode) {
            throw new CommandExecutionException(response.getStatusLine().getStatusCode(), url, response.getStatusLine().toString() + " - " + AxonIQCliCommand.responseBody((CloseableHttpResponse)response));
        }
        if (resultClass.equals(String.class)) {
            return (T)AxonIQCliCommand.responseBody((CloseableHttpResponse)response);
        }
        try (InputStream is = response.getEntity().getContent();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            Object object = objectMapper.readValue((Reader)reader, resultClass);
            return (T)object;
        }
    }

    protected static String responseBody(CloseableHttpResponse response) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
            builder.append(reader.readLine());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    protected static <T> T getMap(CloseableHttpClient httpclient, String url, TypeReference<T> typeReference, int expectedStatusCode, String token) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        if (token != null) {
            httpGet.addHeader("AxonIQ-Access-Token", token);
        }
        httpGet.addHeader("Accept", "application/json");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        if (response.getStatusLine().getStatusCode() != expectedStatusCode) {
            throw new CommandExecutionException(response.getStatusLine().getStatusCode(), url, response.getStatusLine().toString() + " - " + AxonIQCliCommand.responseBody((CloseableHttpResponse)response));
        }
        try (InputStream is = response.getEntity().getContent();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ObjectMapper objectMapper = new ObjectMapper();
            Object object = objectMapper.readValue((Reader)reader, typeReference);
            return (T)object;
        }
    }

    protected static void delete(CloseableHttpClient httpclient, String url, int expectedStatusCode, String token) throws IOException {
        AxonIQCliCommand.delete((CloseableHttpClient)httpclient, (String)url, (T statusCode) -> statusCode == expectedStatusCode, (String)token);
    }

    protected static void delete(CloseableHttpClient httpclient, String url, Predicate<Integer> statusCodeCheck, String token) throws IOException {
        CloseableHttpResponse response;
        HttpDelete httpDelete = new HttpDelete(url);
        if (token != null) {
            httpDelete.addHeader("AxonIQ-Access-Token", token);
        }
        if (!statusCodeCheck.test((response = httpclient.execute((HttpUriRequest)httpDelete)).getStatusLine().getStatusCode())) {
            throw new CommandExecutionException(response.getStatusLine().getStatusCode(), url, response.getStatusLine().toString() + " - " + AxonIQCliCommand.responseBody((CloseableHttpResponse)response));
        }
    }

    protected static String postJSON(CloseableHttpClient httpclient, String url, Object value, int expectedStatusCode, String token) throws IOException {
        return (String)AxonIQCliCommand.postJSON((CloseableHttpClient)httpclient, (String)url, (Object)value, (int)expectedStatusCode, (String)token, String.class);
    }

    protected static <T> T postJSON(CloseableHttpClient httpclient, String url, Object value, int expectedStatusCode, String token, Class<T> responseClass) throws IOException {
        return (T)AxonIQCliCommand.postJSON((CloseableHttpClient)httpclient, (String)url, (Object)value, (T i) -> i == expectedStatusCode, (String)token, responseClass);
    }

    protected static <T> T postJSON(CloseableHttpClient httpclient, String url, Object value, Predicate<Integer> statusCodeCheck, String token, Class<T> responseClass) throws IOException {
        CloseableHttpResponse response;
        HttpPost httpPost = new HttpPost(url);
        if (token != null) {
            httpPost.addHeader("AxonIQ-Access-Token", token);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        if (value != null) {
            httpPost.addHeader("Content-Type", "application/json");
            ByteArrayEntity entity = new ByteArrayEntity(objectMapper.writeValueAsBytes(value));
            httpPost.setEntity((HttpEntity)entity);
        }
        if (!statusCodeCheck.test((response = httpclient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode())) {
            throw new CommandExecutionException(response.getStatusLine().getStatusCode(), url, response.getStatusLine().toString() + " - " + AxonIQCliCommand.responseBody((CloseableHttpResponse)response));
        }
        if (responseClass.equals(String.class)) {
            return (T)AxonIQCliCommand.responseBody((CloseableHttpResponse)response);
        }
        return (T)objectMapper.readValue(response.getEntity().getContent(), responseClass);
    }

    protected static <T> T patchJSON(CloseableHttpClient httpclient, String url, Object value, int expectedStatusCode, String token, Class<T> responseClass) throws IOException {
        CloseableHttpResponse response;
        HttpPatch httpPost = new HttpPatch(url);
        if (token != null) {
            httpPost.addHeader("AxonIQ-Access-Token", token);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        if (value != null) {
            httpPost.addHeader("Content-Type", "application/json");
            ByteArrayEntity entity = new ByteArrayEntity(objectMapper.writeValueAsBytes(value));
            httpPost.setEntity((HttpEntity)entity);
        }
        if ((response = httpclient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() != expectedStatusCode) {
            throw new CommandExecutionException(response.getStatusLine().getStatusCode(), url, response.getStatusLine().toString() + " - " + AxonIQCliCommand.responseBody((CloseableHttpResponse)response));
        }
        if (responseClass.equals(String.class)) {
            return (T)AxonIQCliCommand.responseBody((CloseableHttpResponse)response);
        }
        return (T)objectMapper.readValue(response.getEntity().getContent(), responseClass);
    }

    public static String option(CommandLine commandLine, Option option) {
        return commandLine.getOptionValue(option.getOpt());
    }

    public static boolean jsonOutput(CommandLine commandLine) {
        return "json".equals(AxonIQCliCommand.option((CommandLine)commandLine, (Option)CommandOptions.OUTPUT));
    }

    protected static String getToken(CommandLine commandLine) {
        File tokenFile;
        String token = commandLine.getOptionValue(CommandOptions.TOKEN.getOpt());
        if (token == null && (tokenFile = new File("security/.token")).exists() && tokenFile.canRead()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(tokenFile));){
                token = reader.readLine();
            }
            catch (IOException e) {
                System.err.println("Cannot read token file: " + e.getMessage());
            }
        }
        return token;
    }
}

