/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.ActivatePlugin;
import io.axoniq.cli.AddNodeToContext;
import io.axoniq.cli.AddNodeToReplicationGroup;
import io.axoniq.cli.Cluster;
import io.axoniq.cli.CommandDispatcher;
import io.axoniq.cli.CommandExecutionException;
import io.axoniq.cli.ConfigurePlugin;
import io.axoniq.cli.DeleteApplication;
import io.axoniq.cli.DeleteContext;
import io.axoniq.cli.DeleteEvents;
import io.axoniq.cli.DeleteNodeFromContext;
import io.axoniq.cli.DeleteNodeFromReplicationGroup;
import io.axoniq.cli.DeletePlugin;
import io.axoniq.cli.DeleteReplicationGroup;
import io.axoniq.cli.DeleteUser;
import io.axoniq.cli.InitNode;
import io.axoniq.cli.ListApplications;
import io.axoniq.cli.ListContexts;
import io.axoniq.cli.ListPlugins;
import io.axoniq.cli.ListReplicationGroups;
import io.axoniq.cli.ListUsers;
import io.axoniq.cli.Metrics;
import io.axoniq.cli.RegisterApplication;
import io.axoniq.cli.RegisterContext;
import io.axoniq.cli.RegisterNode;
import io.axoniq.cli.RegisterReplicationGroup;
import io.axoniq.cli.RegisterUser;
import io.axoniq.cli.UnregisterNode;
import io.axoniq.cli.UnregisterPlugin;
import io.axoniq.cli.UpdateContextProperties;
import io.axoniq.cli.UpdateLicense;
import io.axoniq.cli.UploadPlugin;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommandDispatcher {
    private static final Map<String, CommandInformation> executorMap = new HashMap();

    public static void main(String[] args) {
        CommandInformation executor;
        if (args.length == 0) {
            System.err.println("No command specified. Valid commands: ");
            CommandDispatcher.usage();
            System.exit(1);
        }
        if ((executor = (CommandInformation)executorMap.get(args[0])) != null) {
            try {
                executor.process(args);
            }
            catch (CommandExecutionException ex) {
                System.err.println("Error processing command '" + args[0] + "' on '" + ex.getUrl() + "': " + ex.getMessage());
                System.exit(ex.getErrorCode());
            }
            catch (Exception ex) {
                System.err.println("Error processing command '" + args[0] + "': " + ex.getMessage());
                System.exit(1);
            }
        } else {
            System.err.println("Invalid command specified: " + args[0] + ". Valid commands: ");
            CommandDispatcher.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        for (Group value : Group.values()) {
            System.err.println(value);
            executorMap.entrySet().stream().filter(e -> ((CommandInformation)e.getValue()).group.equals((Object)value)).sorted(Map.Entry.comparingByKey()).forEach(e -> System.err.println("  " + (String)e.getKey()));
        }
    }

    static {
        executorMap.put("cluster", new CommandInformation(Group.CLUSTER, Cluster::run));
        executorMap.put("delete-application", new CommandInformation(Group.APPLICATION, DeleteApplication::run));
        executorMap.put("register-application", new CommandInformation(Group.APPLICATION, RegisterApplication::run));
        executorMap.put("applications", new CommandInformation(Group.APPLICATION, ListApplications::run));
        executorMap.put("register-node", new CommandInformation(Group.CLUSTER, RegisterNode::run));
        executorMap.put("unregister-node", new CommandInformation(Group.CLUSTER, UnregisterNode::run));
        executorMap.put("register-context", new CommandInformation(Group.CONTEXT, RegisterContext::run));
        executorMap.put("update-context", new CommandInformation(Group.CONTEXT, UpdateContextProperties::run));
        executorMap.put("delete-context", new CommandInformation(Group.CONTEXT, DeleteContext::run));
        executorMap.put("add-node-to-context", new CommandInformation(Group.CONTEXT, AddNodeToContext::run));
        executorMap.put("delete-node-from-context", new CommandInformation(Group.CONTEXT, DeleteNodeFromContext::run));
        executorMap.put("contexts", new CommandInformation(Group.CONTEXT, ListContexts::run));
        executorMap.put("register-replication-group", new CommandInformation(Group.REPLICATIONGROUP, RegisterReplicationGroup::run));
        executorMap.put("delete-replication-group", new CommandInformation(Group.REPLICATIONGROUP, DeleteReplicationGroup::run));
        executorMap.put("add-node-to-replication-group", new CommandInformation(Group.REPLICATIONGROUP, AddNodeToReplicationGroup::run));
        executorMap.put("delete-node-from-replication-group", new CommandInformation(Group.REPLICATIONGROUP, DeleteNodeFromReplicationGroup::run));
        executorMap.put("replication-groups", new CommandInformation(Group.REPLICATIONGROUP, ListReplicationGroups::run));
        executorMap.put("register-user", new CommandInformation(Group.USER, RegisterUser::run));
        executorMap.put("delete-user", new CommandInformation(Group.USER, DeleteUser::run));
        executorMap.put("users", new CommandInformation(Group.USER, ListUsers::run));
        executorMap.put("metrics", new CommandInformation(Group.METRICS, Metrics::run));
        executorMap.put("init-cluster", new CommandInformation(Group.CLUSTER, InitNode::run));
        executorMap.put("purge-events", new CommandInformation(Group.OTHER, DeleteEvents::run));
        executorMap.put("update-license", new CommandInformation(Group.CLUSTER, UpdateLicense::run));
        executorMap.put("upload-plugin", new CommandInformation(Group.PLUGINS, UploadPlugin::run));
        executorMap.put("configure-plugin", new CommandInformation(Group.PLUGINS, ConfigurePlugin::run));
        executorMap.put("activate-plugin", new CommandInformation(Group.PLUGINS, args -> ActivatePlugin.run((String[])args, (boolean)true)));
        executorMap.put("pause-plugin", new CommandInformation(Group.PLUGINS, args -> ActivatePlugin.run((String[])args, (boolean)false)));
        executorMap.put("unregister-plugin", new CommandInformation(Group.PLUGINS, UnregisterPlugin::run));
        executorMap.put("delete-plugin", new CommandInformation(Group.PLUGINS, DeletePlugin::run));
        executorMap.put("plugins", new CommandInformation(Group.PLUGINS, ListPlugins::run));
    }
}

