/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliCommand;
import io.axoniq.cli.CommandOptions;
import io.axoniq.cli.json.ContextNode;
import io.axoniq.cli.json.NodeAndRole;
import io.axoniq.cli.json.RestResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.http.impl.client.CloseableHttpClient;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegisterContext
extends AxonIQCliCommand {
    private static final List<Integer> VALID_STATUS_CODES = Arrays.asList(200, 202);

    public static void run(String[] args) throws IOException {
        CommandLine commandLine = RegisterContext.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.CONTEXT, CommandOptions.CONTEXTREPLICATIONGROUP, CommandOptions.CONTEXT_PRIMARY_NODES, CommandOptions.ACTIVE_BACKUP_NODES, CommandOptions.PASSIVE_BACKUP_NODES, CommandOptions.MESSAGING_ONLY_NODES, CommandOptions.SECONDARY_NODES, CommandOptions.PROPERTIES, CommandOptions.TOKEN});
        String url = RegisterContext.createUrl((CommandLine)commandLine, (String)"/v1/context", (Option[])new Option[0]);
        ContextNode contextNode = new ContextNode();
        contextNode.setContext(commandLine.getOptionValue(CommandOptions.CONTEXT.getOpt()));
        if (commandLine.hasOption(CommandOptions.REPLICATIONGROUP.getOpt())) {
            contextNode.setReplicationGroup(commandLine.getOptionValue(CommandOptions.CONTEXTREPLICATIONGROUP.getOpt()));
        }
        ArrayList nodeRolesMap = new ArrayList();
        HashSet definedNodes = new HashSet();
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.CONTEXT_PRIMARY_NODES, (String)"PRIMARY", definedNodes, nodeRolesMap);
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.ACTIVE_BACKUP_NODES, (String)"ACTIVE_BACKUP", definedNodes, nodeRolesMap);
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.PASSIVE_BACKUP_NODES, (String)"PASSIVE_BACKUP", definedNodes, nodeRolesMap);
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.MESSAGING_ONLY_NODES, (String)"MESSAGING_ONLY", definedNodes, nodeRolesMap);
        RegisterContext.addNodes((CommandLine)commandLine, (Option)CommandOptions.SECONDARY_NODES, (String)"SECONDARY", definedNodes, nodeRolesMap);
        if (commandLine.hasOption(CommandOptions.PROPERTIES.getOpt())) {
            for (String metadataProperty : commandLine.getOptionValues(CommandOptions.PROPERTIES.getOpt())) {
                String[] keyValue = metadataProperty.split("=", 2);
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException("Property value must be key=value - " + keyValue);
                }
                contextNode.getMetaData().put(keyValue[0].trim(), keyValue[1].trim());
            }
        }
        contextNode.setRoles(nodeRolesMap);
        contextNode.setNodes(new ArrayList(definedNodes));
        try (CloseableHttpClient httpclient = RegisterContext.createClient((CommandLine)commandLine);){
            RegisterContext.postJSON((CloseableHttpClient)httpclient, (String)url, (Object)contextNode, VALID_STATUS_CODES::contains, (String)RegisterContext.getToken((CommandLine)commandLine), RestResponse.class);
        }
    }

    private static void addNodes(CommandLine commandLine, Option nodes, String role, Set<String> definedNodes, List<NodeAndRole> nodeRolesMap) {
        if (commandLine.hasOption(nodes.getOpt())) {
            for (String primary : commandLine.getOptionValues(nodes.getOpt())) {
                if (definedNodes.contains(primary)) {
                    throw new IllegalArgumentException("Node can only be provided once");
                }
                nodeRolesMap.add(new NodeAndRole(primary, role));
                definedNodes.add(primary);
            }
        }
    }
}

