/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.access.application;

import io.axoniq.axonserver.access.application.Hasher;
import org.mindrot.jbcrypt.BCrypt;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={BCrypt.class})
public class BcryptHasher
implements Hasher {
    private static final String L = "{BCrypt}";

    public boolean checkpw(String a2, String a3) {
        if (a3 == null || !a3.startsWith(L)) {
            return false;
        }
        return BCrypt.checkpw((String)a2, (String)a3.substring(L.length()));
    }

    public String hash(String a2) {
        return L + BCrypt.hashpw((String)a2, (String)BCrypt.gensalt());
    }

    public BcryptHasher() {
        BcryptHasher a2;
    }
}

