/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin;

import io.axoniq.axonserver.admin.Result;
import io.axoniq.axonserver.applicationevents.AxonServerEventPublisher;
import io.axoniq.axonserver.applicationevents.InstructionResultEvent;
import io.axoniq.axonserver.component.version.BackwardsCompatibleVersion;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.component.version.UnknownVersion;
import io.axoniq.axonserver.component.version.Version;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.rest.HttpStreamingQuery;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InstructionResultPublisher {
    private final AxonServerEventPublisher C;
    private final List<Version> D;
    private final Function<ClientStreamIdentification, Version> l;
    private static final String I = "Instruction sent to client using Axon connector version prior to 4.6.0, instruction result not returned";
    private final BiConsumer<PlatformInboundInstruction.RequestCase, PlatformService.InstructionConsumer> L;

    public InstructionResultPublisher(AxonServerEventPublisher a2, BiConsumer<PlatformInboundInstruction.RequestCase, PlatformService.InstructionConsumer> a3, Function<ClientStreamIdentification, Version> a4) {
        InstructionResultPublisher a5;
        Version[] versionArray = new Version[2];
        versionArray[0] = new BackwardsCompatibleVersion(ClientVersionsCache.M((Object)"O\u0014M"));
        versionArray[1] = new BackwardsCompatibleVersion(HttpStreamingQuery.M((Object)"h"));
        a5.D = Arrays.asList(versionArray);
        InstructionResultPublisher instructionResultPublisher = a5;
        a5.C = a2;
        instructionResultPublisher.L = a3;
        instructionResultPublisher.l = a4;
    }

    @PostConstruct
    public void initialize() {
        InstructionResultPublisher a4;
        a4.L.accept(PlatformInboundInstruction.RequestCase.RESULT, (a2, a3) -> {
            PlatformInboundInstruction platformInboundInstruction;
            String string;
            PlatformInboundInstruction platformInboundInstruction2;
            Result result;
            InstructionResultPublisher a4;
            a3 = a3.getResult();
            AxonServerEventPublisher axonServerEventPublisher = a4.C;
            String string2 = a3.getInstructionId();
            String string3 = a2.getClientId();
            if (a3.getSuccess()) {
                result = Result.l;
                platformInboundInstruction2 = a3;
            } else {
                result = Result.L;
                platformInboundInstruction2 = a3;
            }
            if (platformInboundInstruction2.hasError()) {
                string = a3.getError().getErrorCode();
                platformInboundInstruction = a3;
            } else {
                string = null;
                platformInboundInstruction = a3;
            }
            axonServerEventPublisher.publishEvent((Object)new InstructionResultEvent(string2, string3, result, string, platformInboundInstruction.hasError() ? a3.getError().getMessage() : null));
        });
        a4.L.accept(PlatformInboundInstruction.RequestCase.ACK, (a2, a3) -> {
            InstructionResultPublisher a4;
            a3 = a3.getAck();
            InstructionResultPublisher instructionResultPublisher = a4;
            if (!instructionResultPublisher.M((Version)instructionResultPublisher.l.apply(new ClientStreamIdentification(a2.getContext(), a2.getClientStreamId())))) {
                PlatformInboundInstruction platformInboundInstruction;
                String string;
                PlatformInboundInstruction platformInboundInstruction2;
                Result result;
                AxonServerEventPublisher axonServerEventPublisher = a4.C;
                String string2 = a3.getInstructionId();
                String string3 = a2.getClientId();
                if (a3.getSuccess()) {
                    result = Result.C;
                    platformInboundInstruction2 = a3;
                } else {
                    result = Result.L;
                    platformInboundInstruction2 = a3;
                }
                if (platformInboundInstruction2.hasError()) {
                    string = a3.getError().getErrorCode();
                    platformInboundInstruction = a3;
                } else {
                    string = ErrorCode.INSTRUCTION_ACK_ONLY.getCode();
                    platformInboundInstruction = a3;
                }
                axonServerEventPublisher.publishEvent((Object)new InstructionResultEvent(string2, string3, result, string, platformInboundInstruction.hasError() ? a3.getError().getMessage() : I));
            }
        });
    }

    @Autowired
    public InstructionResultPublisher(AxonServerEventPublisher a2, PlatformService a4, ClientVersionsCache a5) {
        a6(a2, (arg_0, arg_1) -> ((PlatformService)a4).onInboundInstruction(arg_0, arg_1), a3 -> {
            if ((a3 = a5.apply((ClientStreamIdentification)a3)) == null || ((String)a3).isEmpty()) {
                return new UnknownVersion();
            }
            return new BackwardsCompatibleVersion((String)a3);
        });
        InstructionResultPublisher a6;
    }

    private /* synthetic */ boolean M(Version a2) {
        InstructionResultPublisher a3;
        return a2.greaterOrEqualThan((Iterable)a3.D);
    }
}

