/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.application.requestprocessor;

import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.application.api.ApplicationAdminService;
import io.axoniq.axonserver.admin.application.api.ApplicationContextRoleRequest;
import io.axoniq.axonserver.admin.application.api.ApplicationOverview;
import io.axoniq.axonserver.admin.application.api.ApplicationRequest;
import io.axoniq.axonserver.admin.application.api.ConnectedApplicationOverview;
import io.axoniq.axonserver.admin.application.requestprocessor.ContextStateProvider;
import io.axoniq.axonserver.admin.application.requestprocessor.d;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.common.Role;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.grpc.internal.Application;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.transport.rest.v2.LoggingRestControllerV2;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ApplicationAdminRequestProcessor
implements ApplicationAdminService {
    private final Logger k;
    private final RoleController B;
    private static final Logger C = AuditLog.getLogger();
    private static final String D = "/\\%;";
    private final ContextStateProvider l;
    private final AdminApplicationController I;
    private final RaftConfigServiceFactory L;

    @Nonnull
    public Flux<ApplicationOverview> getApplications(@Nonnull Authentication a3) {
        return Flux.fromStream((Stream)this.I.getApplications()).map(a2 -> {
            ApplicationAdminRequestProcessor a3;
            return new d(a3, a2);
        }).doFirst(() -> {
            if (C.isInfoEnabled()) {
                C.info(LoggingRestControllerV2.M((Object)"\u000bE-cpl5O%[#JpJ?\u001e<W#Jp_ N<W3_$W?P#\u001e1P4\u001e$V5W\"\u001e\"Q<[#\u0010"), (Object)AuditLog.username((String)a3.username()));
            }
        }).doOnSubscribe(a2 -> {
            ApplicationAdminRequestProcessor a3;
            a3.k.info(LoggingRestControllerV2.M((Object)"y5Jp_ N<W3_$W?P#\u001e\"[!K5M$\u001e\"[3[9H5ZpX?Lp_ N<W3_$W?P"));
        }).doOnError(a2 -> {
            ApplicationAdminRequestProcessor a3;
            a3.M(a2, PluginEventsLogger.M((Object)"/$\u00189\u0018v\u0006?\u0019\"\u00038\rv\u000b&\u001a:\u00035\u000b\"\u00039\u0004%"), new Object[0]);
        });
    }

    @Nonnull
    public Mono<ApplicationOverview> getApplication(@Nonnull String applicationName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            ApplicationAdminRequestProcessor applicationAdminRequestProcessor = a3;
            return applicationAdminRequestProcessor.M(applicationAdminRequestProcessor.I.get(applicationName));
        }).doFirst(() -> {
            if (C.isInfoEnabled()) {
                C.info(LoggingRestControllerV2.M((Object)"e+C\r\u001e\u0002[!K5M$\u001e$QpY5Jp_ N<W3_$W?PpE-\u001e1P4\u001e9J#\u001e\"Q<[#\u0010"), (Object)AuditLog.username((String)a2.username()), (Object)applicationName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.k.info(PluginEventsLogger.M((Object)"-3\u001ev\u000b&\u001a:\u00035\u000b\"\u00039\u0004v\u00183\u001b#\u000f%\u001ev\u00183\t3\u0003 \u000f2J0\u0005$J7\u001a&\u0006?\t7\u001e?\u00058Pv\u0011+"), (Object)applicationName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = applicationName;
            a4.M(a3, LoggingRestControllerV2.M((Object)"E-\u0004p{\"L?LpY5J$W>Yp_ N<W3_$W?P"), objectArray);
        });
    }

    @Nonnull
    public Mono<String> refreshToken(@Nonnull String applicationName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            return a3.L.getRaftConfigService().refreshToken(Application.newBuilder().setName(applicationName).build()).getToken();
        }).doFirst(() -> {
            if (C.isInfoEnabled()) {
                C.info(PluginEventsLogger.M((Object)"\r\u0011+7v83\u001b#\u000f%\u001ev\u001e9J$\u000f8\u000f!J\"\u0005=\u000f8J0\u0005$J7\u001a&\u0006?\t7\u001e?\u00058J-\u0017x"), (Object)AuditLog.username((String)a2.username()), (Object)applicationName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.k.info(PluginEventsLogger.M((Object)"\u0012\u000f:\u000f\"\u000fv\u000b&\u001a:\u00035\u000b\"\u00039\u0004v\u00183\u001b#\u000f%\u001ev\u00183\t3\u0003 \u000f2J0\u0005$J7\u001a&\u0006?\t7\u001e?\u00058Pv\u0011+"), (Object)applicationName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = applicationName;
            a4.M(a3, PluginEventsLogger.M((Object)"\u0011+Pv/$\u00189\u0018v\u00183\f$\u000f%\u0002?\u00041J\"\u0005=\u000f8"), objectArray);
        });
    }

    @Nonnull
    public Mono<ConnectedApplicationOverview> getConnectedApplicationsByContext(@Nonnull String contextName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            return a3.l.getCurrentState(contextName);
        }).doFirst(() -> {
            if (C.isInfoEnabled()) {
                C.info(LoggingRestControllerV2.M((Object)"\u000bE-cpl5O%[#JpJ?\u001e7[$\u001e3Q>P5]$[4\u001e1N R9]1J9Q>MpE-\u0010"), (Object)AuditLog.username((String)a2.username()), (Object)contextName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.k.info(LoggingRestControllerV2.M((Object)"\u0017[$\u001e3Q>P5]$[4\u001e1N R9]1J9Q>\u001e\"[!K5M$\u001e\"[3[9H5ZpX?Lp]?P$[(Jj\u001e+C"), (Object)contextName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = contextName;
            a4.M(a3, PluginEventsLogger.M((Object)"-\u0017lJ\u0013\u0018$\u0005$J1\u000f\"\u001e?\u00041J5\u00058\u00043\t\"\u000f2J7\u001a&\u0006?\t7\u001e?\u00058"), objectArray);
        });
    }

    private /* synthetic */ void M(List<ApplicationContextRoleRequest> a2) {
        ApplicationAdminRequestProcessor a3;
        Set set = a3.B.listRoles().stream().map(Role::getRole).collect(Collectors.toSet());
        for (String string : a2.stream().map(ApplicationContextRoleRequest::roles).flatMap(Collection::stream).distinct().collect(Collectors.toList())) {
            if (set.contains(string)) continue;
            throw new MessagingPlatformException(ErrorCode.UNKNOWN_ROLE, string + ": Role unknown");
        }
    }

    @Nonnull
    public Mono<String> createOrUpdateApplication(@Nonnull ApplicationRequest application, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ApplicationAdminRequestProcessor a3;
            return a3.L.getRaftConfigService().updateApplication(ApplicationProtoConverter.createApplication((ApplicationRequest)application)).getToken();
        }).doFirst(() -> {
            if (C.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = application.name();
                objectArray[2] = application.rolesPerContext();
                C.info(PluginEventsLogger.M((Object)"1-\u0017\u000bJ\u0004\u000f'\u001f3\u0019\"J\"\u0005v\t$\u000f7\u001e3J7\u001a&\u0006?\t7\u001e?\u00058Jt\u0011+Hv\u001d?\u001e>J$\u0005:\u000f%J-\u0017x"), objectArray);
            }
        }).doFirst(() -> {
            ApplicationAdminRequestProcessor a3;
            ApplicationAdminRequestProcessor applicationAdminRequestProcessor = a3;
            applicationAdminRequestProcessor.M(application.name());
            applicationAdminRequestProcessor.M(application.rolesPerContext());
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.k.info(PluginEventsLogger.M((Object)"\u0015\u00183\u000b\"\u000fv\u000b&\u001a:\u00035\u000b\"\u00039\u0004v\u00183\u001b#\u000f%\u001ev\u00183\t3\u0003 \u000f2J0\u0005$J7\u001a&\u0006?\t7\u001e?\u00058Pv\u0011+"), (Object)application.name());
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = application.name();
            a4.M(a3, PluginEventsLogger.M((Object)"-\u0017lJ\u0013\u0018$\u0005$J5\u00183\u000b\"\u00038\ry\u001f&\u000e7\u001e?\u00041J7\u001a&\u0006?\t7\u001e?\u00058"), objectArray);
        });
    }

    public ApplicationAdminRequestProcessor(RaftConfigServiceFactory a2, AdminApplicationController a3, RoleController a4, ContextStateProvider a5) {
        ApplicationAdminRequestProcessor a6;
        ApplicationAdminRequestProcessor applicationAdminRequestProcessor = a6;
        ApplicationAdminRequestProcessor applicationAdminRequestProcessor2 = a6;
        a6.k = LoggerFactory.getLogger(ApplicationAdminRequestProcessor.class);
        applicationAdminRequestProcessor2.L = a2;
        applicationAdminRequestProcessor2.I = a3;
        applicationAdminRequestProcessor.B = a4;
        applicationAdminRequestProcessor.l = a5;
    }

    private /* synthetic */ void M(String a2) {
        int n;
        char[] cArray = a2.toCharArray();
        int n2 = cArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            char c2 = cArray[n];
            if (D.indexOf(c2) >= 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = a2;
                objectArray[1] = Character.valueOf(c2);
                throw new MessagingPlatformException(ErrorCode.INVALID_NAME, String.format(LoggingRestControllerV2.M((Object)"uMj\u001e9P&_<W4\u001e3V1L1]$[\"\u001ex\u001b#\u0017pW>\u001e>_=["), objectArray));
            }
            n3 = ++n;
        }
    }

    @Nonnull
    public Mono<Void> deleteApplication(@Nonnull String applicationName, @Nonnull Authentication a2) {
        return Mono.fromRunnable(() -> {
            ApplicationAdminRequestProcessor a3;
            a3.L.getRaftConfigService().deleteApplication(Application.newBuilder().setName(applicationName).build());
        }).doFirst(() -> {
            if (C.isInfoEnabled()) {
                C.info(PluginEventsLogger.M((Object)"1-\u0017\u000bJ\u0004\u000f'\u001f3\u0019\"J\"\u0005v\u000e3\u00063\u001e3J7\u001a&\u0006?\t7\u001e?\u00058J-\u0017x"), (Object)AuditLog.username((String)a2.username()), (Object)applicationName);
            }
        }).doOnSubscribe(a3 -> {
            ApplicationAdminRequestProcessor a4;
            a4.k.info(LoggingRestControllerV2.M((Object)"z5R5J5\u001e1N R9]1J9Q>\u001e\"[!K5M$\u001e\"[3[9H5ZpX?Lp_ N<W3_$W?Pj\u001e+C"), (Object)applicationName);
        }).doOnError(a3 -> {
            ApplicationAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = applicationName;
            a4.M(a3, LoggingRestControllerV2.M((Object)"+Cj\u001e\u0015L\"Q\"\u001e4[<[$W>Yp_ N<W3_$W?P"), objectArray);
        });
    }

    private /* synthetic */ void M(Throwable a2, String a3, Object ... a4) {
        ApplicationAdminRequestProcessor a5;
        if (MessagingPlatformException.isClientException((Throwable)a2)) {
            a5.k.info(a3, (Object)a4, (Object)a2);
            return;
        }
        a5.k.warn(a3, (Object)a4, (Object)a2);
    }
}

