/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.context.requestprocessor;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.admin.context.api.ContextAdminService;
import io.axoniq.axonserver.admin.context.api.ContextOverview;
import io.axoniq.axonserver.admin.context.api.ContextPropertiesUpdate;
import io.axoniq.axonserver.admin.context.api.ContextUpdate;
import io.axoniq.axonserver.admin.context.api.ContextUpdateState;
import io.axoniq.axonserver.admin.context.api.RemoveContext;
import io.axoniq.axonserver.admin.context.api.ReplicationGroupContext;
import io.axoniq.axonserver.admin.context.requestprocessor.ContextFilter;
import io.axoniq.axonserver.admin.context.requestprocessor.F;
import io.axoniq.axonserver.admin.context.requestprocessor.TierConfiguration;
import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.admin.context.requestprocessor.d;
import io.axoniq.axonserver.admin.tier.api.LocalTierInfo;
import io.axoniq.axonserver.admin.tier.requestprocessor.LocalTierAdminRequestProcessor;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminContexts;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.localstorage.ContextPropertyDefinition;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBPropertiesProvider;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.HttpStreamingQuery;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.retry.Retry;

@Service
public class ContextAdminRequestProcessor
implements ContextAdminService {
    private final ContextFilter g;
    private static final Logger E = AuditLog.getLogger();
    private final EmbeddedDBPropertiesProvider F;
    private final AdminContexts a;
    private final Predicate<String> d;
    private final ClusterController k;
    private final Logger B;
    private final Sinks.Many<ContextUpdate> C;
    private final RaftConfigServiceFactory D;
    private final LocalTierAdminRequestProcessor l;
    private final Limits I;
    private final VisibleContextCache L;

    public ContextAdminRequestProcessor(RaftConfigServiceFactory a2, ClusterController a3, AdminContexts a4, ContextFilter a5, Limits a6, VisibleContextCache a7, LocalTierAdminRequestProcessor a8, EmbeddedDBPropertiesProvider a9) {
        ContextAdminRequestProcessor a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor = a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor2 = a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor3 = a10;
        ContextAdminRequestProcessor contextAdminRequestProcessor4 = a10;
        a10.B = LoggerFactory.getLogger(ContextAdminRequestProcessor.class);
        ContextAdminRequestProcessor contextAdminRequestProcessor5 = a10;
        a10.d = new ContextNameValidation();
        contextAdminRequestProcessor5.C = Sinks.many().multicast().onBackpressureBuffer();
        contextAdminRequestProcessor4.D = a2;
        contextAdminRequestProcessor4.k = a3;
        contextAdminRequestProcessor3.a = a4;
        contextAdminRequestProcessor3.g = a5;
        contextAdminRequestProcessor2.I = a6;
        contextAdminRequestProcessor2.L = a7;
        contextAdminRequestProcessor.l = a8;
        contextAdminRequestProcessor.F = a9;
    }

    @NotNull
    public Mono<Void> updateContext(@NotNull ContextPropertiesUpdate request, @Nonnull Authentication a2) {
        return Mono.fromFuture(() -> {
            ContextAdminRequestProcessor a3;
            ContextAdminRequestProcessor contextAdminRequestProcessor = a3;
            contextAdminRequestProcessor.B.info(HttpStreamingQuery.M((Object)"\bB9S)W}Q2\\)W%F}@8C(W.F}@8Q8[+W9\u0012;]/\u0012>]3F8J)\b}I "), (Object)request.contextName());
            return contextAdminRequestProcessor.D.getRaftConfigService().updateContext(request.contextName(), request.metaDataMap());
        }).doFirst(() -> {
            ContextAdminRequestProcessor a4;
            E.info(HttpStreamingQuery.M((Object)"i&O\u0000\u0012\u000fW,G8A)\u0012)]}G-V<F8\u0012>]3F8J)\u0012&Os"), (Object)AuditLog.username((String)a2.username()), (Object)request.contextName());
            ContextAdminRequestProcessor contextAdminRequestProcessor = a4;
            contextAdminRequestProcessor.M(request.metaDataMap());
            contextAdminRequestProcessor.M(request.contextName(), request.metaDataMap(), a2);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.contextName();
            a4.M(a3, HttpStreamingQuery.M((Object)"I \b}W%Q8B)[2\\}E5[1W}G-V<F4\\:\u0012>]3F8J)"), objectArray);
        });
    }

    @Nonnull
    public Mono<ContextOverview> getContext(@Nonnull String contextName, @Nonnull Authentication a4) {
        return Mono.fromCallable(() -> {
            ContextAdminRequestProcessor a3;
            if (!a3.k.isAdminNode()) {
                throw new MessagingPlatformException(ErrorCode.UNSUPPORTED_INSTRUCTION, EventTypeContext.M((Object)"3:\u00190]<\u000eu\u0013:\tu\u001c;]\n\u001c1\u0010<\u0013u\u0013:\u00190"));
            }
            return a3.a.findById(contextName);
        }).map(a2 -> (AdminContext)a2.orElseThrow(() -> new MessagingPlatformException(ErrorCode.CONTEXT_NOT_FOUND, EventTypeContext.M((Object)"\u0016\u0012;\t0\u0005!];\u0012!]3\u0012 \u00131")))).filter(a3 -> {
            ContextAdminRequestProcessor a4;
            return a4.g.hasAccess(a3.getName(), a4);
        }).switchIfEmpty(Mono.error(() -> new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, EventTypeContext.M((Object)"\u001c\u0013#\u001c9\u00141]!\u0012>\u0018;")))).retryWhen((Retry)Retry.backoff((long)2L, (Duration)Duration.ofSeconds(1L)).onRetryExhaustedThrow((a2, a3) -> a3.failure())).map(a2 -> {
            ContextAdminRequestProcessor a3;
            return new d(a3, a2);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = contextName;
            a4.M(a3, HttpStreamingQuery.M((Object)"I \b}W%Q8B)[2\\}E5[1W}@8F/[8D4\\:\u0012>]3F8J)"), objectArray);
        });
    }

    private /* synthetic */ void M(Throwable a2, String a3, Object ... a4) {
        ContextAdminRequestProcessor a5;
        if (MessagingPlatformException.isClientException((Throwable)a2)) {
            a5.B.info(a3, (Object)a4, (Object)a2);
            return;
        }
        a5.B.warn(a3, (Object)a4, (Object)a2);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin a4) {
        ContextAdminRequestProcessor a5;
        a5.C.emitNext((Object)new F(a4.context(), ContextUpdateState.I), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    private /* synthetic */ void M(String a4, Map<String, String> a5, Authentication a6) {
        ContextAdminRequestProcessor a7;
        TierConfiguration tierConfiguration = new TierConfiguration(a5);
        a6 = a7.l.getLocalTiers(a6).stream().map(LocalTierInfo::id).collect(Collectors.toList());
        if (a7.M(tierConfiguration) && !a7.d(tierConfiguration)) {
            throw new IllegalArgumentException(EventTypeContext.M((Object)"\u0018\b9\t<P!\u00140\u000fu\u000e!\u0012'\u001c2\u0018u\u0014&]:\u00139\u0004u\u001c9\u0011:\n0\u0019u\n<\t=]4]#\u001c9\u00141]9\u00146\u0018;\u000e0"));
        }
        tierConfiguration.M((List)a6);
        a5.entrySet().stream().filter(a2 -> ((String)a2.getKey()).startsWith("event.storage")).map(Map.Entry::getValue).forEach(a3 -> {
            ContextAdminRequestProcessor a4;
            a4.F.getEventProperties(a4).getStorage(a3);
        });
        a5.entrySet().stream().filter(a2 -> ((String)a2.getKey()).startsWith("snapshot.storage")).map(Map.Entry::getValue).forEach(a3 -> {
            ContextAdminRequestProcessor a4;
            a4.F.getSnapshotProperties(a4).getStorage(a3);
        });
    }

    @Nonnull
    public Flux<String> getVisibleContexts(boolean includeAdmin, @Nonnull Authentication a2) {
        return Flux.fromIterable((Iterable)this.L.apply(a2)).filter(a3 -> {
            if (includeAdmin || !RaftAdminGroup.M((String)a3)) {
                return true;
            }
            return false;
        });
    }

    private /* synthetic */ void M(@NotNull Map<String, String> a2) {
        for (Map.Entry entry : a2.entrySet()) {
            try {
                ContextPropertyDefinition contextPropertyDefinition = ContextPropertyDefinition.M((String)((String)entry.getKey()));
                if (contextPropertyDefinition == null) continue;
                contextPropertyDefinition.M((String)entry.getValue());
            }
            catch (Exception exception) {
                throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, exception.getMessage());
            }
        }
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin a4) {
        ContextAdminRequestProcessor a5;
        a5.C.emitNext((Object)new F(a4.M(), ContextUpdateState.l), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin a4) {
        ContextAdminRequestProcessor a5;
        a5.C.emitNext((Object)new F(a4.context(), ContextUpdateState.C), (a2, a3) -> {
            if (a3 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    private /* synthetic */ void M(String a2) {
        ContextAdminRequestProcessor a3;
        if (!a3.d.test(a2)) {
            throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, EventTypeContext.M((Object)"4;\u000b4\u0011<\u0019u\u001e:\u0013!\u0018-\tu\u00134\u00100"));
        }
    }

    @Nonnull
    public Mono<Void> createContext(@Nonnull ReplicationGroupContext request, @Nonnull Authentication a2) {
        return Mono.fromFuture(() -> {
            ContextAdminRequestProcessor a3;
            ContextAdminRequestProcessor contextAdminRequestProcessor = a3;
            contextAdminRequestProcessor.B.info(HttpStreamingQuery.M((Object)"\u001e@8S)W}Q2\\)W%F}@8C(W.F}@8Q8[+W9\u0012;]/\u0012>]3F8J)\b}I "), (Object)request.contextName());
            return contextAdminRequestProcessor.D.getRaftConfigService().addContext(request.replicationGroupName(), request.contextName(), request.metaDataMap());
        }).doFirst(() -> {
            ContextAdminRequestProcessor a4;
            E.info(HttpStreamingQuery.M((Object)"\u0006I o}`8C(W.F}F2\u0012<V9\u0012>]3F8J)\u0012&Os"), (Object)AuditLog.username((String)a2.username()), (Object)request.contextName());
            ContextAdminRequestProcessor contextAdminRequestProcessor = a4;
            ReplicationGroupContext replicationGroupContext = request;
            a4.M(replicationGroupContext.contextName());
            contextAdminRequestProcessor.M(replicationGroupContext.metaDataMap());
            contextAdminRequestProcessor.M(request.contextName(), request.metaDataMap(), a2);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.contextName();
            a4.M(a3, HttpStreamingQuery.M((Object)"I \b}W%Q8B)[2\\}E5[1W}Q/W<F4\\:\u0012>]3F8J)"), objectArray);
        });
    }

    private /* synthetic */ boolean d(TierConfiguration a2) {
        block4: {
            block3: {
                block2: {
                    if (a2.M().size() <= 1) break block2;
                    if (((TierConfiguration.Tier)a2.M().get(1)).M(EventTypeContext.M((Object)"\u001f9\u001c6\u0016\n\u0015:\u00110"))) break block3;
                }
                if (a2.d().size() <= 1) break block4;
                if (!((TierConfiguration.Tier)a2.d().get(1)).M(HttpStreamingQuery.M((Object)"P1S>Y\u0002Z2^8"))) break block4;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Mono<Void> initCluster(@Nonnull List<String> contexts, @Nonnull Authentication a3) {
        return Mono.fromRunnable(() -> {
            ContextAdminRequestProcessor a3;
            a3.D.getLocalRaftConfigService().init(contexts);
        }).doFirst(() -> E.info(EventTypeContext.M((Object)"&.\u0000\b]\u0007\u0018$\b0\u000e!]!\u0012u\u0014;\u0014!\u00144\u0011<\u00070]6\u0011 \u000e!\u0018'].\u0000{"), (Object)AuditLog.username((String)a3.username()), (Object)contexts)).doOnError(a2 -> {
            ContextAdminRequestProcessor a3;
            a3.M(a2, EventTypeContext.M((Object)"0\u00056\u0018%\t<\u0012;]<\u0013u\u0014;\u0014!]6\u0011 \u000e!\u0018'"), new Object[0]);
        });
    }

    @Nonnull
    public Mono<Void> deleteContext(@Nonnull RemoveContext request, @Nonnull Authentication a2) {
        return Mono.fromRunnable(() -> {
            ContextAdminRequestProcessor a3;
            RemoveContext removeContext = request;
            a3.B.info(EventTypeContext.M((Object)"\u0011\u00189\u0018!\u0018u\u001e:\u0013!\u0018-\tu\u000f0\f \u0018&\tu\u000f0\u001e0\u0014#\u00181]3\u0012']6\u0012;\t0\u0005!Gu\u0006("), (Object)removeContext.name());
            if (removeContext.name().startsWith(HttpStreamingQuery.M((Object)"\u0002"))) {
                Object[] objectArray = new Object[1];
                objectArray[0] = request.name();
                throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(EventTypeContext.M((Object)"\u0016\u001c;\u0013:\tu\u00190\u00110\t0]<\u0013!\u0018'\u00134\u0011u\u001e:\u0013!\u0018-\tuX&"), objectArray));
            }
            a3.D.getRaftConfigService().deleteContext(request.name(), request.preserveEventStore());
        }).doFirst(() -> {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((String)a2.username());
            objectArray[1] = request.name();
            objectArray[2] = request.preserveEventStore();
            E.info(EventTypeContext.M((Object)"&.\u0000\b]\u0007\u0018$\b0\u000e!]!\u0012u\u00190\u00110\t0]6\u0012;\t0\u0005!].\u0000u\r'\u0018&\u0018'\u000b0]0\u000b0\u0013!]&\t:\u000f0].\u0000{"), objectArray);
        }).doOnError(a3 -> {
            ContextAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.name();
            a4.M(a3, HttpStreamingQuery.M((Object)"I \b}W%Q8B)[2\\}E5[1W}V8^8F4\\:\u0012>]3F8J)"), objectArray);
        });
    }

    @Nonnull
    public Flux<ContextOverview> getContexts(@Nonnull Authentication a4) {
        return Flux.defer(() -> {
            ContextAdminRequestProcessor a2;
            if (!a2.k.isAdminNode()) {
                throw new MessagingPlatformException(ErrorCode.UNSUPPORTED_INSTRUCTION, HttpStreamingQuery.M((Object)"|2V8\u00124A}\\2F}S3\u0012\u0002S9_4\\}\\2V8"));
            }
            return Flux.fromIterable((Iterable)a2.a.findAll());
        }).filter(a3 -> {
            ContextAdminRequestProcessor a4;
            return a4.g.hasAccess(a3.getName(), a4);
        }).map(a2 -> {
            ContextAdminRequestProcessor a3;
            return new d(a3, a2);
        }).doFirst(() -> E.info(EventTypeContext.M((Object)"&.\u0000\b]\u0007\u0018$\b0\u000e!]!\u0012u\u0011<\u000e!]6\u0012;\t0\u0005!\u000e{"), (Object)AuditLog.username((String)a4.username()))).doOnError(a2 -> {
            ContextAdminRequestProcessor a3;
            a3.M(a2, EventTypeContext.M((Object)"0\u00056\u0018%\t<\u0012;]\"\u0015<\u00110]'\u0018!\u000f<\u0018#\u0014;\u001au\u001e:\u0013!\u0018-\t&"), new Object[0]);
        });
    }

    @Nonnull
    public Flux<ContextUpdate> subscribeContextUpdates(@Nonnull Authentication a4) {
        return this.C.asFlux().publish().autoConnect().filter(a3 -> {
            ContextAdminRequestProcessor a4;
            return a4.g.hasAccess(a3.name(), a4);
        }).doOnCancel(() -> {
            ContextAdminRequestProcessor a2;
            a2.B.info(HttpStreamingQuery.M((Object)"\u000eG?A>@4P8V}A)]-\u0012/W>W4D4\\:\u0012>]3F8J)\u0012(B9S)W."));
        }).doOnError(a2 -> {
            ContextAdminRequestProcessor a3;
            a3.M(a2, EventTypeContext.M((Object)"\u0018-\u001e0\r!\u0014:\u0013u\n=\u00149\u0018u\u0011<\u000e!\u0018;\u0014;\u001au\t:]6\u0012;\t0\u0005!] \r1\u001c!\u0018&"), new Object[0]);
        }).doFirst(() -> {
            ContextAdminRequestProcessor a3;
            if (!a3.k.isAdminNode()) {
                throw new MessagingPlatformException(ErrorCode.UNSUPPORTED_INSTRUCTION, HttpStreamingQuery.M((Object)"|2V8\u00124A}\\2F}S3\u0012\u0002S9_4\\}\\2V8"));
            }
            E.info(EventTypeContext.M((Object)"\u000e\u0006( u. \u001f&\u001e'\u00147\u00181]!\u0012u\u001e:\u0013!\u0018-\tu\b%\u00194\t0\u000e{"), (Object)AuditLog.username((String)a4.username()));
            a3.B.info(HttpStreamingQuery.M((Object)"\u0013W*\u0012.G?A>@4P8@}F2\u0012>]3F8J)\u0012(B9S)W."));
        });
    }

    private /* synthetic */ boolean M(TierConfiguration a2) {
        block2: {
            block3: {
                ContextAdminRequestProcessor a3;
                if (a3.I.multitier()) break block2;
                if (a2.M().size() > 1) break block3;
                if (a2.d().size() <= 1) break block2;
            }
            return true;
        }
        return false;
    }
}

