/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.eventprocessor.requestprocessor;

import io.axoniq.axonserver.admin.Instruction;
import io.axoniq.axonserver.admin.InstructionCache;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessor;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessorAdminService;
import io.axoniq.axonserver.admin.eventprocessor.api.EventProcessorId;
import io.axoniq.axonserver.admin.eventprocessor.api.Result;
import io.axoniq.axonserver.admin.eventprocessor.requestprocessor.DistributedEventProcessor;
import io.axoniq.axonserver.admin.eventprocessor.requestprocessor.InstructionInformation;
import io.axoniq.axonserver.admin.eventprocessor.requestprocessor.g;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.component.processor.EventProcessorIdentifier;
import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.component.processor.balancing.LoadBalancingStrategy;
import io.axoniq.axonserver.component.processor.balancing.strategy.LoadBalanceStrategyRepository;
import io.axoniq.axonserver.component.processor.listener.ClientProcessor;
import io.axoniq.axonserver.component.processor.listener.ClientProcessors;
import io.axoniq.axonserver.configuration.common.CommonConfigurationFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class LocalEventProcessorsAdminService
implements EventProcessorAdminService {
    private final Logger k;
    protected final LoadBalanceStrategyRepository B;
    private final ProcessorEventPublisher C;
    protected final Flux<ClientProcessor> D;
    protected static final Logger l = AuditLog.getLogger();
    private final CommonConfigurationFactory I;
    private final ConstraintCache<String, Instruction> L;

    @Nonnull
    public Flux<EventProcessor> eventProcessors(@Nonnull Authentication a3) {
        return this.D.transform(a2 -> a2.groupBy(EventProcessorIdentifier::new).flatMap(a4 -> a4.timeout(Duration.ofMillis(100L)).onErrorResume(a2 -> Flux.empty()).collectList().map(a3 -> new DistributedEventProcessor((EventProcessorId)a4.key(), a3))));
    }

    @Nonnull
    public Mono<Result> move(@Nonnull EventProcessorId identifier, int segment, @Nonnull String target, @Nonnull Authentication a2) {
        EventProcessorId eventProcessorId = identifier;
        String string = eventProcessorId.name();
        String string2 = eventProcessorId.tokenStoreIdentifier();
        String string3 = "Move " + string;
        string2 = new EventProcessorIdentifier(string, identifier.context(), string2);
        return this.D.doFirst(() -> {
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)identifier.tokenStoreIdentifier());
                l.info(GlobalSubscriptionMetricRegistry.M((Object)"\f2*\u0014w\u001b28\",$=w=8i$=6;#i\u0012?2'#i';8*2:$&%iu2*\t,4ug"), objectArray);
            }
        }).filter(arg_0 -> this.d((EventProcessorIdentifier)string2, arg_0)).collectList().flatMap(a6 -> {
            LocalEventProcessorsAdminService a7;
            return Mono.create(a8 -> {
                LocalEventProcessorsAdminService a9;
                Object object = a6.stream().filter(a3 -> target.equals(a3.clientId())).findFirst();
                if (!((Optional)object).isPresent()) {
                    a8.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_MOVE_UNKNOWN_TARGET, GlobalSubscriptionMetricRegistry.M((Object)"\u001d6;0,#i1&%i:&!,w'8=w/8<9-")));
                    return;
                }
                Object object2 = ((Optional)object).get().eventProcessorInfo().getSegmentStatusList();
                if (object2.stream().anyMatch(a3 -> {
                    if (a3.getSegmentId() == segment) {
                        return true;
                    }
                    return false;
                })) {
                    a8.success();
                    return;
                }
                if (((Optional)object).get().eventProcessorInfo().getAvailableThreads() < 1) {
                    a8.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_MOVE_NO_AVAILBLE_THREADS, HeartbeatMonitor.M((Object)"FS(]~]aPi^dY(H`Nm]lO(Sf\u001c|]z[mH")));
                    return;
                }
                object2 = UUID.randomUUID().toString();
                object = a6.stream().map(ClientProcessor::clientId).filter(a3 -> {
                    if (!target.equals(a3)) {
                        return true;
                    }
                    return false;
                }).collect(Collectors.toSet());
                if (object.isEmpty()) {
                    a8.error((Throwable)new MessagingPlatformException(ErrorCode.OTHER, GlobalSubscriptionMetricRegistry.M((Object)"\u00078i8=?,%i4%>,9=w!6:w*;(>$2-w=?,w:2.:,9=")));
                    return;
                }
                a9.L.put(object2, (Object)new InstructionInformation(a8, (String)object2, string3, (Set)object));
                a6.stream().filter(a3 -> {
                    if (!target.equals(a3.clientId())) {
                        return true;
                    }
                    return false;
                }).forEach(arg_0 -> a9.M(string, segment, (String)object2, arg_0));
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.m(string3, a3);
        });
    }

    private /* synthetic */ boolean d(EventProcessorIdentifier a2, ClientProcessor a3) {
        LocalEventProcessorsAdminService a4;
        return a4.M(a3, (EventProcessorId)a2);
    }

    @Nonnull
    public Mono<Void> loadBalance(@Nonnull EventProcessorId processor, @Nonnull String strategy, @Nonnull Authentication a2) {
        return this.D.filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, processor);
        }).map(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.I.trackingEventProcessor(processor.name(), a3.context(), processor.tokenStoreIdentifier());
        }).flatMap(a3 -> {
            LocalEventProcessorsAdminService a4;
            return Mono.fromRunnable(() -> {
                LocalEventProcessorsAdminService a4;
                a4.B.findByName(strategy).balance(a3).perform();
            }).subscribeOn(Schedulers.boundedElastic());
        }).then().doFirst(() -> {
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = processor;
                objectArray[2] = strategy;
                l.info(GlobalSubscriptionMetricRegistry.M((Object)"\u0012,4\ni\u0005,&<2:#i#&w:2=w%8(3d5(;(9*>'0i$=%(#,00w/8;w9%&4,$:8;wk,4ui#&wk,4ug"), objectArray);
            }
        });
    }

    @Nonnull
    public Iterable<LoadBalancingStrategy> getBalancingStrategies(@Nonnull Authentication a2) {
        l.debug(HeartbeatMonitor.M((Object)"gsAU\u001cZYyImO|\u001c|S(PaO|\u001cdSiX%^iPiRkUf[(O|NiHm[aY{\u0012"), (Object)AuditLog.username((String)a2.username()));
        return this.B.findAll();
    }

    private /* synthetic */ void m(String a2, Throwable a3) {
        LocalEventProcessorsAdminService a4;
        if (ErrorCode.fromException((Throwable)a3).isClientException()) {
            a4.k.info(GlobalSubscriptionMetricRegistry.M((Object)"2*i1(>%2-"), (Object)a2, (Object)a3);
            return;
        }
        a4.k.warn(HeartbeatMonitor.M((Object)"Gu\u001cn]aPmX"), (Object)a2, (Object)a3);
    }

    private /* synthetic */ boolean M(ClientProcessor a2, EventProcessorId a3) {
        if (a2.eventProcessorInfo().getProcessorName().equals(a3.name()) && a2.eventProcessorInfo().getTokenStoreIdentifier().equals(a3.tokenStoreIdentifier()) && a2.context().equals(a3.context())) {
            return true;
        }
        return false;
    }

    private /* synthetic */ int M(g a22) {
        g g2 = a22;
        int a22 = g2.D >>> 1;
        return g2.I ^ a22;
    }

    private /* synthetic */ void M(String a2, int a3, String a4, ClientProcessor a5) {
        LocalEventProcessorsAdminService a6;
        a6.C.releaseSegment(a5.context(), a5.clientId(), a2, a3, a4);
    }

    private /* synthetic */ boolean M(EventProcessorIdentifier a2, ClientProcessor a3) {
        LocalEventProcessorsAdminService a4;
        return a4.M(a3, (EventProcessorId)a2);
    }

    @Nonnull
    public Flux<EventProcessor> eventProcessorsByComponent(@Nonnull String component, @Nonnull Authentication a3) {
        if (l.isInfoEnabled()) {
            l.debug(HeartbeatMonitor.M((Object)"SGua(nmM}Y{H(Hg\u001cdU{H(y~YfH(LzSkY{OgN{\u001caR(_gQxSfYfH(\u001esA*\u0012"), (Object)AuditLog.username((String)a3.username()), (Object)StringUtils.sanitize((String)component));
        }
        return this.D.filterWhen(a4 -> {
            LocalEventProcessorsAdminService a5;
            return a5.D.filter(a3 -> a3.belongsToComponent(component)).map(EventProcessorIdentifier::new).map(a3 -> a3.M((EventProcessorId)new EventProcessorIdentifier(a4))).reduce(Boolean::logicalOr);
        }).transform(a2 -> a2.groupBy(EventProcessorIdentifier::new).flatMap(a4 -> a4.timeout(Duration.ofMillis(100L)).onErrorResume(a2 -> Flux.empty()).collectList().map(a3 -> new DistributedEventProcessor((EventProcessorId)a4.key(), a3))));
    }

    @Nonnull
    public Mono<Result> split(@Nonnull EventProcessorId identifier, @Nonnull Authentication a5) {
        String string = identifier.name();
        String string2 = "Split " + string;
        String string3 = identifier.tokenStoreIdentifier();
        return this.D.doFirst(() -> {
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a5.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)string3);
                l.info(HeartbeatMonitor.M((Object)"gsAU\u001cZYyImO|\u001c|S(OxPaH(](Om[eYfH(Sn\u001cMJmR|\u001cxNg_mO{Sz\u001c*Gu|sA*\u0012"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, identifier);
        }).flatMap(a2 -> Flux.fromIterable((Iterable)a2.eventProcessorInfo().getSegmentStatusList()).map(a3 -> new g(a2.clientId(), a2.context(), a3.getSegmentId(), a3.getOnePartOf()))).reduce((a2, a3) -> {
            if (a2.D < a3.D) {
                return a2;
            }
            return a3;
        }).switchIfEmpty(Mono.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_NOT_FOUND, HeartbeatMonitor.M((Object)"y~YfH(LzSkY{OgN(RgH(ZgIfX")))).flatMap(a4 -> {
            LocalEventProcessorsAdminService a6;
            return Mono.create(a5 -> {
                LocalEventProcessorsAdminService a6;
                String string = UUID.randomUUID().toString();
                a6.L.put((Object)string, (Object)new InstructionInformation(a5, string, string2, Collections.singleton(a3.l)));
                g g2 = a4;
                a6.C.splitSegment(g2.L, g2.l, string, a3.I, string);
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.m(string2, a3);
        });
    }

    @Nonnull
    public Mono<Result> merge(@Nonnull EventProcessorId identifier, @Nonnull Authentication a5) {
        String string = identifier.name();
        String string2 = "Merge " + string;
        String string3 = identifier.tokenStoreIdentifier();
        return this.D.doFirst(() -> {
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a5.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)string3);
                l.info(HeartbeatMonitor.M((Object)"gsAU\u001cZYyImO|\u001c|S(QmNoY(](Om[eYfH(Sn\u001cMJmR|\u001cxNg_mO{Sz\u001c*Gu|sA*\u0012"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, identifier);
        }).flatMap(a2 -> Flux.fromIterable((Iterable)a2.eventProcessorInfo().getSegmentStatusList()).map(a3 -> new g(a2.clientId(), a2.context(), a3.getSegmentId(), a3.getOnePartOf()))).collectList().flatMap(a4 -> {
            LocalEventProcessorsAdminService a5;
            return Mono.create(a8 -> {
                LocalEventProcessorsAdminService a9;
                String string = UUID.randomUUID().toString();
                g g2 = (g)a4.stream().reduce((a2, a3) -> {
                    if (a2.D > a3.D) {
                        return a2;
                    }
                    return a3;
                }).orElseThrow(() -> new IllegalArgumentException("No segments found for processor name [" + string + "]"));
                int a42 = a9.M(g2);
                a4.stream().map(a2 -> {
                    g g2 = a2;
                    return new ClientContext(g2.l, g2.L);
                }).distinct().filter(a3 -> {
                    if (!a2.l.equals(a3.clientId())) {
                        return true;
                    }
                    return false;
                }).forEach(a5 -> {
                    LocalEventProcessorsAdminService a6;
                    a6.C.releaseSegment(a5.context(), a5.clientId(), string, a42, string);
                });
                a9.L.put((Object)string, (Object)new InstructionInformation(a8, string, string2, Collections.singleton(g2.l)));
                g g3 = g2;
                a9.C.mergeSegment(g3.L, g3.l, string, g2.I, string);
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.m(string2, a3);
        });
    }

    @Nonnull
    public Mono<Void> setAutoLoadBalanceStrategy(@Nonnull EventProcessorId processor, @Nonnull String strategy, @Nonnull Authentication a2) {
        return Mono.error((Throwable)new UnsupportedOperationException(HeartbeatMonitor.M((Object)"II|S(Pg]l\u001cj]d]f_aRo\u001caO(RgH(O}LxSzHmX")));
    }

    @Nonnull
    public Flux<String> clientsBy(@Nonnull EventProcessorId identifier, @Nonnull Authentication a2) {
        EventProcessorId eventProcessorId = identifier;
        String string = eventProcessorId.name();
        String string2 = eventProcessorId.tokenStoreIdentifier();
        if (l.isInfoEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((String)a2.username());
            objectArray[1] = StringUtils.sanitize((String)string);
            objectArray[2] = StringUtils.sanitize((String)string2);
            l.info(GlobalSubscriptionMetricRegistry.M((Object)"\f2*\u0014w\u001b28\",$=w/8;w(w%>:#i8/w*; 2'#:w=?(#i4&9=6 9:w=?,w9%&4,$:8;wk,4ui\u0017iu2*k"), objectArray);
        }
        identifier = new EventProcessorIdentifier(string, identifier.context(), string2);
        return this.D.filter(arg_0 -> this.M((EventProcessorIdentifier)identifier, arg_0)).map(ClientProcessor::clientId).distinct();
    }

    public LocalEventProcessorsAdminService(ProcessorEventPublisher a2, Flux<ClientProcessor> a3, ConstraintCache<String, Instruction> a4, LoadBalanceStrategyRepository a5, CommonConfigurationFactory a6) {
        LocalEventProcessorsAdminService a7;
        LocalEventProcessorsAdminService localEventProcessorsAdminService = a7;
        LocalEventProcessorsAdminService localEventProcessorsAdminService2 = a7;
        LocalEventProcessorsAdminService localEventProcessorsAdminService3 = a7;
        localEventProcessorsAdminService3.k = LoggerFactory.getLogger(LocalEventProcessorsAdminService.class);
        localEventProcessorsAdminService3.C = a2;
        localEventProcessorsAdminService2.D = a3;
        localEventProcessorsAdminService2.L = a4;
        localEventProcessorsAdminService.B = a5;
        localEventProcessorsAdminService.I = a6;
    }

    @Nonnull
    public Mono<Result> start(@Nonnull EventProcessorId identifier, @Nonnull Authentication a2) {
        String string = identifier.name();
        String string2 = "Start " + string;
        return this.D.doFirst(() -> {
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)identifier.tokenStoreIdentifier());
                l.info(GlobalSubscriptionMetricRegistry.M((Object)"\f2*\u0014w\u001b28\",$=w=8i$=6;#i\u0012?2'#i';8*2:$&%iu2*\t,4ug"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, identifier);
        }).collectList().flatMap(a4 -> {
            LocalEventProcessorsAdminService a5;
            return Mono.create(a6 -> {
                LocalEventProcessorsAdminService a7;
                if (a4.isEmpty()) {
                    a6.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_NOT_FOUND, GlobalSubscriptionMetricRegistry.M((Object)"\f!,9=w9%&4,$:8;w'8=w/8<9-")));
                    return;
                }
                String string = UUID.randomUUID().toString();
                Set set = a4.stream().map(ClientProcessor::clientId).collect(Collectors.toSet());
                LocalEventProcessorsAdminService localEventProcessorsAdminService = a7;
                localEventProcessorsAdminService.L.put((Object)string, (Object)new InstructionInformation(a6, string, string2, set));
                a4.forEach(a4 -> {
                    LocalEventProcessorsAdminService a5;
                    a5.C.startProcessorRequest(a4.context(), a4.clientId(), string, string);
                });
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.m(string2, a3);
        });
    }

    @Nonnull
    public Mono<Result> pause(@Nonnull EventProcessorId identifier, @Nonnull Authentication a2) {
        String string = identifier.name();
        String string2 = "Pause " + string;
        return this.D.doFirst(() -> {
            if (l.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = StringUtils.sanitize((String)string);
                objectArray[2] = StringUtils.sanitize((String)identifier.tokenStoreIdentifier());
                l.info(GlobalSubscriptionMetricRegistry.M((Object)"\f2*\u0014w\u001b28\",$=w=8i'(\":2i\u0012?2'#i';8*2:$&%iu2*\t,4ug"), objectArray);
            }
        }).filter(a3 -> {
            LocalEventProcessorsAdminService a4;
            return a4.M(a3, identifier);
        }).collectList().flatMap(a4 -> {
            LocalEventProcessorsAdminService a5;
            return Mono.create(a6 -> {
                LocalEventProcessorsAdminService a7;
                if (a4.isEmpty()) {
                    a6.error((Throwable)new MessagingPlatformException(ErrorCode.EVENT_PROCESSOR_NOT_FOUND, HeartbeatMonitor.M((Object)"y~YfH(LzSkY{OgN(RgH(ZgIfX")));
                    return;
                }
                String string = UUID.randomUUID().toString();
                Set set = a4.stream().map(ClientProcessor::clientId).collect(Collectors.toSet());
                LocalEventProcessorsAdminService localEventProcessorsAdminService = a7;
                localEventProcessorsAdminService.L.put((Object)string, (Object)new InstructionInformation(a6, string, string2, set));
                a4.forEach(a4 -> {
                    LocalEventProcessorsAdminService a5;
                    a5.C.pauseProcessorRequest(a4.context(), a4.clientId(), string, string);
                });
            });
        }).doOnError(a3 -> {
            LocalEventProcessorsAdminService a4;
            a4.m(string2, a3);
        });
    }

    @Autowired
    public LocalEventProcessorsAdminService(ProcessorEventPublisher a2, ClientProcessors a3, InstructionCache a4, LoadBalanceStrategyRepository a5, CommonConfigurationFactory a6) {
        a7(a2, Flux.fromIterable((Iterable)a3), (ConstraintCache)a4, a5, a6);
        LocalEventProcessorsAdminService a7;
    }
}

