/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.replicationgroup.requestprocessor;

import io.axoniq.axonserver.admin.replicationgroup.api.JoinReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.LeaveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.NodeOverviewInfo;
import io.axoniq.axonserver.admin.replicationgroup.api.RemoveReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroup;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupAdminService;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupMember;
import io.axoniq.axonserver.admin.replicationgroup.api.ReplicationGroupOverview;
import io.axoniq.axonserver.admin.replicationgroup.api.Role;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupTask;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.d;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.j;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.AdminUtils;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroups;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.context.AdminContextController;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ReplicationGroupMemberConverter;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.task.AddNodeToExistingReplicationGroupTask;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import io.axoniq.axonserver.transport.rest.LoadBalancingManagementRestController;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReplicationGroupAdminRequestProcessor
implements ReplicationGroupAdminService {
    private final AddNodeToExistingReplicationGroupTask F;
    private final TaskPublisher a;
    private final AdminReplicationGroupController d;
    private final ClusterController k;
    private final Logger B;
    private static final Logger C = AuditLog.getLogger();
    private final RaftConfigServiceFactory D;
    private final AdminReplicationGroups l;
    private final PrepareDeleteNodeFromContextTask I;
    private final Predicate<String> L;

    private static /* synthetic */ void M(Map a2, List a3, List a4, Map a5, Map a6, ReplicationGroupMember a7) {
        Role role = a7.role();
        Role role2 = (Role)a2.remove(a7.nodeName());
        if (role2 == null) {
            if (role.equals((Object)Role.L)) {
                a3.add(a7.nodeName());
                return;
            }
            a4.add(new UpdateReplicationGroupPayload.AddNode(a7));
            return;
        }
        if (!role2.equals((Object)role)) {
            if (role2.equals((Object)Role.L)) {
                a5.put(a7.nodeName(), true);
                a4.add(new UpdateReplicationGroupPayload.AddNode(a7));
                return;
            }
            a6.put(a7.nodeName(), true);
            if (role.equals((Object)Role.L)) {
                a3.add(a7.nodeName());
                return;
            }
            a4.add(new UpdateReplicationGroupPayload.AddNode(a7));
        }
    }

    private /* synthetic */ void M(Throwable a2, String a3, Object ... a4) {
        ReplicationGroupAdminRequestProcessor a5;
        if (MessagingPlatformException.isClientException((Throwable)a2)) {
            a5.B.info(a3, (Object)a4, (Object)a2);
            return;
        }
        a5.B.warn(a3, (Object)a4, (Object)a2);
    }

    private static /* synthetic */ void M(Map a2, ClusterNode a3) {
        a2.put(a3.getName(), a3);
    }

    @Nonnull
    public Mono<ReplicationGroupOverview> getReplicationGroup(@Nonnull String replicationGroupName, @Nonnull Authentication a2) {
        return Mono.fromCallable(() -> {
            ReplicationGroupAdminRequestProcessor a5;
            if (C.isInfoEnabled()) {
                C.info(LoadBalancingManagementRestController.M((Object)"WWqq,~i]yI\u007fX,Xc\f`E\u007fX,^i\\`EoMxEcB,K~Cy\\\u007f\u0002"), (Object)AuditLog.username((String)a2.username()));
            }
            return a5.l.findByName(replicationGroupName).map(a2 -> ReplicationGroupAdminRequestProcessor.M((AdminReplicationGroup)a2)).orElseThrow(() -> new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, LoadBalancingManagementRestController.M((Object)"~i\\`EoMxEcB,K~Cy\\,BcX,JcYbH")));
        });
    }

    @Nonnull
    public Mono<Void> removeNodeFromReplicationGroup(@Nonnull LeaveReplicationGroup request, @Nonnull Authentication a4) {
        return Mono.defer(() -> {
            ReplicationGroupAdminRequestProcessor a4;
            if (C.isInfoEnabled()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = AuditLog.username((String)a4.username());
                objectArray[1] = request.node();
                objectArray[2] = request.replicationGroup();
                objectArray[3] = request.preserveEventStore();
                C.info(LoadBalancingManagementRestController.M((Object)"WWqq,~i]yI\u007fX,Xc\fhI`IxI,BcHi\fwQ,J~Ca\f~I|@eOmXeCb\fk^cY|\fwQ,\\~I\u007fI~Zi\fiZiBx_,_xC~I\u007f\f,Wq\u0002"), objectArray);
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = request.node();
            objectArray[1] = request.replicationGroup();
            objectArray[2] = request.preserveEventStore() ? LoadBalancingManagementRestController.M((Object)"\u0001,giI|EbK,IzIbX,_xC~I") : "";
            a4.B.info(AdminContextController.M((Object)"\u0000T(T0Td_+U!\u00116T5D!B0\u00116T'T-G!UdW+Cd_+U!\u000bdJ9\u0011i\u0011%_ \u00116T4]-R%E-^*\u0011#C+D4\u000bdJ9\u0011?L"), objectArray);
            return Mono.fromCompletionStage((CompletionStage)a4.I.prepareDeleteNodeFromContext(request.replicationGroup(), request.node(), request.preserveEventStore()));
        }).then().doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[2];
            objectArray[0] = request.replicationGroup();
            objectArray[1] = request.node();
            a4.M(a3, AdminContextController.M((Object)"J9\u000bdT6C+CdF,X(TdC!\\+G-_#\u0011?L"), objectArray);
        }).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
    }

    @Nonnull
    public Mono<Void> createReplicationGroup(@Nonnull ReplicationGroup request, @Nonnull Authentication a2) {
        return Mono.fromRunnable(() -> {
            ReplicationGroupAdminRequestProcessor a4;
            if (C.isInfoEnabled()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = AuditLog.username((String)a2.username());
                objectArray[1] = request.name();
                objectArray[2] = request.members();
                C.info(LoadBalancingManagementRestController.M((Object)"WWqq,~i]yI\u007fX,Xc\fo^iMxI,^i\\`EoMxEcB,K~Cy\\,Wq\f{ExD,BcHi_,Wq\u0002"), objectArray);
            }
            ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor = a4;
            replicationGroupAdminRequestProcessor.B.info(AdminContextController.M((Object)"r6T%E!\u00116T5D!B0\u00116T'T-G!UdW+CdC!A(X'P0X+_dV6^1A~\u0011?L"), (Object)request.name());
            if (!replicationGroupAdminRequestProcessor.L.test(request.name())) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, LoadBalancingManagementRestController.M((Object)"EBzM`Eh\f~I|@eOmXeCb\fk^cY|\fbMaI"));
            }
            if (!request.members().isEmpty()) {
                a2 = new HashMap();
                a4.k.activeNodes().forEach(arg_0 -> ReplicationGroupAdminRequestProcessor.M((Map)a2, arg_0));
                a2 = request.members().stream().map(ReplicationGroupMember::nodeName).filter(arg_0 -> ReplicationGroupAdminRequestProcessor.M((Map)a2, arg_0)).collect(Collectors.toSet());
                if (!a2.isEmpty()) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, "Node is not active: " + (Set)a2);
                }
            } else {
                throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, AdminContextController.M((Object)"p UdP0\u0011(T%B0\u0011+_!\u0011*^ TdW+CdE,TdP4A(X'P0X+_dV6^1A"));
            }
            a4.D.getRaftConfigService().createReplicationGroup(request.name(), (Collection)request.members().stream().map(ReplicationGroupMemberConverter::asReplicationGroupMember).collect(Collectors.toList()));
        }).doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.name();
            a4.M(a3, AdminContextController.M((Object)"?L~\u0011\u0001C6^6\u00113Y-]!\u0011'C!P0X*VdC!A(X'P0X+_dV6^1A"), objectArray);
        });
    }

    private static /* synthetic */ boolean M(Map a2, String a3) {
        if (!a2.containsKey(a3)) {
            return true;
        }
        return false;
    }

    @Nonnull
    public Mono<Void> deleteReplicationGroup(@Nonnull RemoveReplicationGroup request, @Nonnull Authentication a4) {
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((String)a4.username());
        objectArray[1] = request.name();
        objectArray[2] = request.preserveEventStore();
        C.info(LoadBalancingManagementRestController.M((Object)"wwQQ\f^I}Yi_x\fxC,Hi@iXi\f~I|@eOmXeCb\fk^cY|\fwQ,\\~I\u007fI~Zi\fiZiBx\f\u007fXc^i_,Wq\u0002"), objectArray);
        return Mono.fromRunnable(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            a3.D.getRaftConfigService().deleteReplicationGroup(request.name(), request.preserveEventStore());
        }).doFirst(() -> {
            if (request.name().startsWith(AdminContextController.M((Object)"n"))) {
                Object[] objectArray = new Object[1];
                objectArray[0] = request.name();
                throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(LoadBalancingManagementRestController.M((Object)"omBbCx\fhI`IxI,EbXi^bM`\foCbXiTx\f)_"), objectArray));
            }
        }).doFirst(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            a3.B.info(AdminContextController.M((Object)"u!]!E!\u00116T5D!B0\u00116T'T-G!UdW+CdC!A(X'P0X+_dV6^1A~\u0011?L"), (Object)request.name());
        }).doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[1];
            objectArray[0] = request.name();
            a4.M(a3, AdminContextController.M((Object)"?L~\u0011!C6^6\u00113Y-]!\u0011 T(T0X*VdC!A(X'P0X+_dV6^1A"), objectArray);
        }).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
    }

    @Nonnull
    public Flux<ReplicationGroupOverview> getReplicationGroups(@Nonnull Authentication a2) {
        return Flux.defer(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            return Flux.fromStream((Stream)a3.l.findAll()).map(a2 -> new j(a2)).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
        }).doFirst(() -> C.info(LoadBalancingManagementRestController.M((Object)"WWqq,~i]yI\u007fXiH,Xc\f`E\u007fX,M`@,^i\\`EoMxEcB,K~Cy\\\u007f\u0002"), (Object)AuditLog.username((String)a2.username())));
    }

    private /* synthetic */ Role M(io.axoniq.axonserver.grpc.cluster.Role a2) {
        return Role.valueOf((String)a2.name());
    }

    @NotNull
    public Mono<String> updateReplicationGroup(@NotNull ReplicationGroup updated, boolean preserve, @NotNull Authentication a4) {
        Object object = (AdminReplicationGroup)this.d.findByName(updated.name()).orElseThrow(() -> new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, updated.name() + ": not found"));
        HashMap<String, Role> hashMap = new HashMap<String, Role>();
        object.getMembers().forEach(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            hashMap.put(a3.getClusterNode().getName(), a4.M(a3.getRole()));
        });
        object = new ArrayList();
        ArrayList arrayList = new ArrayList();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        if (updated.members().stream().noneMatch(a2 -> a2.role().equals((Object)Role.L))) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, AdminContextController.M((Object)"\n^d_+U!BdF-E,\u00114C-\\%C=\u00116^(TdB4T'X\"X!U"));
        }
        updated.members().forEach(arg_0 -> ReplicationGroupAdminRequestProcessor.M(hashMap, (List)object, arrayList, hashMap2, hashMap3, arg_0));
        hashMap.forEach((a5, a6) -> {
            if (a6.equals((Object)Role.L)) {
                hashMap2.put(a5, preserve);
                return;
            }
            hashMap3.put(a5, preserve);
        });
        UpdateReplicationGroupPayload updateReplicationGroupPayload = preserve = new UpdateReplicationGroupPayload();
        preserve.setReplicationGroup(updated.name());
        updateReplicationGroupPayload.setAddPrimaryNodes((List)object);
        updateReplicationGroupPayload.setDeleteNodes(hashMap3.entrySet().stream().map(a2 -> new UpdateReplicationGroupPayload.DeleteNode((String)a2.getKey(), ((Boolean)a2.getValue()).booleanValue())).collect(Collectors.toList()));
        preserve.setDeletePrimaryNodes(hashMap2.entrySet().stream().map(a2 -> new UpdateReplicationGroupPayload.DeleteNode((String)a2.getKey(), ((Boolean)a2.getValue()).booleanValue())).collect(Collectors.toList()));
        UpdateReplicationGroupPayload updateReplicationGroupPayload2 = preserve;
        updateReplicationGroupPayload2.setAddNodes(arrayList);
        updateReplicationGroupPayload2.setPrincipal(a4.username());
        return Mono.fromFuture(() -> {
            ReplicationGroupAdminRequestProcessor a3;
            return a3.a.publishScheduledTask(AdminUtils.getAdmin(), UpdateReplicationGroupTask.class.getName(), (Object)updateReplicationGroupPayload2, Duration.ZERO);
        });
    }

    public ReplicationGroupAdminRequestProcessor(RaftConfigServiceFactory a2, ClusterController a3, PrepareDeleteNodeFromContextTask a4, AdminReplicationGroups a5, AdminReplicationGroupController a6, AddNodeToExistingReplicationGroupTask a7, TaskPublisher a8) {
        ReplicationGroupAdminRequestProcessor a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor = a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor2 = a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor3 = a9;
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor4 = a9;
        replicationGroupAdminRequestProcessor4.B = LoggerFactory.getLogger(ReplicationGroupAdminRequestProcessor.class);
        ReplicationGroupAdminRequestProcessor replicationGroupAdminRequestProcessor5 = a9;
        replicationGroupAdminRequestProcessor4.L = new ContextNameValidation();
        replicationGroupAdminRequestProcessor4.D = a2;
        replicationGroupAdminRequestProcessor3.k = a3;
        replicationGroupAdminRequestProcessor3.I = a4;
        replicationGroupAdminRequestProcessor2.l = a5;
        replicationGroupAdminRequestProcessor2.d = a6;
        replicationGroupAdminRequestProcessor.F = a7;
        replicationGroupAdminRequestProcessor.a = a8;
    }

    @Nonnull
    public Flux<NodeOverviewInfo> getNodes(@Nonnull Authentication a3) {
        return Flux.fromStream((Stream)this.k.nodes()).doFirst(() -> {
            if (C.isInfoEnabled()) {
                C.info(AdminContextController.M((Object)"j?L\u0019\u0011\u0016T5D!B0\u00110^d]-B0\u0011%](\u0011*^ T7\u0011-_\"^6\\%E-^*\u001f"), (Object)AuditLog.username((String)a3.username()));
            }
        }).map(a2 -> {
            ReplicationGroupAdminRequestProcessor a3;
            return new d(a3, a2);
        });
    }

    @Nonnull
    public Mono<Void> addNodeToReplicationGroup(@Nonnull JoinReplicationGroup request, @Nonnull Authentication a4) {
        return Mono.defer(() -> {
            ReplicationGroupAdminRequestProcessor a4;
            if (C.isInfoEnabled()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = AuditLog.username((String)a4.username());
                objectArray[1] = request.node();
                objectArray[2] = request.replicationGroup();
                objectArray[3] = request.role();
                C.info(AdminContextController.M((Object)"j?L\u0019\u0011\u0016T5D!B0\u00110^dP Ud_+U!\u0011?LdE+\u00116T4]-R%E-^*\u0011#C+D4\u0011?LdF-E,\u00116^(TdJ9\u001f"), objectArray);
            }
            JoinReplicationGroup joinReplicationGroup = request;
            a4 = joinReplicationGroup.node();
            String string = joinReplicationGroup.replicationGroup();
            Object[] objectArray = new Object[3];
            objectArray[0] = a4;
            objectArray[1] = string;
            objectArray[2] = request.role();
            a4.B.info(LoadBalancingManagementRestController.M((Object)"mhH,BcHi\f~I}Yi_x\f~IoIeZiH,Jc^,BcHi\u0016,Wq\f!\fmBh\f~I|@eOmXeCb\fk^cY|\u0016,Wq\f!\f{ExD,^c@i\u0016,Wq\u0002"), objectArray);
            if (!a4.d.findByName(string).isPresent()) {
                String string2 = "[" + ErrorCode.REPLICATION_GROUP_NOT_FOUND + "] Replication group " + string + " not found";
                return Mono.error((Throwable)new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, string2));
            }
            ClusterNode clusterNode = a4.k.getNode((String)a4);
            if (clusterNode == null) {
                String string3 = "[" + ErrorCode.NO_SUCH_NODE + "] Node " + (String)a4 + " not found";
                return Mono.error((Throwable)new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, string3));
            }
            if (clusterNode.getReplicatorGroupNames().contains(string)) {
                String string4 = "Replication group " + string + " already contains node " + (String)a4;
                return Mono.error((Throwable)new IllegalStateException(string4));
            }
            io.axoniq.axonserver.grpc.cluster.Role role = request.role() == null ? io.axoniq.axonserver.grpc.cluster.Role.PRIMARY : io.axoniq.axonserver.grpc.cluster.Role.valueOf((String)Objects.requireNonNull(request.role()).name());
            return Mono.fromCompletionStage((CompletionStage)a4.F.addNode((String)a4, string, role));
        }).then().doOnError(a3 -> {
            ReplicationGroupAdminRequestProcessor a4;
            Object[] objectArray = new Object[2];
            objectArray[0] = request.replicationGroup();
            objectArray[1] = request.node();
            a4.M(a3, LoadBalancingManagementRestController.M((Object)"Wq\u0016,I~^c^,[dE`I,MhHeBk\fwQ"), objectArray);
        }).onErrorMap(a2 -> MessagingPlatformException.create((Throwable)a2));
    }
}

