/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.admin.user.requestprocessor;

import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminUser;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.configuration.admin.AdminUsers;
import io.axoniq.axonserver.util.StringUtils;
import java.util.List;
import java.util.Set;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class UserController {
    private final AdminUsers D;
    private final PasswordEncoder l;
    public static final String I = "nologon";
    private final AdminConfigurationFactory L;

    public UserController(PasswordEncoder a2, AdminUsers a3, AdminConfigurationFactory a4) {
        UserController a5;
        UserController userController = a5;
        a5.l = a2;
        userController.D = a3;
        userController.L = a4;
    }

    public List<AdminUser> getUsers() {
        UserController a2;
        return a2.D.findAll();
    }

    public AdminUser findUser(String a2) {
        UserController a3;
        return a3.D.findById(a2).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void deleteUser(String a3) {
        UserController a4;
        AdminUsers adminUsers = a4.D;
        synchronized (adminUsers) {
            a4.D.findById(a3).ifPresent(a2 -> {
                UserController a3;
                UserController userController = a3;
                userController.D.delete(a2);
                userController.D.flush();
            });
            return;
        }
    }

    @Transactional
    public void removeRolesForContext(String a2) {
        UserController a4;
        a4.D.findAll().forEach(a3 -> a3.removeContext(a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    public void syncUser(AdminUser a2) {
        UserController a3;
        AdminUsers adminUsers = a3.D;
        synchronized (adminUsers) {
            if (StringUtils.isEmpty((String)a2.getPassword())) {
                AdminUser adminUser = a3.findUser(a2.getUserName());
                a2.setPassword(adminUser == null ? I : adminUser.getPassword());
            }
            a3.D.save(a2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    public AdminUser updateUser(String a2, String a3, Set<AdminUserRole> a4) {
        UserController a5;
        AdminUsers adminUsers = a5.D;
        synchronized (adminUsers) {
            UserController userController;
            AdminUser adminUser;
            if (StringUtils.isEmpty((String)a3)) {
                adminUser = a5.findUser(a2);
                a3 = adminUser != null ? adminUser.getPassword() : I;
                userController = a5;
            } else {
                UserController userController2 = a5;
                userController = userController2;
                a3 = userController2.l.encode((CharSequence)a3);
            }
            adminUser = userController.D.save(a5.L.adminUser(a2, a3, a4));
            a5.D.flush();
            return adminUser;
        }
    }

    public String getPassword(String a2) {
        UserController a3;
        return a3.D.findById(a2).map(AdminUser::getPassword).orElse(null);
    }

    public int numberOfUsers() {
        UserController a2;
        return a2.D.findAll().size();
    }

    @Transactional
    public void deleteAll() {
        UserController a2;
        a2.D.deleteAll();
    }
}

