/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.cluster;

import io.axoniq.axonserver.cluster.AbstractMembershipState;
import io.axoniq.axonserver.cluster.CurrentConfiguration;
import io.axoniq.axonserver.cluster.MembershipState;
import io.axoniq.axonserver.cluster.MembershipStateFactory;
import io.axoniq.axonserver.cluster.OtherPeers;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftPeer;
import io.axoniq.axonserver.cluster.RaftResponseFactory;
import io.axoniq.axonserver.cluster.Registration;
import io.axoniq.axonserver.cluster.StateTransitionHandler;
import io.axoniq.axonserver.cluster.TermIndex;
import io.axoniq.axonserver.cluster.election.Election;
import io.axoniq.axonserver.cluster.l;
import io.axoniq.axonserver.cluster.message.factory.DefaultResponseFactory;
import io.axoniq.axonserver.cluster.replication.file.ValidationResult;
import io.axoniq.axonserver.cluster.rules.ActiveBackupsRule;
import io.axoniq.axonserver.cluster.scheduler.ScheduledRegistration;
import io.axoniq.axonserver.cluster.scheduler.Scheduler;
import io.axoniq.axonserver.cluster.snapshot.SnapshotManager;
import io.axoniq.axonserver.grpc.cluster.InstallSnapshotRequest;
import io.axoniq.axonserver.grpc.cluster.InstallSnapshotResponse;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.RequestVoteRequest;
import io.axoniq.axonserver.grpc.cluster.RequestVoteResponse;
import java.time.Clock;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;

public abstract class AbstractMembershipState
implements MembershipState {
    private final AtomicLong e;
    protected final Scheduler j;
    private final SnapshotManager g;
    private final RaftGroup E;
    private final RaftResponseFactory F;
    private final BiFunction<Integer, Integer, Integer> a;
    private final BiConsumer<Long, String> d;
    private final Supplier<Election> k;
    private final CurrentConfiguration B;
    private final Function<Consumer<List<Node>>, Registration> C;
    private final Function<Boolean, Election> D;
    private final StateTransitionHandler l;
    private volatile boolean I;
    private final MembershipStateFactory L;

    protected void schedule(Function<Scheduler, ScheduledRegistration> a2) {
        AbstractMembershipState a3;
        if (!a3.I) {
            a2.apply(a3.j);
        }
    }

    protected Registration registerConfigurationListener(Consumer<List<Node>> a2) {
        AbstractMembershipState a3;
        return (Registration)a3.C.apply(a2);
    }

    protected <R> R handleAsSecondary(Function<MembershipState, R> a2, String a3) {
        AbstractMembershipState a4;
        AbstractMembershipState abstractMembershipState = a4;
        MembershipState membershipState = abstractMembershipState.stateFactory().secondaryState();
        abstractMembershipState.changeStateTo(membershipState, a3);
        return a2.apply(membershipState);
    }

    protected <R> R handleAsFollower(Function<MembershipState, R> a2, String a3) {
        AbstractMembershipState a4;
        AbstractMembershipState abstractMembershipState = a4;
        MembershipState membershipState = abstractMembershipState.stateFactory().followerState();
        abstractMembershipState.changeStateTo(membershipState, a3);
        return a2.apply(membershipState);
    }

    public CurrentConfiguration currentConfiguration() {
        AbstractMembershipState a2;
        return a2.B;
    }

    public boolean health(BiConsumer<String, String> a2) {
        AbstractMembershipState a3;
        AbstractMembershipState abstractMembershipState = a3;
        boolean bl = abstractMembershipState.E.logEntryProcessor().M(a2);
        if (!abstractMembershipState.readyForClients()) {
            a2.accept(a3.groupId() + ".status", ValidationResult.M((Object)"\u0014s\u0005q\u001fo\t}\u001dy\u0005z\bs\u0017c\u0016y\u001bx\u001fn"));
            bl = false;
        }
        return bl;
    }

    protected String groupId() {
        AbstractMembershipState a2;
        return a2.raftGroup().raftConfiguration().groupId();
    }

    protected abstract Logger logger();

    public void stop() {
        AbstractMembershipState a2;
        a2.I = true;
        a2.e.incrementAndGet();
    }

    protected Election newPreVote() {
        AbstractMembershipState a2;
        return (Election)a2.k.get();
    }

    protected int minElectionTimeout() {
        AbstractMembershipState a2;
        return a2.E.raftConfiguration().minElectionTimeout();
    }

    protected void changeStateTo(MembershipState a2, String a3) {
        AbstractMembershipState a4;
        a4.l.updateState((MembershipState)a4, a2, a3);
    }

    protected long lastLogIndex() {
        AbstractMembershipState a2;
        return a2.E.localLogEntryStore().lastLogIndex();
    }

    protected String votedFor() {
        AbstractMembershipState a2;
        return a2.E.localElectionStore().votedFor();
    }

    protected int random(int a2, int a3) {
        AbstractMembershipState a4;
        return (Integer)a4.a.apply(a2, a3);
    }

    protected RaftGroup raftGroup() {
        AbstractMembershipState a2;
        return a2.E;
    }

    protected void execute(Runnable a2) {
        AbstractMembershipState a3;
        if (!a3.I) {
            a3.j.execute(a2);
        }
    }

    protected Node currentNode() {
        AbstractMembershipState a3;
        return a3.currentGroupMembers().stream().filter(a2 -> {
            AbstractMembershipState a3;
            return a2.getNodeId().equals(a3.M());
        }).findFirst().orElse(null);
    }

    public boolean readyForClients() {
        AbstractMembershipState a2;
        if (a2.clock().millis() - a2.raftGroup().localNode().e() < (long)a2.raftGroup().raftConfiguration().maxElectionTimeout() * 2L) {
            return true;
        }
        return false;
    }

    public RequestVoteResponse requestPreVote(RequestVoteRequest a2) {
        AbstractMembershipState a4;
        if (a2.getTerm() > a4.currentTerm()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a4.M();
            objectArray[1] = a2.getTerm();
            objectArray[2] = a4.currentTerm();
            objectArray[3] = a2.getCandidateId();
            String string = String.format(ActiveBackupsRule.M((Object)"l,i-,<,6?:-\u007f9-,r?0=:i( +!\u007f=:;2iwl,iat\u007fl,`\u007f/-&2iz:"), objectArray);
            string = (RequestVoteResponse)a4.handleAsFollower(a3 -> a3.requestPreVote(a2), string);
            Object[] objectArray2 = new Object[6];
            objectArray2[0] = a4.groupId();
            objectArray2[1] = a4.currentTerm();
            objectArray2[2] = a2.getCandidateId();
            objectArray2[3] = a2.getTerm();
            objectArray2[4] = a4.M();
            objectArray2[5] = string != null && string.getVoteGranted();
            a4.logger().info(ValidationResult.M((Object)"!AzU4\u001c.Y(QzG'\u0006zn?M/Y)HzZ5NzL(YwJ5H?\u001c(Y9Y3J?XzZ(S7\u001c!AzZ5NzH?N7\u001c!At\u001c!AzJ5H?XzG'\u001crT;R>P?Xz])\u001c<S6P5K?Ns\u0012"), objectArray2);
            return string;
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = a4.groupId();
        objectArray[1] = a4.currentTerm();
        objectArray[2] = a2.getCandidateId();
        objectArray[3] = a2.getTerm();
        objectArray[4] = a4.M();
        a4.logger().info(ActiveBackupsRule.M((Object)"2\"i6'\u007f=:;2i$4ei\r,.<::+i9&-i/;:d)&+,\u007f;:*: ),;i9;0$\u007f2\"i6'\u007f=:;2i$4qi$4\u007f?0=:-\u007f;:#:*+,;g"), objectArray);
        return a4.responseFactory().voteRejected(a2.getRequestId());
    }

    protected void updateCurrentTerm(long a2, String a3) {
        AbstractMembershipState a4;
        a4.d.accept(a2, a3);
    }

    protected int initialElectionTimeout() {
        AbstractMembershipState a2;
        return a2.E.raftConfiguration().initialElectionTimeout();
    }

    protected long currentTimeMillis() {
        AbstractMembershipState a2;
        return a2.clock().millis();
    }

    protected void markVotedFor(String a2) {
        AbstractMembershipState a3;
        a3.E.localElectionStore().markVotedFor(a2);
    }

    public void start() {
        AbstractMembershipState a2;
        a2.e.incrementAndGet();
        a2.I = false;
    }

    protected TermIndex lastLog() {
        AbstractMembershipState a2;
        return a2.E.localLogEntryStore().lastLog();
    }

    public RequestVoteResponse requestVote(RequestVoteRequest a2) {
        AbstractMembershipState a4;
        if (a2.getTerm() > a4.currentTerm()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a4.M();
            objectArray[1] = a2.getTerm();
            objectArray[2] = a4.currentTerm();
            objectArray[3] = a2.getCandidateId();
            String string = String.format(ValidationResult.M((Object)"\u007fOzN?_?U,Y>\u001c\bY+I?O.j5H?n?M/Y)HzK3H2\u001c=N?].Y(\u001c.Y(Qz\u0014\u007fOz\u0002z\u0019)\u0015zZ(S7\u001c\u007fO"), objectArray);
            string = (RequestVoteResponse)a4.handleAsFollower(a3 -> a3.requestVote(a2), string);
            Object[] objectArray2 = new Object[6];
            objectArray2[0] = a4.groupId();
            objectArray2[1] = a4.currentTerm();
            objectArray2[2] = a2.getCandidateId();
            objectArray2[3] = a2.getTerm();
            objectArray2[4] = a4.M();
            objectArray2[5] = string != null && string.getVoteGranted();
            a4.logger().info(ActiveBackupsRule.M((Object)"$4\u007f 1i+,-$\u007f2\"s\u007f\u001b:8*,,=\u007f/0;\u007f?0=:i-,<,6?:-\u007f/-&2i$4\u007f/0;\u007f=:;2i$4qi$4\u007f?0=:-\u007f2\"iw!>';%:-\u007f(,i9&3%0>:;vg"), objectArray2);
            return string;
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = a4.groupId();
        objectArray[1] = a4.currentTerm();
        objectArray[2] = a2.getCandidateId();
        objectArray[3] = a2.getTerm();
        objectArray[4] = a4.M();
        a4.logger().info(ValidationResult.M((Object)"G'\u001c3RzH?N7\u001c!A`\u001c\bY+I?O.\u001c<S(\u001c,S.YzN?_?U,Y>\u001c<N5QzG'\u001c3RzH?N7\u001c!At\u001c!AzJ5H?XzN?V?_.Y>\u0012"), objectArray);
        return a4.responseFactory().voteRejected(a2.getRequestId());
    }

    protected Election newElection(boolean a2) {
        AbstractMembershipState a3;
        return (Election)a3.D.apply(a2);
    }

    protected Clock clock() {
        AbstractMembershipState a2;
        return a2.j.clock();
    }

    protected RaftResponseFactory responseFactory() {
        AbstractMembershipState a2;
        return a2.F;
    }

    public MembershipStateFactory stateFactory() {
        AbstractMembershipState a2;
        return a2.L;
    }

    protected AbstractMembershipState(Builder a2) {
        AbstractMembershipState a3;
        AbstractMembershipState abstractMembershipState = a3;
        Builder builder = a2;
        AbstractMembershipState abstractMembershipState2 = a3;
        Builder builder2 = a2;
        AbstractMembershipState abstractMembershipState3 = a3;
        Builder builder3 = a2;
        Builder builder4 = a2;
        AbstractMembershipState abstractMembershipState4 = a3;
        a3.I = true;
        AbstractMembershipState abstractMembershipState5 = a3;
        abstractMembershipState4.e = new AtomicLong();
        builder4.M();
        abstractMembershipState4.E = builder4.F;
        a3.l = builder3.l;
        abstractMembershipState3.d = builder3.E;
        abstractMembershipState3.L = a2.a;
        AbstractMembershipState abstractMembershipState6 = a3;
        abstractMembershipState3.j = new l(a3, a2.L);
        a3.D = builder2.k;
        abstractMembershipState2.k = builder2.C;
        abstractMembershipState2.a = a2.B;
        a3.g = builder.g;
        abstractMembershipState.B = builder.D;
        abstractMembershipState.C = a2.d;
        AbstractMembershipState abstractMembershipState7 = a3;
        abstractMembershipState.F = new DefaultResponseFactory(a3.E, (Iterable)a2.I);
    }

    protected long otherNodesCount() {
        AbstractMembershipState a3;
        return a3.B.groupMembers().stream().filter(a2 -> {
            AbstractMembershipState a3;
            if (!a2.getNodeId().equals(a3.M())) {
                return true;
            }
            return false;
        }).count();
    }

    protected SnapshotManager snapshotManager() {
        AbstractMembershipState a2;
        return a2.g;
    }

    protected long currentStateSequence() {
        AbstractMembershipState a2;
        return a2.e.get();
    }

    protected boolean shouldGoAwayIfNotMember() {
        return false;
    }

    protected int maxElectionTimeout() {
        AbstractMembershipState a2;
        return a2.E.raftConfiguration().maxElectionTimeout();
    }

    protected Stream<RaftPeer> otherPeersStream() {
        AbstractMembershipState a2;
        AbstractMembershipState abstractMembershipState = a2;
        return StreamSupport.stream(new OtherPeers(abstractMembershipState.E, abstractMembershipState.B).spliterator(), false);
    }

    String M() {
        AbstractMembershipState a2;
        return a2.E.localNode().d();
    }

    public InstallSnapshotResponse installSnapshot(InstallSnapshotRequest a2) {
        AbstractMembershipState a4;
        if (a2.getTerm() > a4.currentTerm()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4.groupId();
            objectArray[1] = a4.currentTerm();
            objectArray[2] = a2.getTerm();
            a4.logger().info(ActiveBackupsRule.M((Object)"2\"i6'\u007f=:;2i$4ei\r,<,6?:-\u007f 1:+(3%\u007f:1(/:7&+i( +!\u007f=:;2i$4\u007f>7 <!\u007f ,i8;:(+,-i+!>'\u007f$6':g\u007f\u00040?6'8i+&\u007f\u000f0%3&(,-gqg"), objectArray);
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = a4.M();
            objectArray2[1] = a2.getTerm();
            objectArray2[2] = a4.currentTerm();
            objectArray2[3] = a2.getLeaderId();
            String string = String.format(ValidationResult.M((Object)"\u007fOzN?_?U,Y>\u001c\u0013R)H;P6o4]*O2S.n?M/Y)HzK3H2\u001c=N?].Y(\u001c.Y(Qz\u0014\u007fOz\u0002z\u0019)\u0015zZ(S7\u001c\u007fO"), objectArray2);
            return (InstallSnapshotResponse)a4.handleAsFollower(a3 -> a3.installSnapshot(a2), string);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.groupId();
        objectArray[1] = a4.currentTerm();
        objectArray[2] = a2.getTerm();
        String string = String.format(ActiveBackupsRule.M((Object)"l,i6'\u007f=:;2iz:ei\r,<,6?:-\u007f=:;2iwl,`\u007f ,i,$>%3,-i0;\u007f,.<>%\u007f=7(1i2 1,qi\r,5,<=6'8i+!:i-,.<::+g"), objectArray);
        AbstractMembershipState abstractMembershipState = a4;
        abstractMembershipState.logger().trace(string);
        return abstractMembershipState.responseFactory().installSnapshotFailure(a2.getRequestId(), string);
    }

    protected long currentTerm() {
        AbstractMembershipState a2;
        return a2.E.localElectionStore().currentTerm();
    }

    public List<Node> currentGroupMembers() {
        AbstractMembershipState a2;
        return a2.B.groupMembers();
    }
}

