/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.cluster.replication.file;

import io.axoniq.axonserver.cluster.replication.file.Synchronizer;
import io.axoniq.axonserver.cluster.rules.PrimaryMajorityAndActiveBackupsRule;
import java.io.File;
import java.time.Duration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties {
    private long secondaryCleanupDelay;
    private String logStorageFolder;
    private String logSuffix;
    private int primaryCleanupDelay;
    private int validationSegments;
    private int forceInterval;
    private static final boolean WINDOWS;
    private int segmentSize;
    private int maxIndexesInMemory;
    protected Boolean forceCleanMmapIndex;
    private String indexSuffix;
    private int flags;
    private static final String FILENAME_PATTERN;
    private int syncInterval;
    private long numberOfSegments;
    private int minActiveBackups;
    protected Boolean useMmapIndex;

    public long getSyncInterval() {
        StorageProperties a2;
        return a2.syncInterval;
    }

    public void setMaxIndexesInMemory(int a2) {
        a.maxIndexesInMemory = a2;
    }

    public void setForceInterval(Duration a2) {
        a.forceInterval = (int)a2.toMillis();
    }

    public void setMinActiveBackups(int a2) {
        a.minActiveBackups = a2;
    }

    public void setSegmentSize(DataSize a2) {
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)PrimaryMajorityAndActiveBackupsRule.M((Object)"\u000bS?[=X,\u0016+_\"Sx[-E,\u0016:SxZ=E+\u0016,^9Xx\u0004i\u0002o\u0002`\u0005n\u0002o"));
        Assert.isTrue((a2.toBytes() > 0L ? 1 : 0) != 0, (String)Synchronizer.M((Object)"]\u0010i\u0018k\u001bzU}\u001ct\u0010.\u0018{\u0006zUl\u0010.\u0018a\u0007kUz\u001do\u001b.E"));
        a.segmentSize = (int)a2.toBytes();
    }

    public String getLogSuffix() {
        StorageProperties a2;
        return a2.logSuffix;
    }

    public int getFlags() {
        StorageProperties a2;
        return a2.flags;
    }

    public void setSecondaryCleanupDelay(long a2) {
        a.secondaryCleanupDelay = a2;
    }

    public long getNumberOfSegments() {
        StorageProperties a2;
        return a2.numberOfSegments;
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a2;
        return a2.primaryCleanupDelay;
    }

    public String getLogStorageFolder() {
        StorageProperties a2;
        return a2.logStorageFolder;
    }

    public void setForceCleanMmapIndex(Boolean a2) {
        a.forceCleanMmapIndex = a2;
    }

    public void setLogStorageFolder(String a2) {
        a.logStorageFolder = a2;
    }

    public long getSecondaryCleanupDelay() {
        StorageProperties a2;
        return a2.secondaryCleanupDelay;
    }

    public String getStorage(String a2) {
        StorageProperties a3;
        return a3.logStorageFolder + File.separator + a2;
    }

    public void setIndexSuffix(String a2) {
        a.indexSuffix = a2;
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return WINDOWS;
    }

    public void setLogSuffix(String a2) {
        a.logSuffix = a2;
    }

    public File indexFile(String a2, Long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage(a2);
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public void setSyncInterval(Duration a2) {
        a.syncInterval = (int)a2.toMillis();
    }

    public void setUseMmapIndex(Boolean a2) {
        a.useMmapIndex = a2;
    }

    public String getIndexSuffix() {
        StorageProperties a2;
        return a2.indexSuffix;
    }

    public long getSegmentSize() {
        StorageProperties a2;
        return a2.segmentSize;
    }

    public void setPrimaryCleanupDelay(int a2) {
        a.primaryCleanupDelay = a2;
    }

    public boolean isUseMmapIndex() {
        StorageProperties a2;
        if (a2.useMmapIndex != null) {
            return a2.useMmapIndex;
        }
        return false;
    }

    public void setValidationSegments(int a2) {
        a.validationSegments = a2;
    }

    public void setFlags(int a2) {
        a.flags = a2;
    }

    public int getValidationSegments() {
        StorageProperties a2;
        return a2.validationSegments;
    }

    public void setNumberOfSegments(long a2) {
        a.numberOfSegments = a2;
    }

    public File logFile(String a2, Long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage(a2);
        objectArray[1] = a3;
        objectArray[2] = a4.logSuffix;
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }

    public int getForceInterval() {
        StorageProperties a2;
        return a2.forceInterval;
    }

    public int getMinActiveBackups() {
        StorageProperties a2;
        return a2.minActiveBackups;
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a2;
        return a2.maxIndexesInMemory;
    }

    static {
        FILENAME_PATTERN = "%s" + File.separator + "%020d%s";
        WINDOWS = System.getProperty(PrimaryMajorityAndActiveBackupsRule.M((Object)"7EvX9[="), Synchronizer.M((Object)"@\u001az&k\u0001")).toLowerCase().startsWith(PrimaryMajorityAndActiveBackupsRule.M((Object)"/_6"));
    }

    public StorageProperties() {
        StorageProperties a2;
        StorageProperties storageProperties = a2;
        StorageProperties storageProperties2 = a2;
        StorageProperties storageProperties3 = a2;
        StorageProperties storageProperties4 = a2;
        StorageProperties storageProperties5 = a2;
        StorageProperties storageProperties6 = a2;
        StorageProperties storageProperties7 = a2;
        storageProperties7.forceCleanMmapIndex = true;
        storageProperties7.syncInterval = 1000;
        storageProperties6.forceInterval = 1000;
        storageProperties6.logSuffix = ".log";
        storageProperties5.indexSuffix = ".index";
        storageProperties5.validationSegments = 2;
        storageProperties4.flags = 0;
        storageProperties4.primaryCleanupDelay = 5;
        storageProperties3.segmentSize = 0x1000000;
        storageProperties3.numberOfSegments = 1000L;
        storageProperties2.secondaryCleanupDelay = 30L;
        storageProperties2.logStorageFolder = "log";
        storageProperties.minActiveBackups = 1;
        storageProperties.maxIndexesInMemory = 5;
    }

    public File indexTempFile(String a2, Long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.getStorage(a2);
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix + ".temp";
        return new File(String.format(FILENAME_PATTERN, objectArray));
    }
}

