/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.component.processor;

import io.axoniq.axonserver.applicationevents.EventProcessorEvents;
import io.axoniq.axonserver.component.processor.ClientProcessorsByIdentifier;
import io.axoniq.axonserver.component.processor.EventProcessorIdentifier;
import io.axoniq.axonserver.component.processor.listener.ClientProcessor;
import io.axoniq.axonserver.component.processor.listener.ClientProcessors;
import io.axoniq.axonserver.transport.rest.v2.ClusterUpdatesRestController;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class EventProcessorStatusRefresh {
    private static final Logger B = LoggerFactory.getLogger(EventProcessorStatusRefresh.class);
    private final ClientProcessors C;
    private final Duration D;
    private final List<Consumer<EventProcessorEvents.EventProcessorStatusUpdated>> l;
    private final ApplicationEventPublisher I;
    private static final Duration L = Duration.ofSeconds(10L);

    @Autowired
    public EventProcessorStatusRefresh(ClientProcessors a2, ApplicationEventPublisher a3) {
        a4(L, a2, a3);
        EventProcessorStatusRefresh a4;
    }

    public CompletableFuture<Void> run(String a2, EventProcessorIdentifier a3) {
        EventProcessorStatusRefresh a4;
        return CompletableFuture.runAsync(() -> {
            EventProcessorStatusRefresh a6;
            ClientProcessorsByIdentifier clientProcessorsByIdentifier = new ClientProcessorsByIdentifier(a6.C, a3);
            Set set = StreamSupport.stream(clientProcessorsByIdentifier.spliterator(), false).map(ClientProcessor::clientId).collect(Collectors.toSet());
            CountDownLatch countDownLatch = new CountDownLatch(set.size());
            Consumer<EventProcessorEvents.EventProcessorStatusUpdated> consumer = a5 -> {
                EventProcessorEvents.EventProcessorStatusUpdated eventProcessorStatusUpdated = a5;
                a5 = eventProcessorStatusUpdated.M().d();
                String string = eventProcessorStatusUpdated.M().M().getProcessorName();
                if (set.contains(a5) && string.equals(a3.name())) {
                    set.remove(a5);
                    countDownLatch.countDown();
                }
            };
            EventProcessorStatusRefresh eventProcessorStatusRefresh = a6;
            eventProcessorStatusRefresh.l.add(consumer);
            clientProcessorsByIdentifier.forEach(a4 -> {
                EventProcessorStatusRefresh a5;
                a5.I.publishEvent((Object)new EventProcessorEvents.ProcessorStatusRequest(a2, a4.clientId(), a3.name(), false));
            });
            try {
                boolean a22 = countDownLatch.await(a6.D.toMillis(), TimeUnit.MILLISECONDS);
                if (!a22) {
                    throw new RuntimeException("Event processor status update has not be completed in 10 seconds. No response from " + set);
                }
                return;
            }
            catch (InterruptedException a22) {
                B.warn(ClusterUpdatesRestController.M((Object)"b2SzD?P(S)^zY<\u0016.^?\u0016?@?X.\u0016*D5U?E)Y(EzE.W.C)\u0016-W)\u00163X.S(D/F.S>\u0018z"), (Throwable)a22);
                Thread.currentThread().interrupt();
                return;
            }
            finally {
                a6.l.remove(consumer);
            }
        });
    }

    public EventProcessorStatusRefresh(Duration a2, ClientProcessors a3, ApplicationEventPublisher a4) {
        EventProcessorStatusRefresh a5;
        EventProcessorStatusRefresh eventProcessorStatusRefresh = a5;
        EventProcessorStatusRefresh eventProcessorStatusRefresh2 = a5;
        a5.l = new CopyOnWriteArrayList();
        a5.D = a2;
        eventProcessorStatusRefresh.C = a3;
        eventProcessorStatusRefresh.I = a4;
    }

    @EventListener
    public void on(EventProcessorEvents.EventProcessorStatusUpdated a2) {
        EventProcessorStatusRefresh a4;
        a4.l.forEach(a3 -> a3.accept(a2));
    }
}

