/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.HealthStatus;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.message.query.subscription.DirectSubscriptionQueries;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.DiskSpaceMetrics;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.system.DiskSpaceHealthIndicatorProperties;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.system.DiskSpaceHealthIndicator;
import org.springframework.context.annotation.Configuration;

@Configuration(value="diskSpace")
public class FileSystemMonitor
extends DiskSpaceHealthIndicator {
    private final DiskSpaceHealthIndicatorProperties C;
    private final MeterRegistry D;
    private final Logger l = LoggerFactory.getLogger(FileSystemMonitor.class);
    private final Map<String, Path> I;
    public static final String L = "ROOT";

    public void registerPath(String a2, Path a3) {
        FileSystemMonitor a4;
        FileSystemMonitor fileSystemMonitor = a4;
        fileSystemMonitor.l.info(ErrorMessageFactory.M((Object)"#F\u0000@\u001aF\u001c@\u0000NNO\u0007E\u000b\t\u001d]\u0001[\u000b\tIR\u0013\u000eNH\u001a\t\u001eH\u001aAN\u000e\u0015TI"), (Object)a2, (Object)a3);
        fileSystemMonitor.I.put(a2, a3);
        a4.M(a3);
    }

    private /* synthetic */ Path M(Path a2) throws IOException {
        Path path;
        Path path2;
        Path path3 = a2;
        a2 = Files.getFileStore(path3);
        Path path4 = path2 = (path = path3.toAbsolutePath());
        while ((path = path4.getParent()) != null && a2.equals(Files.getFileStore(path))) {
            path4 = path;
        }
        return path2.normalize();
    }

    protected void doHealthCheck(Health.Builder a2) {
        FileSystemMonitor a5;
        a2.up();
        a5.I.forEach((a3, a4) -> {
            FileSystemMonitor a5;
            try {
                if (!L.equals(a3)) {
                    FileStore fileStore;
                    FileStore fileStore2 = fileStore = Files.getFileStore(a4);
                    long l2 = fileStore2.getUsableSpace();
                    long l3 = a5.C.getThreshold().toBytes();
                    if (fileStore2.getUsableSpace() < l3) {
                        Object[] objectArray = new Object[3];
                        objectArray[0] = a4.toString();
                        objectArray[1] = l2;
                        objectArray[2] = l3;
                        a5.l.warn(String.format(DirectSubscriptionQueries.M((Object)"3+\u0010<U=\u001c*\u001ey\u0006)\u0014:\u0010y\u0014-U)\u0014-\u001dyR|\u0006~U0\u0006y\u0017<\u00196\u0002y\u00011\u0007<\u00061\u001a5\u0011wU\u0018\u00038\u001c5\u0014;\u0019<OyP=U;\f-\u0010*Uq\u00011\u0007<\u00061\u001a5\u0011cU|\u0006p"), objectArray));
                        a2.status(HealthStatus.L);
                    }
                    String string = a3;
                    String string2 = a3;
                    a2.withDetail(string2, (Object)new Details(string2, a5.M(a4).toString(), fileStore.getUsableSpace(), fileStore.getTotalSpace()));
                    a2.withDetail(ErrorMessageFactory.M((Object)"\u001aA\u001cL\u001dA\u0001E\n"), (Object)l3);
                    return;
                }
            }
            catch (Exception exception) {
                a5.l.error(DirectSubscriptionQueries.M((Object)"38\u001c5\u0010=U-\u001ay\u0007<\u0001+\u001c<\u0003<U?\u001c5\u0010y\u0006-\u001a+\u0010y\u00136\u0007y\u000e$"), a4, (Object)exception);
                a2.down();
                a2.withDetail(ErrorMessageFactory.M((Object)"Y\u000f]\u0006"), (Object)a4.toString());
            }
        });
    }

    public List<Details> paths() {
        FileSystemMonitor a3;
        return a3.I.entrySet().stream().map(a2 -> {
            try {
                FileSystemMonitor a3;
                FileStore fileStore = Files.getFileStore((Path)a2.getValue());
                return new Details((String)a2.getKey(), a3.M((Path)a2.getValue()).toString(), fileStore.getUsableSpace(), fileStore.getTotalSpace());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }).collect(Collectors.toList());
    }

    public void unregisterPath(String a2) {
        FileSystemMonitor a3;
        FileSystemMonitor fileSystemMonitor = a3;
        fileSystemMonitor.l.info(DirectSubscriptionQueries.M((Object)"&-\u001a)\u0005<\u0011y\u00186\u001b0\u00016\u00070\u001b>U?\u001c5\u0010y\u0006-\u001a+\u0010yR\"\b~"), (Object)a2);
        fileSystemMonitor.I.remove(a2);
    }

    private /* synthetic */ void M(Path a22) {
        FileSystemMonitor a3;
        try {
            a22 = a3.M(a22);
            File file = new File(a22.toString());
            new DiskSpaceMetrics(file).bindTo(a3.D);
            return;
        }
        catch (Exception a22) {
            a3.l.error(ErrorMessageFactory.M((Object)"o\u000f@\u0002L\n\t\u001aFNK\u0007G\n\t\n@\u001dBND\u000b]\u001c@\rZO"), (Throwable)a22);
            return;
        }
    }

    public Map<String, Path> getRegisteredPaths() {
        FileSystemMonitor a2;
        return a2.I;
    }

    public FileSystemMonitor(DiskSpaceHealthIndicatorProperties a2, MeterRegistry a3) {
        super(null, null);
        FileSystemMonitor a4;
        FileSystemMonitor fileSystemMonitor = a4;
        a4.I = new ConcurrentHashMap();
        a4.C = a2;
        a4.D = a3;
        a4.I.put(L, Paths.get("", new String[0]));
    }
}

