/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.component.processor.balancing.strategy.ReplicationGroupProcessorLoadBalancingService;
import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginConfigurationManager;
import io.axoniq.axonserver.replication.ServerProperties;
import io.axoniq.axonserver.util.StringUtils;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(prefix="axoniq.axonserver")
public class MessagingPlatformConfiguration
implements ServerProperties {
    private String name;
    private String domain;
    private String pluginCleanPolicy;
    private String controldbBackupLocation;
    private int clusterExecutorThreadCount;
    private String webSocketAllowedOrigins;
    private String internalHostname;
    @Value(value="${spring.datasource.url:#{null}}")
    private String datasourceUrl;
    private static final Logger logger = LoggerFactory.getLogger(MessagingPlatformConfiguration.class);
    private int grpcBufferedMessages;
    private Duration minKeepAliveTime;
    @NestedConfigurationProperty
    private AccessControlConfiguration accesscontrol;
    private final SystemInfoProvider systemInfoProvider;
    private String pluginPackageDirectory;
    private int maxMessageSize;
    private int httpPort;
    private Duration keepAliveTime;
    private int eventStoreBackgroundThreadCount;
    private Duration metricsInterval;
    @NestedConfigurationProperty
    private EventTransformationConfiguration eventTransformation;
    private String pidFileLocation;
    private static final int DEFAULT_MAX_TRANSACTION_SIZE = 4184304;
    private String internalDomain;
    @NestedConfigurationProperty
    private SslConfiguration ssl;
    private String pluginCacheDirectory;
    private boolean setWebSocketAllowedOrigins;
    private Duration keepAliveTimeout;
    private static final int RESERVED = 10000;
    private final Map<String, Boolean> preview;
    private boolean pluginsEnabled;
    private static final Logger auditLog = AuditLog.getLogger();
    public static final int DEFAULT_INTERNAL_GRPC_PORT = 8224;
    private int eventStoreProcessorsThreadCount;
    private int internalPort;
    private int port;
    private int executorThreadCount;
    private String hostname;
    private boolean forceConnectionToPrimaryOrMessagingNode;
    private int metricsSynchronizationRate;

    public String getFullyQualifiedHostname() {
        MessagingPlatformConfiguration a2;
        String string = a2.getDomain();
        if (!StringUtils.isEmpty((String)string)) {
            return a2.getHostname() + "." + string;
        }
        return a2.getHostname();
    }

    public void setWebSocketAllowedOrigins(String a2) {
        a.webSocketAllowedOrigins = a2;
    }

    public long getKeepAliveTimeout() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTimeout.toMillis();
    }

    public String getPidFileLocation() {
        MessagingPlatformConfiguration a2;
        return a2.pidFileLocation;
    }

    public boolean isSetWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.setWebSocketAllowedOrigins;
    }

    public void setInternalPort(int a2) {
        a.internalPort = a2;
    }

    public String getWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.webSocketAllowedOrigins;
    }

    public void setDomain(String a2) {
        a.domain = a2;
    }

    public void setControldbBackupLocation(String a2) {
        a.controldbBackupLocation = a2;
    }

    public String getHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.hostname)) {
            try {
                MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
                messagingPlatformConfiguration.hostname = messagingPlatformConfiguration.systemInfoProvider.getHostName();
                if (!StringUtils.isEmpty((String)messagingPlatformConfiguration.domain)) {
                    MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
                    if (messagingPlatformConfiguration2.hostname.endsWith("." + messagingPlatformConfiguration2.domain)) {
                        a2.hostname = a2.hostname.substring(0, a2.hostname.length() - a2.domain.length() - 1);
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                logger.warn(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u0013\"%!4m>\"$m4($(\" 9#5m8\"#9>,=(p+\"\"=m9#59p,4)\"(#>jm+0"), (Object)unknownHostException.getMessage());
            }
        }
        return a2.hostname;
    }

    public void setAccesscontrol(AccessControlConfiguration a2) {
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.accesscontrol == null) break block1;
                    auditLog.info(PluginConfigurationManager.M((Object)"\u000b\u0019)\u001f9\tj\u0019%\u0014>\b%\u0016j\u0019%\u0014,\u0013-\u000f8\u001b>\u0013%\u0014j(\u000f7\u0005,\u000f>d"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.accesscontrol == null || a2.isEnabled() != a3.accesscontrol.isEnabled()) {
                    auditLog.info(ReplicationGroupProcessorLoadBalancingService.M((Object)"\f3.5>#m3\">9\"\"<m9>p#?:p6-c"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.accesscontrol = a2;
    }

    public boolean isForceConnectionToPrimaryOrMessagingNode() {
        MessagingPlatformConfiguration a2;
        return a2.forceConnectionToPrimaryOrMessagingNode;
    }

    public String getFullyQualifiedInternalHostname() {
        MessagingPlatformConfiguration a2;
        String string = a2.getInternalDomain();
        if (!StringUtils.isEmpty((String)string)) {
            return a2.getInternalHostname() + "." + string;
        }
        return a2.getInternalHostname();
    }

    public boolean isPluginsEnabled() {
        MessagingPlatformConfiguration a2;
        return a2.pluginsEnabled;
    }

    public void setHostname(String a2) {
        a.hostname = a2;
    }

    public void setMaxMessageSize(DataSize a2) {
        Assert.isTrue((a2.toBytes() >= 0L ? 1 : 0) != 0, (String)PluginConfigurationManager.M((Object)"\u0007\u001b2Z'\u001f9\t+\u001d/Z9\u00130\u001fj\u0017?\t>Z(\u001fj\u001d8\u001f+\u000e/\bj\u000e\"\u001b$Zz"));
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)ReplicationGroupProcessorLoadBalancingService.M((Object)"\u000015p 5>#,7(p>975m=8#9p/5m<(#>p98,>mb|dzduc{dz"));
        a.maxMessageSize = (int)a2.toBytes();
    }

    public void setPort(int a2) {
        a.port = a2;
    }

    public String getControldbBackupLocation() {
        MessagingPlatformConfiguration a2;
        return a2.controldbBackupLocation;
    }

    public void setPluginCacheDirectory(String a2) {
        a.pluginCacheDirectory = a2;
    }

    public String getInternalDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.internalDomain == null) {
            a2.internalDomain = a2.getDomain();
        }
        return a2.internalDomain;
    }

    public boolean isExperimentalFeatureEnabled(String a2) {
        MessagingPlatformConfiguration a3;
        return a3.preview.getOrDefault(a2, false);
    }

    public String getInternalHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.internalHostname)) {
            a2.internalHostname = a2.getHostname();
        }
        return a2.internalHostname;
    }

    public void setExecutorThreadCount(int a2) {
        a.executorThreadCount = a2;
    }

    public int getEventStoreBackgroundThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreBackgroundThreadCount;
    }

    public void setKeepAliveTime(Duration a2) {
        a.keepAliveTime = a2;
    }

    public long getKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTime.toMillis();
    }

    public void setGrpcBufferedMessages(int a2) {
        a.grpcBufferedMessages = a2;
    }

    public void setMinKeepAliveTime(Duration a2) {
        a.minKeepAliveTime = a2;
    }

    public MessagingPlatformConfiguration(SystemInfoProvider a2) {
        MessagingPlatformConfiguration a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration3 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration4 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration5 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration6 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration7 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration8 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration9 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration10 = a3;
        MessagingPlatformConfiguration messagingPlatformConfiguration11 = a3;
        a3.port = 8124;
        messagingPlatformConfiguration11.internalPort = 8224;
        messagingPlatformConfiguration11.keepAliveTimeout = Duration.ofMillis(5000L);
        messagingPlatformConfiguration10.keepAliveTime = Duration.ofMillis(2500L);
        messagingPlatformConfiguration10.minKeepAliveTime = Duration.ofMillis(1000L);
        messagingPlatformConfiguration9.setWebSocketAllowedOrigins = false;
        messagingPlatformConfiguration9.webSocketAllowedOrigins = "*";
        MessagingPlatformConfiguration messagingPlatformConfiguration12 = a3;
        messagingPlatformConfiguration9.ssl = new SslConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration13 = a3;
        messagingPlatformConfiguration8.accesscontrol = new AccessControlConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration14 = a3;
        messagingPlatformConfiguration8.eventTransformation = new EventTransformationConfiguration();
        messagingPlatformConfiguration8.forceConnectionToPrimaryOrMessagingNode = true;
        messagingPlatformConfiguration7.metricsInterval = Duration.ofMinutes(15L);
        messagingPlatformConfiguration7.controldbBackupLocation = ".";
        messagingPlatformConfiguration6.maxMessageSize = 0x400000;
        messagingPlatformConfiguration6.pidFileLocation = ".";
        messagingPlatformConfiguration5.grpcBufferedMessages = 500;
        messagingPlatformConfiguration5.executorThreadCount = 4;
        messagingPlatformConfiguration4.clusterExecutorThreadCount = 4;
        messagingPlatformConfiguration4.eventStoreBackgroundThreadCount = 8;
        messagingPlatformConfiguration3.eventStoreProcessorsThreadCount = 8;
        messagingPlatformConfiguration3.pluginsEnabled = true;
        messagingPlatformConfiguration2.pluginCacheDirectory = "plugins/cache";
        messagingPlatformConfiguration2.pluginPackageDirectory = "plugins/bundles";
        messagingPlatformConfiguration.pluginCleanPolicy = "onFirstInit";
        MessagingPlatformConfiguration messagingPlatformConfiguration15 = a3;
        messagingPlatformConfiguration.preview = new HashMap();
        messagingPlatformConfiguration.systemInfoProvider = a2;
    }

    public AccessControlConfiguration getAccesscontrol() {
        MessagingPlatformConfiguration a2;
        return a2.accesscontrol;
    }

    public void setMetricsSynchronizationRate(int a2) {
        a.metricsSynchronizationRate = a2;
    }

    public int getClusterExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.clusterExecutorThreadCount;
    }

    public void setPluginPackageDirectory(String a2) {
        a.pluginPackageDirectory = a2;
    }

    public void setPluginsEnabled(boolean a2) {
        a.pluginsEnabled = a2;
    }

    public String getPluginCacheDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCacheDirectory;
    }

    public void setInternalDomain(String a2) {
        a.internalDomain = a2;
    }

    public int getExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.executorThreadCount;
    }

    public void setKeepAliveTimeout(Duration a2) {
        a.keepAliveTimeout = a2;
    }

    private /* synthetic */ void M(String a2, String a3, boolean a4, BiConsumer<String, String> a5) {
        String string = a4 = a4 ? PluginConfigurationManager.M((Object)"#\u0014>\u001f8\u0014+\u0016j") : "";
        if (StringUtils.isEmpty((String)a2)) {
            logger.error(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u000e?8<)p#?9p)595?=$>(p,p;1!9)p6-%?>$#1 5c"), (Object)a4);
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, "No " + a4 + "hostname set and system could not provide one.");
        }
        if (Character.isDigit(a2.charAt(0))) {
            logger.warn(PluginConfigurationManager.M((Object)".\"\u001fj\u00017\u0012%\t>\u0014+\u0017/Z\"\u001b9Z(\u001f/\u0014j\t/\u000ej\u001b9Z+\u0014j3\u001aZ+\u001e.\b/\t9Tj.\"\u00139Z'\u001b3Z:\b%\u001e?\u0019/Z?\u0014=\u001b$\u000e/\u001ej\b/\t?\u0016>\td"), (Object)a4);
            return;
        }
        int n = a2.indexOf(46);
        if (n != -1) {
            String string2 = a2;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (StringUtils.isEmpty((String)a3)) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a4;
                objectArray[1] = string3;
                objectArray[2] = string4;
                logger.info(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u000e?#6$78\"$>*p)? 1$>m6?? p6-%?>$#1 5m ??=5?$4jm8\"#9>,=(m6-ap)? 1$>p+0"), objectArray);
                a5.accept(string3, string4);
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = a4;
            objectArray[1] = a2;
            objectArray[2] = string3;
            objectArray[3] = a3;
            logger.warn(PluginConfigurationManager.M((Object)"\u0003\u001d$\u00158\u0013$\u001dj\u001e%\u0017+\u0013$Z:\u001b8\u000ej\u0015,Z>\u0012/Z1\u0007\"\u00159\u000e$\u001b'\u001fj]1\u0007m@j\u0012%\t>\u0014+\u0017/G1\u0007fZ.\u0015'\u001b#\u0014w\u00017"), objectArray);
            a5.accept(string3, a3);
        }
    }

    public int getMaxMessageSize() {
        MessagingPlatformConfiguration a2;
        return a2.maxMessageSize;
    }

    public String getPluginCleanPolicy() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCleanPolicy;
    }

    public int getInternalPort() {
        MessagingPlatformConfiguration a2;
        return a2.internalPort;
    }

    public int getMaxTransactionSize() {
        MessagingPlatformConfiguration a2;
        if (a2.maxMessageSize == 0) {
            return 4184304;
        }
        return a2.maxMessageSize - 10000;
    }

    public void setName(String a2) {
        a.name = a2;
    }

    public SslConfiguration getSsl() {
        MessagingPlatformConfiguration a2;
        return a2.ssl;
    }

    public void setSsl(SslConfiguration a2) {
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.ssl == null) break block1;
                    auditLog.info(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u0003\u001e\u001cm3\">+9*%?199\">m\u0002\b\u001d\u0002\u0006\b\u0014c"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.ssl == null || a2.isEnabled() != a3.ssl.isEnabled()) {
                    auditLog.info(PluginConfigurationManager.M((Object)")\u00196j\u00139Z$\u0015=Z1\u0007d"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.ssl = a2;
    }

    public String getPluginPackageDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginPackageDirectory;
    }

    public Map<String, Boolean> getPreview() {
        MessagingPlatformConfiguration a2;
        return a2.preview;
    }

    @PostConstruct
    public void postConstruct() {
        MessagingPlatformConfiguration a4;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a4;
        messagingPlatformConfiguration.M(a4.getHostname(), messagingPlatformConfiguration.getDomain(), false, (a2, a3) -> {
            MessagingPlatformConfiguration a4;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a4;
            messagingPlatformConfiguration.setHostname(a2);
            messagingPlatformConfiguration.setDomain(a3);
        });
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a4;
        messagingPlatformConfiguration2.M(a4.getInternalHostname(), messagingPlatformConfiguration2.getInternalDomain(), true, (a2, a3) -> {
            MessagingPlatformConfiguration a4;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a4;
            messagingPlatformConfiguration.setInternalHostname(a2);
            messagingPlatformConfiguration.setInternalDomain(a3);
        });
        if (a4.datasourceUrl != null && !a4.datasourceUrl.contains(ReplicationGroupProcessorLoadBalancingService.M((Object)"w=(=w")) && !a4.datasourceUrl.contains(PluginConfigurationManager.M((Object)"+\u0002%\u00149\u001f8\f/\bg\u0019%\u0014,\u0013-\u001e("))) {
            throw new FailedToStartException(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u00198(p)191/1>5m>,=(p+??p\f(\">m\u0003(\";5?p %>$m2(pj15?##(\";5?}.?#6$7)2j~m\u0019+p4?8p,\"(p 9*\",$$>*p+\"\"=m1#p\"<)5?p;5?#$?#p(>>%?5m$%19p98(p\u000e?#$??!p\t\u0012m9>p$>mw,(\">>5?&(\"`3\">9\"\"<)2jp,>)p8 )195m$%5m#=\"$>*~)191>?8\".5c%?<m ??=5?$4p9?m%>5m4,$,2,#(p#1 5mw,(\">>5?&(\"`3\">+9*4/wc"));
        }
        if (auditLog.isInfoEnabled()) {
            auditLog.info(PluginConfigurationManager.M((Object)"9%\u0014,\u0013-\u000f8\u001b>\u0013%\u0014j\u0013$\u0013>\u0013+\u0016#\u0000/\u001ej\r#\u000e\"Z\u0019)\u0006Z1\u0007j\u001b$\u001ej\u001b)\u0019/\t9Z)\u0015$\u000e8\u0015&Z1\u0007d"), (Object)AuditLog.enablement((boolean)a4.ssl.isEnabled()), (Object)AuditLog.enablement((boolean)a4.accesscontrol.isEnabled()));
        }
    }

    public Duration getMetricsInterval() {
        MessagingPlatformConfiguration a2;
        return a2.metricsInterval;
    }

    public void setPluginCleanPolicy(String a2) {
        a.pluginCleanPolicy = a2;
    }

    @PostConstruct
    public void init() {
        if (auditLog.isInfoEnabled()) {
            MessagingPlatformConfiguration a4;
            a4.preview.forEach((a2, a3) -> {
                if (Boolean.TRUE.equals(a3)) {
                    auditLog.info(PluginConfigurationManager.M((Object)"*8\u001f<\u0013/\rj\u0015,Z,\u001f+\u000e?\b/Z1\u0007j\u001f$\u001b(\u0016/\u001ed"), a2);
                }
            });
        }
    }

    public int getEventStoreProcessorsThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreProcessorsThreadCount;
    }

    public String getDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.domain == null) {
            block4: {
                String string = a2.systemInfoProvider.getHostName();
                int n = string.indexOf(46);
                if (n == -1) break block4;
                a2.domain = string.substring(n + 1);
            }
            try {
                a2.domain = "";
            }
            catch (UnknownHostException unknownHostException) {
                logger.warn(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u0013\"%!4m>\"$m4($(\" 9#5m8\"#9>,=(p+\"\"=m9#59p,4)\"(#>jm+0"), (Object)unknownHostException.getMessage());
            }
        }
        return a2.domain;
    }

    public void setClusterExecutorThreadCount(int a2) {
        a.clusterExecutorThreadCount = a2;
    }

    public void setEventStoreBackgroundThreadCount(int a2) {
        a.eventStoreBackgroundThreadCount = a2;
    }

    public void setEventTransformation(EventTransformationConfiguration a2) {
        a.eventTransformation = a2;
    }

    public void setMetricsInterval(Duration a2) {
        a.metricsInterval = a2;
    }

    public void setEventStoreProcessorsThreadCount(int a2) {
        a.eventStoreProcessorsThreadCount = a2;
    }

    public int getPort() {
        MessagingPlatformConfiguration a2;
        return a2.port;
    }

    public long getMinKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.minKeepAliveTime.toMillis();
    }

    public void setPidFileLocation(String a2) {
        a.pidFileLocation = a2;
    }

    public void setSetWebSocketAllowedOrigins(boolean a2) {
        a.setWebSocketAllowedOrigins = a2;
    }

    public EventTransformationConfiguration getEventTransformation() {
        MessagingPlatformConfiguration a2;
        return a2.eventTransformation;
    }

    public void setForceConnectionToPrimaryOrMessagingNode(boolean a2) {
        a.forceConnectionToPrimaryOrMessagingNode = a2;
    }

    public int getGrpcBufferedMessages() {
        MessagingPlatformConfiguration a2;
        return a2.grpcBufferedMessages;
    }

    public String getName() {
        MessagingPlatformConfiguration a2;
        if (a2.name == null) {
            a2.name = a2.getHostname();
        }
        return a2.name;
    }

    public int getHttpPort() {
        MessagingPlatformConfiguration a2;
        if (a2.httpPort == 0) {
            a2.httpPort = a2.systemInfoProvider.getPort();
        }
        return a2.httpPort;
    }

    public void setInternalHostname(String a2) {
        a.internalHostname = a2;
    }
}

