/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.processor.ClientEventProcessorInfo;
import io.axoniq.axonserver.component.tags.ClientTagsCache;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.ReadyForConnections;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoRebalancing {
    private final ClientTagsCache B;
    private final PlatformService C;
    private final boolean D;
    private final Logger l;
    private final NavigableSet<PlatformService.ClientComponent> I;
    private final NodeSelector L;

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        AutoRebalancing a3;
        AutoRebalancing autoRebalancing = a3;
        autoRebalancing.l.debug(ClientEventProcessorInfo.M((Object)"l0],D#L4D/C`i)^#B.C%N4H$\u0017`V="), (Object)a2.k());
        a2 = new PlatformService.ClientComponent(a2.k(), a2.f(), a2.e(), a2.M());
        autoRebalancing.I.remove(a2);
        a3.l.debug(SerializedEvent.M((Object)"4 \n<\u0006$\n;\u0017rC3\u001e"), (Object)a3.I);
    }

    private /* synthetic */ Map<String, String> M(String a2, String a3) {
        AutoRebalancing a4;
        return a4.B.apply(new ClientStreamIdentification(a2, a3));
    }

    private /* synthetic */ void M(PlatformService.ClientComponent a2) {
        AutoRebalancing a3;
        AutoRebalancing autoRebalancing = a3;
        autoRebalancing.l.info(ClientEventProcessorInfo.M((Object)"\u0012H1X%^4D.J`_%N/C.H#Y`K/_`V="), (Object)a2.getClientStreamId());
        autoRebalancing.C.requestReconnect(a2, SerializedEvent.M((Object)"\u0011-\u0000'\r&\u0006+\u0017h\u0011-\u0012=\u0006;\u0017-\u0007h\u00011C)\u0016<\fh\u0001)\u000f)\r+\n&\u0004"));
    }

    @Scheduled(fixedRateString="${axoniq.axonserver.cluster.balancing-rate:15000}")
    protected void M() {
        boolean bl;
        AutoRebalancing a2;
        if (!a2.D) {
            return;
        }
        a2.l.debug(ClientEventProcessorInfo.M((Object)"\u0012H\"L,L.N%\u0017`V="), (Object)a2.I);
        boolean bl2 = false;
        do {
            PlatformService.ClientComponent clientComponent;
            if ((clientComponent = (PlatformService.ClientComponent)a2.I.pollFirst()) != null && a2.L.canRebalance(clientComponent.getClientId(), clientComponent.getComponent(), clientComponent.getContext(), a2.M(clientComponent.getContext(), clientComponent.getClientStreamId()))) {
                bl = bl2;
                a2.M(clientComponent);
                continue;
            }
            bl = bl2 = clientComponent != null;
        } while (bl);
    }

    public AutoRebalancing(PlatformService platformService, ClientTagsCache clientsTags, NodeSelector nodeSelector, @Value(value="${axoniq.axonserver.cluster.auto-balancing:true}") boolean a2) {
        AutoRebalancing autoRebalancing = this;
        AutoRebalancing autoRebalancing2 = this;
        this.l = LoggerFactory.getLogger(AutoRebalancing.class);
        AutoRebalancing autoRebalancing3 = this;
        this.I = new ConcurrentSkipListSet();
        autoRebalancing2.C = platformService;
        autoRebalancing2.B = clientsTags;
        autoRebalancing.L = nodeSelector;
        autoRebalancing.D = a2;
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeHealthChanged a2) {
        AutoRebalancing a3;
        AutoRebalancing autoRebalancing = a3;
        autoRebalancing.l.debug(SerializedEvent.M((Object)"\u001a\u0006+\u0006!\u0015-\u0007h\u000b-\u0002$\u0017 C+\u000b)\r/\u0006,C.\f:C3\u001e"), (Object)a2.getNode());
        autoRebalancing.I.clear();
        autoRebalancing.I.addAll(a3.C.getConnectedClients());
    }

    @EventListener
    public void on(ReadyForConnections a2) {
        if (a2.ready()) {
            AutoRebalancing a3;
            AutoRebalancing autoRebalancing = a3;
            autoRebalancing.I.clear();
            autoRebalancing.I.addAll(a3.C.getConnectedClients());
        }
    }
}

