/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.cluster.util.AxonThreadFactory;
import io.axoniq.axonserver.config.ClusterConfiguration;
import io.axoniq.axonserver.config.FlowControl;
import io.axoniq.axonserver.config.MaintenanceExecutors;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterEvent;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.events.serializer.XStreamEventSerializer;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.StubFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelExceptionHandler;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller(value="ClusterController")
public class ClusterController
implements SmartLifecycle,
ApplicationContextAware {
    private final MessagingPlatformConfiguration b;
    private final AtomicBoolean A;
    private final QueryDispatcher H;
    private final ClusterConfiguration K;
    private final ConcurrentMap<String, RemoteConnection> h;
    private final ConcurrentMap<String, ClusterNode> i;
    private final AdminNodes J;
    private final ClusterTagsCache M;
    private final ClientIdRegistry e;
    private final StubFactory j;
    private final AdminConfigurationFactory g;
    private final ChannelExceptionHandler E;
    private final ScheduledExecutorService F;
    private ApplicationContext a;
    private final CommandDispatcher d;
    private final Limits k;
    private volatile boolean B;
    private final ApplicationEventPublisher C;
    private final Logger D;
    private final AtomicBoolean l;
    private final XStreamEventSerializer I;
    private final List<Consumer<ClusterEvent>> L;

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.h.values().stream().filter(RemoteConnection::M);
    }

    @Transactional
    public void start() {
        ClusterController a3;
        ClusterController clusterController = a3;
        clusterController.M();
        clusterController.D.debug(ShowDetail.M((Object)"h\u0011Z\u0017OEX\tN\u0016O\u0000IEX\nU\u0011I\nW\t^\u0017"));
        clusterController.nodes().forEach(a2 -> {
            ClusterController a3;
            a3.M(a2, true);
        });
        a3.F.scheduleWithFixedDelay(() -> {
            ClusterController a2;
            a2.h.values().forEach(RemoteConnection::d);
        }, a3.K.getConnectionCheckDelay(), a3.K.getConnectionCheckInterval(), TimeUnit.MILLISECONDS);
        a3.B = true;
    }

    public void addNodeListener(Consumer<ClusterEvent> a2) {
        ClusterController a3;
        a3.L.add(a2);
    }

    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, ClusterConfiguration clusterConfiguration, AdminNodes clusterNodeRepository, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, StubFactory stubFactory, QueryDispatcher queryDispatcher, CommandDispatcher commandDispatcher, ClientIdRegistry clientIdRegistry, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, ChannelExceptionHandler channelExceptionHandler, XStreamEventSerializer a2) {
        ClusterController clusterController = this;
        ClusterController clusterController2 = this;
        ClusterController clusterController3 = this;
        ClusterController clusterController4 = this;
        ClusterController clusterController5 = this;
        ClusterController clusterController6 = this;
        ClusterController clusterController7 = this;
        ClusterController clusterController8 = this;
        this.D = LoggerFactory.getLogger(ClusterController.class);
        ClusterController clusterController9 = this;
        clusterController8.F = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new AxonThreadFactory(MaintenanceExecutors.M((Object)"\nZ\u001cE\u001dS\u001b\u001b\u001bS\nY\u0007X\fU\u001d")));
        ClusterController clusterController10 = this;
        clusterController9.L = new CopyOnWriteArrayList();
        ClusterController clusterController11 = this;
        clusterController8.h = new ConcurrentHashMap();
        ClusterController clusterController12 = this;
        clusterController8.i = new ConcurrentHashMap();
        ClusterController clusterController13 = this;
        clusterController7.A = new AtomicBoolean();
        ClusterController clusterController14 = this;
        clusterController7.l = new AtomicBoolean();
        clusterController7.b = messagingPlatformConfiguration;
        clusterController6.K = clusterConfiguration;
        clusterController6.J = clusterNodeRepository;
        clusterController5.g = adminConfigurationFactory;
        clusterController5.M = clusterTagsCache;
        clusterController4.j = stubFactory;
        clusterController4.H = queryDispatcher;
        clusterController3.d = commandDispatcher;
        clusterController3.e = clientIdRegistry;
        clusterController2.C = applicationEventPublisher;
        clusterController2.k = limits;
        clusterController.E = channelExceptionHandler;
        clusterController.I = a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void M(ClusterNode a2, boolean a3) {
        ClusterController a4;
        if (a2.getName().equals(a4.b.getName())) {
            return;
        }
        ConcurrentMap concurrentMap = a4.h;
        synchronized (concurrentMap) {
            if (!a4.h.containsKey(a2.getName())) {
                ClusterController clusterController = a4;
                ClusterController clusterController2 = a4;
                ClusterController clusterController3 = a4;
                RemoteConnection remoteConnection = new RemoteConnection(clusterController, a2, a4.j, clusterController.H, clusterController2.d, clusterController2.e, clusterController3.E, clusterController3.I, a4.A.get());
                a4.h.put(a2.getName(), remoteConnection);
                if (a3) {
                    remoteConnection.M();
                }
            }
            return;
        }
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        ClusterController a3;
        a3.i.clear();
        if (RaftAdminGroup.M((String)a2.replicationGroup())) {
            a3.l.set(false);
        }
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a3;
        return a3.nodes().filter(a2 -> {
            ClusterController a3;
            return a3.isActive(a2.getName());
        });
    }

    public void setApplicationContext(@Nonnull ApplicationContext a2) {
        this.a = a2;
    }

    public long getConnectionWaitTime() {
        ClusterController a2;
        return a2.K.getConnectionWaitTime();
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo a2) {
        ClusterController a3;
        NodeInfo nodeInfo = a2;
        a3.M(nodeInfo.getNodeName());
        if (nodeInfo.getNodeName().equals(a3.b.getName())) {
            ClusterController clusterController = a3;
            clusterController.D.info(ShowDetail.M((Object)"1I\u001cR\u000b\\EO\n\u001b\u000fT\fUEL\fO\r\u001b\u0006N\u0017I\u0000U\u0011\u001b\u000bT\u0001^EU\u0004V\u0000\u0001E@\u0018"), (Object)a2.getNodeName());
            return clusterController.getMe();
        }
        if (a2.getInternalHostName().equals(a3.b.getInternalHostname()) && a2.getGrpcInternalPort() == a3.b.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, MaintenanceExecutors.M((Object)"u\bX\u0007Y\u001d\u0016\u0003Y\u0000XIU\u0005C\u001aB\fDIA\u0000B\u0001\u0016\u001aW\u0004SI^\u0006E\u001dX\b[\f\u0016\bX\r\u0016\u0000X\u001dS\u001bX\bZIF\u0006D\u001d"));
        }
        ClusterController clusterController = a3;
        if (!clusterController.h.containsKey((a2 = clusterController.M(a2)).getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.M((ClusterNode)a2, false);
            clusterController2.L.forEach(arg_0 -> ClusterController.M((ClusterNode)a2, arg_0));
        }
        return a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ ClusterNode M(NodeInfo a2) {
        ClusterController a3;
        AdminNodes adminNodes = a3.J;
        synchronized (adminNodes) {
            ClusterNode clusterNode;
            ClusterController clusterController;
            Optional optional = a3.J.findById(a2.getNodeName());
            if (!optional.isPresent()) {
                optional = a3.J.findFirstByInternalHostNameAndGrpcInternalPort(a2.getInternalHostName(), a2.getGrpcInternalPort());
                if (optional.isPresent()) {
                    a3.J.delete((ClusterNode)optional.get());
                    RemoteConnection remoteConnection = (RemoteConnection)a3.h.remove(((ClusterNode)optional.get()).getName());
                    if (remoteConnection != null) {
                        remoteConnection.e();
                    }
                }
                ClusterController clusterController2 = a3;
                clusterController = clusterController2;
                clusterNode = clusterController2.g.clusterNode(a2);
            } else {
                clusterNode = (ClusterNode)optional.get();
                clusterController = a3;
                ClusterNode clusterNode2 = clusterNode;
                NodeInfo nodeInfo = a2;
                ClusterNode clusterNode3 = clusterNode;
                clusterNode3.setGrpcInternalPort(Integer.valueOf(a2.getGrpcInternalPort()));
                clusterNode3.setGrpcPort(Integer.valueOf(a2.getGrpcPort()));
                clusterNode.setHostName(nodeInfo.getHostName());
                clusterNode2.setHttpPort(Integer.valueOf(nodeInfo.getHttpPort()));
                clusterNode2.setInternalHostName(a2.getInternalHostName());
            }
            return clusterController.J.save(clusterNode);
        }
    }

    public ClusterNode getMe() {
        ClusterController a3;
        ClusterController clusterController = a3;
        return clusterController.J.findById(clusterController.b.getName()).map(a2 -> {
            ClusterController a3;
            ClusterNode clusterNode = a2;
            clusterNode.setTags(a3.M.getClusterTags().getOrDefault(clusterNode.getName(), Collections.emptyMap()));
            return a2;
        }).orElseThrow(() -> new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, ShowDetail.M((Object)"x\u0010I\u0017^\u000bOEU\n_\u0000\u001b\u000bT\u0011\u001b\u0003T\u0010U\u0001")));
    }

    public void closeConnection(String a2) {
        ClusterController a3;
        if (a3.h.containsKey(a2)) {
            ((RemoteConnection)a3.h.get(a2)).M();
        }
    }

    public void requestDelete(String a2) {
        ClusterController a3;
        a3.C.publishEvent((Object)DeleteNode.newBuilder().setNodeName(a2).build());
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a3;
        return a3.J.findAll().peek(a2 -> {
            ClusterController a3;
            ClusterNode clusterNode = a2;
            clusterNode.setTags(a3.M.getClusterTags().getOrDefault(clusterNode.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.h.keySet();
    }

    public void publishEvent(Object a2) {
        ClusterController a3;
        a3.C.publishEvent(a2);
    }

    public String getName() {
        ClusterController a2;
        return a2.b.getName();
    }

    public void stop() {
        ClusterController a4;
        ClusterController clusterController = a4;
        clusterController.F.shutdown();
        clusterController.h.forEach((a2, a3) -> a3.e());
        a4.B = false;
    }

    @Transactional
    public void sendDeleteNode(String a2) {
        ClusterController a3;
        a3.deleteNode(a2);
    }

    public FlowControl getQueryFlowControl() {
        ClusterController a2;
        return a2.K.getQueryFlowControl();
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.h.values();
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.l.get();
    }

    private /* synthetic */ void M(String a2) {
        ClusterController a4;
        if (a4.h.containsKey(a2) || a4.b.getName().equals(a2)) {
            return;
        }
        a4.k.getMaxClusterSize().ifPresent(a3 -> {
            ClusterController a4;
            if (a4.h.size() + 1 >= a3) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + a2);
            }
        });
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.B;
    }

    @Transactional
    public synchronized void handleRemoteConnection(NodeInfo a2) {
        Object object;
        ClusterController a3;
        Object object2 = a2.getNodeName();
        ClusterNode clusterNode = a3.getNode((String)object2);
        if (clusterNode == null) {
            ClusterController clusterController = a3;
            clusterNode = clusterController.addConnection(a2);
            object = (RemoteConnection)clusterController.h.remove(object2);
            if (object != null) {
                object.e();
            }
        }
        if (!a3.h.containsKey(object2)) {
            ClusterController clusterController = a3;
            clusterController.M(clusterNode, false);
            object = clusterController.L.iterator();
            Iterator iterator = object;
            while (iterator.hasNext()) {
                object2 = (Consumer)object.next();
                iterator = object;
                object2.accept(new ClusterEvent(ClusterEvent.EventType.l, clusterNode));
            }
        }
        a3.C.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected(a2));
    }

    public FlowControl getCommandFlowControl() {
        ClusterController a2;
        return a2.K.getCommandFlowControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public synchronized void deleteNode(String a4) {
        ClusterController a5;
        ClusterController clusterController = a5;
        clusterController.D.info(MaintenanceExecutors.M((Object)"-S\u0005S\u001dSIX\u0006R\f\fIM\u0014"), (Object)a4);
        clusterController.C.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested(a4));
        ConcurrentMap concurrentMap = clusterController.h;
        synchronized (concurrentMap) {
            RemoteConnection remoteConnection;
            if (a5.b.getName().equals(a4)) {
                a5.h.forEach((a2, a3) -> a3.e());
                ClusterController clusterController2 = a5;
                clusterController2.h.clear();
                clusterController2.J.deleteAllByNameNot(a4);
            }
            if ((remoteConnection = (RemoteConnection)a5.h.remove(a4)) != null) {
                a5.J.findById(a4).ifPresent(a3 -> {
                    ClusterController a4;
                    a4.J.deleteById(a4);
                });
                remoteConnection.e();
                a5.L.forEach(a3 -> a3.accept(new ClusterEvent(ClusterEvent.EventType.I, remoteConnection.M())));
                a5.i.remove(a4);
            }
        }
        a5.C.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted(a4));
    }

    @EventListener
    @Transactional
    public void on(DeleteNode a2) {
        ClusterController a3;
        a3.deleteNode(a2.getNodeName());
    }

    private static /* synthetic */ void M(ClusterNode a2, Consumer a3) {
        a3.accept(new ClusterEvent(ClusterEvent.EventType.l, a2));
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated a2) {
        ClusterController a3;
        a3.i.clear();
        if (RaftAdminGroup.M((String)a2.replicationGroup())) {
            a3.l.set(a3.getMe().isAdmin());
        }
    }

    private /* synthetic */ void M() {
        ClusterController a2;
        ClusterController clusterController = a2;
        Object object = clusterController.J.findById(clusterController.b.getName());
        if (!((Optional)object).isPresent()) {
            if (a2.J.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = a2.b.getName();
                String string = String.format(ShowDetail.M((Object)"x\u0010I\u0017^\u000bOEU\n_\u0000\u001b\u000bZ\b^ES\u0004HEX\rZ\u000b\\\u0000_I\u001b\u000b^\u0012\u001b\u000bZ\b^E\u001e\u0016\u0015Eh\u0011Z\u0017OEz\u001dT\u000bh\u0000I\u0013^\u0017\u001b\u0012R\u0011SEI\u0000X\nM\u0000I\u001c\u001b\u0003R\t^K"), objectArray);
                throw new FailedToStartException(string);
            }
            ClusterController clusterController2 = a2;
            ClusterNode clusterNode = clusterController2.g.clusterNode(clusterController2.b.getName(), a2.b.getFullyQualifiedHostname(), a2.b.getFullyQualifiedInternalHostname(), a2.b.getPort(), a2.b.getInternalPort(), a2.b.getHttpPort());
            clusterController2.J.save(clusterNode);
            return;
        }
        ClusterNode clusterNode = (ClusterNode)((Optional)object).get();
        if (!clusterNode.getInternalHostName().equals(a2.b.getFullyQualifiedInternalHostname()) || !clusterNode.getGrpcInternalPort().equals(a2.b.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = clusterNode.getInternalHostName();
            objectArray[1] = clusterNode.getGrpcInternalPort();
            objectArray[2] = a2.b.getFullyQualifiedInternalHostname();
            objectArray[3] = a2.b.getInternalPort();
            object = String.format(MaintenanceExecutors.M((Object)"u\u001cD\u001bS\u0007BIX\u0006R\f\u0011\u001a\u0016\u0000X\u001dS\u001bX\bZI^\u0006E\u001dX\b[\f\u0019\u0019Y\u001bBI\u001eLES\u0013\r\u001fI^\bEIU\u0001W\u0007Q\fRE\u0016IX\fAI@\bZ\u001cS\u001a\u0016LES\u0013\r\u0018Ie\u001dW\u001bBIw\u0011Y\u0007e\fD\u001fS\u001b\u0016\u001e_\u001d^ID\fU\u0006@\fD\u0010\u0016\u000f_\u0005SG"), objectArray);
            throw new FailedToStartException((String)object);
        }
        a2.l.set(clusterNode.isAdmin());
    }

    public void connect(Node a2) {
        ClusterController a3;
        if (!a3.J.findById(a2.getNodeName()).isPresent()) {
            ClusterController clusterController = a3;
            clusterController.M(clusterController.g.clusterNode(a2), true);
        }
    }

    public ClusterNode getNode(String a3) {
        ClusterController a4;
        if ((a3 = a4.i.computeIfAbsent(a3, a2 -> {
            ClusterController a3;
            return a3.J.findById(a2).orElse(null);
        })) == null) {
            return null;
        }
        return a4.M((ClusterNode)a3);
    }

    public int getPhase() {
        return 50;
    }

    public void setReadyForConnections(boolean a2) {
        ClusterController a5;
        ClusterController clusterController = a5;
        clusterController.A.set(a2);
        clusterController.h.forEach((a3, a4) -> a4.M(a2));
    }

    public boolean isActive(String a2) {
        ClusterController a3;
        if (a2.equals(a3.b.getName()) || a3.h.get(a2) != null && ((RemoteConnection)a3.h.get(a2)).M()) {
            return true;
        }
        return false;
    }

    public Optional<RemoteConnection> getRemoteConnection(String a2) {
        ClusterController a3;
        return Optional.ofNullable((RemoteConnection)a3.h.get(a2));
    }
}

