/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.enterprise.context.AdminContextController;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private boolean E;
    private final List<AxonServerInternalService> F;
    private final Logger a;
    private final Supplier<ScheduledExecutorService> d;
    private Server k;
    private AdvancedTlsX509KeyManager.Closeable B;
    private final LogReplicationService C;
    private final ExecutorService D;
    private final ApplicationEventPublisher l;
    private final LeaderElectionService I;
    private final MessagingPlatformConfiguration L;

    public boolean isAutoStartup() {
        return true;
    }

    public MessagingClusterServer(MessagingPlatformConfiguration a2, LogReplicationService a3, LeaderElectionService a4, List<AxonServerInternalService> a5, Supplier<ScheduledExecutorService> a6, ApplicationEventPublisher a7) {
        MessagingClusterServer a8;
        MessagingClusterServer messagingClusterServer = a8;
        MessagingClusterServer messagingClusterServer2 = a8;
        MessagingClusterServer messagingClusterServer3 = a8;
        MessagingClusterServer messagingClusterServer4 = a8;
        messagingClusterServer4.a = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.L = a2;
        messagingClusterServer3.C = a3;
        messagingClusterServer3.I = a4;
        messagingClusterServer2.F = a5;
        messagingClusterServer2.d = a6;
        messagingClusterServer.l = a7;
        messagingClusterServer.D = Executors.newFixedThreadPool(a2.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(AdminContextController.M((Object)"R(D7E!CiT<T'D0^6\u001c")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        try {
            MessagingClusterServer messagingClusterServer;
            NettyServerBuilder nettyServerBuilder;
            NettyServerBuilder nettyServerBuilder2;
            MessagingClusterServer a2;
            String string = ErrorMessageFactory.M((Object)"G\u0001\t=z\"");
            if (a2.L.getSsl() != null && a2.L.getSsl().isEnabled()) {
                Object object = a2.L.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(AdminContextController.M((Object)"P<^*X5\u001f%I+_7T6G!CjB7]jR!C0\u001c'Y%X*\u001c\"X(Td_+EdB!E"));
                }
                Object object2 = a2.L.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(ErrorMessageFactory.M((Object)"H\u0016F\u0000@\u001f\u0007\u000fQ\u0001G\u001dL\u001c_\u000b[@Z\u001dE@Y\u001c@\u0018H\u001aLCB\u000bPCO\u0007E\u000b\t\u0000F\u001a\t\u001dL\u001a"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                a2.B = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)a2.d.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                nettyServerBuilder2 = NettyServerBuilder.forPort((int)a2.L.getInternalPort(), (ServerCredentials)object);
                string = AdminContextController.M((Object)"b\u0017}dT*P&]!U");
                nettyServerBuilder = nettyServerBuilder2;
            } else {
                nettyServerBuilder = nettyServerBuilder2 = NettyServerBuilder.forPort((int)a2.L.getInternalPort());
            }
            nettyServerBuilder.permitKeepAliveTime(a2.L.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            if (a2.L.getMaxMessageSize() > 0) {
                nettyServerBuilder2.maxInboundMessageSize(a2.L.getMaxMessageSize());
            }
            nettyServerBuilder2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(a2.L));
            a2.F.forEach(a3 -> {
                LinkedList<ContextInterceptor> linkedList = new LinkedList<ContextInterceptor>(a3.interceptors());
                if (a3.requiresContextInterceptor()) {
                    linkedList.add(new ContextInterceptor());
                }
                nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a3, linkedList));
            });
            MessagingClusterServer messagingClusterServer2 = a2;
            nettyServerBuilder2.addService((BindableService)a2.I);
            nettyServerBuilder2.addService((BindableService)messagingClusterServer2.C);
            if (messagingClusterServer2.L.getKeepAliveTime() > 0L) {
                nettyServerBuilder2.keepAliveTime(a2.L.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                nettyServerBuilder2.keepAliveTimeout(a2.L.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            nettyServerBuilder2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(a2.L.getGrpcBufferedMessages()));
            nettyServerBuilder2.executor((Executor)a2.D);
            if (Epoll.isAvailable()) {
                messagingClusterServer = a2;
                nettyServerBuilder2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ErrorMessageFactory.M((Object)"\rE\u001bZ\u001aL\u001c\u0004\fF\u001dZC"))));
                nettyServerBuilder2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(AdminContextController.M((Object)"R(D7E!CiF+C/T6\u001c"))));
                nettyServerBuilder2.channelType(EpollServerSocketChannel.class);
            } else {
                nettyServerBuilder2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(ErrorMessageFactory.M((Object)"\rE\u001bZ\u001aL\u001c\u0004\fF\u001dZC"))));
                nettyServerBuilder2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(AdminContextController.M((Object)"R(D7E!CiF+C/T6\u001c"))));
                nettyServerBuilder2.channelType(NioServerSocketChannel.class);
                messagingClusterServer = a2;
            }
            messagingClusterServer.k = nettyServerBuilder2.build();
            a2.k.start();
            a2.a.info(ErrorMessageFactory.M((Object)"/Q\u0001GNz\u000b[\u0018L\u001c\t-E\u001bZ\u001aL\u001c\t=L\u001c_\u000b[NZ\u001aH\u001c]\u000bMNF\u0000\t\u001eF\u001c]T\t\u0015TN\u0004NR\u0013"), (Object)a2.L.getInternalPort(), (Object)string);
            a2.l.publishEvent((Object)new ReplicationServerStarted());
            a2.E = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(AdminContextController.M((Object)"b0P6E-_#\u0011\u0005I+_db!C2T6\u0011\u0007]1B0T6\u0011\u0017T6G!CdW%X(T \u0011"), (Throwable)exception);
        }
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.E;
    }

    public int getPhase() {
        return 50;
    }

    public void stop() {
        MessagingClusterServer a2;
        if (a2.B != null) {
            a2.B.close();
        }
        a2.D.shutdown();
        try {
            if (!a2.k.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer = a2;
                messagingClusterServer.a.debug(ErrorMessageFactory.M((Object)"o\u0001[\rL\b\\\u0002E\u0017\t\u001d]\u0001Y\u001e@\u0000NNj\u0002\\\u001d]\u000b[Nz\u000b[\u0018L\u001c"));
                messagingClusterServer.k.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            a2.a.debug(AdminContextController.M((Object)"\r_0T6C1A0T \u0011 D6X*VdB,D0U+F*\u0011+WdX*E!C*P(\u0011\u0005I+_\u0017T6G!C"), (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        a2.E = false;
        a2.a.info(ErrorMessageFactory.M((Object)"h\u0016F\u0000\t=L\u001c_\u000b[Nj\u0002\\\u001d]\u000b[Nz\u000b[\u0018L\u001c\t\u001d]\u0001Y\u001eL\n"));
    }
}

