/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.ContextLeaderProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class ContextLeaderProviderImpl
implements ContextLeaderProvider {
    private final RaftGroupManager D;
    private final String l;
    private final Map<String, String> I;
    private final int L;

    @EventListener
    @Order(value=20)
    public void on(ClusterEvents.BecomeContextLeader a2) {
        ContextLeaderProviderImpl a3;
        long l2 = a3.D.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        a3.I.put(a2.context(), a3.l);
    }

    public String getLeaderOrWait(String a2, boolean a32) {
        ContextLeaderProviderImpl a4;
        String string = a4.getLeader(a2);
        if (string != null || !a32) {
            return string;
        }
        long l2 = System.currentTimeMillis() + (long)a4.L;
        String string2 = string;
        while (string2 == null && System.currentTimeMillis() < l2) {
            try {
                Thread.sleep(10L);
                string2 = string = a4.getLeader(a2);
            }
            catch (InterruptedException a32) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return a4.getLeader(a2);
    }

    public boolean isLeader(String a2) {
        ContextLeaderProviderImpl a3;
        if ((a2 = (String)a3.I.get(a2)) != null && a2.equals(a3.l)) {
            return true;
        }
        return false;
    }

    @EventListener
    public void on(ClusterEvents.ContextLeaderStepDown a2) {
        ContextLeaderProviderImpl a3;
        long l2 = a3.D.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        a3.I.remove(a2.context());
    }

    public String getLeader(String a2) {
        ContextLeaderProviderImpl a3;
        return (String)a3.I.get(a2);
    }

    @Autowired
    public ContextLeaderProviderImpl(MessagingPlatformConfiguration a2, RaftProperties a3, RaftGroupManager a4) {
        a5(a2.getName(), a3.getWaitForLeaderTimeout(), a4);
        ContextLeaderProviderImpl a5;
    }

    @EventListener
    public void on(ClusterEvents.ContextLeaderConfirmation a2) {
        ContextLeaderProviderImpl a3;
        long l2 = a3.D.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        if (a2.node() == null) {
            a3.I.remove(a2.context());
            return;
        }
        a3.I.put(a2.context(), a2.node());
    }

    @EventListener
    public void on(ContextEvents.ContextPreDelete a2) {
        ContextLeaderProviderImpl a3;
        a3.I.remove(a2.context());
    }

    @EventListener
    public void on(ContextEvents.ContextDeleted a2) {
        ContextLeaderProviderImpl a3;
        a3.I.remove(a2.context());
    }

    ContextLeaderProviderImpl(String a2, int a3, RaftGroupManager a4) {
        ContextLeaderProviderImpl a5;
        ContextLeaderProviderImpl contextLeaderProviderImpl = a5;
        ContextLeaderProviderImpl contextLeaderProviderImpl2 = a5;
        a5.I = new ConcurrentHashMap();
        a5.l = a2;
        contextLeaderProviderImpl.L = a3;
        contextLeaderProviderImpl.D = a4;
    }
}

