/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.message.command.CommandMetricsWebSocket;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    private final Logger e;
    private final LifecycleController j;
    private final ApplicationEventPublisher g;
    private final Map<String, Long> E;
    private final FileSystemMonitor F;
    private final ReplicationGroupController a;
    private final Map<String, RaftGroup> d;
    private final MessagingPlatformConfiguration k;
    private volatile boolean B;
    public static final String C = "replication-logs";
    private final GrpcRaftGroupFactory D;
    private final RaftProperties l;
    private final AtomicBoolean I;
    private final RaftGroupRepositoryManager L;

    public String getMyName() {
        GrpcRaftController a2;
        return a2.k.getName();
    }

    public void stop() {
        GrpcRaftController a4;
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.F.unregisterPath(C);
        grpcRaftController.d.forEach((a2, a3) -> a3.stop());
        a4.B = false;
    }

    private /* synthetic */ void M(String a2) {
        GrpcRaftController a3;
        a3.E.put(a2, System.currentTimeMillis() + 2L * (long)a3.l.getMaxElectionTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ RaftGroup M(String a2, String a3) {
        GrpcRaftController a4;
        Map map = a4.d;
        synchronized (map) {
            block4: {
                GrpcRaftController grpcRaftController = a4;
                grpcRaftController.e.info(CommandMetricsWebSocket.M((Object)" \u0013aN2\u00002\u001a{\u001c>\u001e7\u00078\u000f/\u00074\u0000{\t)\u0001.\u001e"), (Object)a2);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.d.get(a2);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a3 = a4.D.create(a2, a3);
            a3.localNode().d(arg_0 -> a4.M((RaftGroup)a3, arg_0));
            a4.d.put(a2, a3);
            return a3;
        }
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.d.keySet();
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.L.contexts();
    }

    public Optional<RaftNode> raftNode(String a2) {
        GrpcRaftController a3;
        if ((a2 = (RaftGroup)a3.d.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    public boolean isHealthy(String a2) {
        GrpcRaftController a3;
        return a3.getRaftNodeForContext(a2).e();
    }

    public void delete(String a2, boolean a3) {
        GrpcRaftController a4;
        if (!a3) {
            a4.M(a2);
        }
        a4.d.remove(a2);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.a.deleteReplicationGroup(a2, a3);
        grpcRaftController.g.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted(a2, a3));
    }

    public GrpcRaftController(MessagingPlatformConfiguration a2, RaftProperties a3, RaftGroupRepositoryManager a4, ApplicationEventPublisher a5, ReplicationGroupController a6, GrpcRaftGroupFactory a7, FileSystemMonitor a8, LifecycleController a9) {
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = a10;
        GrpcRaftController grpcRaftController2 = a10;
        GrpcRaftController grpcRaftController3 = a10;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        a10.e = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController6 = a10;
        grpcRaftController5.d = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController7 = a10;
        grpcRaftController6.E = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController5.I = new AtomicBoolean();
        grpcRaftController4.k = a2;
        grpcRaftController4.L = a4;
        grpcRaftController3.a = a6;
        grpcRaftController3.l = a3;
        grpcRaftController2.g = a5;
        grpcRaftController2.D = a7;
        grpcRaftController.F = a8;
        grpcRaftController.j = a9;
    }

    public RaftNode waitForLeader(RaftGroup a2) {
        RaftGroup raftGroup = a2;
        while (!raftGroup.localNode().m() || a2.logEntryProcessor().M() == 0L) {
            try {
                Thread.sleep(100L);
                raftGroup = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(GlobalSubscriptionMetricRegistry.M((Object)"\u001e'#,%;\"9#i !>%2i (>=>'0i#&w+2*8$2i;,6-2;"));
            }
        }
        return a2.localNode();
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.l.getMaxElectionTimeout();
    }

    public void start() {
        GrpcRaftController a4;
        Object object = new File(a4.l.getLogStorageFolder());
        GrpcRaftController grpcRaftController = a4;
        FileUtils.M((File)object);
        grpcRaftController.F.registerPath(C, ((File)object).toPath());
        object = grpcRaftController.L.getMyReplicationGroups();
        object.forEach(a2 -> {
            GrpcRaftController a3;
            a3.M(a2.groupId(), a2.nodeId());
        });
        a4.B = true;
        AtomicInteger atomicInteger = new AtomicInteger(object.size());
        object.forEach(a3 -> {
            GrpcRaftController a6;
            try {
                GrpcRaftController grpcRaftController = a6;
                grpcRaftController.e.info(GlobalSubscriptionMetricRegistry.M((Object)",4mi\u0005,'%>*6=>&9i0;8<'i$=6;# 9."), (Object)a3.groupId());
                ((RaftGroup)grpcRaftController.d.get(a3.groupId())).start(a3.role()).whenComplete((a4, a5) -> {
                    GrpcRaftController a6;
                    if (a5 == null) {
                        a6.e.info(GlobalSubscriptionMetricRegistry.M((Object)"2*sw\u001b29; 4(# 8'w.%&\"9w:#(%=2-"), (Object)a3.groupId());
                        if (atomicInteger.decrementAndGet() == 0) {
                            GrpcRaftController grpcRaftController = a6;
                            grpcRaftController.j.setCleanShutdown();
                            grpcRaftController.I.set(true);
                            return;
                        }
                    } else {
                        a6.e.warn(CommandMetricsWebSocket.M((Object)" \u0013aN\t\u000b+\u00022\r:\u001a2\u00015N<\u001c4\u001b+N(\u001a:\u001c/N=\u000f2\u0002>\n"), (Object)a3.groupId(), a5);
                    }
                });
                return;
            }
            catch (Exception a22) {
                a6.e.warn(CommandMetricsWebSocket.M((Object)"\u0015&T{(:\u00077\u000b?N/\u0001{\u00075\u0007/\u0007:\u00022\u0014>N)\u000b+\u00022\r:\u001a2\u00015))\u0001.\u001e"), (Object)a3.groupId(), (Object)a22);
                return;
            }
        });
        a4.e.info(CommandMetricsWebSocket.M((Object)"\t\u000b+\u00022\r:\u001a2\u00015N<\u001c4\u001b+N8\u00015\u001a)\u00017\u0002>\u001c{\u001c.\u00005\u00075\t"));
        if (object.isEmpty()) {
            a4.I.set(true);
        }
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.B;
    }

    public RaftNode getRaftNodeForContext(String a2) {
        GrpcRaftController a3;
        return a3.a.findReplicationGroupByContext(a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> {
            GrpcRaftController a3;
            return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.k.getName() + ": Not a member of " + a2);
        });
    }

    public RaftGroup getRaftGroup(String a2) {
        GrpcRaftController a3;
        return (RaftGroup)a3.d.get(a2);
    }

    public RaftNode getRaftNode(String a2) {
        GrpcRaftController a3;
        if (!a3.B) {
            throw new IllegalStateException(GlobalSubscriptionMetricRegistry.M((Object)"\u001e'>=>(; -(# 8'w&%i$!\"=3& 'w 9i';8.%,$:"));
        }
        if (!a3.d.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.k.getName() + ": Not a member of " + a2);
        }
        return ((RaftGroup)a3.d.get(a2)).localNode();
    }

    public void prepareDeleteNodeFromReplicationGroup(String a2, String a3) {
        GrpcRaftController a4;
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.L.prepareDeleteNodeFromReplicationGroup(a2, a3);
        grpcRaftController.g.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested(a2, a3));
    }

    private /* synthetic */ boolean M(String a2) {
        GrpcRaftController a3;
        if (a3.E.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void M(RaftNode a2, StateChanged a3) {
        GrpcRaftController a4;
        StateChanged stateChanged = a3;
        String string = stateChanged.M();
        long l2 = a2.d();
        if (stateChanged.M() && !a3.e()) {
            a4.g.publishEvent((Object)new ClusterEvents.LeaderStepDown(string, l2));
            return;
        }
        if (a3.e() && !a3.M()) {
            a4.g.publishEvent((Object)new ClusterEvents.BecomeLeader(string, () -> ((RaftNode)a2).M(), l2));
            return;
        }
        if (a3.f()) {
            a4.g.publishEvent((Object)new ClusterEvents.LeaderConfirmation(string, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.e())) {
            a4.g.publishEvent((Object)new ClusterEvents.LeaderConfirmation(string, a2.e(), l2));
        }
    }

    public RaftGroup initRaftGroup(String a2, String a3, String a4) {
        GrpcRaftController a5;
        a4 = Node.newBuilder().setNodeId(a3).setHost(a5.k.getFullyQualifiedInternalHostname()).setPort(a5.k.getInternalPort()).setNodeName(a4).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a3 = grpcRaftController.M(a2, a3);
        a3.raftConfiguration().update(Collections.singletonList(a4));
        grpcRaftController.e.debug(CommandMetricsWebSocket.M((Object)"=/\u000f)\u001a{\b)\u00016N2\u00002\u001a\t\u000f=\u001a\u001c\u001c4\u001b+N \u0013"), (Object)a2);
        String string = a3;
        string.startAndWait(Role.PRIMARY);
        return string;
    }

    public String getMyLabel(List<Node> a2) {
        a2 = a2.iterator();
        while (a2.hasNext()) {
            GrpcRaftController a3;
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.k.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(GlobalSubscriptionMetricRegistry.M((Object)"\u0014&\"%3i9&#i1 9-w*\";%,9=w'8-2i>'w'8-2:"));
    }

    public int getPhase() {
        return 100;
    }

    private /* synthetic */ void M(RaftGroup a2, StateChanged a3) {
        GrpcRaftController a4;
        a4.M(a2.localNode(), a3);
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.I.get();
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.d.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftNode getOrCreateRaftNode(String a2, String a3) {
        GrpcRaftController a4;
        if (!a4.B) {
            throw new IllegalStateException(CommandMetricsWebSocket.M((Object)"=>\u001c-\u000b)N(\u001a:\u001c/\u001b+A(\u0006.\u001a?\u0001,\u0000{\u00075N+\u001c4\t)\u000b(\u001d"));
        }
        RaftGroup raftGroup = (RaftGroup)a4.d.get(a2);
        if (raftGroup != null) {
            return raftGroup.localNode();
        }
        Map map = a4.d;
        synchronized (map) {
            raftGroup = (RaftGroup)a4.d.get(a2);
            if (raftGroup == null) {
                if (a4.M(a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, GlobalSubscriptionMetricRegistry.M((Object)"\u0005,'%>*6=>&9i0;8<'i3,;,# 8'w 9i';8.%,$:"));
                }
                raftGroup = a4.M(a2, a3);
                raftGroup.startAndWait(null);
            }
        }
        return raftGroup.localNode();
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a4;
        if (a4.B) {
            a4.d.forEach((a2, a3) -> ((GrpcRaftGroup)a3).M());
        }
    }
}

