/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.cluster.replication.EntryIterator;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.enterprise.replication.g;
import io.axoniq.axonserver.localstorage.file.EventIterator;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class RaftLeaderProviderImpl
implements ReplicationLeaderProvider {
    private final Map<String, String> d;
    private final Set<Consumer<String>> k;
    private final Function<String, Set<String>> B;
    private final ApplicationEventPublisher C;
    private static final EntryIterator D = new g();
    private final String l;
    private final Logger I;
    private final RaftGroupManager L;

    @EventListener
    public void on(ClusterEvents.LeaderStepDown a2) {
        RaftLeaderProviderImpl a3;
        long l2 = a3.L.currentTerm(a2.replicationGroup()).orElse(-1L);
        RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
        raftLeaderProviderImpl.d.remove(a2.replicationGroup());
        ((Set)raftLeaderProviderImpl.B.apply(a2.replicationGroup())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.C.publishEvent((Object)new ClusterEvents.ContextLeaderStepDown(a4, a2.replicationGroup(), l2));
        });
        a3.M(a2.replicationGroup());
    }

    @EventListener
    @Order(value=10)
    public void on(ClusterEvents.BecomeLeader a2) {
        RaftLeaderProviderImpl a3;
        long l2 = a3.L.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
        raftLeaderProviderImpl.d.put(a2.replicationGroup(), a3.l);
        ((Set)raftLeaderProviderImpl.B.apply(a2.replicationGroup())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.C.publishEvent((Object)new ClusterEvents.BecomeContextLeader(a4, a2.replicationGroup(), a2.unappliedEntriesSupplier(), l2));
        });
        RaftLeaderProviderImpl raftLeaderProviderImpl2 = a3;
        raftLeaderProviderImpl2.C.publishEvent((Object)new ClusterEvents.LeaderNotification(a2.replicationGroup(), a3.l, l2));
        raftLeaderProviderImpl2.M(a2.replicationGroup());
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation a2) {
        RaftLeaderProviderImpl raftLeaderProviderImpl;
        RaftLeaderProviderImpl a3;
        long l2 = a3.L.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        if (a2.node() == null) {
            RaftLeaderProviderImpl raftLeaderProviderImpl2 = a3;
            raftLeaderProviderImpl = raftLeaderProviderImpl2;
            raftLeaderProviderImpl2.d.remove(a2.replicationGroup());
        } else {
            RaftLeaderProviderImpl raftLeaderProviderImpl3 = a3;
            raftLeaderProviderImpl = raftLeaderProviderImpl3;
            raftLeaderProviderImpl3.d.put(a2.replicationGroup(), a2.node());
        }
        ((Set)raftLeaderProviderImpl.B.apply(a2.replicationGroup())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.C.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), a2.node(), l2));
        });
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated a2) {
        RaftLeaderProviderImpl a3;
        if (a3.d.containsKey(a2.replicationGroup())) {
            long l2 = a3.L.currentTerm(a2.replicationGroup()).orElse(-1L);
            ((Set)a3.B.apply(a2.replicationGroup())).forEach(a4 -> {
                RaftLeaderProviderImpl a5;
                a5.C.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), (String)a5.d.get(a2.replicationGroup()), l2));
            });
        }
    }

    public boolean isLeader(String a2) {
        RaftLeaderProviderImpl a3;
        String string = (String)a3.d.get(a2);
        a3.I.debug(EventIterator.M((Object)"\u00190Xm\u0001%\u0007.\t$\f*B!\u0007,\u0006(\u0010m\u00190"), (Object)a2, (Object)string);
        if (string != null && string.equals(a3.l)) {
            return true;
        }
        return false;
    }

    public Set<String> leaderFor() {
        RaftLeaderProviderImpl a2;
        return a2.d.keySet().stream().filter(arg_0 -> a2.isLeader(arg_0)).collect(Collectors.toSet());
    }

    @EventListener
    @Order(value=100)
    public void on(ContextEvents.ContextCreated a2) {
        RaftLeaderProviderImpl a3;
        String string = (String)a3.d.get(a2.replicationGroup());
        Optional optional = a3.L.currentTerm(a2.replicationGroup());
        if (!optional.isPresent()) {
            return;
        }
        if (a3.l.equals(string)) {
            a3.C.publishEvent((Object)new ClusterEvents.BecomeContextLeader(a2.context(), a2.replicationGroup(), () -> D, ((Long)optional.get()).longValue()));
            return;
        }
        a3.C.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a2.context(), a2.replicationGroup(), string, ((Long)optional.get()).longValue()));
    }

    public void registerLeaderChangeListener(Consumer<String> a2) {
        RaftLeaderProviderImpl a3;
        a3.k.add(a2);
    }

    public String getLeader(String a2) {
        RaftLeaderProviderImpl a3;
        return (String)a3.d.get(a2);
    }

    @Autowired
    public RaftLeaderProviderImpl(MessagingPlatformConfiguration a2, RaftGroupRepositoryManager a3, AdminReplicationGroupController a5, ApplicationEventPublisher a6, RaftGroupManager a7) {
        a8(a2.getName(), a4 -> {
            Set set = a3.contextsPerReplicationGroup(a4);
            if (set.isEmpty()) {
                set = a5.contextsPerReplicationGroup(a4);
            }
            return set;
        }, a6, a7);
        RaftLeaderProviderImpl a8;
    }

    private /* synthetic */ void M(String a2) {
        RaftLeaderProviderImpl a4;
        a4.k.forEach(a3 -> a3.accept(a2));
    }

    @EventListener
    public void on(ContextEvents.ContextDeleted a2) {
        RaftLeaderProviderImpl a5;
        long l2 = a5.L.currentTerm(a2.replicationGroup()).orElse(-1L);
        ((Set)a5.B.apply(a2.replicationGroup())).stream().filter(a3 -> a3.equals(a2.context())).forEach(a4 -> {
            RaftLeaderProviderImpl a5;
            a5.C.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), (String)a5.d.get(a2.replicationGroup()), l2));
        });
    }

    @EventListener
    public void on(ClusterEvents.LeaderNotification a2) {
        RaftLeaderProviderImpl a3;
        long l2 = a3.L.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        if (!a2.node().equals(a3.d.get(a2.replicationGroup()))) {
            RaftLeaderProviderImpl raftLeaderProviderImpl = a3;
            raftLeaderProviderImpl.d.put(a2.replicationGroup(), a2.node());
            ((Set)raftLeaderProviderImpl.B.apply(a2.replicationGroup())).forEach(a4 -> {
                RaftLeaderProviderImpl a5;
                a5.C.publishEvent((Object)new ClusterEvents.ContextLeaderConfirmation(a4, a2.replicationGroup(), a2.node(), l2));
            });
            a3.M(a2.replicationGroup());
        }
    }

    RaftLeaderProviderImpl(String a2, Function<String, Set<String>> a3, ApplicationEventPublisher a4, RaftGroupManager a5) {
        RaftLeaderProviderImpl a6;
        RaftLeaderProviderImpl raftLeaderProviderImpl = a6;
        RaftLeaderProviderImpl raftLeaderProviderImpl2 = a6;
        a6.I = LoggerFactory.getLogger(RaftLeaderProviderImpl.class);
        RaftLeaderProviderImpl raftLeaderProviderImpl3 = a6;
        a6.d = new ConcurrentHashMap();
        RaftLeaderProviderImpl raftLeaderProviderImpl4 = a6;
        raftLeaderProviderImpl3.k = new CopyOnWriteArraySet();
        raftLeaderProviderImpl2.l = a2;
        raftLeaderProviderImpl2.B = a3;
        raftLeaderProviderImpl.C = a4;
        raftLeaderProviderImpl.L = a5;
    }
}

