/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.admin.replicationgroup.requestprocessor.UpdateReplicationGroupPayload;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.component.processor.balancing.strategy.AdminProcessorLoadBalancingService;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminContexts;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroups;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.grpc.internal.Context;
import io.axoniq.axonserver.grpc.internal.ContextConfiguration;
import io.axoniq.axonserver.grpc.internal.NodeInfoWithLabel;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupContexts;
import io.axoniq.axonserver.plugin.AdminPluginContextManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AdminReplicationGroupController {
    private final Logger F;
    private final AdminContexts a;
    private final AdminConfigurationFactory d;
    private final AdminApplicationController k;
    private final ApplicationEventPublisher B;
    private final AdminPluginContextManager C;
    private final AdminReplicationGroups D;
    private final ClusterController l;
    private final UserController I;
    private final AdminProcessorLoadBalancingService L;

    private static /* synthetic */ AdminContext M(AdminReplicationGroup a2, ContextConfiguration a3) {
        return a2.addContext(a3.getContext());
    }

    private /* synthetic */ boolean M(AdminReplicationGroup a2, String a4) {
        return a2.getContexts().stream().anyMatch(a3 -> a3.getName().equals(a4));
    }

    @Transactional
    public void registerContexts(ReplicationGroupContexts a2) {
        Iterator iterator;
        Iterator iterator2 = iterator = a2.getContextList().iterator();
        while (iterator2.hasNext()) {
            AdminReplicationGroupController a3;
            Context context = (Context)iterator.next();
            iterator2 = iterator;
            a3.registerContext(a2.getReplicationGroupName(), context.getContextName(), context.getMetaDataMap());
        }
    }

    @EventListener
    @Transactional
    public void on(ClusterEvents.ReplicationGroupDeleted a2) {
        if (RaftAdminGroup.M((String)a2.replicationGroup())) {
            AdminReplicationGroupController a3;
            a3.unregisterAllAdminData();
        }
    }

    public Optional<AdminReplicationGroup> findByName(String a2) {
        AdminReplicationGroupController a3;
        return a3.D.findByName(a2);
    }

    @Transactional
    public void updateReplicationGroup(ContextConfiguration a2) {
        AdminReplicationGroupController a3;
        ReplicationGroupConfiguration replicationGroupConfiguration = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2.getContext()).addAllNodes((Iterable)a2.getNodesList()).build();
        AdminReplicationGroupController adminReplicationGroupController = a3;
        replicationGroupConfiguration = adminReplicationGroupController.updateReplicationGroup(replicationGroupConfiguration);
        adminReplicationGroupController.a.findById(a2.getContext()).orElseGet(() -> AdminReplicationGroupController.M((AdminReplicationGroup)replicationGroupConfiguration, a2)).setMetaDataMap(a2.getMetaDataMap());
    }

    public Set<String> contextsPerReplicationGroup(String a3) {
        AdminReplicationGroupController a4;
        return a4.D.findByName(a3).map(a2 -> a2.getContexts().stream().map(AdminContext::getName).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Transactional
    public void unregisterContext(String a3, String a4) {
        AdminReplicationGroupController a5;
        a5.a.findById(a4).ifPresent(a2 -> a2.getReplicationGroup().removeContext(a2));
        AdminReplicationGroupController adminReplicationGroupController = a5;
        adminReplicationGroupController.k.removeRolesForContext(a4);
        adminReplicationGroupController.I.removeRolesForContext(a4);
        adminReplicationGroupController.L.deleteByContext(a4);
        adminReplicationGroupController.C.delete(a4);
        adminReplicationGroupController.B.publishEvent((Object)new ClusterEvents.ReplicationGroupUpdated(a3));
        adminReplicationGroupController.B.publishEvent((Object)new ContextEvents.ContextUnregisteredInAdmin(a4));
    }

    @Transactional
    public void registerReplicationGroup(ReplicationGroupConfiguration a2) {
        Iterator iterator;
        AdminReplicationGroupController a3;
        AdminReplicationGroup adminReplicationGroup = a3.d.adminReplicationGroup(a2.getReplicationGroupName());
        Iterator iterator2 = iterator = a2.getNodesList().iterator();
        while (iterator2.hasNext()) {
            NodeInfoWithLabel nodeInfoWithLabel = (NodeInfoWithLabel)iterator.next();
            String string = nodeInfoWithLabel.getNode().getNodeName();
            iterator2 = iterator;
            a3.l.getNode(string).addReplicationGroup(adminReplicationGroup, nodeInfoWithLabel.getLabel(), nodeInfoWithLabel.getRole());
        }
        a3.D.save(adminReplicationGroup);
        a3.B.publishEvent((Object)new ClusterEvents.ReplicationGroupCreated(a2.getReplicationGroupName()));
    }

    @Transactional
    public void updateContext(String a2, Map<String, String> a3) {
        AdminReplicationGroupController a5;
        a5.a.findById(a2).ifPresent(a4 -> {
            AdminReplicationGroupController a5;
            a4.setMetaDataMap(a3);
            a5.a.save(a4);
            a5.B.publishEvent((Object)new ContextEvents.ContextUpdatedInAdmin(a2));
        });
    }

    @Transactional
    public void unregisterAllContexts() {
        AdminReplicationGroupController a2;
        a2.a.deleteAll();
    }

    public AdminReplicationGroupController(AdminReplicationGroups a2, AdminContexts a3, AdminApplicationController a4, UserController a5, ClusterController a6, AdminProcessorLoadBalancingService a7, AdminPluginContextManager a8, AdminConfigurationFactory a9, ApplicationEventPublisher a10) {
        AdminReplicationGroupController a11;
        AdminReplicationGroupController adminReplicationGroupController = a11;
        AdminReplicationGroupController adminReplicationGroupController2 = a11;
        AdminReplicationGroupController adminReplicationGroupController3 = a11;
        AdminReplicationGroupController adminReplicationGroupController4 = a11;
        AdminReplicationGroupController adminReplicationGroupController5 = a11;
        adminReplicationGroupController5.F = LoggerFactory.getLogger(AdminReplicationGroupController.class);
        adminReplicationGroupController5.D = a2;
        adminReplicationGroupController4.a = a3;
        adminReplicationGroupController4.k = a4;
        adminReplicationGroupController3.I = a5;
        adminReplicationGroupController3.l = a6;
        adminReplicationGroupController2.L = a7;
        adminReplicationGroupController2.C = a8;
        adminReplicationGroupController.d = a9;
        adminReplicationGroupController.B = a10;
    }

    @EventListener
    @Transactional
    public void on(ClusterEvents.DeleteNodeFromReplicationGroupRequested a2) {
        AdminReplicationGroupController a3;
        a3.D.findByName(a2.replicationGroup()).ifPresent(a4 -> {
            AdminReplicationGroupController a5;
            a4.getMember(a2.node()).ifPresent(a3 -> {
                AdminReplicationGroupController a4;
                a3.setPendingDelete(true);
                a4.D.save(a4);
            });
        });
    }

    public int count() {
        AdminReplicationGroupController a2;
        return (int)a2.D.count();
    }

    @Transactional
    public void unregisterAllAdminData() {
        AdminReplicationGroupController a2;
        AdminReplicationGroupController adminReplicationGroupController = a2;
        adminReplicationGroupController.F.debug(VisibleContextCache.M((Object)"(W\u000eZ\u0019R\u0005\\KZ\u000fV\u0002UKI\u000eK\u0007R\bZ\u001fR\u0004UK\\\u0019T\u001eKK_\u000e]\u0002U\u0002O\u0002T\u0005H"));
        adminReplicationGroupController.D.deleteAll();
        adminReplicationGroupController.I.deleteAll();
        adminReplicationGroupController.k.clearApplications();
        adminReplicationGroupController.a.deleteAll();
        adminReplicationGroupController.C.deleteAll();
        adminReplicationGroupController.L.deleteAll();
    }

    public Stream<AdminReplicationGroup> findAll() {
        AdminReplicationGroupController a2;
        return a2.D.findAll();
    }

    private /* synthetic */ void M(Map a2, ReplicationGroupConfiguration a3, Map a4, AdminReplicationGroup a5, String a6, NodeInfoWithLabel a7) {
        if (!a2.containsKey(a6)) {
            AdminReplicationGroupController a8;
            a8.F.debug(UpdateReplicationGroupPayload.M((Object)"u+4v@9j3.8a\".?`vm#|$k8zvm9`0g1{$o\"g9`vu+"), (Object)a3.getReplicationGroupName(), (Object)a6);
            ((ClusterNode)a4.get(a6)).addReplicationGroup(a5, a7.getLabel(), a7.getRole());
        }
    }

    @Transactional
    public void registerContext(String a2, String a3, Map<String, String> a4) {
        AdminReplicationGroupController a6;
        a6.D.findByName(a2).ifPresent(a5 -> {
            AdminReplicationGroupController a6;
            if (!a6.M(a5, a3)) {
                AdminReplicationGroupController adminReplicationGroupController = a6;
                AdminContext adminContext = adminReplicationGroupController.d.adminContext(a3);
                AdminReplicationGroup adminReplicationGroup = a5;
                adminContext.setMetaDataMap(a4);
                adminContext.setReplicationGroup(adminReplicationGroup);
                adminReplicationGroup.addContext(adminContext);
                adminReplicationGroupController.B.publishEvent((Object)new ClusterEvents.ReplicationGroupUpdated(a2));
                adminReplicationGroupController.B.publishEvent((Object)new ContextEvents.ContextRegisteredInAdmin(a3));
            }
        });
    }

    public int nrOfNodesInRole(Role a4, Set<String> a5) {
        AdminReplicationGroupController a6;
        return (int)a6.D.findAll().flatMap(a2 -> a2.getMembers().stream()).filter(a3 -> a4.equals((Object)a3.getRole())).map(a2 -> a2.getClusterNode().getName()).filter(a3 -> {
            if (!a5.contains(a3)) {
                return true;
            }
            return false;
        }).distinct().count();
    }

    private /* synthetic */ void M(Map a2, ReplicationGroupConfiguration a3, AdminReplicationGroup a4, String a5, ClusterNode a6) {
        if (!a2.containsKey(a5)) {
            AdminReplicationGroupController a7;
            a7.F.debug(VisibleContextCache.M((Object)"\u0010FQ\u001b%T\u000f^KU\u0004OKR\u0005\u001b\u0005^\u001c\u001b\bT\u0005]\u0002\\\u001eI\nO\u0002T\u0005\u001b\u0010F"), (Object)a3.getReplicationGroupName(), (Object)a5);
            a6.removeReplicationGroup(a4);
        }
    }

    @Transactional
    public AdminReplicationGroup updateReplicationGroup(ReplicationGroupConfiguration a2) {
        Iterator iterator;
        AdminReplicationGroupController a4;
        Optional optional = a4.D.findByName(a2.getReplicationGroupName());
        if (!a2.getPending() && a2.getNodesCount() == 0) {
            optional.ifPresent(a3 -> {
                AdminReplicationGroupController a4;
                HashSet hashSet = new HashSet(a3.getContexts());
                AdminReplicationGroupController adminReplicationGroupController = a4;
                adminReplicationGroupController.D.delete(a3);
                hashSet.forEach(a2 -> {
                    AdminReplicationGroupController a3;
                    AdminReplicationGroupController adminReplicationGroupController = a3;
                    adminReplicationGroupController.I.removeRolesForContext(a2.getName());
                    adminReplicationGroupController.k.removeRolesForContext(a2.getName());
                    adminReplicationGroupController.L.deleteByContext(a2.getName());
                    adminReplicationGroupController.C.delete(a2.getName());
                });
            });
            return null;
        }
        optional = optional.orElseGet(() -> {
            AdminReplicationGroupController a3;
            AdminReplicationGroupController adminReplicationGroupController = a3;
            a2 = adminReplicationGroupController.d.adminReplicationGroup(a2.getReplicationGroupName());
            return adminReplicationGroupController.D.save((AdminReplicationGroup)a2);
        });
        optional.setChangePending(a2.getPending());
        HashMap<String, ClusterNode> hashMap = new HashMap<String, ClusterNode>();
        optional.getMembers().forEach(a3 -> hashMap.put(a3.getClusterNode().getName(), a3.getClusterNode()));
        HashMap<String, NodeInfoWithLabel> hashMap2 = new HashMap<String, NodeInfoWithLabel>();
        a2.getNodesList().forEach(a3 -> hashMap2.put(a3.getNode().getNodeName(), (NodeInfoWithLabel)a3));
        HashMap<String, ClusterNode> hashMap3 = new HashMap<String, ClusterNode>();
        Iterator iterator2 = iterator = a2.getNodesList().iterator();
        while (iterator2.hasNext()) {
            NodeInfoWithLabel nodeInfoWithLabel = (NodeInfoWithLabel)iterator.next();
            String string = nodeInfoWithLabel.getNode().getNodeName();
            ClusterNode clusterNode = a4.l.getNode(string);
            if (clusterNode == null) {
                AdminReplicationGroupController adminReplicationGroupController = a4;
                adminReplicationGroupController.F.debug(UpdateReplicationGroupPayload.M((Object)"-sl.\u0015|3o\"g8iv`3yvm9`8k5z?a8.\"avu+"), (Object)a2.getReplicationGroupName(), (Object)nodeInfoWithLabel.getNode().getNodeName());
                clusterNode = adminReplicationGroupController.l.addConnection(nodeInfoWithLabel.getNode());
            }
            hashMap3.put(string, clusterNode);
            iterator2 = iterator;
        }
        hashMap.forEach((arg_0, arg_1) -> a4.M(hashMap2, a2, (AdminReplicationGroup)optional, arg_0, arg_1));
        hashMap2.forEach((arg_0, arg_1) -> a4.M(hashMap, a2, hashMap3, (AdminReplicationGroup)optional, arg_0, arg_1));
        a4.B.publishEvent((Object)new ClusterEvents.ReplicationGroupUpdated(optional.getName()));
        return optional;
    }

    public Collection<String> getNodeNames(String a2) {
        AdminReplicationGroupController a3;
        return a3.D.findByName(a2).map(AdminReplicationGroup::getMemberNames).orElse(Collections.emptyList());
    }
}

