/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.access.application.ApplicationNotFoundException;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.util.RoleUtils;
import io.axoniq.axonserver.component.processor.ClientsByEventProcessor;
import io.axoniq.axonserver.config.AxonServerEnterpriseProperties;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminApplication;
import io.axoniq.axonserver.configuration.admin.AdminApplicationContext;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminContext;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.AdminUser;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.configuration.common.EventProcessor;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.AdminContextController;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.enterprise.replication.admin.DeleteReplicationGroupPayload;
import io.axoniq.axonserver.enterprise.replication.admin.DeleteReplicationGroupTask;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigService;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupService;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.enterprise.replication.logconsumer.AdminNodeConsumer;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.grpc.UserProtoConverter;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.grpc.internal.Application;
import io.axoniq.axonserver.grpc.internal.ApplicationContextRole;
import io.axoniq.axonserver.grpc.internal.ContextApplication;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.ContextUpdate;
import io.axoniq.axonserver.grpc.internal.ContextUser;
import io.axoniq.axonserver.grpc.internal.DeleteContextRequest;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.FileChunk;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.NodeInfoWithLabel;
import io.axoniq.axonserver.grpc.internal.Plugin;
import io.axoniq.axonserver.grpc.internal.PluginConfigurationForContext;
import io.axoniq.axonserver.grpc.internal.PluginStatus;
import io.axoniq.axonserver.grpc.internal.PluginStatusForContext;
import io.axoniq.axonserver.grpc.internal.ProcessorLBStrategy;
import io.axoniq.axonserver.grpc.internal.PurgeContext;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupContext;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupMember;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupUpdateConfirmation;
import io.axoniq.axonserver.grpc.internal.UpdateLicense;
import io.axoniq.axonserver.grpc.internal.User;
import io.axoniq.axonserver.grpc.internal.UserContextRole;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.localstorage.ContextPropertyDefinition;
import io.axoniq.axonserver.plugin.PluginContextInfo;
import io.axoniq.axonserver.plugin.PluginPackageProvider;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import io.axoniq.axonserver.taskscheduler.task.UnregisterNodeTask;
import io.axoniq.axonserver.util.CompetableFutureUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LocalRaftConfigService
implements RaftConfigService {
    public static final int G = 255;
    private final MessagingPlatformConfiguration b;
    private final LicenseManager A;
    private final Predicate<String> H;
    private final Logger K;
    public static final int h = 255;
    private final PluginPackageProvider i;
    private final AdminConfigurationFactory J;
    private final AdminApplicationController M;
    public static final int e = 255;
    private final AdminReplicationGroupController j;
    private final CopyOnWriteArraySet<String> g;
    private final AdminContextController E;
    private final TaskPublisher F;
    private final UserController a;
    private final GrpcRaftController d;
    private final ClusterController k;
    private static final long B = TimeUnit.SECONDS.toMillis(30L);
    private final ApplicationEventPublisher C;
    private final AxonServerEnterpriseProperties D;
    public static final int l = 255;
    private final RaftGroupServiceFactory I;
    private final FeatureChecker L;

    public Application updateApplication(Application a2) {
        Application application;
        String string;
        String string2;
        LocalRaftConfigService a3;
        LocalRaftConfigService localRaftConfigService = a3;
        localRaftConfigService.M(a2);
        localRaftConfigService.d(a2);
        AdminApplication adminApplication = null;
        try {
            adminApplication = a3.M.get(a2.getName());
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            a3.K.debug(PluginContextInfo.M((Object)"\t\u0010\"!3\u0010/\t \u00017\t,\u000ec\u000e,\u0014c\u0006,\u0015-\u0004c\u001b>Lc\u00031\u0005\"\u0014*\u000e$@-\u00054"), (Object)a2.getName());
        }
        String string3 = ClientsByEventProcessor.M((Object)"vgImL(CdPmCl[(PmV}PfGl");
        if (adminApplication == null) {
            LocalRaftConfigService localRaftConfigService2;
            if (a3.M.count() >= (long)a3.L.getMaxApplications()) {
                throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, PluginContextInfo.M((Object)"-\"\u0018*\r6\rc\u000e6\r!\u00051@,\u0006c\u00013\u0010/\t \u00017\t,\u000e0@1\u0005\"\u0003+\u0005'"));
            }
            if (StringUtils.isEmpty((String)a2.getToken())) {
                string3 = UUID.randomUUID().toString();
                localRaftConfigService2 = a3;
            } else {
                string3 = a2.getToken();
                localRaftConfigService2 = a3;
            }
            string2 = localRaftConfigService2.M.hash(string3);
            string = AdminApplicationController.tokenPrefix((String)string3);
            application = a2;
        } else {
            AdminApplication adminApplication2 = adminApplication;
            string2 = adminApplication2.getHashedToken();
            string = adminApplication2.getTokenPrefix() == null ? "" : adminApplication.getTokenPrefix();
            application = a2;
        }
        a2 = Application.newBuilder((Application)application).setToken(string2).setTokenPrefix(string).build();
        return a3.M(a2, string3);
    }

    private /* synthetic */ CompletableFuture<Void> d(String a3, String a4) {
        LocalRaftConfigService a6;
        Set<AdminApplication> set = a6.M.getApplications().map(AdminApplication::newContextPermissions).filter(a2 -> {
            if (!a2.getContexts().isEmpty()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList arrayList = new ArrayList();
        set.forEach(a5 -> {
            LocalRaftConfigService a6;
            List list = a5.getContexts().isEmpty() ? Collections.emptyList() : ((AdminApplicationContext)a5.getContexts().iterator().next()).getRoles();
            a4 = ContextApplication.newBuilder().setContext(a4).setName(a5.getName()).setHashedToken(a5.getHashedToken()).setTokenPrefix(a5.getTokenPrefix()).addAllRoles((Iterable)list).build();
            arrayList.add(a6.I.getRaftGroupService(a3).appendEntry(a3, (GeneratedMessageV3)a4));
        });
        return CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0]));
    }

    private /* synthetic */ Void d(String a2, String a3, boolean a4, Throwable a5) {
        LocalRaftConfigService a6;
        if (!Status.UNAVAILABLE.getCode().equals((Object)Status.fromThrowable((Throwable)a5).getCode())) {
            if (a5 instanceof RuntimeException) {
                throw (RuntimeException)a5;
            }
            throw new MessagingPlatformException(ErrorCode.OTHER, a5.getMessage(), a5);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a3;
        objectArray[1] = a2;
        objectArray[2] = Status.fromThrowable((Throwable)a5);
        a6.K.warn(ClientsByEventProcessor.M((Object)"agWdF(LgV(FmNmVm\u0002zGxNaAiVaMf\u0002oPgWx\u0002s_(DzMe\u0002s_(Q|C|W{\u0002s_$\u0002xWjNaQ`KfE(PmVz[(ViQc"), objectArray);
        a6.F.publishScheduledTask(RaftAdminGroup.M(), DeleteReplicationGroupTask.class.getName(), (Object)new DeleteReplicationGroupPayload(a2, a3, a4), Duration.ofSeconds(1L));
        return null;
    }

    private /* synthetic */ void M(String a2) {
        block3: {
            LocalRaftConfigService a4;
            try {
                RaftNode raftNode = a4.d.getRaftNode(RaftAdminGroup.M());
                if (raftNode.m()) {
                    a4.j.findByName(a2).ifPresent(a3 -> {
                        if (a3.isChangePending()) {
                            LocalRaftConfigService a4;
                            a3 = a4.M(a3).setPending(false).build();
                            raftNode.M(ReplicationGroupConfiguration.class.getName(), a3.toByteArray());
                        }
                    });
                    return;
                }
            }
            catch (MessagingPlatformException messagingPlatformException) {
                if (ErrorCode.REPLICATION_GROUP_NOT_FOUND.equals((Object)messagingPlatformException.getErrorCode())) break block3;
                a4.K.warn(ClientsByEventProcessor.M((Object)"gzPgP(A`GkIaLo\u0002xGfFaLo\u0002kJiLoG{"), (Throwable)messagingPlatformException);
            }
        }
    }

    public void deleteNodeFromReplicationGroup(String a2, String a3) {
        LocalRaftConfigService a4;
        LocalRaftConfigService localRaftConfigService = a4;
        localRaftConfigService.K.info(ClientsByEventProcessor.M((Object)"LGdG|G(LgFm\u0002nPgO(PmRdKkC|KgL(EzM}R(KfTgImF(DgP(PmRdKkC|KgL(EzM}R2\u0002s_(\u000f(CfF(LgFm\u0018(Yu"), (Object)a2, (Object)a3);
        AdminReplicationGroup adminReplicationGroup = (AdminReplicationGroup)localRaftConfigService.j.findByName(a2).orElseThrow(() -> {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(PluginContextInfo.M((Object)"2&\u0010/\t \u00017\t,\u000ec\u00071\u000f6\u0010cE0@-\u000f7@%\u000f6\u000e'"), objectArray));
        });
        String string = (String)adminReplicationGroup.getNodeLabel(a3).orElseThrow(() -> {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = a2;
            return new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(PluginContextInfo.M((Object)".,\u0004&@f\u0013c\u000e,\u0014c\u0006,\u0015-\u0004c\t-@1\u00053\f*\u0003\"\u0014*\u000f-'1\u000f6\u0010cE0"), objectArray));
        });
        if (adminReplicationGroup.getMembers().size() == 1) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = a2;
            throw new MessagingPlatformException(ErrorCode.CANNOT_REMOVE_LAST_NODE, String.format(PluginContextInfo.M((Object)".,\u0004&@f\u0013c\t0@/\u00010\u0014c\u000e,\u0004&@*\u000ec\u0012&\u0010/\t \u00017\t,\u000ec\u00071\u000f6\u0010cE0Lc\u0014,@'\u0005/\u00057\u0005c\u0014+\u0005c\u0012&\u0010/\t \u00017\t,\u000ec\u00071\u000f6\u0010c\u00150\u0005c\u0015-\u0012&\u0007*\u00137\u00051@ \u000f-\u0014&\u00187"), objectArray));
        }
        CompetableFutureUtils.M((CompletableFuture)a4.M(adminReplicationGroup, a3, string), (int)1, (TimeUnit)TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Application refreshToken(Application a2) {
        String string;
        AdminApplication adminApplication;
        LocalRaftConfigService a3;
        try {
            adminApplication = a3.M.get(a2.getName());
            string = StringUtils.isEmpty((String)a2.getToken()) ? UUID.randomUUID().toString() : a2.getToken();
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_APPLICATION, ClientsByEventProcessor.M((Object)"IRxNaAiVaMf\u0002fM|\u0002nM}Ll"));
        }
        {
            String string2 = string;
            a2 = Application.newBuilder((Application)ApplicationProtoConverter.createApplication((AdminApplication)adminApplication)).setToken(a3.M.hash(string2)).setTokenPrefix(AdminApplicationController.tokenPrefix((String)string2)).build();
            return a3.M(a2, string2);
        }
    }

    private /* synthetic */ void M(ContextUpdate a2, Void a3) {
        LocalRaftConfigService a4;
        a4.M("ADMIN_UPDATE_CONTEXT", a2.toByteArray());
    }

    private /* synthetic */ void d(User a2, String a3, AdminContext a4) {
        LocalRaftConfigService a5;
        LocalRaftConfigService localRaftConfigService = a5;
        Set set = localRaftConfigService.M(a2.getRolesList(), a4.getName());
        a2 = ContextUser.newBuilder().setContext(a4.getName()).setUser(User.newBuilder((User)a2).setPassword(StringUtils.getOrDefault((String)a3, (String)"")).clearRoles().addAllRoles((Iterable)set).build()).build();
        CompetableFutureUtils.M((CompletableFuture)localRaftConfigService.I.getRaftGroupService(a4.getReplicationGroup().getName()).appendEntry(a4.getReplicationGroup().getName(), (GeneratedMessageV3)a2));
    }

    private /* synthetic */ CompletableFuture M(DeleteContextRequest a2, Void a3) {
        LocalRaftConfigService a4;
        return a4.M("ADMIN_DELETE_CONTEXT", a2.toByteArray());
    }

    public void updatePluginStatusForContext(Plugin a22, String a3, PluginStatus a4) {
        LocalRaftConfigService a5;
        AdminContext adminContext = a5.E.getContext(a3);
        if (adminContext == null) {
            throw new MessagingPlatformException(ErrorCode.CONTEXT_NOT_FOUND, PluginContextInfo.M((Object)"\u0000\u000f-\u0014&\u00187@-\u000f7@%\u000f6\u000e'"));
        }
        a22 = PluginStatusForContext.newBuilder().setContext(a3).setPlugin(a22).setStatus(a4).build();
        try {
            ((CompletableFuture)a5.I.getRaftGroupService(adminContext.getReplicationGroup().getName()).appendEntry(adminContext.getReplicationGroup().getName(), (GeneratedMessageV3)a22).thenAccept(arg_0 -> a5.M((PluginStatusForContext)a22, arg_0))).get();
            return;
        }
        catch (InterruptedException a22) {
            Thread.currentThread().interrupt();
            throw new MessagingPlatformException(ErrorCode.OTHER, ClientsByEventProcessor.M((Object)"AL|GzP}R|Gl\u0002\u007fJaNm\u0002xPgAmQ{KfE(WxFiVm\u0002xN}EaL(Q|C|W{"), (Throwable)a22);
        }
        catch (ExecutionException a22) {
            throw new MessagingPlatformException(ErrorCode.OTHER, PluginContextInfo.M((Object)"\u0006\u00121\u000f1@4\b*\f&@3\u0012,\u0003&\u00130\t-\u0007c\u00153\u0004\"\u0014&@3\f6\u0007*\u000ec\u00137\u00017\u00150"), (Throwable)a22);
        }
    }

    private /* synthetic */ ReplicationGroupConfiguration M(String a2, ReplicationGroupUpdateConfirmation a3) {
        LocalRaftConfigService a4;
        a2 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2).setPending(a3.getPending());
        a3.getMembersList().forEach(arg_0 -> a4.M((ReplicationGroupConfiguration.Builder)a2, arg_0));
        return a2.build();
    }

    private /* synthetic */ ReplicationGroupConfiguration.Builder M(AdminReplicationGroup a2) {
        ReplicationGroupConfiguration.Builder builder = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2.getName());
        a2.getMembers().forEach(a4 -> builder.setPending(a2.isChangePending()).addNodes(NodeInfoWithLabel.newBuilder().setNode(a4.getClusterNode().toNodeInfo()).setLabel(a4.getClusterNodeLabel()).setRole(a4.getRole()).build()));
        return builder;
    }

    @NotNull
    private /* synthetic */ List<String> M(NodeInfo a2) {
        LocalRaftConfigService a3;
        a2 = a2.getContextsList().stream().map(ContextRole::getName).collect(Collectors.toList());
        if (a2.size() == 1) {
            if (((String)a2.get(0)).equals("_none")) {
                Object object = a2;
                a3.K.debug(PluginContextInfo.M((Object)")\u000f*\u000ekIy@\t\u000f*\u000e*\u000e$@7\u000fc\u000e,@ \u000f-\u0014&\u00187\u0013m"));
                object.clear();
                return object;
            }
        }
        if (a2.isEmpty()) {
            LocalRaftConfigService localRaftConfigService = a3;
            localRaftConfigService.K.debug(ClientsByEventProcessor.M((Object)"HgKf\n!\u0018(hgKfKfE(Vg\u0002iNd\u0002kMfVmZ|Q&"));
            a2 = localRaftConfigService.j.findAll().map(AdminReplicationGroup::getName).collect(Collectors.toList());
            return a2;
        }
        a3.K.debug(PluginContextInfo.M((Object)")\u000f*\u000ekIy@\t\u000f*\u000e*\u000e$@7\u000fc\u0001c\u00133\u0005 \t%\t&\u0004c\u0013&\u0014c\u000f%@ \u000f-\u0014&\u00187\u0013m"));
        return a2;
    }

    private /* synthetic */ CompletableFuture<Void> M(String a2, String a3, Map<String, String> a4) {
        LocalRaftConfigService a5;
        LocalRaftConfigService localRaftConfigService = a5;
        return localRaftConfigService.M(localRaftConfigService.I.getRaftGroupService(a2), a2, a3, a4);
    }

    public CompletableFuture<Void> addContext(String a2, String a3, Map<String, String> a4) {
        LocalRaftConfigService a5;
        if (RaftAdminGroup.M((String)a2) && !RaftAdminGroup.M((String)a3)) {
            throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, ClientsByEventProcessor.M((Object)"aiLfM|\u0002iFl\u0002kMfVmZ|Q(Vg\u0002|Jm\u0002iFeKf\u0002zGxNaAiVaMf\u0002oPgWx"));
        }
        if (a5.E.getContext(a3) != null) {
            throw new MessagingPlatformException(ErrorCode.CONTEXT_EXISTS, a3 + ": Context already exists");
        }
        a5.e();
        return a5.M(a2, a3, new HashMap<String, String>(a4));
    }

    @Transactional
    public void updateUser(User a2) {
        LocalRaftConfigService a3;
        LocalRaftConfigService localRaftConfigService = a3;
        localRaftConfigService.d(a2);
        localRaftConfigService.M(a2);
        if (localRaftConfigService.a.findUser(a2.getName()) == null && a3.a.numberOfUsers() >= a3.L.getMaxUsers()) {
            throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, PluginContextInfo.M((Object)"\u000e\u0001;\t.\u0015.@-\u0015.\u0002&\u0012c\u000f%@6\u0013&\u00120@1\u0005\"\u0003+\u0005'"));
        }
        LocalRaftConfigService localRaftConfigService2 = a3;
        localRaftConfigService2.M(User.class.getName(), a2.toByteArray());
        String string = localRaftConfigService2.a.getPassword(a2.getName());
        localRaftConfigService2.E.getContexts().forEach(a4 -> {
            LocalRaftConfigService a5;
            User user = a2;
            a5.d(user, StringUtils.getOrDefault((String)user.getPassword(), (String)string), a4);
        });
    }

    private /* synthetic */ CompletableFuture<Void> M(RaftGroupService a2, String a5, String a6, Map<String, String> a7) {
        LocalRaftConfigService a8;
        a7.putIfAbsent((String)ContextPropertyDefinition.D.M(), (String)a8.D.defaultIndexType());
        a7.putIfAbsent((String)ContextPropertyDefinition.F.M(), (String)a8.D.defaultIndexType());
        a7 = ReplicationGroupContext.newBuilder().setReplicationGroupName(a5).setContextName(a6).putAllMetaData(a7).build();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)a2.appendEntry(a5, (GeneratedMessageV3)a7).thenApply(a4 -> {
            LocalRaftConfigService a5;
            return a5.M(a5, a6);
        })).thenApply(a4 -> {
            LocalRaftConfigService a5;
            return a5.d(a5, a6);
        })).thenAccept(a3 -> {
            LocalRaftConfigService a4;
            a4.M("ADD_CONTEXT", a7.toByteArray());
        })).exceptionally(a3 -> {
            LocalRaftConfigService a4;
            a4.K.warn(PluginContextInfo.M((Object)"\u001b>Zc\u0006\"\t/\u0005'@7\u000fc\u0003,\r3\f&\u0014&@\"\u0004'@ \u000f-\u0014&\u00187"), (Object)a5, a3);
            return null;
        });
    }

    private /* synthetic */ void e() {
        LocalRaftConfigService a3;
        a3.L.getMaxContexts().ifPresent(a2 -> {
            LocalRaftConfigService a3;
            if (a3.E.count() > a2) {
                throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, ClientsByEventProcessor.M((Object)"oiZaO}O(L}OjGz\u0002gD(AgL|GpV{\u0002zGiA`Gl"));
            }
        });
    }

    private /* synthetic */ CompletableFuture<Void> M(String a2, String a3, String a4) {
        LocalRaftConfigService a5;
        LocalRaftConfigService localRaftConfigService = a5;
        Object object = localRaftConfigService.b.getName();
        String string = localRaftConfigService.M((String)object);
        RaftGroup raftGroup = localRaftConfigService.d.initRaftGroup(a2, string, a5.b.getName());
        object = NodeInfo.newBuilder().setNodeName((String)object).setGrpcInternalPort(a5.b.getInternalPort()).setInternalHostName(a5.b.getFullyQualifiedInternalHostname()).setGrpcPort(a5.b.getPort()).setHttpPort(a5.b.getHttpPort()).setHostName(a5.b.getFullyQualifiedHostname()).build();
        object = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2).addNodes(NodeInfoWithLabel.newBuilder().setNode((NodeInfo)object).setRole(Role.PRIMARY).setLabel(string)).build();
        CompetableFutureUtils.M((CompletableFuture)localRaftConfigService.d.waitForLeader(a5.d.getRaftGroup(RaftAdminGroup.M())).M(ReplicationGroupConfiguration.class.getName(), object.toByteArray()));
        a5.d.waitForLeader(raftGroup);
        object = new HashMap();
        if (a4 != null) {
            object.put(ContextPropertyDefinition.D.M(), a4);
            object.put(ContextPropertyDefinition.F.M(), a4);
        }
        return a5.M(a2, a3, (Map)object);
    }

    private /* synthetic */ void d() {
        LocalRaftConfigService a2;
        if (a2.k.nodes().count() > (long)((Integer)a2.L.getMaxClusterSize().get()).intValue()) {
            throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, ClientsByEventProcessor.M((Object)"\\Mg\u0002eCf[(LgFmQ(Kf\u0002kN}Q|Gz"));
        }
    }

    private /* synthetic */ void d(Application a4) {
        LocalRaftConfigService a5;
        Set set = a5.E.getContexts().map(AdminContext::getName).collect(Collectors.toSet());
        if (!(a4 = a4.getRolesPerContextList().stream().map(ApplicationContextRole::getContext).filter(a2 -> {
            if (!a2.equals("*")) {
                return true;
            }
            return false;
        }).filter(a3 -> {
            if (!set.contains(a3)) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet())).isEmpty()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.CONTEXT_NOT_FOUND, String.format(PluginContextInfo.M((Object)"\u0000\u000f-\u0014&\u00187@6\u000e(\u000e,\u0017-ZcE0"), objectArray));
        }
    }

    private /* synthetic */ void d(User a2) {
        if (a2.getName().length() > 255) {
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, ClientsByEventProcessor.M((Object)"]QmPfCeG(VgM(NgLo"));
        }
        if (a2.getPassword().length() > 255) {
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, PluginContextInfo.M((Object)"\u0013\u00010\u00134\u000f1\u0004c\u0014,\u000fc\f,\u000e$"));
        }
    }

    public CompletableFuture<Void> updateContext(String a2, Map<String, String> a3) {
        LocalRaftConfigService a4;
        Object object = a4.E.getContext(a2);
        if (object == null) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            throw new MessagingPlatformException(ErrorCode.CONTEXT_NOT_FOUND, String.format(ClientsByEventProcessor.M((Object)"-Q2\u0002KMfVmZ|\u0002fM|\u0002nM}Ll"), objectArray));
        }
        LocalRaftConfigService localRaftConfigService = a4;
        a3 = localRaftConfigService.M(a3, object.getMetaDataMap());
        object = object.getReplicationGroup().getName();
        a2 = ContextUpdate.newBuilder().setContextName(a2).putAllMetaData(a3).build();
        return localRaftConfigService.I.getRaftGroupService((String)object).appendEntry((String)object, (GeneratedMessageV3)a2).thenAccept(arg_0 -> a4.M((ContextUpdate)a2, arg_0));
    }

    private /* synthetic */ Map<String, String> M(Map<String, String> a2, Map<String, String> a5) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        a5.forEach((a3, a4) -> {
            ContextPropertyDefinition contextPropertyDefinition = ContextPropertyDefinition.M((String)a3);
            if (contextPropertyDefinition != null && !contextPropertyDefinition.M()) {
                concurrentHashMap.put((String)a3, (String)a4);
            }
        });
        a2.forEach((a3, a4) -> {
            ContextPropertyDefinition contextPropertyDefinition = ContextPropertyDefinition.M((String)a3);
            if (contextPropertyDefinition == null || contextPropertyDefinition.M()) {
                concurrentHashMap.put((String)a3, (String)a4);
            }
        });
        return concurrentHashMap;
    }

    private /* synthetic */ Void M(ReplicationGroupConfiguration a2, String a32, Throwable a4) {
        LocalRaftConfigService a5;
        if (a2 == null) {
            a5.K.error(PluginContextInfo.M((Object)"\u001b>"), (Object)a32, (Object)a4);
            return null;
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a2.getReplicationGroupName();
        objectArray[1] = a32;
        objectArray[2] = a4;
        a5.K.error(ClientsByEventProcessor.M((Object)"Yu\u0018(Yu"), objectArray);
        try {
            a5.M(a2.getClass().getName(), a2.toByteArray());
        }
        catch (Exception a32) {
            a5.K.debug(PluginContextInfo.M((Object)"8\u001dy@\u0006\u00121\u000f1@4\b*\f&@1\u00050\u0014,\u0012*\u000e$@,\f'@ \u000f-\u0006*\u00076\u0012\"\u0014*\u000f-@*\u000ec\u0001'\r*\u000ec\u001b>"), (Object)a2.getReplicationGroupName(), (Object)a32.getMessage());
        }
        return null;
    }

    private /* synthetic */ Node M(ClusterNode a2, String a3, Role a4) {
        return Node.newBuilder().setNodeId(a3).setHost(a2.getInternalHostName()).setPort(a2.getGrpcInternalPort().intValue()).setNodeName(a2.getName()).setRole(RoleUtils.M((Role)a4)).build();
    }

    private /* synthetic */ boolean M() {
        LocalRaftConfigService a2;
        if (a2.j.findAll().findAny().isEmpty() && a2.k.getRemoteConnections().isEmpty()) {
            return true;
        }
        return false;
    }

    public void updatePluginConfigurationForContext(Plugin a22, String a3, String a4) {
        LocalRaftConfigService a5;
        AdminContext adminContext = a5.E.getContext(a3);
        if (adminContext == null) {
            throw new MessagingPlatformException(ErrorCode.CONTEXT_NOT_FOUND, ClientsByEventProcessor.M((Object)"KMfVmZ|\u0002fM|\u0002nM}Ll"));
        }
        try {
            a22 = PluginConfigurationForContext.newBuilder().setContext(a3).setPlugin(a22).setConfiguration(a4).build();
            ((CompletableFuture)a5.I.getRaftGroupService(adminContext.getReplicationGroup().getName()).appendEntry(adminContext.getReplicationGroup().getName(), (GeneratedMessageV3)a22).thenAccept(arg_0 -> a5.M((PluginConfigurationForContext)a22, arg_0))).get();
            return;
        }
        catch (InterruptedException a22) {
            Thread.currentThread().interrupt();
            throw new MessagingPlatformException(ErrorCode.OTHER, PluginContextInfo.M((Object)")-\u0014&\u00121\u00153\u0014&\u0004c\u0017+\t/\u0005c\u00101\u000f \u00050\u0013*\u000e$@6\u0010'\u00017\u0005c\u0010/\u0015$\t-@ \u000f-\u0006*\u00076\u0012\"\u0014*\u000f-"), (Throwable)a22);
        }
        catch (ExecutionException a22) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ClientsByEventProcessor.M((Object)"gzPgP(U`KdG(RzMkG{QaLo\u0002}RlC|G(RdWoKf\u0002kMfDaE}PiVaMf"), (Throwable)a22);
        }
    }

    public CompletableFuture<Void> purgeEvents(String a2) {
        LocalRaftConfigService a3;
        LocalRaftConfigService localRaftConfigService = a3;
        String string = localRaftConfigService.d.getRaftNodeForContext(a2).f();
        a2 = PurgeContext.newBuilder().setContext(a2).build();
        return localRaftConfigService.I.getRaftGroupService(string).appendEntry(string, (GeneratedMessageV3)a2);
    }

    public void createReplicationGroup(String a5, Collection<ReplicationGroupMember> a62) {
        LocalRaftConfigService a7;
        if (!a7.g.add(a5)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_UPDATE_IN_PROGRESS, ClientsByEventProcessor.M((Object)"\\Jm\u0002kPmC|KgL(Mn\u0002|Jm\u0002zGxNaAiVaMf\u0002oPgWx\u0002aQ(CdPmCl[(Kf\u0002xPgEzG{Q&"));
        }
        a7.j.findByName(a5).ifPresent(a3 -> {
            LocalRaftConfigService a4;
            a4.g.remove(a5);
            Object[] objectArray = new Object[1];
            objectArray[0] = a5;
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_EXISTS, String.format(PluginContextInfo.M((Object)"\u0011\u00053\f*\u0003\"\u0014*\u000f-@$\u0012,\u00153@f\u0013c\u0001/\u0012&\u0001'\u0019c\u0005;\t0\u00140"), objectArray));
        });
        try {
            a7.M();
        }
        catch (RuntimeException runtimeException) {
            a7.g.remove(a5);
            throw runtimeException;
        }
        ArrayList arrayList = new EnumMap<Role, Set>(Role.class);
        a62.forEach(a4 -> arrayList.computeIfAbsent(a4.getRole(), a2 -> new HashSet()).add(a4.getNodeName()));
        arrayList.forEach((a2, a3) -> {
            LocalRaftConfigService a4;
            a4.M(a3, a2);
        });
        arrayList = a62.stream().map(ReplicationGroupMember::getNodeName).filter(a2 -> {
            LocalRaftConfigService a3;
            if (a3.k.getNode(a2) == null) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (!arrayList.isEmpty()) {
            a7.g.remove(a5);
            Object[] objectArray = new Object[1];
            objectArray[0] = arrayList;
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(PluginContextInfo.M((Object)".,\u0004&H0IcE0@-\u000f7@%\u000f6\u000e'"), objectArray));
        }
        arrayList = new ArrayList();
        AtomicReference atomicReference = new AtomicReference();
        a62.forEach(a4 -> {
            LocalRaftConfigService a5;
            LocalRaftConfigService localRaftConfigService = a5;
            ClusterNode clusterNode = localRaftConfigService.k.getNode(a4.getNodeName());
            String string = localRaftConfigService.M(a4.getNodeName());
            a4 = localRaftConfigService.M(clusterNode, string, a4.getRole());
            if (atomicReference.get() == null && Role.PRIMARY.equals((Object)a4.getRole())) {
                atomicReference.set(a4);
            }
            arrayList.add(a4);
        });
        if (atomicReference.get() == null) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, ClientsByEventProcessor.M((Object)"FM(RzKeCz[(LgFmQ(RzM~KlGl"));
        }
        try {
            CompetableFutureUtils.M((CompletableFuture)((CompletableFuture)a7.I.getRaftGroupServiceForNode(((Node)atomicReference.get()).getNodeName()).initReplicationGroup(a5, arrayList).thenAccept(a2 -> {
                LocalRaftConfigService a3;
                a2 = ReplicationGroupConfiguration.newBuilder((ReplicationGroupConfiguration)a2).setPending(false).build();
                a3.M(ReplicationGroupConfiguration.class.getName(), a2.toByteArray());
            })).whenComplete((a3, a4) -> {
                LocalRaftConfigService a5;
                a5.g.remove(a5);
                if (a4 != null) {
                    a5.deleteReplicationGroup(a5, false);
                }
            }));
            return;
        }
        catch (RuntimeException a62) {
            a7.g.remove(a5);
            throw a62;
        }
    }

    public void deleteNodeIfEmpty(String a3) {
        LocalRaftConfigService a4;
        ClusterNode clusterNode = a4.k.getNode(a3);
        if (clusterNode == null) {
            return;
        }
        if (clusterNode.getReplicationGroups().stream().anyMatch(a2 -> {
            if (a2.getReplicationGroup().getMembers().size() > 1) {
                return true;
            }
            return false;
        })) {
            throw new TransientException(PluginContextInfo.M((Object)".,\u0004&@0\u0014*\f/@.\u0005.\u0002&\u0012c\u000f%@ \u000f-\u0014&\u00187\u0013m"));
        }
        a4.M(DeleteNode.class.getName(), DeleteNode.newBuilder().setNodeName(a3).build().toByteArray());
    }

    private /* synthetic */ void M(AdminReplicationGroup a2, String a3) throws InterruptedException, ExecutionException {
        LocalRaftConfigService a4;
        String string = a4.I.getLeader(a2.getName());
        if (a2.getMembers().size() > 1 && a3.equals(string)) {
            LocalRaftConfigService localRaftConfigService = a4;
            localRaftConfigService.K.info(ClientsByEventProcessor.M((Object)"Yu\u0018(NmClGz\u0002aQ(Yu"), (Object)a2, (Object)string);
            localRaftConfigService.I.getRaftGroupService(a2.getName()).transferLeadership(a2.getName()).get();
            string = a4.I.getLeader(a2.getName());
            String string2 = string;
            for (int i2 = 25; (string2 == null || string.equals(a3)) && i2 > 0; --i2) {
                Thread.sleep(250L);
                string2 = string = a4.I.getLeader(a2.getName());
            }
            if (string == null || string.equals(a3)) {
                throw new MessagingPlatformException(ErrorCode.OTHER, PluginContextInfo.M((Object)"-,\u0016*\u000e$@/\u0005\"\u0004&\u0012c\u0014,@,\u0014+\u00051@-\u000f'\u0005c\u0006\"\t/\u0005'"));
            }
            a4.K.info(ClientsByEventProcessor.M((Object)"Yu\u0018(NmClGz\u0002kJiLoGl\u0002|M(Yu"), (Object)a2, (Object)string);
        }
    }

    private /* synthetic */ void M(Application a2) {
        if (a2.getName().length() > 255) {
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, PluginContextInfo.M((Object)"\r\u0001.\u0005c\u0014,\u000fc\f,\u000e$"));
        }
        if (a2.getDescription().length() > 255) {
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, ClientsByEventProcessor.M((Object)"fmQkPaR|KgL(VgM(NgLo"));
        }
    }

    private /* synthetic */ void M(ReplicationGroupConfiguration a22, String a3, CompletableFuture a4) {
        LocalRaftConfigService a5;
        a22 = ReplicationGroupConfiguration.newBuilder((ReplicationGroupConfiguration)a22).setPending(false).build();
        try {
            a5.M(a22.getClass().getName(), a22.toByteArray());
            return;
        }
        catch (Exception a22) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3;
            objectArray[1] = a22.getMessage();
            objectArray[2] = a22;
            a5.K.warn(PluginContextInfo.M((Object)"8\u001dy@\u0006\u00121\u000f1@4\b*\f&@1\u00050\u0014,\u0012*\u000e$@6\u0010'\u00017\u0005'@ \u000f-\u0006*\u00076\u0012\"\u0014*\u000f-@*\u000ec\u0001'\r*\u000ec\u001b>"), objectArray);
            return;
        }
    }

    private /* synthetic */ Void M(String a2, Node a3, ReplicationGroupConfiguration a4, String a5, Throwable a6) {
        LocalRaftConfigService a7;
        LocalRaftConfigService localRaftConfigService = a7;
        localRaftConfigService.g.remove(a2);
        a7.I.getRaftGroupServiceForNode(a3.getNodeName()).deleteReplicationGroup(a2, true);
        localRaftConfigService.M(a4, "Failed to add node: " + a5, a6);
        throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_UPDATE_IN_PROGRESS, a6.getMessage());
    }

    @EventListener
    @Order(value=5)
    public void on(ClusterEvents.BecomeLeader a2) {
        LocalRaftConfigService a4;
        a4.d.currentTerm(a2.replicationGroup()).ifPresent(a3 -> {
            LocalRaftConfigService a4;
            if (a2.term() < a3) {
                return;
            }
            a4.g.clear();
            a4.M(a2.replicationGroup());
        });
    }

    public void deleteContext(String a2, boolean a32) {
        LocalRaftConfigService a4;
        if (RaftAdminGroup.M((String)a2)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(ClientsByEventProcessor.M((Object)"LGdG|KgL(Mn\u0002aL|GzLiN(AgL|GpV(\u0007{\u0002fM|\u0002iNdM\u007fGl"), objectArray));
        }
        AdminContext adminContext = a4.E.getContext(a2);
        if (adminContext == null) {
            return;
        }
        a4.C.publishEvent((Object)new ContextEvents.ContextPreDelete(a2, adminContext.getReplicationGroup().getName()));
        a2 = DeleteContextRequest.newBuilder().setContext(a2).setReplicationGroupName(adminContext.getReplicationGroup().getName()).setPreserveEventstore(a32).build();
        try {
            ((CompletableFuture)a4.I.getRaftGroupService(a2.getReplicationGroupName()).appendEntry(a2.getReplicationGroupName(), (GeneratedMessageV3)a2).thenApply(arg_0 -> a4.M((DeleteContextRequest)a2, arg_0))).get();
            return;
        }
        catch (InterruptedException a32) {
            Thread.currentThread().interrupt();
            throw new MessagingPlatformException(ErrorCode.INTERRUPTED, "Interrupted during delete context: " + a2.getContext());
        }
        catch (ExecutionException a32) {
            throw MessagingPlatformException.create((Throwable)a32.getCause());
        }
    }

    private /* synthetic */ void M(PluginStatusForContext a2, Void a3) {
        LocalRaftConfigService a4;
        a4.M("ADMIN_CONTEXT_PLUGIN_STATUS", a2.toByteArray());
    }

    public void deleteReplicationGroup(String a2, boolean a3) {
        Iterator iterator;
        LocalRaftConfigService a8;
        String string = a2;
        a8.K.info(PluginContextInfo.M((Object)"$&\f&\u0014&@1\u00053\f*\u0003\"\u0014*\u000f-@$\u0012,\u00153Zc\u001b>"), (Object)string);
        if (RaftAdminGroup.M((String)string)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(ClientsByEventProcessor.M((Object)"LGdG|KgL(Mn\u0002aL|GzLiN(PmRdKkC|KgL(EzM}R(\u0007{\u0002fM|\u0002iNdM\u007fGl"), objectArray));
        }
        AdminReplicationGroup adminReplicationGroup = a8.j.findByName(a2).orElse(null);
        if (adminReplicationGroup == null) {
            LocalRaftConfigService localRaftConfigService = a8;
            localRaftConfigService.K.warn(PluginContextInfo.M((Object)"#,\u0015/\u0004c\u000e,\u0014c\u0006*\u000e'@ \u000f-\u0014&\u00187@8\u001dc\t-@\"\u0004.\t-@7\u0001!\f&\u0013o@0\u0005-\u0004*\u000e$@'\u0005/\u00057\u0005\u0011\u00053\f*\u0003\"\u0014*\u000f-'1\u000f6\u0010c\u0014,@\"\f/@-\u000f'\u00050"), (Object)a2);
            localRaftConfigService.k.remoteNodeNames().forEach(a4 -> {
                LocalRaftConfigService a5;
                a5.I.getRaftGroupServiceForNode(a4).deleteReplicationGroup(a2, a3);
            });
            LocalRaftConfigService localRaftConfigService2 = a8;
            localRaftConfigService2.I.getRaftGroupServiceForNode(localRaftConfigService2.b.getName()).deleteReplicationGroup(a2, a3);
            a8.g.remove(a2);
            return;
        }
        Collection collection = adminReplicationGroup.getMemberNames();
        CompletableFuture[] completableFutureArray = new CompletableFuture[collection.size()];
        LocalRaftConfigService localRaftConfigService = a8;
        ReplicationGroupConfiguration replicationGroupConfiguration = localRaftConfigService.M(adminReplicationGroup).setPending(true).build();
        localRaftConfigService.M(ReplicationGroupConfiguration.class.getName(), replicationGroupConfiguration.toByteArray());
        int n = 0;
        Iterator iterator2 = iterator = new HashSet(collection).iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator.next();
            completableFutureArray[n] = a8.I.getRaftGroupServiceForNode(string2).deleteReplicationGroup(a2, a3).exceptionally(a5 -> {
                LocalRaftConfigService a6;
                return a6.d(string2, a2, a3, a5);
            });
            CompletableFuture completableFuture = completableFutureArray[n];
            ++n;
            completableFuture.thenAccept(a4 -> collection.remove(string2));
            iterator2 = iterator;
        }
        CompetableFutureUtils.M((CompletableFuture)CompletableFuture.allOf(completableFutureArray).whenComplete((a6, a7) -> {
            LocalRaftConfigService localRaftConfigService;
            LocalRaftConfigService a8;
            a6 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2);
            if (a7 != null) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a2;
                objectArray[1] = String.join((CharSequence)PluginContextInfo.M((Object)"o"), collection);
                objectArray[2] = a7;
                a8.K.warn(ClientsByEventProcessor.M((Object)"Yu\u0018(agWdF(LgV(FmNmVm\u0002zGxNaAiVaMf\u0002oPgWx\u0002nPgO(Yu"), objectArray);
                adminReplicationGroup.getMembers().stream().filter(a3 -> collection.contains(a3.getClusterNode().getName())).forEach(arg_0 -> LocalRaftConfigService.M((ReplicationGroupConfiguration.Builder)a6, arg_0));
            }
            try {
                a8.M(ReplicationGroupConfiguration.class.getName(), a6.build().toByteArray());
                localRaftConfigService = a8;
            }
            catch (Exception a42) {
                LocalRaftConfigService localRaftConfigService2 = a8;
                localRaftConfigService = localRaftConfigService2;
                localRaftConfigService2.K.debug(ClientsByEventProcessor.M((Object)"s_2\u0002MPzMz\u0002\u007fJaNm\u0002}RlC|KfE(AgLnKoWzC|KgL(Yu"), (Object)a2, (Object)a42.getMessage());
            }
            localRaftConfigService.g.remove(a2);
        }));
    }

    public void deleteNode(String a2) {
        LocalRaftConfigService a4;
        ClusterNode clusterNode = a4.k.getNode(a2);
        if (clusterNode == null) {
            a4.K.info(ClientsByEventProcessor.M((Object)"LGdG|G(lgFm\u0018(Yu\u0002%\u0002FMlG(LgV(DgWfF&"), (Object)a2);
            return;
        }
        clusterNode.getReplicationGroups().forEach(a3 -> {
            LocalRaftConfigService a4;
            a4.F.publishScheduledTask(RaftAdminGroup.M(), PrepareDeleteNodeFromContextTask.class.getName(), (Object)new NodeContext(a2, a3.getReplicationGroup().getName(), false), Duration.ZERO);
        });
        a4.F.publishScheduledTask(RaftAdminGroup.M(), UnregisterNodeTask.class.getName(), (Object)a2, Duration.ofSeconds(1L));
    }

    public void init(List<String> a2, String a4) {
        LocalRaftConfigService a5;
        if (!a5.M()) {
            throw new MessagingPlatformException(ErrorCode.ALREADY_MEMBER_OF_CLUSTER, PluginContextInfo.M((Object)"\r\u000f'\u0005c\t0@\"\f1\u0005\"\u0004:@.\u0005.\u0002&\u0012c\u000f%@ \f6\u00137\u00051@,\u0012c\t-\t7\t\"\f*\u001a&\u0004c\u0002&\u0006,\u0012&"));
        }
        for (String string : a2) {
            if (a5.H.test(string)) continue;
            throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
        }
        LocalRaftConfigService localRaftConfigService = a5;
        localRaftConfigService.K.info(ClientsByEventProcessor.M((Object)"ALaVaCdKrC|KgL(Mn\u0002|JaQ(LgFm\u0002\u007fK|J(DgNdM\u007fKfE(AgL|GpV{\u0018(Yu"), a2);
        CompetableFutureUtils.M((CompletableFuture)localRaftConfigService.M(RaftAdminGroup.M(), RaftAdminGroup.M(), null), (int)15, (TimeUnit)TimeUnit.MINUTES);
        a2.forEach(a3 -> {
            LocalRaftConfigService a4;
            String string = a3;
            CompetableFutureUtils.M((CompletableFuture)a4.M(string, string, a4), (int)15, (TimeUnit)TimeUnit.MINUTES);
        });
    }

    private /* synthetic */ void e(String a2, ReplicationGroupUpdateConfirmation a32) {
        LocalRaftConfigService a4;
        a4.g.remove(a2);
        if (!a32.getSuccess()) {
            a4.K.error(PluginContextInfo.M((Object)"\u001b>Zc\u001b>"), (Object)a2, (Object)a32.getMessage());
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_UPDATE_IN_PROGRESS, a32.getMessage());
        }
        a32 = a4.M(a2, a32);
        try {
            a4.M(a32.getClass().getName(), a32.toByteArray());
            return;
        }
        catch (Exception a32) {
            a4.K.warn(ClientsByEventProcessor.M((Object)"s_2\u0002MPzMz\u0002{GfFaLo\u0002}RlC|Gl\u0002kMfDaE}PiVaMf\u0002|M(ClOaL(Yu"), (Object)a2, (Object)a32.getMessage());
            return;
        }
    }

    private /* synthetic */ Collection<String> M(Application a2, String a3) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ApplicationContextRole applicationContextRole : a2.getRolesPerContextList()) {
            if (a3.equals(applicationContextRole.getContext())) {
                hashSet.addAll((Collection<String>)applicationContextRole.getRolesList());
            }
            if (!applicationContextRole.getContext().equals("*")) continue;
            hashSet.addAll((Collection<String>)applicationContextRole.getRolesList());
        }
        return hashSet;
    }

    public UpdateLicense join(NodeInfo a3) {
        LocalRaftConfigService a4;
        a4.L.getMaxClusterSize().ifPresent(a2 -> {
            LocalRaftConfigService a3;
            if (a3.k.nodes().count() >= (long)a2.intValue()) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached: " + a3.L.getMaxClusterSize());
            }
        });
        Object object = a4.d.getRaftNode(RaftAdminGroup.M());
        if (!object.m()) {
            throw new MessagingPlatformException(ErrorCode.NODE_IS_REPLICA, "Send join request to the leader of _admin context: " + object.e());
        }
        LocalRaftConfigService localRaftConfigService = a4;
        object = localRaftConfigService.M();
        List list = localRaftConfigService.M(a3);
        String string = localRaftConfigService.M(a3.getNodeName());
        Node node = Node.newBuilder().setNodeId(string).setHost(a3.getInternalHostName()).setPort(a3.getGrpcInternalPort()).setNodeName(a3.getNodeName()).build();
        localRaftConfigService.M(AdminNodeConsumer.class.getName(), a3.toByteArray());
        list.forEach(a7 -> {
            AdminReplicationGroup adminReplicationGroup;
            LocalRaftConfigService a8;
            ReplicationGroupConfiguration replicationGroupConfiguration;
            block4: {
                block5: {
                    replicationGroupConfiguration = null;
                    try {
                        adminReplicationGroup = a8.j.findByName(a7).orElse(null);
                        if (adminReplicationGroup == null) break block4;
                        if (!adminReplicationGroup.getMemberNames().contains(a3.getNodeName())) break block5;
                        a8.K.info(ClientsByEventProcessor.M((Object)"s_2\u0002FMlG(Yu\u0002aQ(CdPmCl[(OmOjGz"), (Object)adminReplicationGroup, (Object)node.getNodeName());
                        return;
                    }
                    catch (Exception exception) {
                        a8.M(replicationGroupConfiguration, "Error while adding node " + node.getNodeName(), (Throwable)exception);
                        return;
                    }
                }
                LocalRaftConfigService localRaftConfigService = a8;
                ReplicationGroupConfiguration replicationGroupConfiguration2 = replicationGroupConfiguration = localRaftConfigService.M(adminReplicationGroup).build();
                ReplicationGroupConfiguration replicationGroupConfiguration3 = ReplicationGroupConfiguration.newBuilder((ReplicationGroupConfiguration)replicationGroupConfiguration2).setPending(true).build();
                localRaftConfigService.M(ReplicationGroupConfiguration.class.getName(), replicationGroupConfiguration3.toByteArray());
                ((CompletableFuture)localRaftConfigService.I.getRaftGroupService(a7).addServer(a7, node).thenAccept(a3 -> {
                    LocalRaftConfigService a4;
                    a4.e(a7, a3);
                })).exceptionally(a4 -> {
                    LocalRaftConfigService a5;
                    return a5.M(replicationGroupConfiguration2, "Failed to add " + node.getNodeName(), a4);
                });
                return;
            }
            LocalRaftConfigService localRaftConfigService = a8;
            adminReplicationGroup = localRaftConfigService.J.adminReplicationGroup(a7);
            ReplicationGroupConfiguration replicationGroupConfiguration4 = replicationGroupConfiguration = localRaftConfigService.M(adminReplicationGroup).build();
            ReplicationGroupConfiguration replicationGroupConfiguration5 = ReplicationGroupConfiguration.newBuilder((ReplicationGroupConfiguration)replicationGroupConfiguration4).setPending(true).build();
            string = localRaftConfigService.M(adminReplicationGroup).addNodes(a8.M(string, a3)).build();
            localRaftConfigService.M(ReplicationGroupConfiguration.class.getName(), replicationGroupConfiguration5.toByteArray());
            ((CompletableFuture)((CompletableFuture)localRaftConfigService.I.getRaftGroupServiceForNode(a8.J.clusterNode(a3)).initReplicationGroup(a7, Collections.singletonList(node)).thenApply(a4 -> {
                LocalRaftConfigService a5;
                LocalRaftConfigService localRaftConfigService = a5;
                String string = a7;
                return localRaftConfigService.M(localRaftConfigService.I.getRaftGroupServiceForNode(node.getNodeName()), string, string, new HashMap());
            })).thenAccept(arg_0 -> a8.M((ReplicationGroupConfiguration)string, a7, arg_0))).exceptionally(a3 -> {
                LocalRaftConfigService a4;
                return a4.M(replicationGroupConfiguration4, PluginContextInfo.M((Object)"%1\u0012,\u0012c\u0017+\t/\u0005c\u00031\u0005\"\u0014*\u000e$@ \u000f-\u0014&\u00187"), a3);
            });
        });
        return UpdateLicense.newBuilder().setLicense(ByteString.copyFrom((byte[])object)).build();
    }

    private /* synthetic */ NodeInfoWithLabel M(String a2, NodeInfo a3) {
        return NodeInfoWithLabel.newBuilder().setLabel(a2).setNode(a3).setRole(Role.PRIMARY).build();
    }

    private /* synthetic */ CompletableFuture<Void> M(AdminReplicationGroup a2, String a5, String a6) {
        LocalRaftConfigService a7;
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ReplicationGroupConfiguration replicationGroupConfiguration = a7.M(a2).build();
        try {
            ReplicationGroupConfiguration replicationGroupConfiguration2 = ReplicationGroupConfiguration.newBuilder((ReplicationGroupConfiguration)replicationGroupConfiguration).setPending(true).build();
            LocalRaftConfigService localRaftConfigService = a7;
            localRaftConfigService.M(ReplicationGroupConfiguration.class.getName(), replicationGroupConfiguration2.toByteArray());
            localRaftConfigService.M(a2, a5);
            ((CompletableFuture)((CompletableFuture)localRaftConfigService.I.getRaftGroupService(a2.getName()).deleteServer(a2.getName(), a6).thenAccept(a3 -> {
                LocalRaftConfigService a4;
                a4.e(a2.getName(), a3);
            })).exceptionally(a4 -> {
                LocalRaftConfigService a5;
                return a5.M(replicationGroupConfiguration, "Failed to delete node " + a5, a4);
            })).thenAccept(a3 -> completableFuture.complete(null));
            return completableFuture;
        }
        catch (Exception exception) {
            a7.M(replicationGroupConfiguration, "Failed to delete node " + a5, (Throwable)exception);
            completableFuture.completeExceptionally(exception);
            return completableFuture;
        }
    }

    public void updateProcessorLoadBalancing(ProcessorLBStrategy a2) {
        LocalRaftConfigService a3;
        LocalRaftConfigService localRaftConfigService = a3;
        AdminContext adminContext = localRaftConfigService.E.getContext(a2.getContext());
        localRaftConfigService.M(ProcessorLBStrategy.class.getName(), a2.toByteArray());
        CompetableFutureUtils.M((CompletableFuture)localRaftConfigService.I.getRaftGroupService(adminContext.getReplicationGroup().getName()).appendEntry(adminContext.getReplicationGroup().getName(), EventProcessor.class.getName(), a2.toByteArray()));
    }

    public LocalRaftConfigService(GrpcRaftController a2, AdminContextController a3, ClusterController a4, AdminConfigurationFactory a5, RaftGroupServiceFactory a6, AdminApplicationController a7, UserController a8, MessagingPlatformConfiguration a9, AxonServerEnterpriseProperties a10, TaskPublisher a11, LicenseManager a12, FeatureChecker a13, AdminReplicationGroupController a14, PluginPackageProvider a15, ApplicationEventPublisher a16) {
        LocalRaftConfigService a17;
        LocalRaftConfigService localRaftConfigService = a17;
        LocalRaftConfigService localRaftConfigService2 = a17;
        LocalRaftConfigService localRaftConfigService3 = a17;
        LocalRaftConfigService localRaftConfigService4 = a17;
        LocalRaftConfigService localRaftConfigService5 = a17;
        LocalRaftConfigService localRaftConfigService6 = a17;
        LocalRaftConfigService localRaftConfigService7 = a17;
        LocalRaftConfigService localRaftConfigService8 = a17;
        LocalRaftConfigService localRaftConfigService9 = a17;
        a17.H = new ContextNameValidation();
        LocalRaftConfigService localRaftConfigService10 = a17;
        localRaftConfigService9.g = new CopyOnWriteArraySet();
        localRaftConfigService8.K = LoggerFactory.getLogger(LocalRaftConfigService.class);
        localRaftConfigService8.d = a2;
        localRaftConfigService7.E = a3;
        localRaftConfigService7.k = a4;
        localRaftConfigService6.J = a5;
        localRaftConfigService6.I = a6;
        localRaftConfigService5.M = a7;
        localRaftConfigService5.a = a8;
        localRaftConfigService4.b = a9;
        localRaftConfigService4.D = a10;
        localRaftConfigService3.F = a11;
        localRaftConfigService3.A = a12;
        localRaftConfigService2.L = a13;
        localRaftConfigService2.j = a14;
        localRaftConfigService.i = a15;
        localRaftConfigService.C = a16;
    }

    private /* synthetic */ void M(Set<String> a2, Role a3) {
        LocalRaftConfigService a5;
        a5.L.getNrOfNodes(a3).ifPresent(a4 -> {
            LocalRaftConfigService a5;
            LocalRaftConfigService localRaftConfigService = a5;
            int n = localRaftConfigService.j.nrOfNodesInRole(a3, a2);
            Object[] objectArray = new Object[4];
            objectArray[0] = n;
            objectArray[1] = a3;
            objectArray[2] = a2;
            objectArray[3] = a4;
            localRaftConfigService.K.debug(ClientsByEventProcessor.M((Object)"s_(LgFmQ(UaV`\u0002zMdG(Yu\u0002nM}Ll\u0002\u007fJaNm\u0002|PqKfE(Vg\u0002iFl\u0002s_$\u0002eCp\u0002iNdM\u007fGl\u0002aQ(Yu"), objectArray);
            if (n + a2.size() > a4) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = a2.size();
                objectArray2[1] = a3;
                throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, String.format(PluginContextInfo.M((Object)"\u000f\t \u0005-\u0013&@'\u000f&\u0013c\u000e,\u0014c\u0001/\f,\u0017c\u0001'\u0004*\u000e$@f\u0004c\r,\u0012&@-\u000f'\u0005k\u0013j@4\t7\bc\u0012,\f&ZcE0"), objectArray2));
            }
        });
    }

    private static /* synthetic */ void M(ReplicationGroupConfiguration.Builder a2, AdminReplicationGroupMember a3) {
        a2.addNodes(NodeInfoWithLabel.newBuilder().setLabel(a3.getClusterNodeLabel()).setNode(a3.getClusterNode().toNodeInfo()));
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation a22) {
        LocalRaftConfigService a3;
        long l2 = a3.d.currentTerm(a22.replicationGroup()).orElse(-1L);
        if (a22.term() < l2) {
            return;
        }
        try {
            a3.M(a22.replicationGroup());
            return;
        }
        catch (IllegalStateException a22) {
            return;
        }
    }

    private /* synthetic */ void M() {
        LocalRaftConfigService a3;
        a3.L.getMaxReplicationGroups().ifPresent(a2 -> {
            LocalRaftConfigService a3;
            if (a3.j.count() > a2) {
                throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, PluginContextInfo.M((Object)"-\"\u0018*\r6\rc\u000e6\r!\u00051@,\u0006c\u0012&\u0010/\t \u00017\t,\u000ec\u00071\u000f6\u00100@1\u0005\"\u0003+\u0005'"));
            }
        });
        a3.d();
    }

    private /* synthetic */ void M(User a2, AdminContext a3) {
        LocalRaftConfigService a4;
        a4.I.getRaftGroupService(a3.getReplicationGroup().getName()).appendEntry(a3.getReplicationGroup().getName(), (GeneratedMessageV3)ContextUser.newBuilder().setContext(a3.getName()).setUser(User.newBuilder().setName(a2.getName())).build());
    }

    public void getPlugin(Plugin a22, StreamObserver<FileChunk> a3) {
        try {
            LocalRaftConfigService a4;
            a4.i.getPlugin(a22, arg_0 -> a3.onNext(arg_0));
            a3.onCompleted();
            return;
        }
        catch (Exception a22) {
            a3.onError((Throwable)a22);
            return;
        }
    }

    private /* synthetic */ void f(Application a2, AdminContext a3) {
        LocalRaftConfigService a4;
        a4.I.getRaftGroupService(a3.getReplicationGroup().getName()).appendEntry(a3.getReplicationGroup().getName(), (GeneratedMessageV3)ContextApplication.newBuilder().setContext(a3.getName()).setName(a2.getName()).build());
    }

    private /* synthetic */ void M(String a2, byte[] a3) {
        LocalRaftConfigService a4;
        CompetableFutureUtils.M((CompletableFuture)a4.M(a2, a3), (int)5, (TimeUnit)TimeUnit.SECONDS);
    }

    private /* synthetic */ void M(ReplicationGroupConfiguration.Builder a2, ReplicationGroupMember a3) {
        LocalRaftConfigService a4;
        ClusterNode clusterNode = a4.k.getNode(a3.getNodeName());
        if (clusterNode == null) {
            LocalRaftConfigService localRaftConfigService = a4;
            localRaftConfigService.K.warn(ClientsByEventProcessor.M((Object)"agWdF(LgV(DaLl\u0002s_(Kf\u0002iFeKf"), (Object)a3.getNodeName());
            clusterNode = localRaftConfigService.J.clusterNode(a3.getNodeName(), "", a3.getHost(), -1, a3.getPort(), -1);
        }
        a2.addNodes(NodeInfoWithLabel.newBuilder().setNode(clusterNode.toNodeInfo()).setLabel(a3.getNodeId()).setRole(a3.getRole()));
    }

    private /* synthetic */ void M(User a4) {
        LocalRaftConfigService a5;
        Set set = a5.E.getContexts().map(AdminContext::getName).collect(Collectors.toSet());
        if (!(a4 = a4.getRolesList().stream().map(UserContextRole::getContext).filter(a2 -> {
            if (!a2.equals("*")) {
                return true;
            }
            return false;
        }).filter(a3 -> {
            if (!set.contains(a3)) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet())).isEmpty()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.CONTEXT_NOT_FOUND, String.format(PluginContextInfo.M((Object)"\u0000\u000f-\u0014&\u00187@6\u000e(\u000e,\u0017-ZcE0"), objectArray));
        }
    }

    private /* synthetic */ CompletableFuture<Void> M(String a3, String a4) {
        LocalRaftConfigService a6;
        Set<AdminUser> set = a6.a.getUsers().stream().map(AdminUser::newContextPermissions).filter(a2 -> {
            if (!a2.getRoles().isEmpty()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList arrayList = new ArrayList();
        set.forEach(a5 -> {
            LocalRaftConfigService a6;
            a4 = UserProtoConverter.createContextUser((String)a4, (AdminUser)a5);
            arrayList.add(a6.I.getRaftGroupService(a3).appendEntry(a3, (GeneratedMessageV3)a4));
        });
        return CompletableFuture.allOf(arrayList.toArray(new CompletableFuture[0]));
    }

    private /* synthetic */ Set<UserContextRole> M(List<UserContextRole> a2, String a4) {
        return a2.stream().filter(a3 -> {
            if (a3.getContext().equals(a4) || a3.getContext().equals("*")) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    private /* synthetic */ byte[] M() {
        LocalRaftConfigService a2;
        return a2.A.readLicense();
    }

    private /* synthetic */ void e(Application a2, AdminContext a3) {
        LocalRaftConfigService a4;
        LocalRaftConfigService localRaftConfigService = a4;
        Collection collection = localRaftConfigService.M(a2, a3.getName());
        a2 = ContextApplication.newBuilder().setContext(a3.getName()).setName(a2.getName()).setHashedToken(a2.getToken()).setTokenPrefix(a2.getTokenPrefix()).putAllMetaData(a2.getMetaDataMap()).addAllRoles((Iterable)collection).build();
        CompetableFutureUtils.M((CompletableFuture)localRaftConfigService.I.getRaftGroupService(a3.getReplicationGroup().getName()).appendEntry(a3.getReplicationGroup().getName(), (GeneratedMessageV3)a2));
    }

    public CompletableFuture<Void> addNodeToReplicationGroup(String a2, String a4, Role a5) {
        LocalRaftConfigService a6;
        LocalRaftConfigService localRaftConfigService = a6;
        localRaftConfigService.K.info(ClientsByEventProcessor.M((Object)"IFl\u0002fMlG(PmS}G{V(KfTgImF(DgP(LgFm\u0018(Yu\u0002%\u0002iLl\u0002kMfVmZ|\u0018(Yu"), (Object)a4, (Object)a2);
        if (!localRaftConfigService.g.add(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_UPDATE_IN_PROGRESS, a2 + ": pending update");
        }
        try {
            a6.M(Collections.singleton(a4), a5);
        }
        catch (RuntimeException runtimeException) {
            a6.g.remove(a2);
            throw runtimeException;
        }
        AdminReplicationGroup adminReplicationGroup = (AdminReplicationGroup)a6.j.findByName(a2).orElseThrow(() -> {
            LocalRaftConfigService a3;
            a3.g.remove(a2);
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(ClientsByEventProcessor.M((Object)"pmRdKkC|KgL(EzM}R(\u0007{\u0002fM|\u0002nM}Ll"), objectArray));
        });
        if (adminReplicationGroup.isChangePending() && adminReplicationGroup.getPendingSince().getTime() > System.currentTimeMillis() - B) {
            a6.g.remove(a2);
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_UPDATE_IN_PROGRESS, a2 + ": pending update");
        }
        ClusterNode clusterNode = a6.k.getNode(a4);
        if (clusterNode == null) {
            a6.g.remove(a2);
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(PluginContextInfo.M((Object)"\r\u000f'\u0005cE0@-\u000f7@%\u000f6\u000e'"), objectArray));
        }
        if (clusterNode.getReplicatorGroupNames().contains(a2)) {
            LocalRaftConfigService localRaftConfigService2 = a6;
            localRaftConfigService2.K.info(ClientsByEventProcessor.M((Object)"Yu\u0002iNzGiFq\u0002kMfViKfQ(LgFm\u0018(Yu"), (Object)a2, (Object)a4);
            localRaftConfigService2.g.remove(a2);
            return null;
        }
        adminReplicationGroup = a6.M(adminReplicationGroup).build();
        try {
            LocalRaftConfigService localRaftConfigService3 = a6;
            String string = localRaftConfigService3.M(a4);
            a5 = localRaftConfigService3.M(clusterNode, string, a5);
            clusterNode = ReplicationGroupConfiguration.newBuilder((ReplicationGroupConfiguration)adminReplicationGroup).setPending(true).build();
            localRaftConfigService3.M(ReplicationGroupConfiguration.class.getName(), clusterNode.toByteArray());
            a5 = ((CompletableFuture)localRaftConfigService3.I.getRaftGroupService(a2).addServer(a2, (Node)a5).thenAccept(a3 -> {
                LocalRaftConfigService a4;
                a4.e(a2, a3);
            })).exceptionally(arg_0 -> a6.M(a2, (Node)a5, (ReplicationGroupConfiguration)adminReplicationGroup, a4, arg_0));
            return a5;
        }
        catch (RuntimeException runtimeException) {
            a6.M((ReplicationGroupConfiguration)adminReplicationGroup, "Failed to add node: " + a4, (Throwable)runtimeException);
            throw runtimeException;
        }
        finally {
            a6.g.remove(a2);
        }
    }

    private /* synthetic */ void M(PluginConfigurationForContext a2, Void a3) {
        LocalRaftConfigService a4;
        a4.M("ADMIN_CONTEXT_PLUGIN_CONFIGURATION", a2.toByteArray());
    }

    private /* synthetic */ String M(String a2) {
        return a2 + "-" + UUID.randomUUID();
    }

    @Transactional
    public void deleteUser(User a2) {
        LocalRaftConfigService a4;
        Object object = a4.a.findUser(a2.getName());
        if (object == null) {
            return;
        }
        object = object.getRoles().stream().map(AdminUserRole::getContext).collect(Collectors.toSet());
        a4.M("DELETE_USER", a2.toByteArray());
        if (object.contains("*")) {
            a4.E.getContexts().forEach(a3 -> {
                LocalRaftConfigService a4;
                a4.M(a2, a3);
            });
            return;
        }
        object.forEach(a3 -> {
            LocalRaftConfigService a4;
            LocalRaftConfigService localRaftConfigService = a4;
            a3 = localRaftConfigService.E.getContext(a3);
            localRaftConfigService.M(a2, (AdminContext)a3);
        });
    }

    @Transactional
    public void deleteApplication(Application a2) {
        Set set;
        LocalRaftConfigService a4;
        block3: {
            try {
                AdminApplication adminApplication = a4.M.get(a2.getName());
                set = adminApplication.getContexts().stream().map(AdminApplicationContext::getContext).collect(Collectors.toSet());
                a4.M("DELETE_APPLICATION", a2.toByteArray());
                if (!set.contains("*")) break block3;
                a4.E.getContexts().forEach(a3 -> {
                    LocalRaftConfigService a4;
                    a4.f(a2, a3);
                });
                return;
            }
            catch (ApplicationNotFoundException applicationNotFoundException) {
                return;
            }
        }
        a4.E.getContexts(set).forEach(a3 -> {
            LocalRaftConfigService a4;
            a4.f(a2, a3);
        });
    }

    private /* synthetic */ Application M(Application a2, String a4) {
        Application application;
        LocalRaftConfigService a5;
        Set set = a2.getRolesPerContextList().stream().map(ApplicationContextRole::getContext).collect(Collectors.toSet());
        boolean bl = set.contains("*");
        a5.M(Application.class.getName(), a2.toByteArray());
        if (bl) {
            a5.E.getContexts().forEach(a3 -> {
                LocalRaftConfigService a4;
                a4.e(a2, a3);
            });
            application = a2;
        } else {
            a5.E.getContexts(set).forEach(a3 -> {
                LocalRaftConfigService a4;
                a4.e(a2, a3);
            });
            application = a2;
        }
        return Application.newBuilder((Application)application).setToken(a4).build();
    }

    private /* synthetic */ CompletableFuture<Void> M(String a2, byte[] a3) {
        LocalRaftConfigService a4;
        return a4.I.getRaftGroupService(RaftAdminGroup.M()).appendEntry(RaftAdminGroup.M(), a2, a3);
    }
}

