/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.replication.admin.LocalRaftConfigService;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigService;
import io.axoniq.axonserver.enterprise.replication.admin.RemoteRaftConfigService;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelProvider;
import io.axoniq.axonserver.grpc.internal.RaftConfigServiceGrpc;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.grpc.Channel;
import org.springframework.stereotype.Component;

@Component
public class RaftConfigServiceFactory {
    private final ReplicationLeaderProvider C;
    private final ChannelProvider D;
    private final MessagingPlatformConfiguration l;
    private final ClusterController I;
    private final RaftConfigService L;

    public RaftConfigServiceFactory(MessagingPlatformConfiguration a2, ClusterController a3, LocalRaftConfigService a4, ReplicationLeaderProvider a5, ChannelProvider a6) {
        RaftConfigServiceFactory a7;
        RaftConfigServiceFactory raftConfigServiceFactory = a7;
        RaftConfigServiceFactory raftConfigServiceFactory2 = a7;
        a7.l = a2;
        raftConfigServiceFactory2.I = a3;
        raftConfigServiceFactory2.L = a4;
        raftConfigServiceFactory.C = a5;
        raftConfigServiceFactory.D = a6;
    }

    public RaftConfigServiceGrpc.RaftConfigServiceBlockingStub getRaftConfigServiceStub(String a2, int a3) {
        RaftConfigServiceFactory a4;
        return RaftConfigServiceGrpc.newBlockingStub((Channel)a4.D.get(a2, a3));
    }

    public RaftConfigService getLocalRaftConfigService() {
        RaftConfigServiceFactory a2;
        return a2.L;
    }

    public RaftConfigService getRaftConfigService() {
        RaftConfigServiceFactory a2;
        if (a2.C.isLeader(RaftAdminGroup.M())) {
            return a2.L;
        }
        String string = a2.C.getLeader(RaftAdminGroup.M());
        if (string == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "No leader for " + RaftAdminGroup.M());
        }
        ClusterNode clusterNode = a2.I.getNode(string);
        if (clusterNode == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "Leader node " + string + " not found for " + RaftAdminGroup.M());
        }
        return new RemoteRaftConfigService(RaftConfigServiceGrpc.newStub((Channel)a2.D.get(clusterNode)));
    }
}

