/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.group;

import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.util.AxonThreadFactory;
import io.axoniq.axonserver.config.ExternalLogin;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupService;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ReplicationGroupMemberConverter;
import io.axoniq.axonserver.grpc.cluster.ConfigChangeResult;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.NodeInfoWithLabel;
import io.axoniq.axonserver.grpc.internal.ReplicationGroup;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupMember;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupUpdateConfirmation;
import io.axoniq.axonserver.grpc.internal.State;
import io.axoniq.axonserver.localstorage.file.multitier.LowerTierEventStoreFactory;
import io.axoniq.axonserver.util.CompetableFutureUtils;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LocalRaftGroupService
implements RaftGroupService {
    private final GrpcRaftController l;
    private final Logger I;
    private final ExecutorService L;

    @Transactional
    public CompletableFuture<Void> deleteReplicationGroup(String a2, boolean a3) {
        LocalRaftGroupService a5;
        RaftNode raftNode = null;
        try {
            raftNode = a5.l.getRaftNode(a2);
        }
        catch (MessagingPlatformException messagingPlatformException) {
            return CompletableFuture.completedFuture(null);
        }
        return raftNode.M().thenAccept(a4 -> {
            LocalRaftGroupService a5;
            a5.l.delete(a2, a3);
        });
    }

    public CompletableFuture<Void> getStatus(Consumer<ReplicationGroup> a2) {
        LocalRaftGroupService a4;
        a4.l.raftGroups().forEach(a3 -> {
            LocalRaftGroupService a4;
            a2.accept(a4.getStatus(a3));
        });
        return CompletableFuture.completedFuture(null);
    }

    public LocalRaftGroupService(GrpcRaftController a2) {
        LocalRaftGroupService a3;
        LocalRaftGroupService localRaftGroupService = a3;
        localRaftGroupService.I = LoggerFactory.getLogger(LocalRaftGroupService.class);
        LocalRaftGroupService localRaftGroupService2 = a3;
        localRaftGroupService.L = Executors.newCachedThreadPool((ThreadFactory)new AxonThreadFactory(LowerTierEventStoreFactory.M((Object)";\"/7d\"::' d")));
        localRaftGroupService.l = a2;
    }

    public CompletableFuture<Void> appendEntry(String a2, String a3, byte[] a4) {
        LocalRaftGroupService a5;
        if ((a2 = a5.l.getRaftNode(a2)) == null) {
            CompletableFuture<Void> completableFuture;
            CompletableFuture<Void> completableFuture2 = completableFuture = new CompletableFuture<Void>();
            completableFuture2.completeExceptionally(new MessagingPlatformException(ErrorCode.OTHER, ExternalLogin.M((Object)")%\u0004*\u00050J\"\u0003*\u000ed\u0004+\u000e!J\"\u00056J'\u0005*\u001e!\u00120")));
            return completableFuture2;
        }
        return a2.M(a3, a4);
    }

    public ReplicationGroup getStatus(String a2) {
        LocalRaftGroupService a4;
        a2 = a4.l.getRaftGroup(a2).localNode();
        String string = a2.M();
        return ReplicationGroup.newBuilder().setName(a2.f()).addAllMembers((Iterable)a2.M().stream().map(a3 -> ReplicationGroupMember.newBuilder().setNodeId(a3.getNodeId()).setNodeName(a3.getNodeName()).setState(a3.getNodeId().equals(string) ? State.LEADER : State.VOTING).build()).collect(Collectors.toList())).build();
    }

    public CompletableFuture<Void> transferLeadership(String a22) {
        try {
            LocalRaftGroupService a3;
            a22 = a3.l.getRaftNode(a22);
            return a22.d();
        }
        catch (MessagingPlatformException a22) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public CompletableFuture<ReplicationGroupUpdateConfirmation> addServer(String a2, Node a3) {
        LocalRaftGroupService a4;
        CompletableFuture<ReplicationGroupUpdateConfirmation> completableFuture = new CompletableFuture<ReplicationGroupUpdateConfirmation>();
        RaftNode raftNode = a4.l.getRaftNode(a2);
        if (raftNode.M().stream().map(Node::getNodeName).collect(Collectors.toSet()).contains(a3.getNodeName())) {
            completableFuture.complete(ReplicationGroupUpdateConfirmation.newBuilder().setSuccess(true).addAllMembers((Iterable)raftNode.M().stream().map(ReplicationGroupMemberConverter::asContextMember).collect(Collectors.toList())).build());
            return completableFuture;
        }
        a4.L.submit(() -> {
            LocalRaftGroupService a6;
            a6.M(a2, a3, completableFuture, raftNode);
        });
        return completableFuture;
    }

    public void stepDown(String a2) {
        LocalRaftGroupService a3;
        if ((a2 = a3.l.getRaftNode(a2)) != null) {
            a2.d();
        }
    }

    private /* synthetic */ void M(String a2, Node a3, CompletableFuture<ReplicationGroupUpdateConfirmation> a4, RaftNode a5) {
        LocalRaftGroupService a8;
        a5.M(a3).whenComplete((a6, a7) -> {
            LocalRaftGroupService a8;
            if (a7 != null) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a2;
                objectArray[1] = a3.getNodeName();
                objectArray[2] = a7;
                a8.I.warn(ExternalLogin.M((Object)"\u00119Pd/<\t!\u001a0\u0003+\u0004d\u001d,\u0003(\u000fd\u000b \u000e-\u0004#J*\u0005 \u000fd\u00119"), objectArray);
            }
            a2 = a8.M(a5, a6, a7);
            a4.complete((ReplicationGroupUpdateConfirmation)a2);
        });
    }

    public CompletableFuture<ReplicationGroupConfiguration> configuration(String a2) {
        LocalRaftGroupService a3;
        CompletableFuture<ReplicationGroupConfiguration> completableFuture = new CompletableFuture<ReplicationGroupConfiguration>();
        ReplicationGroupConfiguration replicationGroupConfiguration = a3.M(a2);
        if (replicationGroupConfiguration == null) {
            completableFuture.completeExceptionally(new RuntimeException("Context not found: " + a2));
            return completableFuture;
        }
        CompletableFuture<ReplicationGroupConfiguration> completableFuture2 = completableFuture;
        completableFuture2.complete(replicationGroupConfiguration);
        return completableFuture2;
    }

    @NotNull
    private /* synthetic */ ReplicationGroupUpdateConfirmation M(RaftNode a2, ConfigChangeResult a4, Throwable a5) {
        LocalRaftGroupService a6;
        ReplicationGroupUpdateConfirmation.Builder builder;
        ReplicationGroupUpdateConfirmation.Builder builder2 = ReplicationGroupUpdateConfirmation.newBuilder();
        a2.M().forEach(a3 -> builder2.addMembers(ReplicationGroupMemberConverter.asContextMember((Node)a3)));
        builder2.setPending(a2.M());
        if (a5 != null) {
            ReplicationGroupUpdateConfirmation.Builder builder3 = builder2;
            builder2.setSuccess(false);
            builder = builder3;
            builder3.setMessage(((Throwable)a5).getMessage());
        } else if (a4.hasNotLeader()) {
            a5 = a2.f() + ": not in leader state while receiving config change request.";
            a6.I.error((String)a5);
            ReplicationGroupUpdateConfirmation.Builder builder4 = builder2;
            builder2.setSuccess(false);
            builder = builder4;
            builder4.setMessage((String)a5);
        } else if (a4.hasFailure()) {
            a6.I.error(LowerTierEventStoreFactory.M((Object)"84yi\u00061 ,3=*&-i4!*%&i !\"'$ -.c*,'% $<1(7 ,'yi84"), (Object)a2.f(), (Object)a4.getFailure());
            ReplicationGroupUpdateConfirmation.Builder builder5 = builder2;
            builder2.setSuccess(false);
            builder = builder5;
            builder5.setMessage(a4.getFailure().getError().getMessage());
        } else {
            ReplicationGroupUpdateConfirmation.Builder builder6 = builder2;
            builder = builder6;
            builder6.setSuccess(true);
            builder2.setPending(false);
        }
        return builder.build();
    }

    @Nullable
    private /* synthetic */ ReplicationGroupConfiguration M(String a2) {
        LocalRaftGroupService a3;
        Object object = a3.l.getRaftGroup(a2);
        if (object == null) {
            return null;
        }
        object = object.localNode();
        a2 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2).setPending(object.M());
        object = object.M().iterator();
        Iterator iterator = object;
        while (iterator.hasNext()) {
            Node node = (Node)object.next();
            iterator = object;
            a2.addNodes(NodeInfoWithLabel.newBuilder().setLabel(node.getNodeId()).setRole(node.getRole()).setNode(NodeInfo.newBuilder().setNodeName(node.getNodeName()).setInternalHostName(node.getHost()).setGrpcInternalPort(node.getPort()).build()).build());
        }
        return a2.build();
    }

    public CompletableFuture<Void> prepareDeleteNodeFromReplicationGroup(String a2, String a3) {
        LocalRaftGroupService a4;
        a4.l.prepareDeleteNodeFromReplicationGroup(a2, a3);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<ReplicationGroupConfiguration> initReplicationGroup(String a2, List<Node> a4) {
        LocalRaftGroupService a5;
        try {
            LocalRaftGroupService localRaftGroupService = a5;
            RaftGroup raftGroup = localRaftGroupService.l.initRaftGroup(a2, a5.l.getMyLabel(a4), a5.l.getMyName());
            RaftNode raftNode = localRaftGroupService.l.waitForLeader(raftGroup);
            a4.forEach(a3 -> CompetableFutureUtils.M((CompletableFuture)raftNode.M(a3)));
            return CompletableFuture.completedFuture(a5.M(a2));
        }
        catch (Exception exception) {
            a5.I.error(LowerTierEventStoreFactory.M((Object)"2>sc*1,\"=&i1,3%**\"=*&-i$;,<3i%(*%&-"), (Object)a2, (Object)exception);
            CompletableFuture<ReplicationGroupConfiguration> completableFuture = new CompletableFuture<ReplicationGroupConfiguration>();
            completableFuture.completeExceptionally(exception);
            return completableFuture;
        }
    }

    @PreDestroy
    public void stop() {
        LocalRaftGroupService a2;
        a2.L.shutdown();
    }

    public CompletableFuture<ReplicationGroupUpdateConfirmation> deleteServer(String a2, String a3) {
        LocalRaftGroupService a4;
        CompletableFuture<ReplicationGroupUpdateConfirmation> completableFuture = new CompletableFuture<ReplicationGroupUpdateConfirmation>();
        RaftNode raftNode = a4.l.getRaftNode(a2);
        try {
            raftNode.M(a3).whenComplete((a6, a7) -> {
                LocalRaftGroupService a8;
                if (a7 != null) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a2;
                    objectArray[1] = a3;
                    objectArray[2] = a7;
                    a8.I.error(LowerTierEventStoreFactory.M((Object)"84yi\u00061 ,3=*&-i4!*%&i',/,7 -.c',-&i84"), objectArray);
                }
                try {
                    raftNode = a8.M(raftNode, a6, a7);
                    completableFuture.complete((ReplicationGroupUpdateConfirmation)raftNode);
                    return;
                }
                catch (Exception a42) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a2;
                    objectArray[1] = a3;
                    objectArray[2] = a42;
                    a8.I.error(ExternalLogin.M((Object)"\u00119Pd/<\t!\u001a0\u0003+\u0004d\u001d,\u0003(\u000fd\u000e!\u0006!\u001e-\u0004#J*\u0005 \u000fd\u00119"), objectArray);
                    completableFuture.completeExceptionally(a42);
                    return;
                }
            });
            return completableFuture;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2;
            objectArray[1] = a3;
            objectArray[2] = exception;
            a4.I.error(ExternalLogin.M((Object)"\u00119Pd/<\t!\u001a0\u0003+\u0004d\u001d,\u0003(\u000fd\u000e!\u0006!\u001e-\u0004#J*\u0005 \u000fd\u00119"), objectArray);
            CompletableFuture<ReplicationGroupUpdateConfirmation> completableFuture2 = completableFuture;
            completableFuture2.completeExceptionally(exception);
            return completableFuture2;
        }
    }
}

