/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.group;

import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.replication.group.LocalRaftGroupService;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupService;
import io.axoniq.axonserver.enterprise.replication.group.RemoteRaftGroupService;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ChannelProvider;
import io.axoniq.axonserver.grpc.internal.RaftGroupServiceGrpc;
import io.axoniq.axonserver.replication.ReplicationLeaderProvider;
import io.grpc.Channel;
import org.springframework.stereotype.Component;

@Component
public class RaftGroupServiceFactory {
    private final MessagingPlatformConfiguration C;
    private final ChannelProvider D;
    private final ReplicationLeaderProvider l;
    private final RaftGroupService I;
    private final ClusterController L;

    public RaftGroupService getRaftGroupService(String a2) {
        RaftGroupServiceFactory a3;
        if (a3.l.isLeader(a2)) {
            return a3.I;
        }
        String string = a3.l.getLeader(a2);
        if (string == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "No leader for " + a2);
        }
        a2 = a3.L.getNode(string);
        return new RemoteRaftGroupService(RaftGroupServiceGrpc.newStub((Channel)a3.D.get((ClusterNode)a2)));
    }

    public RaftGroupService getRaftGroupServiceForNode(ClusterNode a2) {
        RaftGroupServiceFactory a3;
        if (a3.C.getName().equals(a2.getName())) {
            return a3.I;
        }
        return new RemoteRaftGroupService(RaftGroupServiceGrpc.newStub((Channel)a3.D.get(a2)));
    }

    public RaftGroupServiceFactory(MessagingPlatformConfiguration a2, ClusterController a3, LocalRaftGroupService a4, ReplicationLeaderProvider a5, ChannelProvider a6) {
        RaftGroupServiceFactory a7;
        RaftGroupServiceFactory raftGroupServiceFactory = a7;
        RaftGroupServiceFactory raftGroupServiceFactory2 = a7;
        a7.C = a2;
        raftGroupServiceFactory2.L = a3;
        raftGroupServiceFactory2.I = a4;
        raftGroupServiceFactory.l = a5;
        raftGroupServiceFactory.D = a6;
    }

    public String getLeader(String a2) {
        RaftGroupServiceFactory a3;
        return a3.l.getLeader(a2);
    }

    public RaftGroupService getRaftGroupServiceForNode(String a2) {
        RaftGroupServiceFactory a3;
        if (a3.C.getName().equals(a2)) {
            return a3.I;
        }
        ClusterNode clusterNode = a3.L.getNode(a2);
        if (clusterNode == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, a2 + " not found");
        }
        return new RemoteRaftGroupService(RaftGroupServiceGrpc.newStub((Channel)a3.D.get(clusterNode)));
    }
}

