/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.snapshot;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.cluster.exception.FatalApplyException;
import io.axoniq.axonserver.cluster.snapshot.SnapshotContext;
import io.axoniq.axonserver.cluster.snapshot.SnapshotDataStore;
import io.axoniq.axonserver.cluster.snapshot.SnapshotDeserializationException;
import io.axoniq.axonserver.cluster.util.RoleUtils;
import io.axoniq.axonserver.enterprise.replication.TransactionWithTokenUtils;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.EventStoreValidationException;
import io.axoniq.axonserver.grpc.SerializedTransactionWithTokenConverter;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.grpc.cluster.SerializedObject;
import io.axoniq.axonserver.grpc.internal.TransactionWithToken;
import io.axoniq.axonserver.localstorage.LocalEventStore;
import io.axoniq.axonserver.localstorage.SerializedTransactionWithToken;
import io.axoniq.axonserver.localstorage.file.EventSourceNotFoundException;
import io.axoniq.axonserver.localstorage.file.multitier.LowerTierEventStoreLocator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.util.CloseableIterator;
import reactor.core.publisher.Flux;

public class EventTransactionsSnapshotDataStore
implements SnapshotDataStore {
    private final String k;
    private final LocalEventStore B;
    private final ReplicationGroupController C;
    private static final Logger D = LoggerFactory.getLogger(EventTransactionsSnapshotDataStore.class);
    private final LowerTierEventStoreLocator l;
    private final boolean I;
    private static final String L = "eventsTransaction";

    public EventTransactionsSnapshotDataStore(String a2, LocalEventStore a3, LowerTierEventStoreLocator a4, ReplicationGroupController a5) {
        EventTransactionsSnapshotDataStore a6;
        EventTransactionsSnapshotDataStore eventTransactionsSnapshotDataStore = a6;
        EventTransactionsSnapshotDataStore eventTransactionsSnapshotDataStore2 = a6;
        a6.k = a2;
        eventTransactionsSnapshotDataStore2.B = a3;
        eventTransactionsSnapshotDataStore2.I = RaftAdminGroup.M((String)a2);
        eventTransactionsSnapshotDataStore.l = a4;
        eventTransactionsSnapshotDataStore.C = a5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applySnapshotData(SerializedObject a22, Role a3) {
        try {
            SerializedObject serializedObject;
            String string;
            EventTransactionsSnapshotDataStore a4;
            a22 = TransactionWithToken.parseFrom((ByteString)a22.getData());
            LocalEventStore localEventStore = a4.B;
            if (a22.getContext().isEmpty()) {
                string = a4.k;
                serializedObject = a22;
            } else {
                string = a22.getContext();
                serializedObject = a22;
            }
            localEventStore.syncEvents(string, serializedObject.getToken(), 0, TransactionWithTokenUtils.M((TransactionWithToken)a22));
            return;
        }
        catch (InvalidProtocolBufferException a22) {
            throw new SnapshotDeserializationException(EventSourceNotFoundException.M((Object)"=(\t$\u0004#H2\u0007f\f#\u001b#\u001a/\t*\u0001<\rf\r0\r(\u001c5H2\u001a'\u00065\t%\u001c/\u0007(F"), (Throwable)a22);
        }
        catch (EventStoreValidationException a22) {
            throw new FatalApplyException(a22.getMessage(), (Throwable)a22);
        }
    }

    private static /* synthetic */ Iterator M(CloseableIterator a2) {
        return a2;
    }

    private /* synthetic */ Flux<SerializedObject> M(String a4, SnapshotContext a5, Flux<SerializedObject> a6) {
        EventTransactionsSnapshotDataStore a7;
        long l2 = a5.fromEventSequence(a4);
        long l3 = a7.B.getLastEvent(a4) + 1L;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4;
        objectArray[1] = l2;
        objectArray[2] = l3;
        objectArray[3] = a7.B.firstToken(a4);
        D.debug(EventSourceNotFoundException.M((Object)"\u0013;Rf\u001a#\u0018*\u0001%\t2\rf\u000e4\u0007+H=\u0015f\u001c)H=\u0015f\u000e/\u001a5\u001cf\u001c)\u0003#\u0006f\t2H*\r'\f#\u001af\u00015H=\u0015"), objectArray);
        if (l2 < a7.B.firstToken(a4)) {
            EventTransactionsSnapshotDataStore eventTransactionsSnapshotDataStore = a7;
            a5 = eventTransactionsSnapshotDataStore.l.getEventStore(a4);
            long l4 = a5.getLastToken(a4);
            D.debug(EventSourceNotFoundException.M((Object)"\u0013;Rf\u0004'\u001b2H2\u0007-\r(H'\u001cf\u001b#\u000b)\u0006\"\t4\u0011f\u0006)\f#H=\u0015"), (Object)a4, (Object)l4);
            CloseableIterator closeableIterator = eventTransactionsSnapshotDataStore.B.eventTransactionsIterator(a4, l4 + 1L, l3);
            return a6.concatWith((Publisher)a5.eventTransactions(a4, l2, l4 + 1L).map(a2 -> SerializedObject.newBuilder().setType(L).setData(a2.toByteString()).build())).concatWith((Publisher)Flux.fromIterable(() -> closeableIterator).doOnTerminate(() -> ((CloseableIterator)closeableIterator).close()).map(a3 -> {
                EventTransactionsSnapshotDataStore a4;
                return a4.M(a3, a4);
            }));
        }
        if (l3 > l2) {
            a5 = a7.B.eventTransactionsIterator(a4, l2, l3);
            return a6.concatWith((Publisher)Flux.fromIterable(() -> EventTransactionsSnapshotDataStore.M((CloseableIterator)a5)).doOnTerminate(() -> ((CloseableIterator)a5).close()).map(a3 -> {
                EventTransactionsSnapshotDataStore a4;
                return a4.M(a3, a4);
            }));
        }
        return a6;
    }

    public Flux<SerializedObject> streamSnapshotData(SnapshotContext a2) {
        EventTransactionsSnapshotDataStore a3;
        if (a3.I || a2.supportsReplicationGroups() || !RoleUtils.d((Role)a2.role())) {
            return Flux.empty();
        }
        EventTransactionsSnapshotDataStore eventTransactionsSnapshotDataStore = a3;
        return eventTransactionsSnapshotDataStore.M(eventTransactionsSnapshotDataStore.k, a2, Flux.empty());
    }

    @NotNull
    private /* synthetic */ SerializedObject M(SerializedTransactionWithToken a2, String a3) {
        return SerializedObject.newBuilder().setType(L).setData(SerializedTransactionWithTokenConverter.asByteString((SerializedTransactionWithToken)a2, (String)a3)).build();
    }

    public boolean canApplySnapshotData(String a2) {
        EventTransactionsSnapshotDataStore a3;
        if (!a3.I && L.equals(a2)) {
            return true;
        }
        return false;
    }

    public Flux<SerializedObject> streamEventStoreData(SnapshotContext a2) {
        Iterator iterator;
        EventTransactionsSnapshotDataStore a3;
        if (a3.I || !a2.supportsReplicationGroups() || !RoleUtils.d((Role)a2.role())) {
            return Flux.empty();
        }
        Flux flux = Flux.empty();
        EventTransactionsSnapshotDataStore eventTransactionsSnapshotDataStore = a3;
        Iterator iterator2 = iterator = eventTransactionsSnapshotDataStore.C.getContextNames(eventTransactionsSnapshotDataStore.k).iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator.next();
            flux = a3.M(string, a2, flux);
            iterator2 = iterator;
        }
        return flux;
    }

    public int order() {
        return 100;
    }

    public void clear() {
    }
}

