/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.SubscriptionEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.serializer.Media;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class DefaultClientIdRegistry
implements ClientIdRegistry {
    private final Logger I = LoggerFactory.getLogger(DefaultClientIdRegistry.class);
    private final Map<ClientIdRegistry.ConnectionType, Map<String, ClientContext>> L;

    @EventListener
    public void on(SubscriptionEvents.SubscribeCommand a2) {
        DefaultClientIdRegistry a3;
        SubscriptionEvents.SubscribeCommand subscribeCommand = a2;
        String string = subscribeCommand.M().e();
        String string2 = subscribeCommand.M().M();
        if (!a3.L.getOrDefault(ClientIdRegistry.ConnectionType.l, Collections.emptyMap()).containsKey(string2)) {
            a3.I.info(ErrorMessageFactory.M((Object)"j\u0001D\u0003H\u0000MNZ\u001a[\u000bH\u0003\t\rF\u0000G\u000bJ\u001aL\n\u0013NR\u0013\t5Z\u001a[\u000bH\u0003\t\u0007MN\u0004P\t\u0015T3"), (Object)string, (Object)string2);
        }
        a3.register(string2, new ClientContext(string, a2.M()), ClientIdRegistry.ConnectionType.l);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        DefaultClientIdRegistry a3;
        DefaultClientIdRegistry defaultClientIdRegistry = a3;
        defaultClientIdRegistry.I.info(HeartbeatMonitor.M((Object)"XPiHnSzQ(O|Nm]e\u001clU{_gRfYkHmX2\u001csA(g{HzYiQ(Ul\u001c%\u0002(Gua"), (Object)a2.f(), (Object)a2.k());
        defaultClientIdRegistry.unregister(a2.k(), ClientIdRegistry.ConnectionType.D);
    }

    @EventListener
    public void on(TopologyEvents.CommandHandlerDisconnected a2) {
        DefaultClientIdRegistry a3;
        DefaultClientIdRegistry defaultClientIdRegistry = a3;
        defaultClientIdRegistry.I.info(ErrorMessageFactory.M((Object)"-F\u0003D\u000fG\n\t\u001d]\u001cL\u000fDNM\u0007Z\rF\u0000G\u000bJ\u001aL\n\u0013NR\u0013\t5Z\u001a[\u000bH\u0003\t\u0007MN\u0004P\t\u0015T3"), (Object)a2.M(), (Object)a2.d());
        defaultClientIdRegistry.unregister(a2.d(), ClientIdRegistry.ConnectionType.l);
    }

    public Set<String> streamIdsFor(ClientContext a2, ClientIdRegistry.ConnectionType a4) {
        DefaultClientIdRegistry a5;
        return Collections.unmodifiableSet(a5.L.getOrDefault(a4, Collections.emptyMap()).entrySet().stream().filter(a3 -> ((ClientContext)a3.getValue()).equals((Object)a2)).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }

    public boolean unregister(String a2, ClientIdRegistry.ConnectionType a3) {
        DefaultClientIdRegistry a4;
        if ((ClientContext)a4.L.getOrDefault(a3, Collections.emptyMap()).remove(a2) != null) {
            return true;
        }
        return false;
    }

    public boolean register(String a4, ClientContext a5, ClientIdRegistry.ConnectionType a6) {
        DefaultClientIdRegistry a7;
        Object object = a7.L.computeIfAbsent(a6, a2 -> new ConcurrentHashMap());
        a4 = object.put(a4, a5);
        if (a7.I.isInfoEnabled()) {
            object = object.entrySet().stream().filter(a3 -> ((ClientContext)a3.getValue()).equals((Object)a5)).map(Map.Entry::getKey).collect(Collectors.toSet());
            if (object.size() != 1) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a6;
                objectArray[1] = a5;
                objectArray[2] = object;
                a7.I.info(HeartbeatMonitor.M((Object)"q}P|UxPm\u001ce]xLaRoO(ZgN(Gu\u001c{HzYiQ(ZgN(_dUmR|ul\u001csA2\u001csA"), objectArray);
            }
        }
        if (a4 == null) {
            return true;
        }
        return false;
    }

    @EventListener
    public void on(SubscriptionEvents.SubscribeQuery a2) {
        DefaultClientIdRegistry a3;
        SubscriptionEvents.SubscribeQuery subscribeQuery = a2;
        String string = subscribeQuery.M().e();
        String string2 = subscribeQuery.M().M();
        if (!a3.L.getOrDefault(ClientIdRegistry.ConnectionType.I, Collections.emptyMap()).containsKey(string2)) {
            a3.I.info(ErrorMessageFactory.M((Object)"x\u001bL\u001cPNZ\u001a[\u000bH\u0003\t\rF\u0000G\u000bJ\u001aL\n\u0013NR\u0013\t5Z\u001a[\u000bH\u0003\t\u0007MN\u0004P\t\u0015T3"), (Object)string, (Object)string2);
        }
        a3.register(string2, new ClientContext(string, a2.M()), ClientIdRegistry.ConnectionType.I);
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected a2) {
        DefaultClientIdRegistry a3;
        DefaultClientIdRegistry defaultClientIdRegistry = a3;
        defaultClientIdRegistry.I.info(HeartbeatMonitor.M((Object)"m}YzE(O|Nm]e\u001clU{_gRfYkHmX2\u001csA(g{HzYiQ(Ul\u001c%\u0002(Gua"), (Object)a2.e(), (Object)a2.M());
        defaultClientIdRegistry.unregister(a2.M(), ClientIdRegistry.ConnectionType.I);
    }

    @Order(value=0)
    @EventListener
    public void on(TopologyEvents.ApplicationConnected a2) {
        DefaultClientIdRegistry a3;
        DefaultClientIdRegistry defaultClientIdRegistry = a3;
        defaultClientIdRegistry.I.info(ErrorMessageFactory.M((Object)">E\u000f]\bF\u001cDNZ\u001a[\u000bH\u0003\t\rF\u0000G\u000bJ\u001aL\n\u0013NR\u0013\t5Z\u001a[\u000bH\u0003\t\u0007MN\u0004P\t\u0015T3"), (Object)a2.m(), (Object)a2.e());
        defaultClientIdRegistry.register(a2.e(), new ClientContext(a2.m(), a2.k()), ClientIdRegistry.ConnectionType.D);
    }

    public ClientContext clientId(String a2) {
        int n;
        ClientIdRegistry.ConnectionType[] connectionTypeArray = ClientIdRegistry.ConnectionType.values();
        int n2 = connectionTypeArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            DefaultClientIdRegistry a3;
            ClientIdRegistry.ConnectionType connectionType = connectionTypeArray[n];
            if ((connectionType = (ClientContext)a3.L.getOrDefault(connectionType, Collections.emptyMap()).get(a2)) != null) {
                return connectionType;
            }
            n3 = ++n;
        }
        throw new IllegalStateException("Client " + a2 + " is not present in this registry.");
    }

    public DefaultClientIdRegistry() {
        DefaultClientIdRegistry a2;
        DefaultClientIdRegistry defaultClientIdRegistry = a2;
        a2.L = new ConcurrentHashMap();
    }

    public void printOn(Media a2) {
        DefaultClientIdRegistry a5;
        a5.L.forEach((a3, a4) -> a2.with(a3.toString(), a5 -> a4.forEach((a3, a4) -> a5.with(a3, a4.toString()))));
    }
}

