/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.SendingStreamObserver;
import io.axoniq.axonserver.grpc.control.ClientIdentification;
import io.axoniq.axonserver.grpc.control.NodeInfo;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformInfo;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformServiceGrpc;
import io.axoniq.axonserver.grpc.control.RequestReconnect;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.logging.PluginEventsLogger;
import io.axoniq.axonserver.message.query.subscription.metric.GlobalSubscriptionMetricRegistry;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.topology.AxonServerNode;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.util.StreamObserverUtils;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="PlatformService")
public class PlatformService
extends PlatformServiceGrpc.PlatformServiceImplBase
implements AxonServerClientService {
    private final Topology g;
    private final InstructionAckSource<PlatformOutboundInstruction> E;
    private final Map<PlatformInboundInstruction.RequestCase, Deque<InstructionConsumer>> F;
    private final Map<String, Gauge> a;
    private static final Logger d = LoggerFactory.getLogger(PlatformService.class);
    private final ApplicationEventPublisher k;
    private final ContextProvider B;
    public static final String C = "component";
    private final ClientIdRegistry D;
    private final Map<ClientComponent, SendingStreamObserver<PlatformOutboundInstruction>> l;
    private final MeterFactory I;
    private final AuthenticationProvider L;

    public boolean requestReconnect(String a2, String a4) {
        PlatformService a5;
        d.debug(PluginEventsLogger.M((Object)"\u0004\u000f'\u001f3\u0019\"J$\u000f5\u00058\u00043\t\"Pv\u0011+"), (Object)a2);
        return a5.l.keySet().stream().filter(a3 -> a3.D.equals(a2)).map(a3 -> {
            PlatformService a4;
            return a4.requestReconnect(a3, a4);
        }).findFirst().orElse(false);
    }

    @EventListener
    public void on(TopologyEvents.RequestClientReconnect a2) {
        PlatformService a3;
        a3.requestReconnect(a2.M(), GlobalSubscriptionMetricRegistry.M((Object)"\u001b28\",$=2-w+.i\":2;"));
    }

    private /* synthetic */ void M(ClientComponent a2, Throwable a3) {
        PlatformService a4;
        SendingStreamObserver sendingStreamObserver = (SendingStreamObserver)a4.l.remove(a2);
        if (sendingStreamObserver != null) {
            StreamObserverUtils.M((StreamObserver)sendingStreamObserver, (Throwable)a3);
        }
        a4.M(a2, 0L, a3.getMessage());
    }

    private /* synthetic */ void M(ClientComponent a2, long a3, String a4) {
        d.debug(PluginEventsLogger.M((Object)"\u0012\u000f{\u00183\r?\u0019\"\u000f$\u000f2J5\u0006?\u000f8\u001evPv\u0011+"), (Object)a2);
        if (a2 != null) {
            PlatformService a5;
            String[] stringArray = new String[4];
            stringArray[0] = "context";
            stringArray[1] = a2.getContext();
            stringArray[2] = C;
            stringArray[3] = a2.getComponent();
            Tags tags = Tags.of((String[])stringArray);
            a5.I.counter((MetricName)BaseMetricName.F, tags).increment();
            if (a3 > 0L) {
                a5.I.timer((MetricName)BaseMetricName.K, tags).record(System.currentTimeMillis() - a3, TimeUnit.MILLISECONDS);
            }
            if ((tags = (SendingStreamObserver)a5.l.remove(a2)) != null) {
                StreamObserverUtils.M((StreamObserver)tags);
            }
            a5.D.unregister(a2.l, ClientIdRegistry.ConnectionType.D);
            ClientComponent clientComponent = a2;
            ClientComponent clientComponent2 = a2;
            a5.k.publishEvent((Object)new TopologyEvents.ApplicationDisconnected(clientComponent.L, clientComponent.I, clientComponent2.l, clientComponent2.D, null, a4));
        }
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        PlatformService a3;
        StreamObserver streamObserver = (StreamObserver)a3.l.remove(new ClientComponent(a2.k(), a2.f(), a2.e(), a2.M()));
        d.debug(GlobalSubscriptionMetricRegistry.M((Object)"69'%>*6=>&9i3 $*8'9,4=2-mi,4{i4&9'2*# 8'mi,4"), (Object)a2.k(), (Object)streamObserver);
        if (streamObserver != null) {
            try {
                streamObserver.onCompleted();
                return;
            }
            catch (Exception exception) {
                d.debug(PluginEventsLogger.M((Object)"/$\u00189\u0018v\u001d>\u0003:\u000fv\t:\u0005%\u00038\rv\u001e$\u000b5\u0001?\u00041J3\u001c3\u0004\"J&\u00189\t3\u0019%\u0005$J5\u00058\u00043\t\"\u00039\u0004v\f$\u0005;J-\u0017vGv\u0011+"), (Object)a2.k(), (Object)exception.getMessage());
            }
        }
    }

    public PlatformService(Topology topology, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, ApplicationEventPublisher eventPublisher, MeterFactory meterFactory, @Qualifier(value="platformInstructionAckSource") InstructionAckSource<PlatformOutboundInstruction> a4) {
        PlatformService platformService = this;
        PlatformService platformService2 = this;
        PlatformService platformService3 = this;
        PlatformService platformService4 = this;
        platformService4.l = new ConcurrentHashMap();
        PlatformService platformService5 = this;
        platformService3.a = new ConcurrentHashMap();
        PlatformService platformService6 = this;
        platformService3.F = new EnumMap(PlatformInboundInstruction.RequestCase.class);
        platformService3.g = topology;
        platformService2.B = contextProvider;
        platformService2.L = authenticationProvider;
        platformService.D = clientIdRegistry;
        platformService.k = eventPublisher;
        this.I = meterFactory;
        this.E = a4;
        this.onInboundInstruction(PlatformInboundInstruction.RequestCase.ACK, (a2, a3) -> {
            PlatformService a4;
            if (a4.M((InstructionAck)(a3 = a3.getAck()))) {
                ClientComponent clientComponent = a2;
                d.warn(PluginEventsLogger.M((Object)"?8\u0019#\u001a&\u0005$\u001e3\u000ev\u00038\u0019\"\u0018#\t\"\u00039\u0004v\u00193\u0004\"J\"\u0005v\u001e>\u000fv\t:\u00033\u0004\"J-\u0017v\u00050J5\u00058\u001e3\u0012\"J-\u0017x"), (Object)clientComponent.l, (Object)clientComponent.L);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.l;
            objectArray[1] = a2.L;
            objectArray[2] = a3;
            d.trace(GlobalSubscriptionMetricRegistry.M((Object)"\u001b2*2 !,3i>'$=%<4=>&9i6*<i1;8$w=?,w*; 2'#i,4w&1i4&9=21#i,4yi\u0005,$<;=w2*g"), objectArray);
        });
    }

    private /* synthetic */ boolean M(InstructionAck a2) {
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    public void getPlatformServer(ClientIdentification a2, StreamObserver<PlatformInfo> a3) {
        PlatformService a4;
        String string = a4.B.getContext();
        try {
            AxonServerNode axonServerNode = a4.g.findNodeForClient(a2.getClientId(), a2.getComponentName(), string, a2.getTagsMap());
            StreamObserver<PlatformInfo> streamObserver = a3;
            streamObserver.onNext((Object)PlatformInfo.newBuilder().setSameConnection(axonServerNode.getName().equals(a4.g.getName())).setPrimary(NodeInfo.newBuilder().setNodeName(axonServerNode.getName()).setHostName(axonServerNode.getHostName()).setGrpcPort(axonServerNode.getGrpcPort().intValue()).setHttpPort(axonServerNode.getHttpPort().intValue())).build());
            streamObserver.onCompleted();
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getClientId();
            objectArray[1] = string;
            objectArray[2] = messagingPlatformException.getMessage();
            d.info(GlobalSubscriptionMetricRegistry.M((Object)"\f%;8;w/>'3 9.w=6;0,#i1&%i4%>,9=w2*f,4mi,4"), objectArray);
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)messagingPlatformException));
            return;
        }
        catch (RuntimeException runtimeException) {
            d.warn(PluginEventsLogger.M((Object)"/$\u00189\u0018v\u001a$\u00055\u000f%\u0019?\u00041J5\u0006?\u000f8\u001ev\u00183\u001b#\u000f%\u001ev\u0011+"), (Object)a2, (Object)runtimeException);
            a3.onError((Throwable)GrpcExceptionBuilder.build((Throwable)runtimeException));
            return;
        }
    }

    public StreamObserver<PlatformInboundInstruction> openStream(StreamObserver<PlatformOutboundInstruction> a2) {
        PlatformService a3;
        PlatformService platformService = a3;
        String string = platformService.B.getContext();
        a2 = new SendingStreamObserver(a2);
        Authentication authentication = (Authentication)platformService.L.get();
        if (d.isInfoEnabled()) {
            d.info(GlobalSubscriptionMetricRegistry.M((Object)"\u0014&9'2*# 8'w&',9,3i1&%i,4"), (Object)authentication.getName());
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void sendToClientStreamId(String a2, PlatformOutboundInstruction a4) {
        PlatformService a5;
        a5.l.entrySet().stream().filter(a3 -> a2.equals(((ClientComponent)a3.getKey()).l)).map(Map.Entry::getValue).collect(Collectors.toList()).forEach(a3 -> a3.onNext((Object)a4));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationInactivityTimeout a2) {
        PlatformService a3;
        Object object = a2.M();
        a2 = new ClientComponent(object.M(), a2.M().clientId(), a2.M(), a2.M().context());
        object = "Platform stream inactivity for " + object.M();
        object = new ApplicationInactivityException((String)object);
        a3.M((ClientComponent)a2, (Throwable)object);
    }

    private /* synthetic */ long M(String a2) {
        PlatformService a4;
        return a4.l.keySet().stream().filter(a3 -> a3.getContext().equals(a2)).count();
    }

    public Set<ClientComponent> getConnectedClients() {
        PlatformService a2;
        return a2.l.keySet();
    }

    public boolean requestReconnect(ClientComponent a2, String a3) {
        PlatformService a4;
        d.debug(PluginEventsLogger.M((Object)"83\u001b#\u000f%\u001ev\u00183\t9\u00048\u000f5\u001elJ-\u0017vGv\u0011+"), (Object)a2, (Object)a3);
        StreamObserver streamObserver = (StreamObserver)a4.l.get(a2);
        if (streamObserver != null) {
            ClientComponent clientComponent = a2;
            a4.k.publishEvent((Object)new TopologyEvents.ApplicationReconnectRequested(clientComponent.L, clientComponent.D, a2.I, a3));
            streamObserver.onNext((Object)PlatformOutboundInstruction.newBuilder().setRequestReconnect(RequestReconnect.newBuilder()).build());
            return true;
        }
        return false;
    }

    public void requestReconnectForContext(String a2, String a4) {
        PlatformService a5;
        a5.l.keySet().stream().filter(a3 -> a3.L.equals(a2)).collect(Collectors.toSet()).forEach(a3 -> {
            PlatformService a4;
            a4.requestReconnect(a3, a4);
        });
    }

    public void onInboundInstruction(PlatformInboundInstruction.RequestCase a3, InstructionConsumer a4) {
        PlatformService a5;
        a5.F.computeIfAbsent(a3, a2 -> new ArrayDeque()).add(a4);
    }

    private /* synthetic */ void M(ClientComponent a2, String a3, SendingStreamObserver<PlatformOutboundInstruction> a4) {
        PlatformService a5;
        d.debug(GlobalSubscriptionMetricRegistry.M((Object)"\u0005,0 $=2;2-w*; 2'#imi,4"), (Object)a2);
        a5.l.put(a2, a4);
        ClientComponent clientComponent = a2;
        ClientComponent clientComponent2 = a2;
        a5.k.publishEvent((Object)new TopologyEvents.ApplicationConnected(clientComponent.L, clientComponent.I, clientComponent2.l, clientComponent2.D, a3, null));
    }

    public void sendToClient(String a2, String a4, PlatformOutboundInstruction a5) {
        PlatformService a6;
        a6.l.entrySet().stream().filter(a3 -> ((ClientComponent)a3.getKey()).D.equals(a4)).filter(a3 -> ((ClientComponent)a3.getKey()).L.equals(a2)).map(Map.Entry::getValue).forEach(a3 -> a3.onNext((Object)a5));
    }
}

