/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcFlowControlExecutorProvider;
import io.axoniq.axonserver.grpc.GrpcQueryDispatcherListener;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.QueryService;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.SubscriptionQueryRequestTarget;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.grpc.query.QueryProviderInbound;
import io.axoniq.axonserver.grpc.query.QueryProviderOutbound;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryServiceGrpc;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryRequest;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryResponse;
import io.axoniq.axonserver.interceptor.SubscriptionQueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.flowcontrol.producer.grpc.FlowControlledOutgoingStream;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Service(value="QueryService")
public class QueryService
extends QueryServiceGrpc.QueryServiceImplBase
implements AxonServerClientService {
    private final Topology j;
    private final Logger g;
    private final SubscriptionQueryInterceptors E;
    private final AuthenticationProvider F;
    private final InstructionAckSource<QueryProviderInbound> a;
    private final ApplicationEventPublisher d;
    private final ClientIdRegistry k;
    private final MeterFactory B;
    private final Map<ClientStreamIdentification, GrpcQueryDispatcherListener> C;
    private final QueryDispatcher D;
    private final ContextProvider l;
    @Value(value="${axoniq.axonserver.query-threads:1}")
    private int I;
    private final GrpcFlowControlExecutorProvider L;

    public Set<GrpcQueryDispatcherListener> listeners() {
        QueryService a2;
        return new HashSet<GrpcQueryDispatcherListener>(a2.C.values());
    }

    public void completeStreamForInactivity(String a2, ClientStreamIdentification a3) {
        QueryService a4;
        if (a4.C.containsKey(a3)) {
            String string = "Query stream inactivity for " + a3.M();
            string = new ApplicationInactivityException(string);
            ((GrpcQueryDispatcherListener)a4.C.remove(a3)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string));
            QueryService queryService = a4;
            queryService.g.debug(ClientVersionsCache.M((Object)"k\u000e_\tC[i\u000fH\u001e[\u0016\u001a\u0018V\u0014I\u001e^[\\\u0014H[Y\u0017S\u001eT\u000f\u0000[A\u0006"), (Object)a3);
            queryService.d.publishEvent((Object)new TopologyEvents.QueryHandlerDisconnected(a3.e(), a2, a3.M()));
        }
    }

    private /* synthetic */ boolean M(InstructionAck a2) {
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    public void query(QueryRequest a2, StreamObserver<QueryResponse> a3) {
        QueryService a5;
        if (a5.g.isTraceEnabled()) {
            a5.g.trace(ClientVersionsCache.M((Object)"A\u0006\u0000[h\u001eY\u001eS\r_\u001f\u001a\nO\u001eH\u0002\u0000[A\u0006"), (Object)a2.getClientId(), (Object)a2.getQuery());
        }
        a3 = a3;
        a3.setOnCancelHandler(() -> {
            QueryService a3;
            a3.D.cancel(a2.getMessageIdentifier());
        });
        new FlowControlledOutgoingStream((CallStreamObserver)new GrpcQueryResponseConsumer(a5, (CallStreamObserver)a3), a5.L.provide()).accept((Publisher)Flux.create(a4 -> {
            QueryService a5;
            SerializedQuery serializedQuery = new SerializedQuery(a5.l.getContext(), a2);
            a5.D.query(serializedQuery, (Authentication)a5.F.get(), arg_0 -> ((FluxSink)a4).next(arg_0), a3 -> a4.complete());
            a4.onRequest(a3 -> {
                QueryService a4;
                a4.D.flowControl(a2.getMessageIdentifier(), a3);
            });
        }).limitRate(32));
    }

    @PreDestroy
    public void cleanup() {
        QueryService a4;
        a4.C.forEach((a2, a3) -> a3.cancel());
        a4.C.clear();
    }

    public QueryService(Topology topology, QueryDispatcher queryDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, SubscriptionQueryInterceptors subscriptionQueryInterceptors, MeterFactory meterFactory, ApplicationEventPublisher eventPublisher, @Qualifier(value="queryInstructionAckSource") InstructionAckSource<QueryProviderInbound> instructionAckSource, GrpcFlowControlExecutorProvider a2) {
        QueryService queryService = this;
        QueryService queryService2 = this;
        QueryService queryService3 = this;
        QueryService queryService4 = this;
        QueryService queryService5 = this;
        QueryService queryService6 = this;
        queryService6.g = LoggerFactory.getLogger(QueryService.class);
        QueryService queryService7 = this;
        queryService6.C = new ConcurrentHashMap();
        queryService6.I = 1;
        queryService5.j = topology;
        queryService5.D = queryDispatcher;
        queryService4.l = contextProvider;
        queryService4.F = authenticationProvider;
        queryService3.k = clientIdRegistry;
        queryService3.E = subscriptionQueryInterceptors;
        queryService2.B = meterFactory;
        queryService2.d = eventPublisher;
        queryService.a = instructionAckSource;
        queryService.L = a2;
    }

    public StreamObserver<SubscriptionQueryRequest> subscription(StreamObserver<SubscriptionQueryResponse> a2) {
        QueryService a3;
        String string = a3.l.getContext();
        QueryService queryService = a3;
        return new SubscriptionQueryRequestTarget(string, (Authentication)a3.F.get(), a2, queryService.E, queryService.d);
    }

    @NotNull
    private /* synthetic */ QueryProviderInbound M(String a2) {
        return QueryProviderInbound.newBuilder().setSubscriptionQueryRequest(SubscriptionQueryRequest.newBuilder().setUnsubscribe(SubscriptionQuery.newBuilder().setSubscriptionIdentifier(a2))).build();
    }

    public StreamObserver<QueryProviderOutbound> openStream(StreamObserver<QueryProviderInbound> a2) {
        QueryService a3;
        String string = a3.l.getContext();
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        QueryService queryService = a3;
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

