/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.replication.SnapshotDataProviders;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.rest.svg.jsfunction.ShowDetail;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"})
public class HeartbeatMonitor {
    private final Publisher<PlatformOutboundInstruction> k;
    private final Map<ClientStreamIdentification, Instant> B;
    private final ApplicationEventPublisher C;
    private final long D;
    private final Map<ClientStreamIdentification, ClientInformation> l;
    private final Logger I = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private final Clock L;

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:500}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.k.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> a4, ApplicationEventPublisher a5, Publisher<PlatformOutboundInstruction> a6, long a7, Clock a8) {
        HeartbeatMonitor a9;
        HeartbeatMonitor heartbeatMonitor = a9;
        a9.l = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor2 = a9;
        heartbeatMonitor.B = new ConcurrentHashMap();
        a4.accept((a2, a3) -> {
            HeartbeatMonitor a4;
            HeartbeatMonitor heartbeatMonitor = a4;
            heartbeatMonitor.I.trace(ShowDetail.M((Object)"s\u0000Z\u0017O'^\u0004OEI\u0000X\u0000R\u0013^\u0001\u001b\u0003I\nVE@\u0018"), a2);
            heartbeatMonitor.B.put(a2, Instant.now(a4.L));
        });
        HeartbeatMonitor heartbeatMonitor3 = a9;
        HeartbeatMonitor heartbeatMonitor4 = a9;
        heartbeatMonitor4.L = a8;
        heartbeatMonitor4.C = a5;
        heartbeatMonitor3.D = a7;
        heartbeatMonitor3.k = a6;
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor a2;
        HeartbeatMonitor heartbeatMonitor = a2;
        heartbeatMonitor.I.debug(ShowDetail.M((Object)"&S\u0000X\u000eR\u000b\\EX\nU\u000b^\u0006O\u0000_EX\tR\u0000U\u0011HEZ\u0017^EH\u0011R\tWEZ\tR\u0013^K\u0015K"));
        HeartbeatMonitor heartbeatMonitor2 = a2;
        Instant instant = Instant.now(heartbeatMonitor.L).minus(heartbeatMonitor2.D, ChronoUnit.MILLIS);
        heartbeatMonitor2.B.forEach((a3, a4) -> {
            HeartbeatMonitor a5;
            if (a4.isBefore(instant) && a5.l.containsKey(a3)) {
                ClientInformation clientInformation = (ClientInformation)a5.l.get(a3);
                String string = clientInformation.I;
                String string2 = clientInformation.L;
                Object[] objectArray = new Object[4];
                objectArray[0] = a5.D;
                objectArray[1] = a3;
                objectArray[2] = a4;
                objectArray[3] = instant;
                a5.I.info(SnapshotDataProviders.M((Object)"u'_.X?\u0016\"X*U?_=_?OkR.B.U?S/\u0016-Y9\u0016&Y9SkB#W%\u00160Kk[\"Z'_8S(Y%R8\u0018ku'_.X?\fkM6\u001akZ*E?w(B\"@\"B2\fkM6\u001akB\"[.Y>Bq\u00160Ke\u0016"), objectArray);
                a5.C.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout(a3, string, new ClientContext(string2, clientInformation.l)));
            }
        });
    }

    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher eventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long a2) {
        this(a5 -> platformService.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (a3, a4) -> a5.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a4)), eventPublisher, (Publisher)heartbeatPublisher, a2, Clock.systemUTC());
    }

    public static String M(Object a2) {
        a2 = (String)a2;
        int n = ((String)a2).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 1 << 3;
        int cfr_ignored_0 = (2 ^ 5) << 4 ^ 1 << 1;
        int n4 = n2;
        int n5 = (2 ^ 5) << 3 ^ 4;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)a2).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)a2).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected a2) {
        HeartbeatMonitor a3;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.k(), a2.e());
        a3.l.put(clientStreamIdentification, new ClientInformation(a2.f(), a2.m(), a2.k()));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected a2) {
        HeartbeatMonitor a3;
        a2 = new ClientStreamIdentification(a2.M(), a2.k());
        a3.B.remove(a2);
        a3.l.remove(a2);
        a3.I.debug(SnapshotDataProviders.M((Object)"\u0018B$Fk[$X\"B$D\"X,\u0016#S*D?T.W?\u0016-Y9\u0016(Z\"S%BkM6\u0018"), (Object)a2);
    }
}

