/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.interceptor;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryRequest;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryResponse;
import io.axoniq.axonserver.interceptor.InterceptorTimer;
import io.axoniq.axonserver.interceptor.PluginContextFilter;
import io.axoniq.axonserver.interceptor.SubscriptionQueryInterceptors;
import io.axoniq.axonserver.managed.ManagedAxonServerEventStoreStatusService;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.plugin.RequestRejectedException;
import io.axoniq.axonserver.plugin.ServiceWithInfo;
import io.axoniq.axonserver.plugin.interceptor.SubscriptionQueryRequestInterceptor;
import io.axoniq.axonserver.plugin.interceptor.SubscriptionQueryResponseInterceptor;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DefaultSubscriptionQueryInterceptors
implements SubscriptionQueryInterceptors {
    private final PluginContextFilter I;
    private final InterceptorTimer L;

    public DefaultSubscriptionQueryInterceptors(PluginContextFilter a2, MeterFactory a3) {
        DefaultSubscriptionQueryInterceptors a4;
        a4.I = a2;
        DefaultSubscriptionQueryInterceptors defaultSubscriptionQueryInterceptors = a4;
        a4.L = new InterceptorTimer(a3);
    }

    public SubscriptionQueryRequest subscriptionQueryRequest(SubscriptionQueryRequest a2, ExecutionContext a3) {
        DefaultSubscriptionQueryInterceptors a4;
        List list = a4.I.getServicesWithInfoForContext(SubscriptionQueryRequestInterceptor.class, a3.contextName());
        if (list.isEmpty()) {
            return a2;
        }
        return (SubscriptionQueryRequest)a4.L.M(a3.contextName(), ManagedAxonServerEventStoreStatusService.M((Object)";G\nA\u000b@\u0001B\u001c[\u0007\\9G\r@\u0011`\rC\u001dW\u001bF!\\\u001cW\u001aQ\rB\u001c]\u001a"), () -> {
            SubscriptionQueryRequest subscriptionQueryRequest = a2;
            list = list.iterator();
            while (list.hasNext()) {
                ServiceWithInfo serviceWithInfo = (ServiceWithInfo)list.next();
                try {
                    subscriptionQueryRequest = ((SubscriptionQueryRequestInterceptor)serviceWithInfo.M()).subscriptionQueryRequest(subscriptionQueryRequest, a3);
                }
                catch (RequestRejectedException requestRejectedException) {
                    throw new MessagingPlatformException(ErrorCode.SUBSCRIPTION_QUERY_REJECTED_BY_INTERCEPTOR, a3.contextName() + " : request rejected by interceptor " + serviceWithInfo.M(), (Throwable)requestRejectedException);
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.EXCEPTION_IN_INTERCEPTOR, a3.contextName() + " : Exception thrown by the SubscriptionQueryRequestInterceptor in " + serviceWithInfo.M(), (Throwable)exception);
                }
            }
            return subscriptionQueryRequest;
        });
    }

    public SubscriptionQueryResponse subscriptionQueryResponse(SubscriptionQueryResponse a2, ExecutionContext a3) {
        DefaultSubscriptionQueryInterceptors a4;
        Object object = a4.I.getServicesWithInfoForContext(SubscriptionQueryResponseInterceptor.class, a3.contextName());
        if (object.isEmpty()) {
            return a2;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ServiceWithInfo serviceWithInfo = (ServiceWithInfo)object.next();
            try {
                a2 = ((SubscriptionQueryResponseInterceptor)serviceWithInfo.M()).subscriptionQueryResponse(a2, a3);
            }
            catch (Exception exception) {
                throw new MessagingPlatformException(ErrorCode.EXCEPTION_IN_INTERCEPTOR, a3.contextName() + " : Exception thrown by the SubscriptionQueryResponseInterceptor in " + serviceWithInfo.M(), (Throwable)exception);
            }
        }
        return a2;
    }
}

