/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.AggregateIndexEntries;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.I;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.PersistedBloomFilter;
import io.axoniq.axonserver.localstorage.file.RemoteAggregateSequenceNumberResolver;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntries;
import io.axoniq.axonserver.localstorage.file.StandardIndexEntriesSerializer;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.ApplicationJSON;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class StandardIndexManager
implements IndexManager {
    private final Counter K;
    private final MeterFactory.RateMeter h;
    private static final String i = "aggregateMap";
    private final ConcurrentNavigableMap<Long, Map<String, IndexEntries>> J;
    private final Supplier<IndexManager> M;
    private final ConcurrentNavigableMap<FileVersion, PersistedBloomFilter> e;
    private final Counter j;
    private static final Logger g = LoggerFactory.getLogger(StandardIndexManager.class);
    protected final Supplier<StorageProperties> E;
    protected final String F;
    private final MeterFactory.RateMeter a;
    private final RemoteAggregateSequenceNumberResolver d;
    private static final ScheduledExecutorService k = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(ApplicationJSON.M((Object)"9\u00144\u001f(W=\u001b>\u001b7\u001f\"W")));
    private ScheduledFuture<?> B;
    private final ConcurrentNavigableMap<Long, Integer> C;
    private final ConcurrentSkipListMap<FileVersion, I> D;
    private final String l;
    private final EventType I;
    private final AtomicLong L;

    public boolean removeAllVersions(long a2) {
        Integer n;
        StandardIndexManager a3;
        StorageProperties storageProperties = (StorageProperties)a3.E.get();
        if (a3.J.remove(a2) == null && (n = (Integer)a3.C.remove(a2)) != null) {
            FileVersion fileVersion;
            int n2;
            int n3 = n2 = 0;
            while (n3 < n) {
                fileVersion = new FileVersion(a2, n2);
                if (storageProperties.index(a3.l, fileVersion).exists()) {
                    a3.remove(fileVersion);
                }
                n3 = ++n2;
            }
            FileVersion fileVersion2 = new FileVersion(a2, n.intValue());
            fileVersion = (I)a3.D.remove(fileVersion2);
            if (fileVersion != null) {
                fileVersion.close();
            }
            a3.e.remove(fileVersion2);
        }
        if (FileUtils.M((File)storageProperties.index(a3.l, a2)) && FileUtils.M((File)storageProperties.bloomFilter(a3.l, a2))) {
            return true;
        }
        return false;
    }

    private /* synthetic */ boolean M(FileVersion a3, String a4) {
        StandardIndexManager a5;
        if ((a3 = a5.e.computeIfAbsent(a3, a2 -> {
            StandardIndexManager a3;
            g.debug(QueryHandler.M((Object)"Yb\u0018?MoGq\u0002}NpMr\u0002yKsVzP?DpP?Yb"), (Object)a3.F, (Object)a2.M());
            StorageProperties storageProperties = (StorageProperties)a3.E.get();
            a2 = new PersistedBloomFilter(storageProperties.bloomFilter(a3.l, a2).getAbsolutePath(), 0, 0.03f);
            if (!a2.M()) {
                return null;
            }
            a3.K.increment();
            FileVersion fileVersion = a2;
            fileVersion.d();
            return fileVersion;
        })) != null && !a3.M(a4)) {
            return true;
        }
        return false;
    }

    private /* synthetic */ int M(long a2, long a3, SortedMap<FileVersion, IndexEntries> a4, FileVersion a5, IndexEntries a6) {
        StandardIndexManager a7;
        if (!(a6 = a6.range(a2, a3, EventType.L.equals((Object)a7.I))).isEmpty()) {
            a4.put(a5, a6);
        }
        return a6.size();
    }

    private /* synthetic */ void d(FileVersion a2, Map<String, IndexEntries> a3) {
        DBMaker.Maker maker;
        HTreeMap hTreeMap;
        File file;
        StorageProperties storageProperties;
        StandardIndexManager a4;
        block14: {
            DBMaker.Maker maker2;
            block9: {
                DBMaker.Maker maker3;
                block13: {
                    block12: {
                        block11: {
                            storageProperties = (StorageProperties)a4.E.get();
                            if (a3 == null) {
                                a3 = Collections.emptyMap();
                            }
                            if (!FileUtils.M((File)(file = storageProperties.indexTemp(a4.l, a2.M())))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + file);
                            }
                            maker2 = DBMaker.fileDB((File)file);
                            if (!storageProperties.isUseMmapIndex()) break block11;
                            maker2.fileMmapEnable();
                            if (!storageProperties.isForceCleanMmapIndex()) break block12;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block13;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                hTreeMap = maker2.hashMap(i, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.M()).createOrOpen();
                try {
                    hTreeMap.putAll(a3);
                    if (hTreeMap == null) break block9;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block10: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block10;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block14;
            }
            maker = maker2;
        }
        maker.close();
        try {
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), storageProperties.index(a4.l, a2).toPath(), copyOptionArray);
        }
        catch (IOException iOException) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a4.l, a2), (Throwable)iOException);
        }
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(storageProperties.bloomFilter(a4.l, a2).getAbsolutePath(), a3.keySet().size(), storageProperties.getBloomIndexFpp());
        hTreeMap2.e();
        hTreeMap2.M(a3.keySet());
        hTreeMap2.M();
        a4.e.put(a2, hTreeMap);
        a4.C.put(a2.M(), a2.M());
        a4.d(a2);
    }

    public List<File> indexFiles(FileVersion a2) {
        StandardIndexManager a3;
        File[] fileArray = new File[2];
        fileArray[0] = ((StorageProperties)a3.E.get()).index(a3.l, a2);
        fileArray[1] = ((StorageProperties)a3.E.get()).bloomFilter(a3.l, a2);
        return Arrays.asList(fileArray);
    }

    public SegmentIndexEntries lastIndexEntries(String a2, long a3) {
        StandardIndexManager a4;
        for (Long l2 : a4.J.descendingKeySet()) {
            IndexEntries indexEntries = (IndexEntries)((Map)a4.J.get(l2)).get(a2);
            if (indexEntries == null || indexEntries.firstSequenceNumber() >= a3) continue;
            IndexEntries indexEntries2 = indexEntries;
            return new SegmentIndexEntries(new FileVersion(l2.longValue(), 0), indexEntries2.range(indexEntries2.firstSequenceNumber(), a3, EventType.L.equals((Object)a4.I)));
        }
        if (!a4.C.isEmpty()) {
            return a4.lastIndexEntriesFromClosedSegments(a2, a3, ((Long)a4.C.keySet().first()).longValue());
        }
        return null;
    }

    public Stream<AggregateIndexEntries> latestSequenceNumbers(FileVersion a2) {
        StandardIndexManager a3;
        return a3.d(a2).M();
    }

    public void init() {
        int n;
        StandardIndexManager a2;
        StorageProperties storageProperties = (StorageProperties)a2.E.get();
        String[] stringArray = FileUtils.M((File)new File(a2.l), (String)storageProperties.getIndexSuffix());
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            FileVersion fileVersion = FileUtils.M((String)stringArray[n]);
            if (storageProperties.dataFile(a2.l, fileVersion).exists()) {
                a2.C.compute(fileVersion.M(), (a3, a4) -> a4 == null ? fileVersion.M() : Math.max(fileVersion.M(), a4));
            } else {
                a2.remove(fileVersion);
            }
            n3 = ++n;
        }
        a2.d();
    }

    public long size() {
        return 0L;
    }

    public StandardIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, RemoteAggregateSequenceNumberResolver a6, MeterFactory a7, Supplier<IndexManager> a8) {
        StandardIndexManager a9;
        StandardIndexManager standardIndexManager = a9;
        StandardIndexManager standardIndexManager2 = a9;
        StandardIndexManager standardIndexManager3 = a9;
        StandardIndexManager standardIndexManager4 = a9;
        a9.J = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager5 = a9;
        standardIndexManager4.e = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager6 = a9;
        a9.D = new ConcurrentSkipListMap();
        StandardIndexManager standardIndexManager7 = a9;
        standardIndexManager3.C = new ConcurrentSkipListMap(Comparator.reverseOrder());
        StandardIndexManager standardIndexManager8 = a9;
        standardIndexManager3.L = new AtomicLong();
        standardIndexManager3.E = a3;
        standardIndexManager2.l = a4;
        standardIndexManager2.F = a2;
        standardIndexManager.I = a5;
        standardIndexManager.d = a6;
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a2;
        stringArray[2] = "type";
        stringArray[3] = a5.name();
        a2 = Tags.of((String[])stringArray);
        StandardIndexManager standardIndexManager9 = a9;
        MeterFactory meterFactory = a7;
        a9.a = a7.rateMeter((MetricName)BaseMetricName.R, (Tags)a2);
        a9.h = meterFactory.rateMeter((MetricName)BaseMetricName.e, (Tags)a2);
        standardIndexManager9.K = meterFactory.counter((MetricName)BaseMetricName.la, (Tags)a2);
        standardIndexManager9.j = a7.counter((MetricName)BaseMetricName.E, (Tags)a2);
        k.scheduleAtFixedRate(() -> {
            Map.Entry entry;
            StandardIndexManager a2;
            StorageProperties storageProperties = (StorageProperties)a2.E.get();
            StandardIndexManager standardIndexManager = a2;
            while (standardIndexManager.D.size() > storageProperties.getMaxIndexesInMemory()) {
                entry = a2.D.pollFirstEntry();
                g.debug(ApplicationJSON.M((Object)"+\u0007jZ\u0013\u0016?\t9\u00147Z9\u00144\u001f(Z+\u0007"), (Object)a2.F, entry.getKey());
                a2.B = k.schedule(() -> ((I)entry.getValue()).close(), 2L, TimeUnit.SECONDS);
                standardIndexManager = a2;
            }
            StandardIndexManager standardIndexManager2 = a2;
            while (standardIndexManager2.e.size() > storageProperties.getMaxBloomFiltersInMemory()) {
                StandardIndexManager standardIndexManager3 = a2;
                standardIndexManager2 = standardIndexManager3;
                entry = standardIndexManager3.e.pollFirstEntry();
                StandardIndexManager standardIndexManager4 = a2;
                g.debug(QueryHandler.M((Object)"d_%\u0002MGrMiG{\u0002}NpMr\u0002yKsVzP?DpP?Yb\u0002yPpO?OzOpPf"), (Object)standardIndexManager4.F, entry.getKey());
                standardIndexManager4.j.increment();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        a9.M = a8;
    }

    public void createNewVersion(long a2, int a52, Map<String, List<IndexEntry>> a6) {
        DBMaker.Maker maker;
        HTreeMap hTreeMap;
        StandardIndexManager a7;
        FileVersion a52;
        block12: {
            DBMaker.Maker maker2;
            block7: {
                DBMaker.Maker maker3;
                block11: {
                    block10: {
                        block9: {
                            a52 = new FileVersion(a2, a52);
                            if (a6 == null) {
                                a6 = Collections.emptyMap();
                            }
                            if (!FileUtils.M((File)(a2 = ((StorageProperties)a7.E.get()).transformedIndex(a7.l, a52)))) {
                                throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to delete temp index file:" + a2);
                            }
                            maker2 = DBMaker.fileDB((File)a2);
                            if (!((StorageProperties)a7.E.get()).isUseMmapIndex()) break block9;
                            maker2.fileMmapEnable();
                            if (!((StorageProperties)a7.E.get()).isForceCleanMmapIndex()) break block10;
                            DBMaker.Maker maker4 = maker2;
                            maker3 = maker4;
                            maker4.cleanerHackEnable();
                            break block11;
                        }
                        maker2.fileChannelEnable();
                    }
                    maker3 = maker2;
                }
                maker2 = maker3.make();
                hTreeMap = maker2.hashMap(i, (Serializer)Serializer.STRING, (Serializer)StandardIndexEntriesSerializer.M()).createOrOpen();
                try {
                    a6.forEach((a3, a4) -> {
                        int n;
                        IndexEntry indexEntry = (IndexEntry)a4.get(0);
                        Integer[] integerArray = new Integer[a4.size()];
                        int n2 = n = 0;
                        while (n2 < a4.size()) {
                            int n3 = n++;
                            integerArray[n3] = ((IndexEntry)a4.get(n3)).M();
                            n2 = n;
                        }
                        hTreeMap.put(a3, (Object)new StandardIndexEntries(indexEntry.d(), integerArray));
                    });
                    if (hTreeMap == null) break block7;
                    maker = maker2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block8: {
                        if (hTreeMap != null) {
                            try {
                                hTreeMap.close();
                                throwable2 = throwable;
                                break block8;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                hTreeMap.close();
                break block12;
            }
            maker = maker2;
        }
        maker.close();
        HTreeMap hTreeMap2 = hTreeMap = new PersistedBloomFilter(((StorageProperties)a7.E.get()).bloomFilter(a7.l, a52).getAbsolutePath(), a6.keySet().size(), ((StorageProperties)a7.E.get()).getBloomIndexFpp());
        hTreeMap2.e();
        hTreeMap2.M(a6.keySet());
        hTreeMap2.M();
    }

    public void M(FileVersion a2, Map<String, IndexEntries> a3) {
        StandardIndexManager a4;
        if (a4.M(a2)) {
            a4.d(a2, a3);
            return;
        }
        StandardIndexManager standardIndexManager = (StandardIndexManager)a4.M.get();
        if (standardIndexManager != null) {
            standardIndexManager.M(a2, a3);
        }
    }

    private /* synthetic */ IndexEntries M(FileVersion a2, String a3) {
        int n;
        StandardIndexManager a4;
        if (a4.M(a2, a3)) {
            return null;
        }
        RuntimeException runtimeException = new RuntimeException();
        int n2 = n = 0;
        while (true) {
            if (n2 >= 3) break;
            try {
                I i2 = a4.d(a2);
                return i2.M(a3);
            }
            catch (IndexNotFoundException indexNotFoundException) {
                return null;
            }
            catch (Exception exception) {
                runtimeException = new RuntimeException("Error happened while trying get positions for " + a2.M() + " segment.", exception);
                n2 = ++n;
                continue;
            }
            break;
        }
        throw runtimeException;
    }

    public SegmentIndexEntries lastIndexEntriesFromClosedSegments(String a2, long a3, long a422) {
        StandardIndexManager a5;
        for (Map.Entry entry : a5.C.entrySet()) {
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = a5.M(fileVersion, a2);
            if (indexEntries == null || indexEntries.firstSequenceNumber() >= a3) continue;
            IndexEntries indexEntries2 = indexEntries;
            return new SegmentIndexEntries(fileVersion, indexEntries2.range(indexEntries2.firstSequenceNumber(), a3, EventType.L.equals((Object)a5.I)));
        }
        IndexManager a422 = (IndexManager)a5.M.get();
        if (a422 != null) {
            return a422.lastIndexEntriesFromClosedSegments(a2, a3, (Long)a5.C.keySet().last() - 1L);
        }
        return null;
    }

    private /* synthetic */ I d(FileVersion a3) {
        StandardIndexManager a4;
        try {
            return a4.D.computeIfAbsent(a3, a2 -> {
                StandardIndexManager a3;
                return new I(a3, a2);
            }).M();
        }
        catch (IndexNotFoundException indexNotFoundException) {
            a3 = (I)a4.D.remove(a3);
            if (a3 != null) {
                a3.close();
            }
            throw indexNotFoundException;
        }
    }

    public void complete(FileVersion a2) {
        StandardIndexManager a3;
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.d(a2, (Map)standardIndexManager.J.get(a2.M()));
        a3.J.remove(a2.M());
        a3.d();
    }

    public void addExistingIndex(FileVersion a2) {
        StandardIndexManager a3;
        a3.C.put(a2.M(), a2.M());
        a3.d();
    }

    public Mono<Void> activateVersion(FileVersion a2, File a3) {
        StandardIndexManager a4;
        if (a4.C.containsKey(a2.M())) {
            return a4.M(a2, a3);
        }
        IndexManager indexManager = (IndexManager)a4.M.get();
        if (indexManager != null) {
            return indexManager.activateVersion(a2, a3);
        }
        return Mono.empty();
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String a2, long a3, long a4, long a5, long a6) {
        Iterator iterator;
        StandardIndexManager a7;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        Object[] objectArray = new Object[4];
        objectArray[0] = a7.F;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        g.debug(ApplicationJSON.M((Object)"+\u0007jZ<\u0015?\u0011%\n\u0011\u001d7\b5\u001d1\u000e5Z+\u0007p\u00179\u0014\u0003\u001f!\u000f5\u00143\u001f\u001e\u000f=\u00185\bp\u0001-Vp\u00161\t$)5\u000b%\u001f>\u001954%\u00172\u001f\"Z+\u0007"), objectArray);
        long l2 = Long.MAX_VALUE;
        Iterator iterator2 = iterator = a7.J.descendingKeySet().iterator();
        while (iterator2.hasNext()) {
            Long l3 = (Long)iterator.next();
            if (l2 < a6) {
                return treeMap;
            }
            IndexEntries indexEntries = (IndexEntries)a7.J.getOrDefault(l3, Collections.emptyMap()).get(a2);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager = a7;
                int n = standardIndexManager.M(a3, a4, treeMap, new FileVersion(l3.longValue(), 0), indexEntries);
                if (standardIndexManager.M(a3, a5 -= (long)n, indexEntries)) {
                    return treeMap;
                }
            }
            l2 = l3;
            iterator2 = iterator;
        }
        TreeMap<FileVersion, IndexEntries> treeMap2 = treeMap;
        treeMap2.putAll(a7.lookupAggregateInClosedSegments(a2, a3, a4, a5, a6, l2));
        return treeMap2;
    }

    private /* synthetic */ void d() {
        StandardIndexManager a2;
        StandardIndexManager standardIndexManager = a2;
        standardIndexManager.L.set(standardIndexManager.C.keySet().stream().skip(((StorageProperties)a2.E.get()).getMaxIndexesInMemory()).findFirst().orElse(-1L));
    }

    public void addToActiveSegment(long a4, String a5, IndexEntry a6) {
        StandardIndexManager a7;
        if (a7.C.containsKey(a4)) {
            throw new IndexNotFoundException(a4 + ": already completed");
        }
        a7.J.computeIfAbsent(a4, a2 -> new ConcurrentHashMap()).computeIfAbsent(a5, a3 -> new StandardIndexEntries(a6.d())).add(a6);
    }

    public void cleanup(boolean a4) {
        StandardIndexManager a5;
        StandardIndexManager standardIndexManager = a5;
        standardIndexManager.J.clear();
        standardIndexManager.e.clear();
        standardIndexManager.D.forEach((a2, a3) -> a3.close());
        StandardIndexManager standardIndexManager2 = a5;
        standardIndexManager2.D.clear();
        if (standardIndexManager2.B != null && !a5.B.isDone()) {
            a5.B.cancel(true);
        }
        if (a4) {
            a5.C.keySet().forEach(arg_0 -> a5.removeAllVersions(arg_0));
        }
        StandardIndexManager standardIndexManager3 = a5;
        standardIndexManager3.C.clear();
        IndexManager indexManager = (IndexManager)standardIndexManager3.M.get();
        if (indexManager != null) {
            indexManager.cleanup(a4);
        }
    }

    public Stream<File> getBackupFilenames(long a2, int a5) {
        StandardIndexManager a6;
        StorageProperties storageProperties = (StorageProperties)a6.E.get();
        return a6.C.entrySet().stream().filter(a4 -> {
            if ((Long)a4.getKey() > a2 || (Integer)a4.getValue() > a5) {
                return true;
            }
            return false;
        }).flatMap(a3 -> {
            StandardIndexManager a4;
            File[] fileArray = new File[2];
            fileArray[0] = storageProperties.index(a4.l, ((Long)a3.getKey()).longValue());
            fileArray[1] = storageProperties.bloomFilter(a4.l, ((Long)a3.getKey()).longValue());
            return Stream.of(fileArray);
        });
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregateInClosedSegments(String a2, long a3, long a4, long a5, long a6, long a7) {
        StandardIndexManager a8;
        IndexManager indexManager;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        IndexManager indexManager2 = indexManager = a8.C.entrySet().iterator();
        while (indexManager2.hasNext()) {
            Map.Entry entry = indexManager.next();
            if (a7 < a6) {
                return treeMap;
            }
            FileVersion fileVersion = new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue());
            IndexEntries indexEntries = a8.M(fileVersion, a2);
            Object[] objectArray = new Object[4];
            objectArray[0] = a8.F;
            objectArray[1] = a2;
            objectArray[2] = entry;
            objectArray[3] = indexEntries;
            g.debug(QueryHandler.M((Object)"d_%\u0002sMpIjR^ExPzE~Vz\u0002d_?Kq\u0002lGxOzLk\u0002d_?DpWqF?Yb"), objectArray);
            if (indexEntries != null) {
                StandardIndexManager standardIndexManager = a8;
                int n = standardIndexManager.M(a3, a4, treeMap, fileVersion, indexEntries);
                if (standardIndexManager.M(a3, a5 -= (long)n, indexEntries)) {
                    return treeMap;
                }
            }
            a7 = (Long)entry.getKey();
            indexManager2 = indexManager;
        }
        indexManager = (IndexManager)a8.M.get();
        if (indexManager != null) {
            treeMap.putAll(indexManager.lookupAggregateInClosedSegments(a2, a3, a4, a5, a6, a7));
        }
        return treeMap;
    }

    public Optional<Long> getLastSequenceNumber(String a2, EventStorageEngine.SearchHint a32, long a4) {
        StandardIndexManager a5;
        int a32 = a32.equals((Object)EventStorageEngine.SearchHint.l) ? ((StorageProperties)a5.E.get()).segmentsForSequenceNumberCheck() : Integer.MAX_VALUE;
        return a5.M(a2, a32, a4);
    }

    public Mono<Void> activateVersion(FileVersion a2) {
        StandardIndexManager a3;
        return Mono.defer(() -> {
            StandardIndexManager a3;
            File file = ((StorageProperties)a3.E.get()).transformedIndex(a3.l, a2);
            return a3.activateVersion(a2, file);
        });
    }

    public boolean remove(FileVersion a2) {
        StandardIndexManager a3;
        I i2 = (I)a3.D.remove(a2);
        if (i2 != null) {
            i2.close();
        }
        StandardIndexManager standardIndexManager = a3;
        standardIndexManager.e.remove(a2);
        if (FileUtils.M((File)((StorageProperties)standardIndexManager.E.get()).index(a3.l, a2)) && FileUtils.M((File)((StorageProperties)a3.E.get()).bloomFilter(a3.l, a2))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Long> M(String a2, int a3, long a4) {
        void var7_13;
        void var7_11;
        Map map;
        StandardIndexManager a5;
        int n = 0;
        for (Long optional2 : a5.J.descendingKeySet()) {
            if (n >= a3) {
                return Optional.empty();
            }
            if (optional2 > a4 || (map = (Map)a5.J.get(optional2)) == null) continue;
            IndexEntries indexEntries = (IndexEntries)map.get(a2);
            if (indexEntries != null) {
                return Optional.of(indexEntries.lastSequenceNumber());
            }
            ++n;
        }
        for (Map.Entry entry : a5.C.entrySet()) {
            if (n >= a3) {
                return Optional.empty();
            }
            if ((Long)entry.getKey() > a4) continue;
            map = a5.M(new FileVersion(((Long)entry.getKey()).longValue(), ((Integer)entry.getValue()).intValue()), a2);
            if (map != null) {
                return Optional.of(map.lastSequenceNumber());
            }
            ++n;
        }
        Iterator<Object> iterator = (StandardIndexManager)a5.M.get();
        Optional optional = Optional.empty();
        if (iterator != null) {
            Optional optional2 = iterator.M(a2, a3 - n, a4);
        }
        if (var7_11.isEmpty() && a5.d != null && n < a3 && !a5.C.isEmpty()) {
            StandardIndexManager standardIndexManager = a5;
            Optional optional3 = standardIndexManager.d.getLastSequenceNumber(standardIndexManager.F, a2, a3 - n, (Long)a5.C.keySet().last() - 1L);
        }
        return var7_13;
    }

    private /* synthetic */ boolean M(FileVersion a2) {
        StandardIndexManager a3;
        return ((StorageProperties)a3.E.get()).dataFile(a3.l, a2).exists();
    }

    public void createIndex(FileVersion a2, Map<String, List<IndexEntry>> a3) {
        StandardIndexManager a6;
        HashMap hashMap = new HashMap();
        a3.forEach((a4, a5) -> hashMap.computeIfAbsent(a4, a3 -> new StandardIndexEntries(((IndexEntry)a5.get(0)).d())).addAll(a5));
        a6.M(a2, hashMap);
    }

    private /* synthetic */ boolean M(long a2, long a3, IndexEntries a4) {
        if (!a4.isEmpty() && a2 >= a4.firstSequenceNumber() || a3 <= 0L) {
            return true;
        }
        return false;
    }

    public boolean validIndex(FileVersion a2) {
        block3: {
            boolean bl;
            block4: {
                StandardIndexManager a3;
                if (!a3.C.containsKey(a2.M()) || ((Integer)a3.C.get(a2.M())).intValue() != a2.M()) break block3;
                if (a3.M(a2) == null || a3.d(a2) == null) break block4;
                return true;
            }
            try {
                bl = false;
            }
            catch (Exception exception) {
                g.warn(ApplicationJSON.M((Object)"\u0016\u001b9\u00165\u001ep\u000e?Z&\u001b<\u00134\u001b$\u001fp\u0013>\u001e5\u0002p\u001c?\bp\t5\u001d=\u001f>\u000ejZ+\u0007"), (Object)a2, (Object)exception);
            }
            return bl;
        }
        return false;
    }

    private /* synthetic */ Mono<Void> M(FileVersion a4, File a5) {
        StandardIndexManager a6;
        return Mono.fromSupplier(() -> {
            StandardIndexManager a3;
            return ((StorageProperties)a3.E.get()).index(a3.l, a4);
        }).filter(a2 -> {
            if (!a2.exists()) {
                return true;
            }
            return false;
        }).flatMap(a3 -> Mono.fromSupplier(() -> a5).filter(File::exists).switchIfEmpty(Mono.error((Throwable)new RuntimeException())).flatMap(a4 -> FileUtils.M((File)a5, (File)a3))).doOnSuccess(a3 -> {
            StandardIndexManager a4;
            a4.C.put(a4.M(), a4.M());
        });
    }

    public StandardIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6, Supplier<IndexManager> a7) {
        a8(a2, a3, a4, a5, null, a6, a7);
        StandardIndexManager a8;
    }

    public void addToActiveSegment(Long a2, Map<String, List<IndexEntry>> a3) {
        StandardIndexManager a4;
        if (a4.C.containsKey(a2)) {
            throw new IndexNotFoundException(a2 + ": already completed");
        }
        a3.forEach((a5, a6) -> {
            StandardIndexManager a7;
            a7.J.computeIfAbsent(a2, a2 -> new ConcurrentHashMap()).computeIfAbsent(a5, a3 -> new StandardIndexEntries(((IndexEntry)a6.get(0)).d())).addAll(a6);
        });
    }

    public StandardIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6) {
        a7(a2, a3, a4, a5, null, a6, () -> null);
        StandardIndexManager a7;
    }
}

