/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.component.processor.ClientEventProcessorInfo;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.interceptor.PluginRemovedEvent;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class StorageProperties
implements Cloneable,
Serializable {
    private static final String TEMP_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.temp";
    private int maxBloomFiltersInMemory;
    private int segmentSize;
    private String newIndexSuffix;
    private boolean useMmapIndex;
    public static final String PRIMARY_STORAGE_KEY = "primary";
    private int eventsPerSegmentPrefetch;
    private String bloomIndexSuffix;
    private long forceInterval;
    private int validationSegments;
    private static final String PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s";
    private long syncInterval;
    private int primaryCleanupDelay;
    private int memoryMappedSegments;
    private int flags;
    private static final String PATH_FORMAT = "%s/%020d%s";
    private Boolean forceClean;
    private static final String TRANSFORMED_PATH_WITH_VERSION_FORMAT = "%s/%020d_%05d%s.transformed";
    private int maxIndexesInMemory;
    private boolean keepOldVersions;
    private int globalIndexSegmentsCheck;
    private Boolean forceCleanMmapIndex;
    private Duration[] retentionTime;
    private int secondaryCleanupDelay;
    private String indexSuffix;
    private static final String FILE_FORMAT = "%020d%s";
    private static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    private final SystemInfoProvider systemInfoProvider;
    public static final String TRANSFORMED_SUFFIX = ".transformed";
    private static final String OLD_PATH_FORMAT = "%s/%014d%s";
    private String storage;
    private String indexFormat;
    private GlobalIndexPreload globalIndexPreload;
    private Map<String, String> storages;
    private float bloomIndexFpp;
    private int readBufferSize;
    private static final String FILE_WITH_VERSION_FORMAT = "%020d_%05d%s";
    private Duration globalIndexPreloadTimeout;
    private String eventsSuffix;
    private static final String TEMP_PATH_FORMAT = "%s/%020d%s.temp";
    private String globalIndexSuffix;
    private int segmentsForSequenceNumberCheck;

    public void setEventsPerSegmentPrefetch(int a2) {
        a.eventsPerSegmentPrefetch = a2;
    }

    public void setUseMmapIndex(Boolean a2) {
        a.useMmapIndex = a2;
    }

    public int getEventsPerSegmentPrefetch() {
        StorageProperties a2;
        return a2.eventsPerSegmentPrefetch;
    }

    public void setSyncInterval(long a2) {
        a.syncInterval = a2;
    }

    public void setForceCleanMmapIndex(Boolean a2) {
        a.forceCleanMmapIndex = a2;
    }

    public boolean isCleanRequired() {
        StorageProperties a2;
        if (Boolean.TRUE.equals(a2.forceClean) || a2.systemInfoProvider.javaOnWindows()) {
            return true;
        }
        return false;
    }

    public void setMemoryMappedSegments(int a2) {
        a.memoryMappedSegments = a2;
    }

    public long getForceInterval() {
        StorageProperties a2;
        return a2.forceInterval;
    }

    public void setBloomIndexFpp(float a2) {
        a.bloomIndexFpp = a2;
    }

    public File indexTemp(String a2, long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public int globalIndexSegmentsCheck() {
        StorageProperties a2;
        return a2.globalIndexSegmentsCheck;
    }

    public String dataFile(long a2) {
        StorageProperties a3;
        Object[] objectArray = new Object[2];
        objectArray[0] = a2;
        objectArray[1] = a3.eventsSuffix;
        return String.format(FILE_FORMAT, objectArray);
    }

    public void setStorages(Map<String, String> a2) {
        StorageProperties a3;
        if (a3.storages != null && a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
            a3.storages.putAll(a2);
            return;
        }
        a3.storages = a2;
    }

    public void setValidationSegments(int a2) {
        a.validationSegments = a2;
    }

    public File transformedDataFile(String a2, FileVersion a3) {
        StorageProperties a4;
        if (a3.M() == 0) {
            throw new RuntimeException(PluginRemovedEvent.M((Object)"?B2M3W|W.B2P:L.N|W3\u0003*F.P5L2\u0003l"));
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.M();
        objectArray[2] = a3.M();
        objectArray[3] = a4.eventsSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public StorageProperties withIndexFormat(String a2) {
        StorageProperties a3;
        a3.M().indexFormat = a2;
        return a3.M();
    }

    public boolean isForceCleanMmapIndex() {
        StorageProperties a2;
        if (a2.forceCleanMmapIndex != null) {
            return a2.forceCleanMmapIndex;
        }
        return a2.systemInfoProvider.javaOnWindows();
    }

    public int getValidationSegments() {
        StorageProperties a2;
        return a2.validationSegments;
    }

    public File index(String a2, FileVersion a3) {
        StorageProperties a4;
        if (a3.M() == 0) {
            return a4.index(a2, a3.M());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.M();
        objectArray[2] = a3.M();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public int getMaxIndexesInMemory() {
        StorageProperties a2;
        return a2.maxIndexesInMemory;
    }

    public void setForceClean(Boolean a2) {
        a.forceClean = a2;
    }

    public void setKeepOldVersions(boolean a2) {
        a.keepOldVersions = a2;
    }

    public StorageProperties withGlobalIndexPreload(GlobalIndexPreload a2) {
        StorageProperties a3;
        a3.M().globalIndexPreload = a2;
        return a3.M();
    }

    public boolean isUseMmapIndex() {
        StorageProperties a2;
        return a2.useMmapIndex;
    }

    public File newTransformedIndex(String a2, FileVersion a3) {
        StorageProperties a4;
        if (a3.M() == 0) {
            return a4.transformedIndex(a2, a3.M());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.M();
        objectArray[2] = a3.M();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setNewIndexSuffix(String a2) {
        a.newIndexSuffix = a2;
    }

    public StorageProperties withKeepOldVersions(boolean a2) {
        StorageProperties a3;
        a3.M().keepOldVersions = a2;
        return a3.M();
    }

    public int segmentsForSequenceNumberCheck() {
        StorageProperties a2;
        return a2.segmentsForSequenceNumberCheck;
    }

    public void setGlobalIndexPreloadTimeout(Duration a2) {
        a.globalIndexPreloadTimeout = a2;
    }

    public float getBloomIndexFpp() {
        StorageProperties a2;
        return a2.bloomIndexFpp;
    }

    public StorageProperties withRetentionTime(Duration[] a2) {
        StorageProperties a3;
        a3.M().retentionTime = a2;
        return a3.M();
    }

    public String getNewIndexSuffix() {
        StorageProperties a2;
        return a2.newIndexSuffix;
    }

    public void setIndexSuffix(String a2) {
        a.indexSuffix = a2;
    }

    public File transformedIndex(String a2, long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public Boolean getForceClean() {
        StorageProperties a2;
        return a2.forceClean;
    }

    public String dataFile(FileVersion a2) {
        StorageProperties a3;
        if (a2.M() == 0) {
            return a3.dataFile(a2.M());
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a2.M();
        objectArray[1] = a2.M();
        objectArray[2] = a3.eventsSuffix;
        return String.format(FILE_WITH_VERSION_FORMAT, objectArray);
    }

    public Duration getGlobalIndexPreloadTimeout() {
        StorageProperties a2;
        return a2.globalIndexPreloadTimeout;
    }

    public File bloomFilter(String a2, FileVersion a3) {
        StorageProperties a4;
        if (a3.M() == 0) {
            return a4.bloomFilter(a2, a3.M());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.M();
        objectArray[2] = a3.M();
        objectArray[3] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setFlags(int a2) {
        a.flags = a2;
    }

    public File newIndex(String a2, FileVersion a3) {
        StorageProperties a4;
        if (a3.M() == 0) {
            return a4.newIndex(a2, a3.M());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.M();
        objectArray[2] = a3.M();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public void setStorage(String a2) {
        StorageProperties a3;
        a3.storage = a2;
        if (a3.storages != null) {
            if (!a3.storages.containsKey(PRIMARY_STORAGE_KEY)) {
                a3.storages.put(PRIMARY_STORAGE_KEY, a2);
                return;
            }
        } else {
            a3.storages = new HashMap();
            a3.storages.put(PRIMARY_STORAGE_KEY, a2);
        }
    }

    public int getSegmentSize() {
        StorageProperties a2;
        return a2.segmentSize;
    }

    public StorageProperties(SystemInfoProvider a2, String a3, String a4, String a5, String a6, String a7) {
        StorageProperties a8;
        StorageProperties storageProperties = a8;
        StorageProperties storageProperties2 = a8;
        a8(a2);
        a8.eventsSuffix = a3;
        storageProperties2.indexSuffix = a4;
        storageProperties2.bloomIndexSuffix = a5;
        storageProperties.globalIndexSuffix = a7;
        storageProperties.newIndexSuffix = a6;
    }

    public long getRetentionTime(int a2) {
        StorageProperties a3;
        if (a2 < 0 || a2 >= a3.retentionTime.length) {
            return System.currentTimeMillis();
        }
        return a3.retentionTime[a2].toMillis();
    }

    public void setMaxBloomFiltersInMemory(int a2) {
        a.maxBloomFiltersInMemory = a2;
    }

    public StorageProperties withSegmentSize(int a2) {
        StorageProperties a3;
        a3.M().segmentSize = a2;
        return a3.M();
    }

    public int getMaxBloomFiltersInMemory() {
        StorageProperties a2;
        return a2.maxBloomFiltersInMemory;
    }

    public void setBloomIndexSuffix(String a2) {
        a.bloomIndexSuffix = a2;
    }

    public boolean isKeepOldVersions() {
        StorageProperties a2;
        return a2.keepOldVersions;
    }

    public String getEventsSuffix() {
        StorageProperties a2;
        return a2.eventsSuffix;
    }

    public File bloomFilter(String a2, long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = a3;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setEventsSuffix(String a2) {
        a.eventsSuffix = a2;
    }

    public void setIndexFormat(String a2) {
        a.indexFormat = a2;
    }

    public File newIndexTemp(String a2, long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = a3;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(TEMP_PATH_FORMAT, objectArray));
    }

    public File oldIndex(String a2, long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public void setGlobalIndexSegmentsCheck(int a2) {
        a.globalIndexSegmentsCheck = a2;
    }

    public long getSyncInterval() {
        StorageProperties a2;
        return a2.syncInterval;
    }

    public File newIndex(String a2, long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = a3;
        objectArray[2] = a4.newIndexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setPrimaryCleanupDelay(int a2) {
        a.primaryCleanupDelay = a2;
    }

    public void setGlobalIndexPreload(GlobalIndexPreload a2) {
        a.globalIndexPreload = a2;
    }

    public String getIndexFormat() {
        StorageProperties a2;
        return a2.indexFormat;
    }

    public File index(String a2, long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = a3;
        objectArray[2] = a4.indexSuffix;
        return new File(String.format(PATH_FORMAT, objectArray));
    }

    public void setSegmentSize(DataSize a2) {
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)ClientEventProcessorInfo.M((Object)"\u0013H'@%C4\r3D:H`@5^4\r\"H`A%^3\r4E!C`\u001fq\u0019w\u0019x\u001ev\u0019w"));
        Assert.isTrue((a2.toBytes() > 0L ? 1 : 0) != 0, (String)PluginRemovedEvent.M((Object)"\u000fF;N9M(\u0003/J&F|N)P(\u0003>F|D.F=W9Q|W4B2\u0003l"));
        a.segmentSize = (int)a2.toBytes();
    }

    public void setSecondaryCleanupDelay(int a2) {
        a.secondaryCleanupDelay = a2;
    }

    public String getIndexSuffix() {
        StorageProperties a2;
        return a2.indexSuffix;
    }

    public File dataFile(String a2, FileVersion a3) {
        StorageProperties a4;
        return new File(a2 + File.separator + a4.dataFile(a3));
    }

    public void setForceInterval(long a2) {
        a.forceInterval = a2;
    }

    public File oldBloomFilter(String a2, long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = a3;
        objectArray[2] = a4.bloomIndexSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public StorageProperties withGlobalIndexSegmentsCheck(int a2) {
        StorageProperties a3;
        a3.M().globalIndexSegmentsCheck = a2;
        return a3.M();
    }

    public void setReadBufferSize(int a2) {
        a.readBufferSize = a2;
    }

    public void setMaxIndexesInMemory(int a2) {
        a.maxIndexesInMemory = a2;
    }

    public StorageProperties withMaxBloomFiltersInMemory(int a2) {
        StorageProperties a3;
        a3.M().maxBloomFiltersInMemory = a2;
        return a3.M();
    }

    public Map<String, String> getAvailableStorages() {
        StorageProperties a2;
        return a2.storages;
    }

    private /* synthetic */ StorageProperties M() {
        try {
            StorageProperties a2;
            return (StorageProperties)a2.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
    }

    public String getStorage(String a2) {
        StorageProperties a3;
        String string = (String)a3.storages.get(a2);
        if (string == null) {
            if (PRIMARY_STORAGE_KEY.equals(a2)) {
                return a3.storage;
            }
            String string2 = a2;
            throw new IllegalStateException("Storage " + string2 + " not defined on this node.To define storage set property: axoniq.axonserver.event.storages." + string2);
        }
        return string;
    }

    public GlobalIndexPreload getGlobalIndexPreload() {
        StorageProperties a2;
        return a2.globalIndexPreload;
    }

    public File newIndexTemp(String a2, FileVersion a3) {
        StorageProperties a4;
        if (a3.M() == 0) {
            return a4.newIndexTemp(a2, a3.M());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.M();
        objectArray[2] = a3.M();
        objectArray[3] = a4.newIndexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public StorageProperties withSegmentsForSequenceNumberCheck(int a2) {
        StorageProperties a3;
        a3.M().segmentsForSequenceNumberCheck = a2;
        return a3.M();
    }

    public int getPrimaryCleanupDelay() {
        StorageProperties a2;
        return a2.primaryCleanupDelay;
    }

    public File oldDataFile(String a2, long a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a2;
        objectArray[1] = a3;
        objectArray[2] = a4.eventsSuffix;
        return new File(String.format(OLD_PATH_FORMAT, objectArray));
    }

    public String getStorage(String a2, String a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[2];
        objectArray[0] = a4.getStorage(a2);
        objectArray[1] = a3;
        return String.format(ClientEventProcessorInfo.M((Object)"e^o\b3"), objectArray);
    }

    public StorageProperties withGlobalIndexPreloadTimeout(Duration a2) {
        StorageProperties a3;
        a3.M().globalIndexPreloadTimeout = a2;
        return a3.M();
    }

    public String getGlobalIndexSuffix() {
        StorageProperties a2;
        return a2.globalIndexSuffix;
    }

    public int getMemoryMappedSegments() {
        StorageProperties a2;
        return a2.memoryMappedSegments;
    }

    public String getBloomIndexSuffix() {
        StorageProperties a2;
        return a2.bloomIndexSuffix;
    }

    public void setGlobalIndexSuffix(String a2) {
        a.globalIndexSuffix = a2;
    }

    public String getPrimaryStorage(String a2) {
        StorageProperties a3;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3.storages.getOrDefault(PRIMARY_STORAGE_KEY, a3.storage);
        objectArray[1] = a2;
        return String.format(PluginRemovedEvent.M((Object)"yPs\u0006/"), objectArray);
    }

    public int getReadBufferSize() {
        StorageProperties a2;
        return a2.readBufferSize;
    }

    public File transformedIndex(String a2, FileVersion a3) {
        StorageProperties a4;
        if (a3.M() == 0) {
            return a4.transformedIndex(a2, a3.M());
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.M();
        objectArray[2] = a3.M();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TRANSFORMED_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public File indexTemp(String a2, FileVersion a3) {
        StorageProperties a4;
        Object[] objectArray = new Object[4];
        objectArray[0] = a2;
        objectArray[1] = a3.M();
        objectArray[2] = a3.M();
        objectArray[3] = a4.indexSuffix;
        return new File(String.format(TEMP_PATH_WITH_VERSION_FORMAT, objectArray));
    }

    public StorageProperties withMaxIndexesInMemory(int a2) {
        StorageProperties a3;
        a3.M().maxIndexesInMemory = a2;
        return a3.M();
    }

    public StorageProperties withForceClean(boolean a2) {
        StorageProperties a3;
        a3.M().forceClean = a2;
        return a3.M();
    }

    public int getSecondaryCleanupDelay() {
        StorageProperties a2;
        return a2.secondaryCleanupDelay;
    }

    public int getFlags() {
        StorageProperties a2;
        return a2.flags;
    }

    public void setRetentionTime(Duration[] a2) {
        a.retentionTime = a2;
    }

    public StorageProperties(SystemInfoProvider a2) {
        StorageProperties a3;
        StorageProperties storageProperties = a3;
        StorageProperties storageProperties2 = a3;
        StorageProperties storageProperties3 = a3;
        StorageProperties storageProperties4 = a3;
        StorageProperties storageProperties5 = a3;
        StorageProperties storageProperties6 = a3;
        StorageProperties storageProperties7 = a3;
        StorageProperties storageProperties8 = a3;
        StorageProperties storageProperties9 = a3;
        StorageProperties storageProperties10 = a3;
        StorageProperties storageProperties11 = a3;
        a3.eventsSuffix = ".events";
        storageProperties11.indexSuffix = ".index";
        storageProperties11.newIndexSuffix = ".nindex";
        storageProperties10.globalIndexSuffix = ".xref";
        storageProperties10.bloomIndexSuffix = ".bloom";
        storageProperties9.segmentSize = 0x10000000;
        storageProperties9.storage = "./data";
        StorageProperties storageProperties12 = a3;
        storageProperties9.storages = new HashMap();
        storageProperties8.bloomIndexFpp = 0.03f;
        storageProperties8.forceInterval = 1000L;
        storageProperties7.validationSegments = 10;
        storageProperties7.memoryMappedSegments = 5;
        storageProperties6.primaryCleanupDelay = 0;
        storageProperties6.secondaryCleanupDelay = 0;
        storageProperties5.maxIndexesInMemory = 50;
        storageProperties5.maxBloomFiltersInMemory = 100;
        storageProperties4.syncInterval = 1000L;
        storageProperties4.useMmapIndex = true;
        storageProperties3.forceCleanMmapIndex = true;
        storageProperties3.eventsPerSegmentPrefetch = 10;
        storageProperties2.globalIndexSegmentsCheck = Integer.MAX_VALUE;
        storageProperties2.readBufferSize = 32768;
        storageProperties.keepOldVersions = false;
        Duration[] durationArray = new Duration[1];
        durationArray[0] = Duration.ofDays(7L);
        storageProperties.retentionTime = durationArray;
        StorageProperties storageProperties13 = a3;
        StorageProperties storageProperties14 = a3;
        storageProperties14.segmentsForSequenceNumberCheck = 10;
        storageProperties14.globalIndexPreload = GlobalIndexPreload.l;
        storageProperties13.globalIndexPreloadTimeout = Duration.ofSeconds(10L);
        storageProperties13.systemInfoProvider = a2;
    }

    public void setSegmentsForSequenceNumberCheck(int a2) {
        a.segmentsForSequenceNumberCheck = a2;
    }
}

