/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.admin.context.requestprocessor.VisibleContextCache;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.enterprise.cluster.internal.LicenseMetrics;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventIterator;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.file.g;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final MeterFactory d;
    protected final AtomicLong k;
    private final Gauge B;
    private final FileSystemMonitor C;
    private final Synchronizer D;
    private final EventTransformer l;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> I;
    protected final AtomicReference<WritePosition> L;
    private static final Logger B = LoggerFactory.getLogger(WritableFileStorageTier.class);

    public Stream<String> M(long a3, int a5, boolean a6) {
        WritableFileStorageTier a7;
        if (a6) {
            return Stream.concat(a7.I.entrySet().stream().map(a2 -> {
                WritableFileStorageTier a3;
                return FileUtils.M((File)a3.d(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).M())));
            }), (Stream)a7.M((T a4) -> a4.getBackupFilenames(a3, a5), Stream.empty()));
        }
        return (Stream)a7.M((T a4) -> a4.getBackupFilenames(a3, a5), Stream.empty());
    }

    public void initSegments(long a2) {
    }

    private /* synthetic */ void M(WritePosition a2, List<ProcessedEvent> a6, Map<String, List<IndexEntry>> a7) {
        WritableFileStorageTier a8;
        WritePosition writePosition = a2;
        a2.d.M(a6, writePosition.D, writePosition.L, (a3, a4, a5) -> {
            WritableFileStorageTier a6;
            a6.M(a3, a4, a5, a7);
        });
    }

    /*
     * Loose catch block
     */
    protected WritableEventSource M(FileVersion a2, int a32222, boolean a42222) {
        WritableEventSource a42222;
        FileChannel fileChannel;
        Object object;
        WritableFileStorageTier a5;
        block21: {
            StorageProperties storageProperties = (StorageProperties)a5.J.get();
            File file = storageProperties.dataFile(a5.l, a2);
            int n = Math.max(storageProperties.getSegmentSize(), a32222);
            if (file.exists()) {
                if (a42222 && file.length() < (long)a32222) {
                    object = (ByteBufferEventSource)a5.I.remove(a2.M());
                    if (object != null) {
                        object.M(0L);
                    }
                    FileUtils.M((File)file);
                } else {
                    n = (int)file.length();
                }
            } else if (a2.M() > 0) {
                object = storageProperties.dataFile(a5.l, new FileVersion(a2.M(), 0));
                if (((File)object).exists()) {
                    fileChannel = (ByteBufferEventSource)a5.I.remove(a2.M());
                    if (fileChannel != null) {
                        fileChannel.M(0L);
                    }
                    FileUtils.M((File)object);
                }
            }
            object = new RandomAccessFile(file, LicenseMetrics.M((Object)"s."));
            fileChannel = ((RandomAccessFile)object).getChannel();
            B.info(VisibleContextCache.M((Object)"@\u0016\u0001Kt\u001b^\u0005R\u0005\\K]\u0002W\u000e\u001b\u0010F"), (Object)a5.H, (Object)file);
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a32222 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a2.M(), a2.M(), a5.l, storageProperties);
            a5.I.put(a2.M(), a32222);
            a42222 = a32222;
            if (fileChannel == null) break block21;
            fileChannel.close();
        }
        ((RandomAccessFile)object).close();
        return a42222;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (fileChannel != null) {
                                try {
                                    fileChannel.close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a32222) {
                                    throwable.addSuppressed(a32222);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable4 = throwable3;
                        }
                        catch (Throwable throwable5) {
                            Throwable throwable6 = throwable3;
                            throwable4 = throwable6;
                            throwable6.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a5.H + ": Failed to create segment: " + a2, (Throwable)exception);
                }
            }
        }
    }

    public Optional<EventSource> eventSource(FileVersion a2) {
        WritableFileStorageTier a4;
        Optional optional = a4.M(a2);
        if (optional.isPresent()) {
            return optional;
        }
        return (Optional)a4.M((T a3) -> a3.eventSource(a2), Optional.empty());
    }

    protected Optional<EventSource> M(long a2) {
        WritableFileStorageTier a3;
        if (a3.I.containsKey(a2)) {
            return Optional.of((EventSource)a3.I.get(a2));
        }
        return Optional.empty();
    }

    private /* synthetic */ void d() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        while (true) {
            if (writableFileStorageTier.I.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, a2.H + ": Interrupted while waiting for completion", (Throwable)interruptedException);
            }
        }
    }

    private /* synthetic */ FilePreparedTransaction M(List<Event> a3, int a42) {
        WritableFileStorageTier a5;
        a3 = a3.stream().map(a2 -> {
            WritableFileStorageTier a3;
            return new WrappedEvent(a2, a3.l);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a5;
        int n = writableFileStorageTier.M(a3);
        WritePosition a42 = writableFileStorageTier.M(n, a3.size(), a42);
        return new FilePreparedTransaction(a42, n, a3);
    }

    private /* synthetic */ WritePosition M(int a2, int a3, int a4) {
        int n = (int)Math.ceil((double)a3 / 32767.0);
        if ((n = a2 + n * 11) > 0x7FFFFFF6 || a2 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a2;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(LicenseMetrics.M((Object)"H5m<f8myu+`7r8b-h6oyr0{<;y$="), objectArray));
        }
        do {
            WritableFileStorageTier a6;
            if (!(a2 = (WritePosition)a6.L.getAndUpdate(a5 -> a5.M(a3, n, a4))).M(n) && !a2.e(a4)) continue;
            B.debug(VisibleContextCache.M((Object)"@\u0016\u0001Kx\u0019^\nO\u0002U\f\u001b\u0005^\u001c\u001b\u0018^\fV\u000eU\u001f\u001b\u0010F"), (Object)a6.H, (Object)a2.L);
            WritePosition writePosition = a2;
            writePosition.d.M(writePosition.D, -1);
            WritableEventSource writableEventSource = a6.M(new FileVersion(a2.L, a4), n + 5 + 4, true);
            a6.L.set(a2.M(writableEventSource, a4));
        } while (!a2.d(n) || a2.e(a4));
        return a2;
    }

    public long e() {
        WritableFileStorageTier a2;
        return a2.k.get();
    }

    public long M(List<Event> a2, int a32) {
        WritableFileStorageTier a4;
        HashMap hashMap = new HashMap();
        WritableFileStorageTier writableFileStorageTier = a4;
        a2 = writableFileStorageTier.M(a2, a32);
        WritePosition a32 = a2.M();
        writableFileStorageTier.M(a32, a2.M(), hashMap);
        writableFileStorageTier.i.addToActiveSegment(a32.l, hashMap);
        writableFileStorageTier.k.set(a32.L + (long)a2.M().size() - 1L);
        writableFileStorageTier.D.d(a32);
        return a32.L;
    }

    private /* synthetic */ void M() {
        WritableFileStorageTier a2;
        a2.segmentsWithoutIndex().forEach(a4 -> {
            HashMap<String, List> hashMap;
            WritableFileStorageTier a5;
            Optional optional = (Optional)a5.M((T a3) -> a3.eventSource(a4), Optional.empty());
            if (!optional.isPresent()) return;
            optional = ((EventSource)optional.get()).createEventIterator(a4.M());
            try {
                hashMap = new HashMap<String, List>();
                while (optional.hasNext()) {
                    EventInformation eventInformation = optional.M();
                    if (!eventInformation.M()) continue;
                    IndexEntry indexEntry = new IndexEntry(eventInformation.M().getAggregateSequenceNumber(), eventInformation.M(), eventInformation.M());
                    hashMap.computeIfAbsent(eventInformation.M().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (optional != null) {
                    try {
                        optional.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
            a5.i.createIndex(a4, hashMap);
            if (optional == null) return;
            optional.close();
        });
    }

    public boolean removeSegment(long a2, int a3) {
        WritableFileStorageTier a5;
        if (a5.I.containsKey(a2)) {
            return a5.M(a2, a3);
        }
        return (Boolean)a5.M((T a4) -> a4.removeSegment(a2, a3), (Object)true);
    }

    public void close(boolean a2) {
        WritableFileStorageTier a5;
        File file = new File(a5.l);
        WritableFileStorageTier writableFileStorageTier = a5;
        WritableFileStorageTier writableFileStorageTier2 = a5;
        writableFileStorageTier.C.unregisterPath(writableFileStorageTier2.M());
        writableFileStorageTier.d.remove((Meter)a5.B);
        writableFileStorageTier2.D.M();
        writableFileStorageTier.I.forEach((a3, a4) -> {
            a4.M(0L);
            if (a2) {
                WritableFileStorageTier a5;
                a5.d(a3.longValue());
            }
        });
        a5.M((T a3) -> a3.close(a2));
        boolean bl = a2;
        a5.i.cleanup(bl);
        if (bl) {
            FileUtils.M((File)file);
        }
    }

    private /* synthetic */ void M(long a3, File a4, long a52, StorageProperties a6) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        EventIterator eventIterator;
        HashMap<String, List> a52;
        WritableFileStorageTier a7;
        block10: {
            block8: {
                WritableFileStorageTier writableFileStorageTier2 = a7;
                a4 = writableFileStorageTier2.M(a3, a4, new FileVersion(a52, 0), a6);
                writableFileStorageTier2.M(a4.M());
                a4 = writableFileStorageTier2.M((FileVersion)a4, a6);
                writableFileStorageTier2.M(arg_0 -> WritableFileStorageTier.M((FileVersion)a4, arg_0));
                WritableFileStorageTier writableFileStorageTier3 = a7;
                writableFileStorageTier3.M();
                a6 = writableFileStorageTier3.M((FileVersion)a4, a6.getSegmentSize(), false);
                writableFileStorageTier3.i.remove((FileVersion)a4);
                a3 = a4.M();
                a52 = new HashMap<String, List>();
                eventIterator = a6.createEventIterator();
                try {
                    EventIterator eventIterator2 = eventIterator;
                    while (eventIterator2.hasNext()) {
                        EventInformation eventInformation = eventIterator.M();
                        if (eventInformation.M()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.M().getAggregateSequenceNumber(), eventInformation.M(), a3);
                            a52.computeIfAbsent(eventInformation.M().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a3;
                        eventIterator2 = eventIterator;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (eventIterator != null) {
                            try {
                                eventIterator.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = eventIterator.M();
                a7.k.set(a3 - 1L);
                if (eventIterator == null) break block8;
                writableFileStorageTier = a7;
                eventIterator.close();
                break block10;
            }
            writableFileStorageTier = a7;
        }
        writableFileStorageTier.i.addToActiveSegment(Long.valueOf(a4.M()), a52);
        a6.M(n, 0);
        eventIterator = new WritePosition(a3, n, a4.M(), (WritableEventSource)a6, Long.valueOf(a4.M()), 0);
        WritableFileStorageTier writableFileStorageTier4 = a7;
        writableFileStorageTier4.L.set(eventIterator);
        writableFileStorageTier4.D.M((WritePosition)eventIterator);
    }

    public void e(long a22) {
        WritableFileStorageTier a4;
        if (!a4.I.containsKey(a22)) {
            return;
        }
        if (a22 == (Long)a4.I.firstKey()) {
            B.info(LicenseMetrics.M((Object)"z$;yG6s:h7fyo<y-!*d>l<o-!-nyc<!:s<`-d="), (Object)a4.H);
            StorageProperties a22 = (StorageProperties)a4.J.get();
            WritePosition writePosition = (WritePosition)a4.L.getAndUpdate(a3 -> a3.M(0, a22.getSegmentSize(), 0));
            if (writePosition.M(a22.getSegmentSize())) {
                B.debug(VisibleContextCache.M((Object)"@\u0016\u0001Kx\u0019^\nO\u0002U\f\u001b\u0005^\u001c\u001b\u0018^\fV\u000eU\u001f\u001b\u0010F"), (Object)a4.H, (Object)writePosition.L);
                WritePosition writePosition2 = writePosition;
                writePosition2.d.M(writePosition2.D, -1);
                WritableFileStorageTier writableFileStorageTier = a4;
                WritableFileStorageTier writableFileStorageTier2 = a4;
                WritableEventSource writableEventSource = writableFileStorageTier.M(new FileVersion(writePosition.L, 0), a22.getSegmentSize(), false);
                a4.L.set(writePosition.M(writableEventSource, 0));
                writableFileStorageTier.D.d(new WritePosition(writePosition.L, 0, 0, writableEventSource, Long.valueOf(writePosition.L), writePosition.B));
            }
        }
        a4.d();
    }

    public Flux<FileVersion> fileVersions(String a2) {
        WritableFileStorageTier a4;
        return (Flux)a4.M((T a3) -> a3.fileVersions(a2), (Object)Flux.empty());
    }

    private /* synthetic */ void M(ProcessedEvent a3, long a4, int a5, Map<String, List<IndexEntry>> a6) {
        if (a3.isDomainEvent()) {
            a6.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), a5, a4));
        }
    }

    public long d() {
        WritableFileStorageTier a3;
        return (Long)a3.M((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    public WritableFileStorageTier(EventTypeContext a3, IndexManager a4, Supplier<StorageProperties> a5, Supplier<StorageTier> a6, MeterFactory a7, ScheduledExecutorService a8, String a9, EventTransformerFactory a10, FileSystemMonitor a11) {
        WritableFileStorageTier a12;
        WritableFileStorageTier writableFileStorageTier = a12;
        WritableFileStorageTier writableFileStorageTier2 = a12;
        super(a3, a4, a5, a6, a7, a9);
        WritableFileStorageTier writableFileStorageTier3 = a12;
        writableFileStorageTier3.L = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier4 = a12;
        writableFileStorageTier2.k = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier5 = a12;
        writableFileStorageTier2.I = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier2.d = a7;
        writableFileStorageTier.C = a11;
        writableFileStorageTier.l = a10.get(a5.get().getFlags());
        WritableFileStorageTier writableFileStorageTier6 = a12;
        writableFileStorageTier6.D = new Synchronizer(a3, a5.get(), a7, a8, a2 -> {
            WritableFileStorageTier a4;
            WritableFileStorageTier writableFileStorageTier = a4;
            writableFileStorageTier.i.complete(new FileVersion(a2.l.longValue(), 0));
            writableFileStorageTier.M((T a3) -> {
                WritableFileStorageTier a4;
                a3.handover((Segment)new g(a4, a2), () -> {
                    WritableFileStorageTier a3;
                    ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a3.I.remove(a2.l);
                    B.debug(LicenseMetrics.M((Object)"I8o=d=!6w<syz$-ys<l8h7h7fyr<f4d7u*;yz$"), (Object)a2.l, (Object)a3.getSegments());
                    if (byteBufferEventSource != null) {
                        byteBufferEventSource.M((long)((StorageProperties)a3.J.get()).getPrimaryCleanupDelay());
                    }
                });
            });
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a3.M();
        stringArray[2] = "type";
        stringArray[3] = a3.M().name();
        a12.B = a7.gauge((MetricName)BaseMetricName.fa, Tags.of((String[])stringArray), (Object)a12.D, a2 -> {
            WritableFileStorageTier a3;
            return (double)a3.k.get() - (double)a2.M();
        });
    }

    protected Optional<EventSource> M(FileVersion a2) {
        WritableFileStorageTier a3;
        return a3.M(a2.M());
    }

    private /* synthetic */ int M(List<ProcessedEvent> a2) {
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            WritableFileStorageTier a3;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.H + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.I.values().stream().mapToLong(a2 -> a2.a.capacity()).sum() + (Long)a3.M(StorageTier::size, (Object)0L);
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.I.keySet();
    }

    public void activateSegmentVersion(long a2, int a3) {
        WritableFileStorageTier a5;
        a5.M((T a4) -> a4.activateSegmentVersion(a2, a3));
    }

    private /* synthetic */ String M() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.H + "-" + writableFileStorageTier.H.M().name().toLowerCase();
    }

    public void handover(Segment a2, Runnable a3) {
        a3.run();
    }

    private /* synthetic */ FileVersion M(long a2, File a4, FileVersion a5, StorageProperties a6) {
        return Arrays.stream(FileUtils.M((File)a4, (String)a6.getEventsSuffix())).map(FileUtils::M).filter(a3 -> {
            if (a3.M() < a2) {
                return true;
            }
            return false;
        }).max(FileVersion::M).orElse(a5);
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.M(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    public void M(long a2, long a3) {
        WritableFileStorageTier a4;
        StorageProperties storageProperties = (StorageProperties)a4.J.get();
        File file = new File(a4.l);
        FileUtils.M((File)file);
        WritableFileStorageTier writableFileStorageTier = a4;
        writableFileStorageTier.i.init();
        writableFileStorageTier.M(a2, file, a3, storageProperties);
        writableFileStorageTier.C.registerPath(a4.M(), file.toPath());
    }

    private static /* synthetic */ void M(FileVersion a2, StorageTier a3) {
        a3.initSegments(a2.M());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion M(FileVersion a2, StorageProperties a3) {
        WritableFileStorageTier writableFileStorageTier;
        EventIterator eventIterator;
        WritableFileStorageTier a4;
        if (!a4.i.validIndex(a2)) {
            return a2;
        }
        a3 = a4.M(a2, a3.getSegmentSize(), false);
        long l2 = a2.M();
        try {
            eventIterator = a3.createEventIterator(a2.M());
            try {
                while (eventIterator.hasNext()) {
                    eventIterator.M();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (eventIterator != null) {
                    try {
                        eventIterator.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable throwable) {
            a4.I.remove(a2.M());
            a3.M(0L);
            throw throwable;
        }
        if (eventIterator != null) {
            writableFileStorageTier = a4;
            eventIterator.close();
        } else {
            writableFileStorageTier = a4;
        }
        writableFileStorageTier.I.remove(a2.M());
        a3.M(0L);
        return new FileVersion(l2, 0);
    }

    private /* synthetic */ void d(long a2) {
        WritableFileStorageTier a4;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.I.remove(a2);
        int n = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            n = byteBufferEventSource2.M();
            byteBufferEventSource2.M(0L);
        }
        a4.M(a2, n).forEach(a3 -> {
            WritableFileStorageTier a4;
            a4.M(a2, a3.intValue());
        });
    }

    private /* synthetic */ boolean M(long a2, int a3) {
        WritableFileStorageTier a4;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.I.remove(a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.M(0L);
        }
        if (a4.i.remove(a3 = new FileVersion(a2, a3)) && FileUtils.M((File)a4.d(a3))) {
            return true;
        }
        return false;
    }

    public Integer currentSegmentVersion(Long a2) {
        WritableFileStorageTier a4;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.I.get(a2);
        if (byteBufferEventSource != null) {
            return byteBufferEventSource.M();
        }
        return (Integer)a4.M((T a3) -> a3.currentSegmentVersion(a2), (Object)0);
    }

    public long M() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.L.get()).L;
    }

    public Optional<EventSource> eventSource(long a2) {
        WritableFileStorageTier a4;
        Optional optional = a4.M(a2);
        if (optional.isPresent()) {
            return optional;
        }
        return (Optional)a4.M((T a3) -> a3.eventSource(a2), Optional.empty());
    }

    public int M() {
        WritableFileStorageTier a2;
        return a2.I.size();
    }
}

