/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file.xref;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.EventStoreValidationException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventType;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntries;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.localstorage.file.SegmentIndexEntries;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.multitier.LowerTierEventStoreFactory;
import io.axoniq.axonserver.localstorage.file.xref.GlobalIndex;
import io.axoniq.axonserver.localstorage.file.xref.JumpSkipIndexEntries;
import io.axoniq.axonserver.localstorage.file.xref.LastEventPositionInfo;
import io.axoniq.axonserver.localstorage.file.xref.ReadOnlyJumpSkipIndexManager;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.transport.rest.v2.LoggingRestControllerV2;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryJumpSkipIndexManager
extends ReadOnlyJumpSkipIndexManager {
    public static final int D = 2;
    protected final ConcurrentNavigableMap<Long, Map<String, JumpSkipIndexEntries>> l;
    protected final GlobalIndex I;
    private static final Logger L = LoggerFactory.getLogger(ReadOnlyJumpSkipIndexManager.class);

    protected void d(FileVersion a2, Map<String, JumpSkipIndexEntries> a3) {
        PrimaryJumpSkipIndexManager a4;
        Object[] objectArray = new Object[3];
        objectArray[0] = a4.D;
        objectArray[1] = a4.E;
        objectArray[2] = a2;
        L.debug(LowerTierEventStoreFactory.M((Object)"84yi ;&(7,c2>i*'',;i%&1i84"), objectArray);
        StorageProperties storageProperties = (StorageProperties)a4.d.get();
        a3 = a3 == null ? Collections.emptyMap() : a3;
        File file = a4.M(a2, a3);
        try {
            File file2 = storageProperties.newIndex(a4.M, a2);
            CopyOption[] copyOptionArray = new CopyOption[1];
            copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
            Files.move(file.toPath(), file2.toPath(), copyOptionArray);
            a4.h.addAndGet(file2.length());
            a4.I.M(a3, a2.M());
            return;
        }
        catch (IOException iOException) {
            throw new MessagingPlatformException(ErrorCode.INDEX_WRITE_ERROR, "Failed to rename index file" + storageProperties.index(a4.M, a2), (Throwable)iOException);
        }
    }

    public Stream<File> getBackupFilenames(long a2, int a3) {
        PrimaryJumpSkipIndexManager a4;
        return Stream.concat(super.getBackupFilenames(a2, a3), a4.I.M());
    }

    public PrimaryJumpSkipIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6, Supplier<IndexManager> a7) {
        a8(a2, a3, a4, a5, a6, 1000000, a7);
        PrimaryJumpSkipIndexManager a8;
    }

    public void createIndex(FileVersion a2, Map<String, List<IndexEntry>> a5) {
        PrimaryJumpSkipIndexManager a6;
        HashMap hashMap = new HashMap();
        a5.forEach((a3, a4) -> {
            JumpSkipIndexEntries jumpSkipIndexEntries = (JumpSkipIndexEntries)hashMap.get(a3);
            if (jumpSkipIndexEntries == null) {
                PrimaryJumpSkipIndexManager a5;
                IndexEntry indexEntry = (IndexEntry)a4.get(0);
                jumpSkipIndexEntries = a5.M(a3, indexEntry);
                hashMap.put(a3, jumpSkipIndexEntries);
            }
            jumpSkipIndexEntries.addAll(a4);
        });
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a6;
        primaryJumpSkipIndexManager.M(a2, hashMap);
        primaryJumpSkipIndexManager.I.M(hashMap, a2.M());
    }

    public boolean limitedSegmentChecks() {
        PrimaryJumpSkipIndexManager a2;
        if (((StorageProperties)a2.d.get()).globalIndexSegmentsCheck() < Integer.MAX_VALUE) {
            return true;
        }
        return false;
    }

    public void addToActiveSegment(Long a2, Map<String, List<IndexEntry>> a3) {
        PrimaryJumpSkipIndexManager a6;
        if (a6.k.containsKey(a2)) {
            throw new IndexNotFoundException(a2 + ": already completed");
        }
        a3.forEach((a4, a5) -> {
            PrimaryJumpSkipIndexManager a6;
            JumpSkipIndexEntries jumpSkipIndexEntries = (JumpSkipIndexEntries)a6.l.computeIfAbsent(a2, a2 -> new ConcurrentHashMap()).get(a4);
            if (jumpSkipIndexEntries == null) {
                IndexEntry indexEntry = (IndexEntry)a5.get(0);
                PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a6;
                jumpSkipIndexEntries = primaryJumpSkipIndexManager.M(a4, indexEntry);
                ((Map)primaryJumpSkipIndexManager.l.get(a2)).put(a4, jumpSkipIndexEntries);
            }
            jumpSkipIndexEntries.addAll(a5);
        });
    }

    MeterFactory.RateMeter M() {
        PrimaryJumpSkipIndexManager a2;
        return a2.L;
    }

    public PrimaryJumpSkipIndexManager(String a2, Supplier<StorageProperties> a3, String a4, EventType a5, MeterFactory a6, int a7, Supplier<IndexManager> a8) {
        PrimaryJumpSkipIndexManager a9;
        Supplier<StorageProperties> supplier = a3;
        super(a2, supplier, a4, a5, a6, a8);
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a9;
        primaryJumpSkipIndexManager.l = new ConcurrentSkipListMap();
        a2 = supplier.get();
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager2 = a9;
        primaryJumpSkipIndexManager2.I = new GlobalIndex(a4, (StorageProperties)a2, a7);
    }

    /*
     * Exception decompiling
     */
    public boolean validIndex(FileVersion a) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SortedMap<FileVersion, IndexEntries> lookupAggregate(String a2, long a3, long a4, long a5, long a6) {
        LastEventPositionInfo lastEventPositionInfo;
        PrimaryJumpSkipIndexManager a7;
        TreeMap<FileVersion, IndexEntries> treeMap = new TreeMap<FileVersion, IndexEntries>();
        Object[] objectArray = new Object[4];
        objectArray[0] = a7.D;
        objectArray[1] = a2;
        objectArray[2] = a3;
        objectArray[3] = a4;
        L.debug(LowerTierEventStoreFactory.M((Object)"84yi/&,\"69\u0002.$;&.\"=&i84c$*'\u0010,2<&' ,\r<.+&;c2>ec%\":7\u001a&86,-*&\u00076$!,1i84"), objectArray);
        long l2 = -1L;
        long l3 = Long.MAX_VALUE;
        LastEventPositionInfo lastEventPositionInfo2 = lastEventPositionInfo = a7.l.descendingKeySet().iterator();
        while (lastEventPositionInfo2.hasNext()) {
            Long l4 = (Long)lastEventPositionInfo.next();
            if (l3 < a6) {
                return treeMap;
            }
            JumpSkipIndexEntries jumpSkipIndexEntries = (JumpSkipIndexEntries)a7.l.getOrDefault(l4, Collections.emptyMap()).get(a2);
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = a7.D;
            objectArray2[1] = a2;
            objectArray2[2] = l4;
            objectArray2[3] = jumpSkipIndexEntries;
            L.debug(LoggingRestControllerV2.M((Object)"E-\u0004pR?Q;K \u007f7Y\"[7_$[pE-\u001e9PpM5Y=[>JpE-\u001e6Q%P4\u001e+C"), objectArray2);
            if (jumpSkipIndexEntries != null) {
                if (jumpSkipIndexEntries.lastSequenceNumber() < a3) {
                    return treeMap;
                }
                IndexEntries indexEntries = jumpSkipIndexEntries.range(a3, a4, EventType.L.equals((Object)a7.E));
                if (!indexEntries.isEmpty()) {
                    treeMap.put(new FileVersion(l4.longValue(), 0), indexEntries);
                    if (a7.M(a3, a5 -= (long)indexEntries.size(), (IndexEntries)jumpSkipIndexEntries)) {
                        return treeMap;
                    }
                }
                l2 = jumpSkipIndexEntries.M();
            }
            l3 = l4;
            lastEventPositionInfo2 = lastEventPositionInfo;
        }
        if (l2 < 0L && (lastEventPositionInfo = a7.I.M(a2, Integer.MAX_VALUE)) != null) {
            LastEventPositionInfo lastEventPositionInfo3 = lastEventPositionInfo;
            l2 = lastEventPositionInfo3.M();
            if (lastEventPositionInfo3.d() < a3) {
                return treeMap;
            }
        }
        TreeMap<FileVersion, IndexEntries> treeMap2 = treeMap;
        treeMap2.putAll(a7.lookupAggregateInClosedSegments(a2, a3, a4, a5, a6, l2));
        return treeMap2;
    }

    public void cleanup(boolean a2) {
        PrimaryJumpSkipIndexManager a3;
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a3;
        primaryJumpSkipIndexManager.l.clear();
        primaryJumpSkipIndexManager.I.M(a2);
        super.cleanup(a2);
    }

    @Nonnull
    protected JumpSkipIndexEntries M(String a2, IndexEntry a3) {
        JumpSkipIndexEntries jumpSkipIndexEntries;
        if (a3.d() > 0L) {
            PrimaryJumpSkipIndexManager a4;
            LastEventPositionInfo lastEventPositionInfo = a4.M(a2);
            if (lastEventPositionInfo != null) {
                jumpSkipIndexEntries = new JumpSkipIndexEntries(lastEventPositionInfo.M(), a3.d());
            } else {
                a2 = a4.I.M(a2, Integer.MAX_VALUE, new LastEventPositionInfo(-1L, -1L));
                jumpSkipIndexEntries = new JumpSkipIndexEntries(a2.M(), a3.d());
            }
        } else {
            jumpSkipIndexEntries = new JumpSkipIndexEntries(-1L, a3.d());
        }
        return jumpSkipIndexEntries;
    }

    public Optional<Long> getLastSequenceNumber(String a2, EventStorageEngine.SearchHint a3, long a42) {
        Long l22;
        PrimaryJumpSkipIndexManager a5;
        for (Long l22 : a5.l.descendingKeySet()) {
            IndexEntries indexEntries = (IndexEntries)a5.l.getOrDefault(l22, Collections.emptyMap()).get(a2);
            if (indexEntries == null) continue;
            return Optional.of(indexEntries.lastSequenceNumber());
        }
        int a42 = EventStorageEngine.SearchHint.l.equals((Object)a3) ? Math.max(((StorageProperties)a5.d.get()).globalIndexSegmentsCheck(), 2) : Integer.MAX_VALUE;
        l22 = a5.I.M(a2, a42);
        if (l22 == null) {
            return Optional.empty();
        }
        return Optional.of(l22.d());
    }

    public SegmentIndexEntries lastIndexEntries(String a2, long a3) {
        PrimaryJumpSkipIndexManager a4;
        for (Long l2 : a4.l.descendingKeySet()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a4.D;
            objectArray[1] = a2;
            objectArray[2] = l2;
            objectArray[3] = a4.l.getOrDefault(l2, Collections.emptyMap()).size();
            L.debug(LowerTierEventStoreFactory.M((Object)"84yi/(0=\u0006?&'7i84c -i0,$$&'7i84c$\"9c:*3&i84"), objectArray);
            IndexEntries indexEntries = (IndexEntries)a4.l.getOrDefault(l2, Collections.emptyMap()).get(a2);
            if (indexEntries == null || a3 != Long.MAX_VALUE && indexEntries.firstSequenceNumber() >= a3) continue;
            IndexEntries indexEntries2 = indexEntries;
            return new SegmentIndexEntries(new FileVersion(l2.longValue(), 0), indexEntries2.range(indexEntries2.firstSequenceNumber(), a3, EventType.L.equals((Object)a4.E)));
        }
        LastEventPositionInfo lastEventPositionInfo = a4.I.M(a2, Integer.MAX_VALUE);
        if (lastEventPositionInfo == null) {
            return null;
        }
        return a4.lastIndexEntriesFromClosedSegments(a2, a3, lastEventPositionInfo.M());
    }

    protected LastEventPositionInfo M(String a2) {
        PrimaryJumpSkipIndexManager a3;
        for (Long l2 : a3.l.descendingKeySet()) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a3.D;
            objectArray[1] = a2;
            objectArray[2] = l2;
            objectArray[3] = a3.l.getOrDefault(l2, Collections.emptyMap()).size();
            L.debug(LoggingRestControllerV2.M((Object)"E-\u0004pR1M$\u007f3J9H5w>Z5F\u0015P$L)\u001e+CpW>\u001e#[7S5P$\u001e+CpS1NpM9D5\u001e+C"), objectArray);
            if ((l2 = (JumpSkipIndexEntries)a3.l.getOrDefault(l2, Collections.emptyMap()).get(a2)) == null) continue;
            return l2.M();
        }
        return null;
    }

    public void complete(FileVersion a2) {
        PrimaryJumpSkipIndexManager a3;
        PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a3;
        primaryJumpSkipIndexManager.d(a2, (Map)primaryJumpSkipIndexManager.l.get(a2.M()));
        a3.k.put(a2.M(), a2.M());
        a3.l.remove(a2.M());
        a3.d();
    }

    protected FileVersion M(long a2) {
        PrimaryJumpSkipIndexManager a3;
        NavigableSet<Long> navigableSet = a3.l.headMap((Object)a2, true);
        if (!navigableSet.isEmpty()) {
            return new FileVersion(((Long)navigableSet.lastKey()).longValue(), ((Integer)a3.k.get(navigableSet.lastKey())).intValue());
        }
        navigableSet = a3.k.keySet().tailSet(a2, true);
        if (navigableSet.isEmpty()) {
            throw new IndexNotFoundException(a3.D + ": Index for token not found: " + a2);
        }
        return new FileVersion(((Long)navigableSet.first()).longValue(), ((Integer)a3.k.get(navigableSet.first())).intValue());
    }

    public void init() {
        PrimaryJumpSkipIndexManager a5;
        if (!a5.g.get()) {
            int n;
            long l2;
            a5.I.e();
            File[] fileArray = new File(a5.M).listFiles(a2 -> {
                PrimaryJumpSkipIndexManager a3;
                return a2.getName().endsWith(a3.B);
            });
            long l3 = l2 = a5.I.d() == 0L ? Long.MAX_VALUE : a5.I.d();
            if (fileArray == null) {
                return;
            }
            int n2 = fileArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                File file = fileArray[n];
                FileVersion fileVersion = FileUtils.M((String)file.getName());
                if (fileVersion.M() <= l2) {
                    PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a5;
                    if (((StorageProperties)a5.d.get()).dataFile(a5.M, fileVersion).exists()) {
                        primaryJumpSkipIndexManager.k.compute(fileVersion.M(), (a3, a4) -> a4 == null ? fileVersion.M() : Math.max(fileVersion.M(), a4));
                        a5.h.addAndGet(file.length());
                    } else {
                        primaryJumpSkipIndexManager.remove(fileVersion);
                    }
                } else {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a5.D;
                    objectArray[1] = a5.E;
                    objectArray[2] = file;
                    L.warn(LowerTierEventStoreFactory.M((Object)"2>sc\u000f,<--c2>i*'',;i0,$$&'7i-&7i*'c./&!(/i*'',;ec;&$,?*'$i84"), objectArray);
                    a5.remove(fileVersion);
                }
                n3 = ++n;
            }
            if (a5.I.d() >= 0L && (a5.k.isEmpty() || a5.I.d() != ((Long)a5.k.keySet().first()).longValue())) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a5.D;
                objectArray[1] = a5.E;
                objectArray[2] = a5.I.d();
                throw new EventStoreValidationException(String.format(LoggingRestControllerV2.M((Object)"\u001b#\u0004pW>H1R9ZpY<Q2_<\u001e9P4[(\u001e6Q\"\u001euM|\u001e7R?\\1RpW>Z5Fp[(N5]$MpR1M$\u001e#[7S5P$\u001euZ"), objectArray));
            }
            PrimaryJumpSkipIndexManager primaryJumpSkipIndexManager = a5;
            primaryJumpSkipIndexManager.d();
            primaryJumpSkipIndexManager.g.set(true);
        }
    }

    public long size() {
        PrimaryJumpSkipIndexManager a2;
        return super.size() + a2.I.M();
    }

    public List<File> indexFiles(FileVersion a2) {
        PrimaryJumpSkipIndexManager a3;
        return Collections.singletonList(((StorageProperties)a3.d.get()).newIndex(a3.M, a2));
    }

    public void addToActiveSegment(long a3, String a4, IndexEntry a5) {
        PrimaryJumpSkipIndexManager a6;
        if (a6.k.containsKey(a3)) {
            throw new IndexNotFoundException(a3 + ": already completed");
        }
        JumpSkipIndexEntries jumpSkipIndexEntries = (JumpSkipIndexEntries)a6.l.computeIfAbsent(a3, a2 -> new ConcurrentHashMap()).get(a4);
        if (jumpSkipIndexEntries == null) {
            if (a5.d() > 0L) {
                LastEventPositionInfo lastEventPositionInfo = a6.M(a4);
                if (lastEventPositionInfo != null) {
                    jumpSkipIndexEntries = new JumpSkipIndexEntries(lastEventPositionInfo.M(), a5.d());
                } else {
                    lastEventPositionInfo = a6.I.M(a4, Integer.MAX_VALUE, new LastEventPositionInfo(-1L, -1L));
                    jumpSkipIndexEntries = new JumpSkipIndexEntries(lastEventPositionInfo.M(), a5.d());
                }
            } else {
                jumpSkipIndexEntries = new JumpSkipIndexEntries(-1L, a5.d());
            }
            ((Map)a6.l.get(a3)).put(a4, jumpSkipIndexEntries);
        }
        jumpSkipIndexEntries.add(a5);
    }
}

