/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.logging;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.component.processor.balancing.strategy.ReplicationGroupProcessorLoadBalancingService;
import io.axoniq.axonserver.logging.g;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.util.StringUtils;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class AuditLog {
    private static final Logger L = AuditLog.getLogger();

    @EventListener
    public void on(AbstractAuthenticationEvent a2) {
        if (a2 instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        Authentication authentication = a2.getAuthentication();
        if (L.isDebugEnabled()) {
            L.debug(a2.toString());
            return;
        }
        if (a2 instanceof AuthenticationSuccessEvent && authentication.isAuthenticated()) {
            L.info(NodeContext.M((Object)"E\u001en\u0018gQ~\u0018}\u0019)\u0004z\u0014{\u001fh\u001clQ+\ntS'"), (Object)authentication.getName());
            return;
        }
        if (a2 instanceof AbstractAuthenticationFailureEvent) {
            a2 = (AbstractAuthenticationFailureEvent)a2;
            L.error(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u0001?*9#p:998m%>5?>,=(po+0rm\u0016\f\u0019\u0001\u0015\tjm+0"), (Object)authentication.getName(), (Object)a2.getException().getMessage());
        }
    }

    public static <T> Logger getLogger() {
        return LoggerFactory.getLogger((String)("AUDIT." + g.L.M()[2].getName()));
    }

    public static String username(Principal a2) {
        if (a2 == null) {
            return NodeContext.M((Object)"5\u0010g\u001eg\bd\u001e|\u00027");
        }
        return StringUtils.sanitize((String)a2.getName());
    }

    public static String enablement(boolean a2) {
        if (a2) {
            return ReplicationGroupProcessorLoadBalancingService.M((Object)"\b\u001e\f\u0012\u0001\u0015\t");
        }
        return NodeContext.M((Object)"5@\"H3E4M");
    }

    @EventListener
    public void on(UserEvents.AdminUserDeleted a2) {
        if (L.isDebugEnabled()) {
            L.debug(a2.toString());
        }
    }

    public static String username(String a2) {
        if (a2 == null) {
            return ReplicationGroupProcessorLoadBalancingService.M((Object)"q1#?#) ?8#s");
        }
        return StringUtils.sanitize((String)a2);
    }

    @EventListener
    public void on(UserEvents.AdminUserUpdated a2) {
        if (L.isDebugEnabled()) {
            L.debug(a2.toString());
        }
    }

    public AuditLog() {
        AuditLog a2;
    }
}

