/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message;

import io.axoniq.axonserver.config.MaintenanceExecutors;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class ContextLimitedCache<CACHE extends NonReplacingConstraintCache<String, T>, T>
implements NonReplacingConstraintCache<String, T> {
    private final Function<String, Long> C;
    private final Function<T, String> D;
    private final Map<String, Long> l;
    private final Map<String, AtomicLong> I;
    private final CACHE L;

    public Stream<T> getMessagesForContext(String a2) {
        ContextLimitedCache a4;
        return a4.L.entrySet().stream().filter(a3 -> {
            ContextLimitedCache a4;
            return a2.equals(a4.D.apply(a3.getValue()));
        }).map(Map.Entry::getValue);
    }

    public int size() {
        ContextLimitedCache a2;
        return a2.L.size();
    }

    public Set<Map.Entry<String, T>> timedOut() {
        ContextLimitedCache a2;
        return a2.L.timedOut();
    }

    public T get(String a2) {
        ContextLimitedCache a3;
        return (T)a3.L.get((Object)a2);
    }

    public T remove(@Nonnull String a4) {
        if ((a4 = this.L.remove(a4)) != null) {
            ContextLimitedCache contextLimitedCache = this;
            contextLimitedCache.I.computeIfPresent((String)contextLimitedCache.D.apply(a4), (a2, a3) -> {
                AtomicLong atomicLong = a3;
                atomicLong.decrementAndGet();
                return atomicLong;
            });
        }
        return (T)a4;
    }

    public long activeMessages(String a2) {
        ContextLimitedCache a3;
        return a3.I.getOrDefault(a2, new AtomicLong(0L)).get();
    }

    public T putIfAbsent(@Nonnull String key, @Nonnull T a4) {
        String string = (String)this.D.apply(a4);
        long l2 = this.l.computeIfAbsent(string, this.C::apply);
        if (l2 != -1L) {
            this.I.computeIfAbsent(string, a2 -> new AtomicLong()).getAndUpdate(a3 -> {
                if (a3 >= l2) {
                    throw new InsufficientBufferCapacityException(MaintenanceExecutors.M((Object)"t\u001cP\u000fS\u001b\u0016\u0000EIP\u001cZ\u0005\u001aIE\u0005Y\u001e\u0016\rY\u001eXG"));
                }
                return a3 + 1L;
            });
        }
        try {
            return (T)this.L.putIfAbsent((Object)key, a4);
        }
        catch (InsufficientBufferCapacityException insufficientBufferCapacityException) {
            this.I.computeIfPresent(string, (a2, a3) -> {
                AtomicLong atomicLong = a3;
                atomicLong.decrementAndGet();
                return atomicLong;
            });
            throw insufficientBufferCapacityException;
        }
    }

    public Collection<Map.Entry<String, T>> entrySet() {
        ContextLimitedCache a2;
        return a2.L.entrySet();
    }

    protected ContextLimitedCache(Function<T, String> a2, Function<String, Long> a3, CACHE a4) {
        ContextLimitedCache a5;
        ContextLimitedCache contextLimitedCache = a5;
        ContextLimitedCache contextLimitedCache2 = a5;
        ContextLimitedCache contextLimitedCache3 = a5;
        contextLimitedCache2.I = new ConcurrentHashMap();
        ContextLimitedCache contextLimitedCache4 = a5;
        contextLimitedCache2.l = new ConcurrentHashMap();
        contextLimitedCache2.D = a2;
        contextLimitedCache.C = a3;
        contextLimitedCache.L = a4;
    }

    public void setMaxMessagesForContext(String a2, long a3) {
        ContextLimitedCache a4;
        a4.l.put(a2, a3);
    }
}

