/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message;

import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.localstorage.ContextPropertyDefinition;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBPropertiesProvider;
import io.axoniq.axonserver.message.ContextLimitedCache;
import io.axoniq.axonserver.message.command.CommandMetricsWebSocket;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryCache;
import io.axoniq.axonserver.rest.HttpStreamingQuery;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Primary
@Component(value="queryCache")
public class EnterpriseQueryCache
extends ContextLimitedCache<QueryCache, ActiveQuery> {
    private final Logger L = LoggerFactory.getLogger(EnterpriseQueryCache.class);

    @Scheduled(fixedDelayString="${axoniq.axonserver.cache-close-rate:5000}")
    public void clearOnTimeout() {
        EnterpriseQueryCache a3;
        EnterpriseQueryCache enterpriseQueryCache = a3;
        enterpriseQueryCache.L.debug(CommandMetricsWebSocket.M((Object)"\u0018\u0006>\r0\u00075\t{\u001a2\u0003>\n{\u0001.\u001a{\u001f.\u000b)\u0007>\u001d"));
        Set set = enterpriseQueryCache.timedOut();
        if (!set.isEmpty()) {
            EnterpriseQueryCache enterpriseQueryCache2 = a3;
            enterpriseQueryCache2.L.warn(HttpStreamingQuery.M((Object)"t2G3V}I \u0012*S4F4\\:\u0012,G8@4W.\u0012)]}V8^8F8"), (Object)set.size());
            set.forEach(a2 -> {
                EnterpriseQueryCache a3;
                Object[] objectArray = new Object[3];
                objectArray[0] = ((ActiveQuery)a2.getValue()).M().getQueryName();
                objectArray[1] = ((ActiveQuery)a2.getValue()).d();
                objectArray[2] = ((ActiveQuery)a2.getValue()).M();
                a3.L.warn(CommandMetricsWebSocket.M((Object)"-:\u00008\u000b7\u00022\u0000<N*\u001b>\u001c\"N \u0013{\u001d>\u0000/N9\u0017{\u0015&B{\u0019:\u0007/\u00075\t{\b4\u001c{\u001c>\u001e7\u0017{\b)\u00016N \u0013"), objectArray);
                a3.remove((String)a2.getKey());
                ((ActiveQuery)a2.getValue()).M(ErrorCode.QUERY_TIMEOUT, HttpStreamingQuery.M((Object)"c(W/K}Q<\\>W1^8V}V(W}F2\u0012)[0W2G)"));
            });
        }
    }

    public EnterpriseQueryCache(EmbeddedDBPropertiesProvider embeddedDBPropertiesProvider, QueryCache queryCache, @Value(value="${axoniq.axonserver.messages.context-buffer-limit:-1}") long a2) {
        super(ActiveQuery::M, a4 -> embeddedDBPropertiesProvider.property(a4, ContextPropertyDefinition.I, Long.valueOf(a2)), (NonReplacingConstraintCache)queryCache);
    }
}

