/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.command;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.version.ClientVersionsCache;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import io.axoniq.axonserver.interceptor.CommandInterceptors;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.CommandHandler;
import io.axoniq.axonserver.message.command.CommandInformation;
import io.axoniq.axonserver.message.command.CommandMetricsRegistry;
import io.axoniq.axonserver.message.command.CommandRegistrationCache;
import io.axoniq.axonserver.message.command.WrappedCommand;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.micrometer.core.instrument.Tags;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="CommandDispatcher")
public class CommandDispatcher {
    private final FlowControlQueues<WrappedCommand> d;
    private final CommandInterceptors k;
    private final Logger B;
    private final Map<String, MeterFactory.RateMeter> C;
    private final Map<String, AtomicInteger> D;
    private final CommandRegistrationCache l;
    private final CommandMetricsRegistry I;
    private final NonReplacingConstraintCache<String, CommandInformation> L;

    public int activeCommandCount() {
        CommandDispatcher a2;
        return a2.L.size();
    }

    private /* synthetic */ void d(ClientStreamIdentification a2) {
        CommandDispatcher a3;
        a3.l.remove(a2);
    }

    private /* synthetic */ void M(DefaultExecutionContext a2, SerializedCommandResponse a3, Consumer<SerializedCommandResponse> a4) {
        CommandDispatcher a5;
        try {
            a4.accept(a5.k.commandResponse(a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception exception) {
            CommandDispatcher commandDispatcher = a5;
            commandDispatcher.B.warn(ClientVersionsCache.M((Object)"\u0000GA\u001a>B\u0018_\u000bN\u0012U\u0015\u001a\u0012T[H\u001eI\u000bU\u0015I\u001e\u001a\u0012T\u000f_\tY\u001eJ\u000fU\t"), (Object)a2.contextName(), (Object)exception);
            a4.accept(commandDispatcher.M(a3.getRequestIdentifier(), ErrorCode.fromException((Throwable)exception), exception.getMessage()));
            a2.compensate((Throwable)exception);
            return;
        }
    }

    public void handleResponse(SerializedCommandResponse a2) {
        CommandDispatcher a3;
        CommandInformation commandInformation = (CommandInformation)a3.L.remove((Object)a2.getRequestIdentifier());
        if (commandInformation != null) {
            CommandInformation commandInformation2 = commandInformation;
            a3.B.debug(ClientVersionsCache.M((Object)"(_\u0015^\u0012T\u001c\u001a\t_\bJ\u0014T\b_[N\u0014\u0000[A\u0006"), (Object)commandInformation2);
            commandInformation2.M().accept(a2);
            return;
        }
        a3.B.info(ClientVersionsCache.M((Object)"y\u0014O\u0017^[T\u0014N[\\\u0012T\u001f\u001a\u0018U\u0016W\u001aT\u001f\u001a\t_\nO\u001eI\u000f\u0000[A\u0006"), (Object)a2.getRequestIdentifier());
    }

    private /* synthetic */ boolean M(SerializedCommandResponse a2) {
        if (ErrorCode.NO_HANDLER_FOR_COMMAND.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.COMMAND_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    public void dispatchProxied(String a2, SerializedCommand a3, Consumer<SerializedCommandResponse> a4) {
        CommandDispatcher a5;
        String string = a3.getClientStreamId();
        a2 = new ClientStreamIdentification(a2, string);
        CommandDispatcher commandDispatcher = a5;
        a2 = commandDispatcher.l.findByClientAndCommand((ClientStreamIdentification)a2, a3.getCommand());
        Object[] objectArray = new Object[2];
        objectArray[0] = string;
        objectArray[1] = a3.getCommand();
        commandDispatcher.M(a3, (CommandHandler)a2, a4, ErrorCode.CLIENT_DISCONNECTED, String.format(ClientVersionsCache.M((Object)"y\u0017S\u001eT\u000f\u001a^I[T\u0014N[\\\u0014O\u0015^[M\u0013S\u0017_[J\tU\u0018_\bI\u0012T\u001c\u0000[\u001f\b"), objectArray));
    }

    @EventListener
    public void on(TopologyEvents.CommandHandlerDisconnected a2) {
        CommandDispatcher a3;
        a3.M(a2.M(), a2.M());
    }

    public MeterFactory.RateMeter commandRate(String a3) {
        CommandDispatcher a4;
        return a4.C.computeIfAbsent(a3, a2 -> {
            CommandDispatcher a3;
            return a3.I.rateMeter(a2, (MetricName)BaseMetricName.ja, (MetricName)BaseMetricName.Ca);
        });
    }

    private /* synthetic */ void M(String a2, Authentication a3, SerializedCommand a4, Consumer<SerializedCommandResponse> a5) {
        CommandDispatcher a6;
        long l2 = System.currentTimeMillis();
        a3 = new DefaultExecutionContext(a2, a3);
        a5 = arg_0 -> a6.M((DefaultExecutionContext)a3, a5, arg_0);
        try {
            CommandHandler commandHandler;
            CommandDispatcher commandDispatcher = a6;
            SerializedCommand serializedCommand = commandDispatcher.k.commandRequest(a4, (ExecutionContext)a3);
            CommandHandler commandHandler2 = commandHandler = commandDispatcher.l.getHandlerForCommand(a2, serializedCommand.wrapped(), serializedCommand.getRoutingKey());
            commandDispatcher.M(serializedCommand, commandHandler2, a7 -> {
                CommandDispatcher a8;
                SerializedCommandResponse serializedCommandResponse = a7;
                a5.accept(serializedCommandResponse);
                if (!a8.M(serializedCommandResponse) && commandHandler2 != null) {
                    a8.I.add(a4.getCommand(), a4.wrapped().getClientId(), commandHandler2.e(), a2, System.currentTimeMillis() - l2);
                }
            }, ErrorCode.NO_HANDLER_FOR_COMMAND, "No Handler for command: " + serializedCommand.getCommand());
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2;
            objectArray[1] = a4.getCommand();
            objectArray[2] = exception;
            a6.B.warn(ClientVersionsCache.M((Object)"A\u0006\u0000[\u007f\u0003Y\u001eJ\u000fS\u0014T[^\u0012I\u000b[\u000fY\u0013S\u0015][Y\u0014W\u0016[\u0015^[A\u0006"), objectArray);
            a5.accept(a6.M(a4.getMessageIdentifier(), ErrorCode.fromException((Throwable)exception), exception.getMessage()));
            a3.compensate((Throwable)exception);
            return;
        }
    }

    private /* synthetic */ void M(ClientStreamIdentification a4) {
        CommandDispatcher a5;
        a5.L.entrySet().stream().filter(a3 -> ((CommandInformation)a3.getValue()).M(a4)).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(a2 -> {
            CommandDispatcher a3;
            CommandInformation commandInformation = (CommandInformation)a3.L.remove(a2);
            if (commandInformation != null) {
                commandInformation.M().accept(a3.M(a2, ErrorCode.CONNECTION_TO_HANDLER_LOST, "Connection lost while executing command on: " + commandInformation.M()));
            }
        });
    }

    public FlowControlQueues<WrappedCommand> getCommandQueues() {
        CommandDispatcher a2;
        return a2.d;
    }

    private /* synthetic */ void M(ClientStreamIdentification a3, boolean a4) {
        CommandDispatcher a5;
        a5.d(a3);
        if (!a4) {
            a5.getCommandQueues().M(a3.toString(), (T a2) -> {
                CommandDispatcher a3;
                SerializedCommand serializedCommand = a2.M();
                CommandInformation commandInformation = (CommandInformation)a3.L.remove((Object)serializedCommand.getMessageIdentifier());
                if (commandInformation == null) {
                    return null;
                }
                if ((a2 = a3.l.getHandlerForCommand(a2.M().e(), serializedCommand.wrapped(), serializedCommand.getRoutingKey())) == null) {
                    commandInformation.M().accept(a3.M(serializedCommand.getMessageIdentifier(), ErrorCode.NO_HANDLER_FOR_COMMAND, "No Handler for command: " + serializedCommand.getName()));
                    return null;
                }
                CommandDispatcher commandDispatcher = a3;
                commandDispatcher.B.debug(ClientVersionsCache.M((Object)"~\u0012I\u000b[\u000fY\u0013\u001a\u0000G[N\u0014\u0000[A\u0006"), (Object)serializedCommand.getName(), (Object)a2.M());
                commandDispatcher.L.putIfAbsent((Object)serializedCommand.getMessageIdentifier(), (Object)new CommandInformation(serializedCommand.getName(), serializedCommand.getMessageIdentifier(), serializedCommand.wrapped().getClientId(), (CommandHandler)a2, commandInformation.M()));
                return a2.I.toString();
            });
        }
        a5.M(a3);
    }

    public void deleteMetrics(String a2) {
        CommandDispatcher a3;
        MeterFactory.RateMeter rateMeter = (MeterFactory.RateMeter)a3.C.remove(a2);
        if (rateMeter != null) {
            rateMeter.d();
        }
        a3.D.remove(a2);
        CommandDispatcher commandDispatcher = a3;
        commandDispatcher.I.remove((MetricName)BaseMetricName.g, a2);
        commandDispatcher.I.removeForContext(a2);
    }

    @Nonnull
    private /* synthetic */ SerializedCommandResponse M(String a2, ErrorCode a3, String a4) {
        return new SerializedCommandResponse(CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(a2).setErrorCode(a3.getCode()).setErrorMessage(ErrorMessageFactory.M((String)a4)).build());
    }

    private /* synthetic */ void M(SerializedCommand a2, CommandHandler a3, Consumer<SerializedCommandResponse> a4, ErrorCode a52, String a6) {
        block4: {
            CommandDispatcher a7;
            if (a3 == null) {
                CommandDispatcher commandDispatcher = a7;
                commandDispatcher.B.warn(ClientVersionsCache.M((Object)"t\u0014\u001a3[\u0015^\u0017_\t\u001a\u001dU\t\u001a\u0018U\u0016W\u001aT\u001f\u0000[A\u0006"), (Object)a2.getName());
                a4.accept(commandDispatcher.M(a2.getMessageIdentifier(), a52, a6));
                return;
            }
            try {
                CommandDispatcher commandDispatcher = a7;
                commandDispatcher.B.debug(ClientVersionsCache.M((Object)"~\u0012I\u000b[\u000fY\u0013\u001a\u0000G[N\u0014\u0000[A\u0006"), (Object)a2.getName(), (Object)a3.M());
                a52 = new CommandInformation(a2.getName(), a2.getMessageIdentifier(), a2.wrapped().getClientId(), a3, a4);
                if (commandDispatcher.L.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)a52) == null) break block4;
                Object[] objectArray = new Object[1];
                objectArray[0] = a2.getMessageIdentifier();
                a4.accept(a7.M(a2.getMessageIdentifier(), ErrorCode.COMMAND_DUPLICATED, String.format(ClientVersionsCache.M((Object)"Y\u0014W\u0016[\u0015^[S\u001f\u001a^I[^\u000eJ\u0017S\u0018[\u000f_\u001f"), objectArray)));
                return;
            }
            catch (MessagingPlatformException a52) {
                a7.L.remove((Object)a2.getMessageIdentifier());
                a4.accept(a7.M(a2.getMessageIdentifier(), a52.getErrorCode(), a52.getMessage()));
                return;
            }
        }
        a3.M(a2);
    }

    public CommandDispatcher(CommandRegistrationCache registrations, NonReplacingConstraintCache<String, CommandInformation> commandCache, CommandMetricsRegistry metricRegistry, MeterFactory meterFactory, CommandInterceptors commandInterceptors, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.command-queue-capacity-per-client:10000}") int a2) {
        CommandDispatcher commandDispatcher = this;
        CommandDispatcher commandDispatcher2 = this;
        this.B = LoggerFactory.getLogger(CommandDispatcher.class);
        CommandDispatcher commandDispatcher3 = this;
        this.C = new ConcurrentHashMap();
        CommandDispatcher commandDispatcher4 = this;
        commandDispatcher3.D = new ConcurrentHashMap();
        commandDispatcher2.l = registrations;
        commandDispatcher2.L = commandCache;
        commandDispatcher.I = metricRegistry;
        commandDispatcher.k = commandInterceptors;
        registrations = new DispatchQueueMetrics(meterFactory, (MetricName)BaseMetricName.j, (MetricName)BaseMetricName.M, clientIdRegistry);
        CommandDispatcher commandDispatcher5 = this;
        commandDispatcher.d = new FlowControlQueues(Comparator.comparing(WrappedCommand::M).reversed(), a2, (QueueMetrics)registrations, ErrorCode.TOO_MANY_REQUESTS);
        metricRegistry.gauge((MetricName)BaseMetricName.T, commandCache, ConstraintCache::size);
    }

    private /* synthetic */ void M(DefaultExecutionContext a2, Consumer a3, SerializedCommandResponse a4) {
        CommandDispatcher a5;
        a5.M(a2, a4, a3);
    }

    public void dispatch(String a2, Authentication a4, SerializedCommand a6, Consumer<SerializedCommandResponse> a7) {
        CommandDispatcher a8;
        String string = a2;
        a8.D.computeIfAbsent(string, a3 -> {
            CommandDispatcher a4;
            a3 = new AtomicInteger();
            a4.I.gauge((MetricName)BaseMetricName.g, Tags.of((String)"context", (String)string), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        a7 = a5 -> {
            CommandDispatcher a6;
            SerializedCommandResponse serializedCommandResponse = a5;
            a7.accept(serializedCommandResponse);
            if (a6.M(serializedCommandResponse)) {
                a6.I.error(a6.getCommand(), a2, a5.getErrorCode());
            }
            ((AtomicInteger)a6.D.get(a2)).decrementAndGet();
        };
        CommandDispatcher commandDispatcher = a8;
        commandDispatcher.commandRate(a2).M();
        commandDispatcher.M(a2, a4, a6, a7);
    }
}

