/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.event;

import io.axoniq.axonserver.config.ExternalLogin;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.grpc.event.QueryEventsRequest;
import io.axoniq.axonserver.grpc.event.QueryEventsResponse;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.event.D;
import io.axoniq.axonserver.message.event.EventStore;
import io.axoniq.axonserver.message.event.SequenceValidationStrategy;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.rest.ApplicationJSON;
import io.axoniq.axonserver.topology.EventStoreLocator;
import io.micrometer.core.instrument.Tags;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

@Component
public class EventDispatcher {
    private final EventStoreLocator K;
    private final Map<ClientStreamIdentification, List<D>> h;
    private final Map<String, AtomicInteger> i;
    private final Map<String, AtomicInteger> J;
    private final long M;
    private final Map<String, MeterFactory.RateMeter> e;
    private final int j;
    private final Map<String, AtomicInteger> g;
    private final MeterFactory E;
    static final String F = "{}:  Error on connection from event store: {}";
    private final Map<String, MeterFactory.RateMeter> a;
    private final Map<String, MeterFactory.RateMeter> d;
    private final Map<String, AtomicInteger> k;
    private final boolean B;
    private static final Logger C = AuditLog.getLogger();
    private final Map<String, MeterFactory.RateMeter> D;
    private final Logger l;
    @Value(value="${axoniq.axonserver.read-sequence-validation-strategy:LOG}")
    private SequenceValidationStrategy I;
    private final RetryBackoffSpec L;

    public Mono<Long> eventTokenAt(String a2, Instant a3) {
        EventDispatcher a5;
        return a5.K.eventStore(a2, false).flatMap(a4 -> a4.eventTokenAt(a2, a3));
    }

    public Flux<QueryEventsResponse> queryEvents(String a2, Authentication a3, Flux<QueryEventsRequest> a5) {
        EventDispatcher a7;
        return a5.switchOnFirst((a4, a6) -> {
            if (a4.isOnNext()) {
                EventDispatcher a7;
                QueryEventsRequest queryEventsRequest = (QueryEventsRequest)a4.get();
                return a7.K.eventStore(a2, queryEventsRequest.getForceReadFromLeader()).flatMapMany(a5 -> a5.queryEvents(a2, a6, a3));
            }
            if (a4.isOnError()) {
                return Flux.error((Throwable)a4.getThrowable());
            }
            return Flux.empty();
        });
    }

    private /* synthetic */ MeterFactory.RateMeter M(String a2, Map<String, MeterFactory.RateMeter> a3, BaseMetricName a4, BaseMetricName a6) {
        EventDispatcher a7;
        return a3.computeIfAbsent(a2, a5 -> {
            EventDispatcher a6;
            return a6.E.rateMeter((MetricName)a4, (MetricName)(a6.B ? a6 : null), Tags.of((String)"context", (String)a2));
        });
    }

    public Flux<SerializedEvent> aggregateSnapshots(String a2, Authentication a4, GetAggregateSnapshotsRequest a6) {
        EventDispatcher a7;
        long l2 = System.currentTimeMillis();
        Tags tags = Tags.of((String)"context", (String)a2);
        return a7.K.eventStore(a2).flatMapMany(a5 -> a5.aggregateSnapshots(a2, a4, a6)).doFirst(() -> {
            EventDispatcher a6;
            AtomicInteger atomicInteger = a6.k.computeIfAbsent(a2, a2 -> new AtomicInteger());
            atomicInteger.incrementAndGet();
            a6.E.gauge((MetricName)BaseMetricName.o, tags, atomicInteger::get);
            a6.d.computeIfAbsent(a2, a3 -> {
                EventDispatcher a4;
                return a4.E.rateMeter((MetricName)BaseMetricName.y, tags);
            }).M();
        }).doOnError(a3 -> {
            EventDispatcher a4;
            String[] stringArray = new String[4];
            stringArray[0] = "context";
            stringArray[1] = a2;
            stringArray[2] = "error";
            stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
            a4.E.counter((MetricName)BaseMetricName.n, Tags.of((String[])stringArray)).increment();
        }).doOnComplete(() -> {
            EventDispatcher a4;
            a4.E.timer((MetricName)BaseMetricName.i, tags).record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
        }).doOnTerminate(() -> {
            EventDispatcher a3;
            ((AtomicInteger)a3.k.get(a2)).decrementAndGet();
        });
    }

    private /* synthetic */ void d(String a4, Tags a5) {
        EventDispatcher a6;
        AtomicInteger atomicInteger = a6.J.computeIfAbsent(a4, a2 -> new AtomicInteger());
        atomicInteger.incrementAndGet();
        a6.E.gauge((MetricName)BaseMetricName.da, a5, atomicInteger::get);
        a6.e.computeIfAbsent(a4, a3 -> {
            EventDispatcher a4;
            return a4.E.rateMeter((MetricName)BaseMetricName.V, a5);
        }).M();
    }

    public Mono<Void> appendEvent(String a2, Authentication a3, Flux<SerializedEvent> a4) {
        EventDispatcher a5;
        if (C.isDebugEnabled()) {
            C.debug(ApplicationJSON.M((Object)"!+\u0007\u0010\u0001-'p(5\u000b%\u001f#\u000ep\u000e?Z1\n \u001f>\u001ep\u001f&\u001f>\u000e#T"), (Object)AuditLog.username((Principal)a3), (Object)a2);
        }
        long l2 = System.currentTimeMillis();
        return a5.K.eventStore(a2).flatMap(a8 -> {
            EventDispatcher a9;
            a4 = a4.doOnNext(a3 -> {
                EventDispatcher a4;
                EventDispatcher eventDispatcher = a4;
                eventDispatcher.M(a2, eventDispatcher.D, BaseMetricName.Pa, BaseMetricName.J).M();
            });
            return a8.appendEvents(a2, a4, a3).doFirst(() -> {
                EventDispatcher a4;
                AtomicInteger atomicInteger = a4.i.computeIfAbsent(a2, a2 -> new AtomicInteger());
                atomicInteger.incrementAndGet();
                a4.E.gauge((MetricName)BaseMetricName.q, Tags.of((String)"context", (String)a2), atomicInteger::get);
            }).doOnSuccess(a4 -> {
                EventDispatcher a5;
                a5.E.timer((MetricName)BaseMetricName.Ja, Tags.of((String)"context", (String)a2)).record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
            }).doOnError(a3 -> {
                EventDispatcher a4;
                String[] stringArray = new String[4];
                stringArray[0] = "context";
                stringArray[1] = a2;
                stringArray[2] = "error";
                stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
                a4.E.counter((MetricName)BaseMetricName.G, Tags.of((String[])stringArray)).increment();
            }).doOnTerminate(() -> {
                EventDispatcher a3;
                ((AtomicInteger)a3.i.get(a2)).decrementAndGet();
            });
        });
    }

    private static /* synthetic */ Mono M(String a2, EventStore a3) {
        return a3.lastEventToken(a2);
    }

    public Map<String, Iterable<Long>> eventTrackerStatus(String a2) {
        EventDispatcher a3;
        HashMap<String, Iterable<Long>> hashMap = new HashMap<String, Iterable<Long>>();
        a3.h.forEach((a4, a5) -> {
            if (a4.e().equals(a2)) {
                a5 = a5.stream().map(D::M).collect(Collectors.toList());
                hashMap.put(a4.toString(), (Iterable<Long>)a5);
            }
        });
        return hashMap;
    }

    public MeterFactory.RateMeter eventRate(String a2) {
        EventDispatcher a3;
        EventDispatcher eventDispatcher = a3;
        return eventDispatcher.M(a2, eventDispatcher.D, BaseMetricName.Pa, BaseMetricName.J);
    }

    public Mono<Long> highestSequenceNumber(String a2, String a3) {
        EventDispatcher a5;
        return a5.K.eventStore(a2).flatMap(a4 -> a4.highestSequenceNumber(a2, a3));
    }

    public Mono<Long> lastEventToken(String a2) {
        EventDispatcher a4;
        return a4.K.eventStore(a2).flatMap(a3 -> a3.lastEventToken(a2));
    }

    public MeterFactory.RateMeter snapshotRate(String a2) {
        EventDispatcher a3;
        EventDispatcher eventDispatcher = a3;
        return eventDispatcher.M(a2, eventDispatcher.a, BaseMetricName.Ma, BaseMetricName.N);
    }

    private /* synthetic */ void M(Tags a2, long a3) {
        EventDispatcher a4;
        a4.E.timer((MetricName)BaseMetricName.Fa, a2).record(System.currentTimeMillis() - a3, TimeUnit.MILLISECONDS);
    }

    public void deleteMetrics(String a2) {
        EventDispatcher a3;
        MeterFactory.RateMeter rateMeter = (MeterFactory.RateMeter)a3.D.remove(a2);
        if (rateMeter != null) {
            rateMeter.d();
        }
        if ((rateMeter = (MeterFactory.RateMeter)a3.a.remove(a2)) != null) {
            rateMeter.d();
        }
        if ((rateMeter = (MeterFactory.RateMeter)a3.e.remove(a2)) != null) {
            rateMeter.d();
        }
        if ((rateMeter = (MeterFactory.RateMeter)a3.d.remove(a2)) != null) {
            rateMeter.d();
        }
        EventDispatcher eventDispatcher = a3;
        eventDispatcher.E.remove((MetricName)BaseMetricName.Ja, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.G, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.ga, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.Ga, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.n, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.Fa, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.i, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.aa, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.q, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.C, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.da, "context", a2);
        eventDispatcher.E.remove((MetricName)BaseMetricName.o, "context", a2);
        eventDispatcher.k.remove(a2);
        a3.J.remove(a2);
        a3.g.remove(a2);
        a3.i.remove(a2);
    }

    public long getNrOfEvents(String a2) {
        EventDispatcher a3;
        if ((a2 = (Long)a3.K.eventStore((String)a2).flatMap(arg_0 -> EventDispatcher.M((String)a2, arg_0)).switchIfEmpty(Mono.just((Object)-1L)).block()) != null) {
            return (Long)a2;
        }
        return -1L;
    }

    public Mono<Void> appendSnapshot(String a2, Event a3, Authentication a4) {
        EventDispatcher a5;
        if (C.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a4);
            objectArray[1] = a2;
            objectArray[2] = a3.getAggregateIdentifier();
            C.debug(ApplicationJSON.M((Object)"\u000b\u0001-:+\u0007\rZ\u0002\u001f!\u000f5\t$Z$\u0015p\u00169\t$Z5\f5\u0014$\tp\u001c?\bp\u0001-T"), objectArray);
        }
        long l2 = System.currentTimeMillis();
        return a5.K.eventStore(a2).flatMap(a8 -> {
            EventDispatcher a9;
            return a8.appendSnapshot(a2, a3, a4).doFirst(() -> {
                EventDispatcher a4;
                AtomicInteger atomicInteger = a4.g.computeIfAbsent(a2, a2 -> new AtomicInteger());
                atomicInteger.incrementAndGet();
                a4.E.gauge((MetricName)BaseMetricName.C, Tags.of((String)"context", (String)a2), atomicInteger::get);
            }).doOnSuccess(a4 -> {
                EventDispatcher a5;
                EventDispatcher eventDispatcher = a5;
                eventDispatcher.M(a2, eventDispatcher.a, BaseMetricName.Ma, BaseMetricName.N).M();
                eventDispatcher.E.timer((MetricName)BaseMetricName.ga, Tags.of((String)"context", (String)a2)).record(System.currentTimeMillis() - l2, TimeUnit.MILLISECONDS);
            }).doOnError(a3 -> {
                EventDispatcher a4;
                EventDispatcher eventDispatcher = a4;
                eventDispatcher.l.warn(F, (Object)ApplicationJSON.M((Object)"1\n \u001f>\u001e\u0003\u00141\n#\u0012?\u000e"), (Object)a3.getMessage());
                String[] stringArray = new String[4];
                stringArray[0] = "context";
                stringArray[1] = a2;
                stringArray[2] = "error";
                stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
                eventDispatcher.E.counter((MetricName)BaseMetricName.Ga, Tags.of((String[])stringArray)).increment();
            }).doOnTerminate(() -> {
                EventDispatcher a3;
                ((AtomicInteger)a3.g.get(a2)).decrementAndGet();
            });
        });
    }

    public Flux<SerializedEventWithToken> events(String a2, Authentication a3, Flux<GetEventsRequest> a4) {
        EventDispatcher a5;
        return a4.switchOnFirst((a7, a8) -> {
            if (a7.isOnNext()) {
                EventDispatcher a9;
                D d2;
                GetEventsRequest getEventsRequest = (GetEventsRequest)a7.get();
                D d3 = d2 = new D(getEventsRequest.getClientId(), a2, getEventsRequest.getTrackingToken() - 1L);
                ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(d3.I, d3.l);
                a9.h.computeIfAbsent(clientStreamIdentification, a2 -> new CopyOnWriteArrayList()).add(d2);
                Object[] objectArray = new Object[3];
                objectArray[0] = getEventsRequest.getClientId();
                objectArray[1] = getEventsRequest.getComponentName();
                objectArray[2] = getEventsRequest.getTrackingToken();
                a9.l.info(ApplicationJSON.M((Object)"\u0003\u000e1\b$\u0013>\u001dp\u000e\"\u001b3\u00119\u00147Z5\f5\u0014$Z \b?\u00195\t#\u0015\"Z6\u0015\"Z+\u0007j\u0001-Z}Z+\u0007"), objectArray);
                return a9.K.eventStore(a2, getEventsRequest.getForceReadFromLeader()).flatMapMany(a5 -> a5.events(a2, a3, a8)).doOnNext(a3 -> d2.M()).doFinally(a3 -> {
                    EventDispatcher a4;
                    a4.M(d2);
                });
            }
            if (a7.isOnError()) {
                return Flux.error((Throwable)a7.getThrowable());
            }
            return Flux.empty();
        });
    }

    private /* synthetic */ void M(@Nonnull D a2) {
        EventDispatcher eventDispatcher = this;
        eventDispatcher.l.info(ApplicationJSON.M((Object)"(5\u0017?\f5\u001ep\u000e\"\u001b3\u00115\bp\u0013>\u001c?Z+\u0007"), (Object)a2);
        D d2 = a2;
        eventDispatcher.h.computeIfPresent(new ClientStreamIdentification(d2.I, d2.l), (a3, a4) -> {
            EventDispatcher a5;
            List list = a4;
            a5.l.debug(ExternalLogin.M((Object)"\u00119Pd\u00119J7\u001e6\u000f%\u00077"), (Object)a2.l, (Object)a4.size());
            list.remove(a2);
            if (list.isEmpty()) {
                return null;
            }
            return a4;
        });
    }

    public Mono<Long> firstEventToken(String a2) {
        EventDispatcher a4;
        return a4.K.eventStore(a2, false).flatMap(a3 -> a3.firstEventToken(a2));
    }

    public Flux<SerializedEvent> aggregateEvents(String a2, Authentication a3, GetAggregateEventsRequest a4) {
        EventDispatcher a5;
        if (C.isDebugEnabled()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a3);
            objectArray[1] = a2;
            objectArray[2] = a4.getAggregateId();
            C.debug(ApplicationJSON.M((Object)"\u000b\u0001-:+\u0007\rZ\u0002\u001f!\u000f5\t$Z$\u0015p\u00169\t$Z5\f5\u0014$\tp\u001c?\bp\u0001-T"), objectArray);
        }
        long l2 = System.currentTimeMillis();
        return a5.K.eventStore(a2).flatMapMany(a9 -> {
            EventDispatcher a10;
            String string = ExternalLogin.M((Object)"5\u001b&\u00059\u00105\u0017/\u0015");
            string = Tags.of((String)"context", (String)a2);
            return Flux.deferContextual(a6 -> {
                EventDispatcher a7;
                a6 = (AtomicLong)a6.get((Object)ExternalLogin.M((Object)"5\u001b&\u00059\u00105\u0017/\u0015"));
                boolean bl = a4.getAllowSnapshots() && ((AtomicLong)a6).get() == -1L;
                GetAggregateEventsRequest getAggregateEventsRequest = a4.toBuilder().setAllowSnapshots(bl).setInitialSequence(((AtomicLong)a6).get() + 1L).build();
                a7.l.debug(ApplicationJSON.M((Object)"(5\u001b4\u0013>\u001dp\u001f&\u001f>\u000e#Z6\b?\u0017p\t5\u000bs\u0001-Z6\u0015\"Z1\u001d7\b5\u001d1\u000e5Z+\u0007"), (Object)(((AtomicLong)a6).get() + 1L), (Object)a4.getAggregateId());
                return a9.aggregateEvents(a2, a3, getAggregateEventsRequest);
            }).doFirst(() -> a10.d(a2, (Tags)string)).limitRate(a10.j * 5, a10.j).doOnEach(a2 -> {
                if (a2.hasValue()) {
                    ((AtomicLong)a2.getContextView().get((Object)ExternalLogin.M((Object)"5\u001b&\u00059\u00105\u0017/\u0015"))).set(((SerializedEvent)a2.get()).d());
                }
            }).timeout(Duration.ofMillis(a10.M)).onErrorMap(TimeoutException.class, a2 -> {
                EventDispatcher a3;
                return new MessagingPlatformException(ErrorCode.LIST_AGGREGATE_EVENTS_TIMEOUT, "Timeout exception: No events were emitted from event store in last " + a3.M + "ms. Check the logs for virtual machine errors like OutOfMemoryError.");
            }).retryWhen((Retry)a10.L.doBeforeRetry(a3 -> {
                EventDispatcher a4;
                Object[] objectArray = new Object[3];
                objectArray[0] = a3.failure().getClass().getName();
                objectArray[1] = a3.failure().getMessage();
                objectArray[2] = a4.getAggregateId();
                a4.l.warn(ExternalLogin.M((Object)"8!\u001e6\u0013-\u0004#J0\u0005d\u0018!\u000b J!\u001c!\u00040\u0019d\u000b#\r6\u000f#\u000b0\u000fd\u00190\u0018!\u000b)J \u001f!J0\u0005d\u00119P?\u0017hJ\"\u00056J%\r#\u0018!\r%\u001e!Pd\u00119"), objectArray);
            })).onErrorMap(a2 -> {
                if (Exceptions.isRetryExhausted((Throwable)a2)) {
                    return a2.getCause();
                }
                return a2;
            }).doOnError(a3 -> {
                EventDispatcher a4;
                EventDispatcher eventDispatcher = a4;
                eventDispatcher.l.error(ExternalLogin.M((Object)"\u0001\u00186\u00056J \u001f6\u0003*\rd\u0018!\u000b \u0003*\rd\u000b#\r6\u000f#\u000b0\u000fd\u000f2\u000f*\u001e7Dd"), a3);
                String[] stringArray = new String[4];
                stringArray[0] = "context";
                stringArray[1] = a2;
                stringArray[2] = "error";
                stringArray[3] = ErrorCode.fromException((Throwable)a3).getCode();
                eventDispatcher.E.counter((MetricName)BaseMetricName.n, Tags.of((String[])stringArray)).increment();
            }).doOnNext(a3 -> {
                EventDispatcher a4;
                a4.l.trace(ExternalLogin.M((Object)"!\u001c!\u00040J?\u0017d\f+\u0018d\u000b#\r6\u000f#\u000b0\u000fd\u00119"), a3, (Object)a4.getAggregateId());
            }).doOnComplete(() -> a10.M((Tags)string, l2)).doOnTerminate(() -> {
                EventDispatcher a3;
                ((AtomicInteger)a3.J.get(a2)).decrementAndGet();
            }).contextWrite(a3 -> a3.put((Object)ExternalLogin.M((Object)"5\u001b&\u00059\u00105\u0017/\u0015"), (Object)new AtomicLong(a4.getInitialSequence() - 1L))).name(ApplicationJSON.M((Object)"5\f5\u0014$%#\u000e\"\u001f1\u0017")).tag("context", a2).tag("stream", ExternalLogin.M((Object)"\u000b#\r6\u000f#\u000b0\u000f\u001b\u000f2\u000f*\u001e7")).tag("origin", ApplicationJSON.M((Object)"3\u00169\u001f>\u000e\u000f\b5\u000b%\u001f#\u000e")).metrics();
        }).onErrorResume(Flux::error);
    }

    public EventDispatcher(EventStoreLocator eventStoreLocator, MeterFactory meterFactory, @Value(value="${axoniq.axonserver.event.aggregate.retry.attempts:3}") int maxRetryAttempts, @Value(value="${axoniq.axonserver.event.aggregate.retry.delay:100}") long retryDelayMillis, @Value(value="${axoniq.axonserver.event.aggregate.prefetch:5}") int aggregateEventsPrefetch, @Value(value="${axoniq.axonserver.event.aggregate.timeout:30000}") long a2, @Value(value="${axoniq.axonserver.legacy-metrics-enabled:true}") boolean a3) {
        EventDispatcher eventDispatcher = this;
        EventDispatcher eventDispatcher2 = this;
        EventDispatcher eventDispatcher3 = this;
        EventDispatcher eventDispatcher4 = this;
        this.l = LoggerFactory.getLogger(EventDispatcher.class);
        EventDispatcher eventDispatcher5 = this;
        eventDispatcher4.h = new ConcurrentHashMap();
        EventDispatcher eventDispatcher6 = this;
        eventDispatcher5.D = new ConcurrentHashMap();
        EventDispatcher eventDispatcher7 = this;
        eventDispatcher4.a = new ConcurrentHashMap();
        EventDispatcher eventDispatcher8 = this;
        eventDispatcher4.e = new ConcurrentHashMap();
        EventDispatcher eventDispatcher9 = this;
        eventDispatcher4.d = new ConcurrentHashMap();
        eventDispatcher4.I = SequenceValidationStrategy.l;
        EventDispatcher eventDispatcher10 = this;
        eventDispatcher4.i = new ConcurrentHashMap();
        EventDispatcher eventDispatcher11 = this;
        eventDispatcher4.g = new ConcurrentHashMap();
        EventDispatcher eventDispatcher12 = this;
        eventDispatcher4.J = new ConcurrentHashMap();
        EventDispatcher eventDispatcher13 = this;
        eventDispatcher4.k = new ConcurrentHashMap();
        eventDispatcher3.K = eventStoreLocator;
        eventDispatcher3.E = meterFactory;
        eventDispatcher2.B = a3;
        eventDispatcher2.L = Retry.backoff((long)maxRetryAttempts, (Duration)Duration.ofMillis(retryDelayMillis));
        eventDispatcher.j = aggregateEventsPrefetch;
        eventDispatcher.M = a2;
    }
}

