/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.diagnostics.DiagnosticsOptions;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final Map<String, ActiveQuery> C;
    private final long D;
    private final Logger l;
    private final int I = 25000;
    private final long L;

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a2) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.l = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.I = 25000;
        QueryCache queryCache3 = this;
        queryCache.C = new ConcurrentHashMap();
        queryCache.L = defaultQueryTimeout;
        if (a2 > 0L) {
            this.D = a2;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.D = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    private /* synthetic */ void M() {
        QueryCache a2;
        if ((long)a2.C.size() >= a2.D) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a2.D + "/" + a2.D + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }

    private /* synthetic */ void M(ActiveQuery a2, String a3) {
        QueryCache a4;
        a4.l.debug(EventTypeContext.M((Object)">:\u0010%\u00110\t0]$\b0\u000f,].\u0000u\u001b:\u000fu\f \u0018'\u0004u\u00154\u00131\u00110\u000fu\u00141\u0018;\t<\u001b<\u00181]7\u0004u\u001e9\u00140\u0013!.!\u000f0\u001c841].\u0000{"), (Object)a2.f(), (Object)a3);
        if (a2.e(a3)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            if (a2.M(a3, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(DiagnosticsOptions.M((Object)"\\JqKzFkLpK?Qp\u0005wDqAs@m\u0005:V?IpVk"), objectArray))) {
                a4.remove(a2.f());
            }
        }
    }

    public int size() {
        QueryCache a2;
        return a2.C.size();
    }

    public boolean isEmpty() {
        QueryCache a2;
        return a2.C.isEmpty();
    }

    public ActiveQuery putIfAbsent(String a2, ActiveQuery a3) {
        QueryCache a4;
        QueryCache queryCache = a4;
        queryCache.M();
        return queryCache.C.putIfAbsent(a2, a3);
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a2;
        return a2.C.entrySet();
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected a2) {
        QueryCache a5;
        a5.C.forEach((a3, a4) -> {
            QueryCache a5;
            a5.M(a4, a2.M());
        });
    }

    public ActiveQuery get(String a2) {
        QueryCache a3;
        return (ActiveQuery)a3.C.get(a2);
    }

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a4;
        long l2 = System.currentTimeMillis() - a4.L;
        return a4.entrySet().stream().filter(a3 -> {
            if (((ActiveQuery)a3.getValue()).M() < l2) {
                return true;
            }
            return false;
        }).filter(a2 -> {
            if (!((ActiveQuery)a2.getValue()).d()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    public ActiveQuery remove(String a2) {
        QueryCache a3;
        QueryCache queryCache = a3;
        queryCache.l.debug(EventTypeContext.M((Object)"\u0007\u00188\u0012#\u0018u\u00100\u000e&\u001c2\u0018\u001c\u0019u\u0006("), (Object)a2);
        return (ActiveQuery)queryCache.C.remove(a2);
    }
}

