/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.component.processor.balancing.strategy.ReplicationGroupProcessorLoadBalancingService;
import io.axoniq.axonserver.enterprise.replication.SnapshotDataProviders;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final QueryMetricsRegistry d;
    private final Logger k;
    private final NonReplacingConstraintCache<String, ActiveQuery> B;
    private final QueryInterceptors C;
    private final Map<String, AtomicInteger> D;
    private final FlowControlQueues<QueryInstruction> l;
    private final QueryRegistrationCache I;
    private final DispatchQueueMetrics L;

    private /* synthetic */ boolean M(QueryRequest a2) {
        return ProcessingInstructionHelper.M((List)a2.getProcessingInstructionsList());
    }

    public void flowControlProxied(String a2, String a3, long a4, String a6, String a7) {
        QueryDispatcher a8;
        a8.M(a6, a3, a7, a5 -> {
            QueryDispatcher a6;
            a6.M(a5, a2, a3, a4);
        });
    }

    private /* synthetic */ void M(String a2, String a3, String a4, Consumer<QueryHandler> a5) {
        QueryDispatcher a6;
        a2 = new QueryDefinition(a2, a3);
        if ((a2 = a6.I.find((QueryDefinition)a2, a4)) != null) {
            a5.accept((QueryHandler)a2);
        }
    }

    public MeterFactory.RateMeter queryRate(String a2) {
        QueryDispatcher a3;
        return a3.d.rateMeter(a2);
    }

    private /* synthetic */ String M(String a2, String a3) {
        return a2 + "/" + a3;
    }

    private /* synthetic */ void M(String a2, String a3, Runnable a42) {
        try {
            a42.run();
            return;
        }
        catch (MessagingPlatformException a42) {
            QueryDispatcher a5;
            QueryDispatcher queryDispatcher = a5;
            queryDispatcher.k.debug(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u0015?\"\"\"m4$#=193%9#7m6!?:p<%(\"4p$>>$?%.$$?#p9?m$,\"*59p.<$5#$m+0"), (Object)a3);
            queryDispatcher.completeWithError(a2, a3, a42.getErrorCode(), a42.getMessage());
            return;
        }
    }

    public QueryDispatcher(QueryRegistrationCache registrationCache, NonReplacingConstraintCache<String, ActiveQuery> queryCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int a2) {
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher queryDispatcher2 = this;
        this.k = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher3 = this;
        this.D = new ConcurrentHashMap();
        queryDispatcher2.I = registrationCache;
        queryDispatcher2.d = queryMetricsRegistry;
        queryDispatcher.B = queryCache;
        queryDispatcher.C = queryInterceptors;
        QueryDispatcher queryDispatcher4 = this;
        queryDispatcher.L = new DispatchQueueMetrics(meterFactory, (MetricName)BaseMetricName.P, (MetricName)BaseMetricName.ba, clientIdRegistry);
        QueryDispatcher queryDispatcher5 = this;
        queryDispatcher4.l = new FlowControlQueues(Comparator.comparing(QueryInstruction::M).reversed(), a2, (QueueMetrics)this.L, ErrorCode.TOO_MANY_REQUESTS);
        queryMetricsRegistry.gauge((MetricName)BaseMetricName.Ba, queryCache, ConstraintCache::size);
    }

    public void deleteMetrics(String a2) {
        QueryDispatcher a3;
        a3.D.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.d.remove((MetricName)BaseMetricName.c, a2);
        queryDispatcher.d.removeForContext(a2);
    }

    public void completeWithError(String a2, String a3, ErrorCode a4, String a5) {
        QueryDispatcher a6;
        Object[] objectArray = new Object[4];
        objectArray[0] = a3;
        objectArray[1] = a2;
        objectArray[2] = a4.getCode();
        objectArray[3] = a5;
        a6.k.debug(SnapshotDataProviders.M((Object)"u$[;Z.B\"X,\u0016<_?^kS9D$DkB#SkU$[&C%_(W?_$XkA\"B#\u0016*\u00168F.U\"P\"Uk^*X/Z.Dkm(Z\"S%B\u0018B9S*[\u0002RvM6kg\u0016-Y9\u0016?^.\u0016:C.D2\u0016\u0010_/\u000b0K\u0016\u0018ks9D$DkU$R.\fkM6\u0018ks9D$D\u0006S8E*Q.\fkM6\u0018"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.B.get((Object)a2);
        if (activeQuery != null && activeQuery.M(a3, a4, a5)) {
            a6.B.remove((Object)a2);
        }
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.l;
    }

    public void flowControl(String a2, long a3) {
        QueryDispatcher a4;
        if ((a2 = (ActiveQuery)a4.B.get((Object)a2)) != null) {
            a2.d().forEach(arg_0 -> a4.M((ActiveQuery)a2, a3, arg_0));
        }
    }

    private /* synthetic */ void M(QueryHandler a2, String a3, String a4, long a5) {
        QueryDispatcher a6;
        String string = a3;
        a6.M(string, a2.d(), () -> a2.M(string, a4, a5));
    }

    private /* synthetic */ void M(DefaultExecutionContext a2, QueryResponse a3, Consumer<QueryResponse> a4) {
        QueryDispatcher a5;
        try {
            a4.accept(a5.C.queryResponse(a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception exception) {
            a5.k.warn(ReplicationGroupProcessorLoadBalancingService.M((Object)"6-wp\b(.5=$$?#p$>m\"(#=?##(p$>95?3( 9??"), (Object)a2.contextName(), (Object)exception);
            Exception exception2 = exception;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)exception2.getMessage())).build());
            a2.compensate((Throwable)exception2);
            return;
        }
    }

    private /* synthetic */ void M(String a2, ActiveQuery a3) {
        QueryDispatcher a4;
        try {
            a4.k.trace(SnapshotDataProviders.M((Object)"r\"E;W?U#_%QkG>S9OkM6\u0018e\u0018"), (Object)a3.f());
            a3.d();
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            QueryDispatcher queryDispatcher = a4;
            queryDispatcher.k.debug(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u0015?\"\"\"m48\"$>*p)9> ,$.8$>*p\"6m!85?)m+0~m\u0013,>.5!<$>*p:998m5?\"\"\"c"), (Object)a3.f(), (Object)messagingPlatformException);
            a3.M(messagingPlatformException.getErrorCode(), messagingPlatformException.getMessage());
            queryDispatcher.B.remove((Object)a2);
            return;
        }
    }

    public void cancelProxied(String a2, String a3) {
        QueryDispatcher a4;
        QueryDispatcher queryDispatcher = a4;
        queryDispatcher.cancel(queryDispatcher.M(a2, a3));
    }

    public void dispatchProxied(SerializedQuery a22, Consumer<QueryResponse> a3, Consumer<String> a4, boolean a52) {
        QueryDispatcher a6;
        SerializedQuery serializedQuery = a22;
        QueryRequest queryRequest = serializedQuery.query();
        String string = serializedQuery.context();
        String string2 = serializedQuery.clientStreamId();
        if ((string = a6.I.find(string, queryRequest, string2)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = string2;
            objectArray[1] = queryRequest.getQuery();
            a3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)String.format(SnapshotDataProviders.M((Object)"\bZ\"S%Bk\u00138\u0016%Y?\u0016-Y>X/\u0016<^\"Z.\u0016;D$U.E8_%Qq\u0016nE"), objectArray))).build());
            a4.accept(string2);
            return;
        }
        string2 = a6.M(queryRequest.getMessageIdentifier(), a22.clientStreamId());
        ActiveQuery a52 = new ActiveQuery(string2, a22, false, a3, a4, Collections.singleton(string), a52 && a6.M(queryRequest));
        try {
            if (a6.B.putIfAbsent((Object)string2, (Object)a52) != null) {
                a3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a22.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)ReplicationGroupProcessorLoadBalancingService.M((Object)"\u000185?)m'$$%p>%= !9(4m\u0019\tp,<?5,44p=\"(#(>9"))).build());
                a4.accept(SnapshotDataProviders.M((Object)"r>F'_(W?S\u0002R"));
                return;
            }
            a6.M(string2, a52);
            return;
        }
        catch (InsufficientBufferCapacityException a22) {
            a52.M(string.d(), ErrorCode.QUERY_DISPATCH_ERROR, a22.getMessage());
            return;
        }
    }

    private /* synthetic */ void M(ActiveQuery a2, long a3, QueryHandler a4) {
        QueryDispatcher a5;
        a5.M(a4, a2.f(), a2.e(), a3);
    }

    private /* synthetic */ void M(SerializedQuery a2, String a3, Authentication a4, Consumer<QueryResponse> a5, Consumer<String> a6) {
        Set set;
        QueryRequest queryRequest;
        QueryDispatcher a7;
        block5: {
            SerializedQuery serializedQuery;
            Consumer<QueryResponse> consumer;
            block4: {
                a4 = new DefaultExecutionContext(a3, a4);
                consumer = arg_0 -> a7.M((DefaultExecutionContext)a4, a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher = a7;
                    serializedQuery = queryDispatcher.C.queryRequest(a2, (ExecutionContext)a4);
                    queryRequest = serializedQuery.query();
                    set = queryDispatcher.I.find(a3, queryRequest);
                    if (!set.isEmpty()) break block4;
                    consumer.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)("No handler for query: " + queryRequest.getQuery()))).build());
                    a6.accept(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u001e\"\u0013!9(>9"));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a3;
                    objectArray[1] = a2.query().getQuery();
                    objectArray[2] = exception;
                    a7.k.warn(SnapshotDataProviders.M((Object)"M6\fkP*_'S/\u0016?YkR\"E;W?U#\u0016:C.D2\u00160K"), objectArray);
                    queryRequest = ErrorCode.fromException((Throwable)exception);
                    consumer.accept(QueryResponse.newBuilder().setErrorCode(queryRequest.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)StringUtils.getOrDefault((String)queryRequest.getCode(), (String)exception.getClass().getName()))).build());
                    a6.accept(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u0016,9!5)"));
                    a4.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(queryRequest.getMessageIdentifier(), serializedQuery, true, consumer, a6, set, a7.M(queryRequest));
            if (a7.B.putIfAbsent((Object)queryRequest.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.M((String)SnapshotDataProviders.M((Object)"\u001aC.D2\u0016<_?^kE>F;Z\"S/\u0016\u0002rkW'D.W/OkF9S8S%B"))).build());
            a6.accept(ReplicationGroupProcessorLoadBalancingService.M((Object)"\t%=<$3,$(\u0019)"));
            return;
        }
        a7.M(queryRequest.getMessageIdentifier(), (ActiveQuery)set);
    }

    public void handleComplete(String a2, String a3, String a4) {
        QueryDispatcher a5;
        ActiveQuery activeQuery = a5.M(a3, a2);
        if (activeQuery != null) {
            if (activeQuery.M(a3)) {
                a5.B.remove((Object)activeQuery.f());
            }
            long l2 = System.currentTimeMillis() - activeQuery.M();
            if (activeQuery.M()) {
                a5.d.addHandlerResponseTime(activeQuery.M(), activeQuery.d(), a4, activeQuery.M(), l2);
                return;
            }
        } else {
            a5.k.debug(SnapshotDataProviders.M((Object)"x$\u0016c[$D.\u001fk_%P$D&W?_$XkP$DkM6\u0016$XkU$[;Z.B.R"), (Object)a2);
        }
    }

    public void query(SerializedQuery a3, Authentication a6, Consumer<QueryResponse> a7, Consumer<String> a8) {
        QueryDispatcher a9;
        String string = a3.context();
        a7 = a5 -> {
            QueryDispatcher a6;
            QueryResponse queryResponse = a5;
            a7.accept(queryResponse);
            if (a6.M(queryResponse)) {
                a6.d.error(a3.query().getQuery(), string, a5.getErrorCode());
            }
        };
        a8 = a4 -> {
            QueryDispatcher a5;
            a8.accept((String)a4);
            ((AtomicInteger)a5.D.get(string)).decrementAndGet();
        };
        QueryDispatcher queryDispatcher = a9;
        queryDispatcher.queryRate(string).M();
        queryDispatcher.D.computeIfAbsent(string, a2 -> {
            QueryDispatcher a3;
            AtomicInteger atomicInteger = new AtomicInteger();
            a3.d.gauge((MetricName)BaseMetricName.c, Tags.of((String)"context", (String)a2), atomicInteger::get);
            return atomicInteger;
        }).incrementAndGet();
        a9.M(a3, string, a6, a7, a8);
    }

    public void handleResponse(QueryResponse a2, String a3, String a4) {
        QueryDispatcher a5;
        String string = a2.getRequestIdentifier();
        if ((string = a5.M(a3, string)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(string.M(), a3);
            long l2 = System.currentTimeMillis() - string.M();
            if (string.M()) {
                a5.d.addEndToEndResponseTime(string.M(), string.d(), a4, clientStreamIdentification.e(), string.d(), l2);
            }
            if (string.M(a2, a3) && string.d()) {
                string.M(a3);
                return;
            }
        } else {
            a5.k.debug(ReplicationGroupProcessorLoadBalancingService.M((Object)"\u001e\"pe=\"\"(ym9#6\"\" 199\">m6\"\"m+0"), (Object)a2.getRequestIdentifier());
        }
    }

    private /* synthetic */ boolean M(QueryResponse a2) {
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    private /* synthetic */ ActiveQuery M(String a2, String a3) {
        QueryDispatcher a4;
        ActiveQuery activeQuery = (ActiveQuery)a4.B.get(a3);
        if (activeQuery == null) {
            a3 = (String)a3 + "/" + a2;
            activeQuery = (ActiveQuery)a4.B.get(a3);
        }
        return activeQuery;
    }

    public void dispatchProxied(SerializedQuery a2, Consumer<QueryResponse> a3, Consumer<String> a4) {
        QueryDispatcher a5;
        a5.dispatchProxied(a2, a3, a4, true);
    }

    public void cancel(String a2) {
        QueryDispatcher a3;
        if ((a2 = (ActiveQuery)a3.B.remove((Object)a2)) != null) {
            a2.M();
        }
    }

    private /* synthetic */ void M(DefaultExecutionContext a2, Consumer a3, QueryResponse a4) {
        QueryDispatcher a5;
        a5.M(a2, a4, a3);
    }
}

