/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.enterprise.replication.BackupInfoController;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.BackupInfoRestController;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.transport.rest.v2.ClusterUpdatesRestController;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/backup"})
public class ClusterBackupInfoRestController {
    private final BackupInfoRestController D;
    private final GrpcRaftController l;
    private final BackupInfoController I;
    private static final Logger L = AuditLog.getLogger();

    @GetMapping(value={"/log/filenames"})
    public List<String> M(@Parameter(deprecated=true, description="Indicates the replication group, use 'replicationgroup' paramater") @RequestParam(value="context", defaultValue="default") String context, @RequestParam(value="replicationgroup", required=false) String replicationGroup, @Parameter(hidden=true) Principal a2) {
        if (replicationGroup == null) {
            replicationGroup = context;
        }
        if (L.isInfoEnabled()) {
            L.info(TaskPublisher.M((Object)"i+O\r\u0012\u0002W!G5A$\u0012$]p^9A$\u00122S3Y%BpT9^5ApT?@p@5B<[3S$[?\\pU\"]%BpI-\u001c"), (Object)AuditLog.username((Principal)a2), (Object)StringUtils.sanitize((String)replicationGroup));
        }
        if ((context = this.l.getRaftGroup(replicationGroup)) == null) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, replicationGroup + ": replication group not found");
        }
        return context.localLogEntryStore().getBackupFilenames().collect(Collectors.toList());
    }

    public ClusterBackupInfoRestController(BackupInfoRestController a2, GrpcRaftController a3, BackupInfoController a4) {
        ClusterBackupInfoRestController a5;
        ClusterBackupInfoRestController clusterBackupInfoRestController = a5;
        a5.D = a2;
        clusterBackupInfoRestController.l = a3;
        clusterBackupInfoRestController.I = a4;
    }

    @PostMapping(value={"/createControlDbBackup"})
    public String M(@Parameter(hidden=true) Principal a3) throws SQLException {
        L.info(ClusterUpdatesRestController.M((Object)"m!K\u0007\u0016\bS+C?E.\u0016.YzU(S;B?\u00169Y4B(Y6R8\u00168W9]/Ft"), (Object)AuditLog.username((Principal)a3));
        this.l.getRaftGroups().forEach(a2 -> {
            ClusterBackupInfoRestController a3;
            ClusterBackupInfoRestController clusterBackupInfoRestController = a3;
            String string = a2;
            clusterBackupInfoRestController.I.registerControlDbBackup(string, clusterBackupInfoRestController.l.getRaftGroup(string).logEntryProcessor().M(), System.currentTimeMillis());
        });
        return this.D.M();
    }
}

