/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.command.CommandMetricsWebSocket;
import io.axoniq.axonserver.plugin.PluginPackageProvider;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final ClusterController E;
    private static final Logger F;
    private final RaftConfigServiceFactory a;
    private static final Logger d;
    private final ClusterTemplateController k;
    public static final String B = "_none";
    private final DistributeLicenseService C;
    private final Predicate<String> D;
    private final ApplicationEventPublisher l;
    private final FeatureChecker I;
    private final ClusterTopology L;

    @PostMapping(value={"/upload-license"})
    public void M(@RequestParam(value="licenseFile") MultipartFile licenseFile, @Parameter(hidden=true) Principal a2) throws IOException {
        d.info(CommandMetricsWebSocket.M((Object)"\u0000\u0015&3{<>\u001f.\u000b(\u001a{\u00022\r>\u0000(\u000b{\u001b+\n:\u001a>@"), (Object)AuditLog.username((Principal)a2));
        F.info(PluginPackageProvider.M((Object)"\u00196 s;:469 2s\"#;<6727{s'6%58!::94w?>02=$6w&'76'2}y}"));
        try {
            this.C.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, CommandMetricsWebSocket.M((Object)" 4N7\u000b:\n>\u001c{\b4\u001c{1:\n6\u00075@{+5\u001d.\u001c>N/\u0006:\u001a{\u001a3\u000b{1:\n6\u00075N)\u000b+\u00022\r:\u001a2\u00015N<\u001c4\u001b+N2\u001d{\r)\u000b:\u001a>\n{\f>\b4\u001c>N.\u001e7\u0001:\n2\u0000<N:N7\u00078\u000b5\u001d>@"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException licenseException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, licenseException.getMessage());
        }
    }

    public ClusterRestController(ClusterController a2, RaftConfigServiceFactory a3, FeatureChecker a4, DistributeLicenseService a5, ApplicationEventPublisher a6, ClusterTopology a7, ClusterTemplateController a8) {
        ClusterRestController a9;
        ClusterRestController clusterRestController = a9;
        ClusterRestController clusterRestController2 = a9;
        ClusterRestController clusterRestController3 = a9;
        ClusterRestController clusterRestController4 = a9;
        a9.D = new ContextNameValidation();
        a9.E = a2;
        clusterRestController3.a = a3;
        clusterRestController3.I = a4;
        clusterRestController2.C = a5;
        clusterRestController2.l = a6;
        clusterRestController.L = a7;
        clusterRestController.k = a8;
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode M(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        d.info(PluginPackageProvider.M((Object)"\b,.\ns\u00056&&2 #s9<36w72'6:; w58!w(*}"), (Object)AuditLog.username((Principal)a2), (Object)name);
        a2 = this.E.getNode(name);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + name + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)this.E.isActive(name));
    }

    static {
        d = AuditLog.getLogger();
        F = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void M(HttpServletResponse resp, @Parameter(hidden=true) Principal a2) throws IOException {
        d.info(CommandMetricsWebSocket.M((Object)"5 \u0013\u0006N\t\u000b*\u001b>\u001d/N8\u0002.\u001d/\u000b)N/\u000b6\u001e7\u000f/\u000b{\n4\u00195\u00024\u000f?@"), (Object)AuditLog.username((Principal)a2));
        if (this.L.isAdminNode()) {
            a2 = PluginPackageProvider.M((Object)"4?\" #6%~#6:#;2#6y*:?");
            String string = this.k.buildYamlTemplate();
            HttpServletResponse httpServletResponse = resp;
            resp = httpServletResponse.getOutputStream();
            httpServletResponse.setContentType(CommandMetricsWebSocket.M((Object)"\u001a>\u0016/A+\u0002:\u00075U{\r3\u000f)\u001d>\u001af\u001b/\bvV"));
            httpServletResponse.addHeader(PluginPackageProvider.M((Object)"\u00108=#69'z\u0017> '<$:#:8="), "attachment; filename=\"" + (String)a2 + "\"");
            HttpServletResponse httpServletResponse2 = resp;
            httpServletResponse2.write(string.getBytes(StandardCharsets.UTF_8));
            httpServletResponse2.flush();
            httpServletResponse2.close();
            return;
        }
        throw new RuntimeException(CommandMetricsWebSocket.M((Object)"74\u001b{\r:\u0000{\u001b(\u000b{\u001a3\u0007(N=\u001b5\r/\u00074\u0000:\u00022\u001a\"N4\u00007\u0017{\b)\u00016N:\n6\u00075N5\u0001?\u000b"));
    }

    @DeleteMapping(path={"{name}"})
    public void M(@PathVariable(value="name") String name, @Parameter(hidden=true) Principal a2) {
        d.info(PluginPackageProvider.M((Object)"\b,.\ns\u00056&&2 #s#<w72?2'2s9<36w(*}"), (Object)AuditLog.username((Principal)a2), (Object)name);
        this.a.getRaftConfigService().deleteNode(name);
    }

    @PostMapping
    public ResponseEntity<RestResponse> M(@Valid @RequestBody ClusterJoinRequest jsonClusterNode2, @Parameter(hidden=true) Principal a2) {
        ClusterRestController clusterRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = jsonClusterNode2.getInternalHostName();
        objectArray[2] = jsonClusterNode2.internalGrpcPort;
        d.info(CommandMetricsWebSocket.M((Object)"\u0000\u0015&3{<>\u001f.\u000b(\u001a{\u001a4N1\u00012\u0000{\r7\u001b(\u001a>\u001c{\u000f/N \u0013a\u0015&@"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)this.E.getMe().toNodeInfo());
        String string = jsonClusterNode2.getContext();
        if (string != null && !string.isEmpty()) {
            if (jsonClusterNode2.getNoContexts() != null && jsonClusterNode2.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, PluginPackageProvider.M((Object)"\u00106=9<#s4<:1>=2s=<>=>=0s4<9'2+#s :#;w=8\u00108=#6/'$}"));
            }
            if (!RaftAdminGroup.M((String)string) && !this.D.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            F.debug(CommandMetricsWebSocket.M((Object)":\n?FrT{<>\t2\u001d/\u000b)\u00075\t{\u0003\"\u001d>\u0002=N:\u0000?N:\n?\u00075\t{\u0003>N/\u0001{\r4\u0000/\u000b#\u001a{L \u0013y@"), (Object)string);
            clusterRestController = this;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (jsonClusterNode2.getNoContexts() != null && jsonClusterNode2.getNoContexts().booleanValue()) {
            F.debug(PluginPackageProvider.M((Object)"237\u007fzms\u000560:$'2!>=0s:*$6;5w297w237>=0s:6w'8s9<w08=#6/'$}"));
            clusterRestController = this;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            F.debug(CommandMetricsWebSocket.M((Object)":\n?FrT{<>\t2\u001d/\u000b)\u00075\t{\u0003\"\u001d>\u0002=N:\u0000?N:\n?\u00075\t{\u0003>N/\u0001{\u000f7\u0002{\r4\u0000/\u000b#\u001a(@"));
            clusterRestController = this;
        }
        if (clusterRestController.E.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)new RestResponse(false, PluginPackageProvider.M((Object)"\u0019<36w2;!223*w!24> #6%63s>=w2w0;&$'2!")));
        }
        try {
            ClusterRestController clusterRestController2 = this;
            ClusterJoinRequest clusterJoinRequest = jsonClusterNode2;
            jsonClusterNode2 = clusterRestController2.a.getRaftConfigServiceStub(clusterJoinRequest.internalHostName, clusterJoinRequest.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController2.l.publishEvent((Object)new ClusterEvents.LicenseUpdated(jsonClusterNode2.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, CommandMetricsWebSocket.M((Object)"\u001a\r8\u000b+\u001a>\n{\u00044\u00075N)\u000b*\u001b>\u001d/B{\u0003:\u0017{\u001a:\u0005>N:N,\u00062\u0002>N/\u0001{\u001e)\u00018\u000b(\u001d")));
        }
        catch (Exception jsonClusterNode2) {
            return new RestResponse(false, jsonClusterNode2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)jsonClusterNode2));
        }
    }

    @GetMapping
    public List<JsonClusterNode> M(@Parameter(hidden=true) Principal a3) {
        d.info(PluginPackageProvider.M((Object)"\b,.\ns\u00056&&2 #s#<w?> #s9<36$}"), (Object)AuditLog.username((Principal)a3));
        return this.E.nodes().map(a2 -> {
            ClusterRestController a3;
            ClusterNode clusterNode = a2;
            return JsonClusterNode.from((ClusterNode)clusterNode, (boolean)a3.E.isActive(clusterNode.getName()));
        }).collect(Collectors.toList());
    }
}

